<?php
/*
 *********************************************************************************************************
 * daloRADIUS - RADIUS Web Platform
 * Copyright (C) 2007 - Liran Tal <liran@lirantal.com> All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *********************************************************************************************************
 * Description:    Brazilian Portuguese language file
 *
 * Authors:        Liran Tal <liran@lirantal.com>
 *                 Filippo Lauria <filippo.lauria@iit.cnr.it>
 *
 *********************************************************************************************************
 */

// prevent this file to be directly accessed
if (strpos($_SERVER['PHP_SELF'], '/lang/pt_br.php') !== false) {
    header("Location: ../index.php");
    exit;
}

$l['all']['daloRADIUS'] = sprintf("daloRADIUS %s", $configValues['DALORADIUS_VERSION']);
$l['all']['daloRADIUSVersion'] = sprintf("versão %s ", $configValues['DALORADIUS_VERSION']);
$l['all']['copyright1'] = 'RADIUS Management, Reporting, Accounting and Billing by <a target="_blank" href="https://github.com/lirantal/daloradius">Liran Tal</a>';
$l['all']['copyright2'] = 'daloRADIUS - Copyright &copy; 2007-' . date('Y') . <<<EOF
 <span class="d-inline-block" tabindex="0" data-bs-toggle="popover" data-bs-trigger="hover focus" data-bs-content="Follow @filippolauria on GitHub">
  <a target="_blank" href="https://github.com/filippolauria">Filippo Lauria</a>
</span>  and <a target="_blank" href="https://github.com/lirantal/daloradius">Liran Tal</a>.
EOF;

$l['all']['ID'] = "ID";
$l['all']['PoolName'] = "Nome da fila";
$l['all']['CalledStationId'] = "IDEstaçãoChamada";
$l['all']['CallingStationID'] = "IDEstaçãoChama";
$l['all']['ExpiryTime'] = "Tempo para expirar";
$l['all']['PoolKey'] = "Chave da Fila";

/********************************************************************************/
/* Vendor Attributes related translation                                        */
/********************************************************************************/
$l['all']['Dictionary'] = "Dicionario";
$l['all']['VendorID'] = "ID do Vendedor";
$l['all']['VendorName'] = "Nome do Vendedor";
$l['all']['VendorAttribute'] = "Atributos do vendedor";
$l['all']['RecommendedOP'] = "OP Recomendada";
$l['all']['RecommendedTable'] = "Tabela Recomendada";
$l['all']['RecommendedTooltip'] = "Dica da Ferramenta";
$l['all']['RecommendedHelper'] = "Ajuda Recomendada";
/********************************************************************************/

/* radius related text */
$l['all']['RADIUSDictionaryPath'] = "Caminho do dicionario do RADIUS";


$l['all']['Compare'] = "Comparar";

$l['all']['Section'] = "Secao";
$l['all']['Item'] = "Item";

$l['all']['RemoveRadacctRecords'] = "Remover Registros de Accounting";

$l['all']['CleanupSessions'] = "Limpar sessões anteriores a";
$l['all']['DeleteSessions'] = "Excluir sessões anteriores a";

$l['all']['StartingDate'] = "Data Inicial";
$l['all']['EndingDate'] = "Data Final";

$l['all']['Realm'] = "Reino";
$l['all']['RealmName'] = "Nome do Reino";
$l['all']['RealmSecret'] = "Senha do Reino";
$l['all']['AuthHost'] = "Autenticação Host";
$l['all']['AcctHost'] = "Conta do  Host";
$l['all']['Ldflag'] = "ldflag";
$l['all']['Nostrip'] = "sem tira";
$l['all']['Notrealm'] = "não é o reino";
$l['all']['Hints'] = "dicas";

$l['all']['Proxy'] = "Proxy";
$l['all']['ProxyName'] = "Nome do proxy";
$l['all']['ProxySecret'] = "Senha do Proxy";
$l['all']['DeadTime'] = "Hora Final";
$l['all']['RetryDelay'] = "Tentar novamente com atraso";
$l['all']['RetryCount'] = "Repetir Contagem";
$l['all']['DefaultFallback'] = "Retorno padrão";

$l['all']['FramedIPAddress'] = "Faixa de ip";
$l['all']['SimultaneousUse'] = "Uso Simultaneo";
$l['all']['NasID'] = "NAS ID";
$l['all']['Nas'] = "NAS ";
$l['all']['NasIPHost'] = "NAS IP/Host";
$l['all']['NasShortname'] = "NAS NomeCurto";
$l['all']['NasType'] = "NAS Tipo";
$l['all']['NasPorts'] = "NAS Portas";
$l['all']['NasSecret'] = "NAS Senha";
$l['all']['NasVirtualServer'] = "NAS Servidor Virtual";
$l['all']['NasCommunity'] = "NAS Comunidade";
$l['all']['NasDescription'] = "NAS Descrição";
$l['all']['PacketType'] = "Tipo de pacote";
$l['all']['HotSpot'] = "HotSpot";
$l['all']['HotSpots'] = "HotSpots";
$l['all']['HotSpotName'] = "Nome do Hotspot ";
$l['all']['Name'] = "Nome";
$l['all']['Username'] = "Usuário";
$l['all']['Password'] = "Senha";
$l['all']['PasswordType'] = "Tipo da Senha";
$l['all']['IPAddress'] = "Endereco IP";
$l['all']['Profile'] = "Perfil";
$l['all']['Group'] = "Grupo";
$l['all']['Groupname'] = "Nome do Grupo";
$l['all']['ProfilePriority'] = "Prioridade do Perfil";
$l['all']['GroupPriority'] = "Prioridade do Grupo";
$l['all']['CurrentGroupname'] = "Nome de grupo atual";
$l['all']['NewGroupname'] = "Novo nome de Grupo";
$l['all']['Priority'] = "Prioridade";
$l['all']['Attribute'] = "Atributo";
$l['all']['Operator'] = "Operador";
$l['all']['Value'] = "Valor";
$l['all']['NewValue'] = "Novo Valor";
$l['all']['MaxTimeExpiration'] = "Tempo maximo / Expiração";
$l['all']['UsedTime'] = "Tempo de uso";
$l['all']['Status'] = "Status";
$l['all']['Usage'] = "Uso";
$l['all']['StartTime'] = "Horário Inicial";
$l['all']['StopTime'] = "Horário Final";
$l['all']['TotalTime'] = "Tempo Total";
$l['all']['Bytes'] = "Bytes";
$l['all']['Upload'] = "Upload";
$l['all']['Download'] = "Download";
$l['all']['Rollback'] = "Reversão";
$l['all']['Termination'] = "Terminação";
$l['all']['NASIPAddress'] = "NAS - Endereço IP";
$l['all']['Action'] = "Ação";
$l['all']['UniqueUsers'] = "Usuário único ";
$l['all']['TotalHits'] = "Total Hits";
$l['all']['AverageTime'] = "Tempo Médio";
$l['all']['Records'] = "Registros";
$l['all']['Summary'] = "Sumário";
$l['all']['Statistics'] = "Statisticas";
$l['all']['Credit'] = "Credito";
$l['all']['Used'] = "Utilizado";
$l['all']['LeftTime'] = "Tempo Restante";
$l['all']['LeftPercent'] = "% de tempo restante";
$l['all']['TotalSessions'] = "Total de Sessões";
$l['all']['LastLoginTime'] = "Último Login";
$l['all']['TotalSessionTime'] = "Total da Sessão";
$l['all']['RateName'] = "Nome da taxa";
$l['all']['RateType'] = "Tipo da taxa";
$l['all']['RateCost'] = "Custo da taxa";
$l['all']['Billed'] = "Faturado";
$l['all']['TotalUsers'] = "Total de Usuários";
$l['all']['TotalBilled'] = "Total de Cobranças";
$l['all']['CardBank'] = "Cartão de credito";
$l['all']['Type'] = "Tipo";
$l['all']['CardBank'] = "Cartão de credito";
$l['all']['MACAddress'] = "Endereço do MAC";
$l['all']['Geocode'] = "Geocode";
$l['all']['PINCode'] = "Codigo PIN";
$l['all']['CreationDate'] = "Data de criação";
$l['all']['CreationBy'] = "Criado por";
$l['all']['UpdateDate'] = "Atualização de data";
$l['all']['UpdateBy'] = "Atualizado por";

$l['all']['Discount'] = "Desconto";
$l['all']['BillAmount'] = "Quantia paga";
$l['all']['BillAction'] = "Quantia faturada";
$l['all']['BillPerformer'] = "Fatura realizada";
$l['all']['BillReason'] = "Motivo da cobrança";
$l['all']['Lead'] = "Encaminhar";
$l['all']['Coupon'] = "Cupom";
$l['all']['OrderTaker'] = "Gerente de pedidos";
$l['all']['BillStatus'] = "Status da conta";
$l['all']['LastBill'] = "Ultima Conta";
$l['all']['NextBill'] = "Proxima Conta";
$l['all']['PostalInvoice'] = "Endereço para o pedido";
$l['all']['FaxInvoice'] = "Fax para o pedido";
$l['all']['EmailInvoice'] = "E-mail para o pedido";

$l['all']['edit'] = "editar";
$l['all']['del'] = "deletar";
$l['all']['groupslist'] = "Lista de grupos";
$l['all']['TestUser'] = "Testar Usuário";
$l['all']['Accounting'] = "Contas";
$l['all']['RADIUSReply'] = "RADIUS Resposta";

$l['all']['Disconnect'] = "Desconectar";

$l['all']['Debug'] = "Debug";
$l['all']['Timeout'] = "Tempo esgotado";
$l['all']['Retries'] = "Tentativa";
$l['all']['Count'] = "Contador";
$l['all']['Requests'] = "Requisição";

$l['all']['DatabaseHostname'] = "Host do banco de dados";
$l['all']['DatabaseUser'] = "Usuário do Banco";
$l['all']['DatabasePass'] = "Senha do Banco";
$l['all']['DatabaseName'] = "Nome do Banco";

$l['all']['PrimaryLanguage'] = "Linguagem primária";

$l['all']['PagesLogging'] = "Registro em páginas";
$l['all']['QueriesLogging'] = "Registro de consultas";
$l['all']['ActionsLogging'] = "Registro de ações";
$l['all']['FilenameLogging'] = "Registro de nome de arquivos";
$l['all']['LoggingDebugOnPages'] = "Registro de erros e informações";
$l['all']['LoggingDebugInfo'] = "Registro de erros e informações";

$l['all']['PasswordHidden'] = "Habilitar Esconder password";
$l['all']['TablesListing'] = "Registro de tabelas por página e listagem";
$l['all']['TablesListingNum'] = "Ativar numeração de listagem de tabelas";
$l['all']['AjaxAutoComplete'] = "Ativar Ajax Auto-Complete";

$l['all']['RadiusServer'] = "Radius Servidor";
$l['all']['RadiusPort'] = "Radius Porta";

$l['all']['UsernamePrefix'] = "Usuário Prefixo";
$l['all']['NumberInstances'] = "Número de instâncias para criar";
$l['all']['UsernameLength'] = "Cumprimento do nome";
$l['all']['PasswordLength'] = "Cumprimento do password";

$l['all']['Expiration'] = "Validade";
$l['all']['MaxAllSession'] = "Número Máximo de Sessão";
$l['all']['SessionTimeout'] = "Tempo máximo sessão";
$l['all']['IdleTimeout'] = "Tempo inativo";

$l['all']['DBEngine'] = "Driver Banco de dados";
$l['all']['radcheck'] = "radiocheck";
$l['all']['radreply'] = "radreply";
$l['all']['radgroupcheck'] = "radgroupcheck";
$l['all']['radgroupreply'] = "radgroupreply";
$l['all']['usergroup'] = "Grupo de Usuário";
$l['all']['radacct'] = "radacct";
$l['all']['operators'] = "operador";
$l['all']['billingrates'] = "Taxa de cobrança";
$l['all']['hotspots'] = "hotspots";
$l['all']['nas'] = "nas";
$l['all']['radpostauth'] = "Após Autenticação Radius";
$l['all']['radippool'] = "radipfaixa";
$l['all']['userinfo'] = "infousuario";
$l['all']['dictionary'] = "dicionario";
$l['all']['realms'] = "reino";
$l['all']['proxys'] = "proxys";
$l['all']['billingpaypal'] = "Fatura pelo paypal";
$l['all']['billingplans'] = "Forma de pagamento";
$l['all']['billinghistory'] = "Histórico de pagamentos";
$l['all']['billinginfo'] = "Informações do pagamento do usuario";

$l['all']['Month'] = "Mês";

$l['all']['PaymentDate'] = "Data de pagamento";
$l['all']['PaymentStatus'] = "Status do pagamentos";
$l['all']['FirstName'] = "Primeiro nome";
$l['all']['LastName'] = "Ultimo Nome";
$l['all']['VendorType'] = "Vendedor";
$l['all']['PayerStatus'] = "Status do pagamento";
$l['all']['PaymentAddressStatus'] = "Status do endereço de pagamento";
$l['all']['PayerEmail'] = "Email do pagamento";
$l['all']['TxnId'] = "Id da transação";
$l['all']['PlanTimeType'] = "Tempo do tipo de plano";
$l['all']['PlanTimeBank'] = "Tempo do tipo de bacno";
$l['all']['PlanTimeRefillCost'] = "Custo para recarga";
$l['all']['PlanTrafficRefillCost'] = "Plano de recarga";
$l['all']['PlanBandwidthUp'] = "Plano de upload";
$l['all']['PlanBandwidthDown'] = "Plano de  Download";
$l['all']['PlanTrafficTotal'] = "Plano de trafego  Total";
$l['all']['PlanTrafficDown'] = "Plano Trafego baixo";
$l['all']['PlanTrafficUp'] = "Plano Trafego alto";
$l['all']['PlanRecurring'] = "Plano Recorrente";
$l['all']['PlanRecurringPeriod'] = "Plano periodo recorrente";
$l['all']['PlanCost'] = "Custo do Plano";
$l['all']['PlanSetupCost'] = "Configuração custo do plano";
$l['all']['PlanTax'] = "Taxa do plano";
$l['all']['PlanCurrency'] = "Plano corrente";
$l['all']['PlanGroup'] = "Perfil do plano (Grupo)";
$l['all']['PlanType'] = "Tipo de plano";
$l['all']['PlanName'] = "Nome do Plano";
$l['all']['PlanId'] = "Id do Plano";
$l['all']['Quantity'] = "Quantidade";
$l['all']['ReceiverEmail'] = "Endereço de Email";
$l['all']['Business'] = "Negocios";
$l['all']['Tax'] = "Taxa";
$l['all']['Cost'] = "Custo";
$l['all']['TotalCost'] = "Custo Total";
$l['all']['TransactionFee'] = "imposto da transação";
$l['all']['PaymentCurrency'] = "Pagamento atual";
$l['all']['AddressRecipient'] = "Endereço do recebedor";
$l['all']['Street'] = "Rua";
$l['all']['Country'] = "Pais";
$l['all']['CountryCode'] = "Codigo do Páis";
$l['all']['City'] = "Cidade";
$l['all']['State'] = "Estado";
$l['all']['Zip'] = "CEP";

$l['all']['BusinessName'] = "Nome do negocio";
$l['all']['BusinessPhone'] = "Telefone da empresa";
$l['all']['BusinessAddress'] = "Endereço da empresa";
$l['all']['BusinessWebsite'] = "Site da empresa";
$l['all']['BusinessEmail'] = "Email da empresa";
$l['all']['BusinessContactPerson'] = "Contato pessoal da empresa";
$l['all']['DBPasswordEncryption'] = "Tipo de criptografia do banco";


/* **********************************************************************************
 * Tooltips
 * Helper information such as tooltip text for mouseover events and popup tooltips
 ************************************************************************************/

$l['Tooltip']['Username'] = "Digite o usuario";
$l['Tooltip']['UsernameWildcard'] = "Voçe pode usar * para especificar um curinga";
$l['Tooltip']['HotspotName'] = "Digita o nome do hotspot";
$l['Tooltip']['NasName'] = "Digite o nome do NAS";
$l['Tooltip']['GroupName'] = "Digite o nome do grupo";
$l['Tooltip']['AttributeName'] = "Digite o nome para atribuir";
$l['Tooltip']['VendorName'] = "Digite o nome da empresa";
$l['Tooltip']['PoolName'] = "Digite o nome da faixa";
$l['Tooltip']['IPAddress'] = "Digite o ip address";
$l['Tooltip']['Filter'] = "Digite um filtro, pode ser qualquer sequência alfanumérica. Deixe em branco para combinar com qualquer coisa. ";
$l['Tooltip']['Date'] = "Digite a data no formato : 1982-06-04 (Y-M-D)";
$l['Tooltip']['RateName'] = "Digite o nome da TAxa";
$l['Tooltip']['OperatorName'] = "Digite o nome do operador";
$l['Tooltip']['BillingPlanName'] = "Digite o nome do plano";

$l['Tooltip']['EditRate'] = "Edite a taxa";
$l['Tooltip']['RemoveRate'] = "Remova a taxa";

$l['Tooltip']['rateNameTooltip'] = "Nome para a taxa,<br/>
                    para descrever o objetivo da taxa ";
$l['Tooltip']['rateTypeTooltip'] = "Tipo de taxa <br/>
                    o que essa taxa faz";
$l['Tooltip']['rateCostTooltip'] = "O valor do custo da taxa";

$l['Tooltip']['planNameTooltip'] = "O nome do plano<br/>
                    breve descrição do plano";
$l['Tooltip']['planIdTooltip'] = "";
$l['Tooltip']['planTimeTypeTooltip'] = "";
$l['Tooltip']['planTimeBankTooltip'] = "";
$l['Tooltip']['planTimeRefillCostTooltip'] = "";
$l['Tooltip']['planTrafficRefillCostTooltip'] = "";
$l['Tooltip']['planBandwidthUpTooltip'] = "";
$l['Tooltip']['planBandwidthDownTooltip'] = "";
$l['Tooltip']['planTrafficTotalTooltip'] = "";
$l['Tooltip']['planTrafficDownTooltip'] = "";
$l['Tooltip']['planTrafficUpTooltip'] = "";

$l['Tooltip']['planRecurringTooltip'] = "";
$l['Tooltip']['planRecurringPeriodTooltip'] = "";
$l['Tooltip']['planCostTooltip'] = "";
$l['Tooltip']['planSetupCostTooltip'] = "";
$l['Tooltip']['planTaxTooltip'] = "";
$l['Tooltip']['planCurrencyTooltip'] = "";
$l['Tooltip']['planGroupTooltip'] = "";

$l['Tooltip']['EditIPPool'] = "Editar faixa de ip";
$l['Tooltip']['RemoveIPPool'] = "Remover faixa de ip";
$l['Tooltip']['EditIPAddress'] = "Editar endereço ip";
$l['Tooltip']['RemoveIPAddress'] = "Remover endereço de ip";

$l['Tooltip']['BusinessNameTooltip'] = "";
$l['Tooltip']['BusinessPhoneTooltip'] = "";
$l['Tooltip']['BusinessAddressTooltip'] = "";
$l['Tooltip']['BusinessWebsiteTooltip'] = "";
$l['Tooltip']['BusinessEmailTooltip'] = "";
$l['Tooltip']['BusinessContactPersonTooltip'] = "";

$l['Tooltip']['proxyNameTooltip'] = "Nome do proxy";
$l['Tooltip']['proxyRetryDelayTooltip'] = "Tempo em segundos que falta <br/>
                    para o proxy responder, <br/>
                    após ser enviado a requisição para o proxy.";
$l['Tooltip']['proxyRetryCountTooltip'] = "O numero de tentativas para reenviar <br/>
                    apos reenviar <br/>
                    mensagem rejeitado peloa NAS";
$l['Tooltip']['proxyDeadTimeTooltip'] = "Se o servidor não responder <br/>
                    para varios servidores, <br/>
                    freeraius parou de responder <br/>
                    após requisições não resondeu o proxy.";
$l['Tooltip']['proxyDefaultFallbackTooltip'] = "Nome identico ao do reino <br/>
                        não precisa responder <br/>
                        ";
$l['Tooltip']['realmNameTooltip'] = "Nome do reino";
$l['Tooltip']['realmTypeTooltip'] = "Escolher Servidor radius default";
$l['Tooltip']['realmSecretTooltip'] = "Chave compartilhado do reino e radius ";
$l['Tooltip']['realmAuthhostTooltip'] = "Reino auteticação no dominio";
$l['Tooltip']['realmAccthostTooltip'] = "Conta do host ";
$l['Tooltip']['realmLdflagTooltip'] = "Permitido balanceamento <br/>
                    em caso de  'fail_over' <br/>
                    ou 'round_robin'.";
$l['Tooltip']['realmNostripTooltip'] = "Remover sufixo do dominio <br/>
                    ";
$l['Tooltip']['realmHintsTooltip'] = "";
$l['Tooltip']['realmNotrealmTooltip'] = "";


$l['Tooltip']['vendorNameTooltip'] = "Example: Cisco<br/>&nbsp;&nbsp;&nbsp;
                                        The Vendor's name.<br/>&nbsp;&nbsp;&nbsp;";
$l['Tooltip']['typeTooltip'] = "Example: string<br/>&nbsp;&nbsp;&nbsp;
                                        The attributes variable type<br/>&nbsp;&nbsp;&nbsp;
                    (string, integer, date, ipaddr).";
$l['Tooltip']['attributeTooltip'] = "Example: Framed-IPAddress<br/>&nbsp;&nbsp;&nbsp;
                                        The exact attribute name.<br/>&nbsp;&nbsp;&nbsp;";

$l['Tooltip']['RecommendedOPTooltip'] = "Example: :=<br/>&nbsp;&nbsp;&nbsp;
                                        The recommended attribute's operator.<br/>&nbsp;&nbsp;&nbsp;
                    (one of: := == != etc...)";
$l['Tooltip']['RecommendedTableTooltip'] = "Example: check<br/>&nbsp;&nbsp;&nbsp;
                                        The recommended target table.<br/>&nbsp;&nbsp;&nbsp;
                    (either check or reply).";
$l['Tooltip']['RecommendedTooltipTooltip'] = "Example: the ip address for the user<br/>&nbsp;&nbsp;&nbsp;
                                        The recommended tooltip.<br/>&nbsp;&nbsp;&nbsp;";
$l['Tooltip']['RecommendedHelperTooltip'] = "The helper function which will be<br/>&nbsp;&nbsp;&nbsp;
                                        available when adding this attribute<br/>&nbsp;&nbsp;&nbsp;";



$l['Tooltip']['AttributeEdit'] = "Editar Atributo";


$l['Tooltip']['UserEdit'] = "Editar Usuário";
$l['Tooltip']['HotspotEdit'] = "Editar Hotspot";
$l['Tooltip']['EditNAS'] = "Editar NAS";
$l['Tooltip']['RemoveNAS'] = "Remover NAS";

$l['Tooltip']['EditUserGroup'] = "Editar Usuário do Group";
$l['Tooltip']['ListUserGroups'] = "Listar Usuário dos Grupos";

$l['Tooltip']['EditProfile'] = "Editar Perfil";

$l['Tooltip']['EditRealm'] = "Editar Reino";
$l['Tooltip']['EditProxy'] = "Editar Proxy";

$l['Tooltip']['EditGroup'] = "Editar Grupo";

$l['FormField']['mngradgroupcheck.php']['ToolTip']['Value'] = "Se você especificar o valor, apenas o registro único que corresponder ao nome do grupo e ao valor específico que você especificou será removido. Se você omitir o valor, todos os registros para esse nome de grupo específico serão removidos!";

$l['FormField']['mngradgroupreplydel.php']['ToolTip']['Value'] = "Se você especificar o valor, apenas o registro único que corresponder ao nome do grupo e ao valor específico que você especificou será removido. Se você omitir o valor, todos os registros para esse nome de grupo específico serão removidos!";

$l['FormField']['mngradnasnew.php']['ToolTip']['NasShortname'] = "(Descrição do nome)";

$l['FormField']['mngradusergroupdel.php']['ToolTip']['Groupname'] = "Se você especificar grupo, apenas o registro único que corresponder ao nome de usuário e ao grupo que você especificou será removido. Se você omitir o grupo, todos os registros para esse usuário específico serão removidos!";

$l['Tooltip']['usernameTooltip'] = "O nome exato do usuario <br/>&nbsp;&nbsp;&nbsp;
                    para se conectar no sistema";
$l['Tooltip']['passwordTypeTooltip'] = "O password digitado corresponde ao usuario do radius";
$l['Tooltip']['passwordTooltip'] = "O password  é case sensitive<br/>&nbsp;&nbsp;&nbsp;
                    Tenha um cuidado dobrado";
$l['Tooltip']['groupTooltip'] = "O usuario foi adicionado ao grupo<br/>&nbsp;&nbsp;&nbsp;
                    Usuário particular adicionado ao grupo<br/>&nbsp;&nbsp;&nbsp;
                    O usuario é o assunto's attributes";
$l['Tooltip']['macaddressTooltip'] = "Exemplo: 00:AA:BB:CC:DD:EE<br/>&nbsp;&nbsp;&nbsp;
                    O formato do endereço MAC deve ser o mesmo<br/>&nbsp;&nbsp;&nbsp;
                    como o NAS envia. Principalmente isso é sem<br/>&nbsp;&nbsp;&nbsp;
                    qualquer caracter";
$l['Tooltip']['pincodeTooltip'] = "Exemplo: khrivnxufi101<br/>&nbsp;&nbsp;&nbsp;
                    Esse é o código exato, conforme o usuário o digitará.<br/>&nbsp;&nbsp;&nbsp;
                    Você pode usar caracteres alfanuméricos, caso sensível";
$l['Tooltip']['usernamePrefixTooltip'] = "Exemplo: TMP_ POP_ WIFI1_ <br/>&nbsp;&nbsp;&nbsp;
                    O usuario foi adicionando <br/>&nbsp;&nbsp;&nbsp;
                    o usuario foi gerado finalmente.";
$l['Tooltip']['instancesToCreateTooltip'] = "Exemplo: 100<br/>&nbsp;&nbsp;&nbsp;
                    A quantidade de usuarios aleatorios a serem criados<br/>&nbsp;&nbsp;&nbsp;
                    em perfil especifico.";
$l['Tooltip']['lengthOfUsernameTooltip'] = "Exemplo: 8<br/>&nbsp;&nbsp;&nbsp;
                    O comprimento dos caracteres do nome de usuário<br/>&nbsp;&nbsp;&nbsp;
                    recomendado de 8-12  caracteres.";
$l['Tooltip']['lengthOfPasswordTooltip'] = "Exemplo: 8<br/>&nbsp;&nbsp;&nbsp;
                    O cumprimento do password<br/>&nbsp;&nbsp;&nbsp;
                    Recomendado de  8-12 caracteres.";


$l['Tooltip']['hotspotNameTooltip'] = "Exemplo: Hotel Stratocaster<br/>&nbsp;&nbsp;&nbsp;
                    nome amigavel para o hotspot <br/>";

$l['Tooltip']['hotspotMacaddressTooltip'] = "Exeplo: 00:aa:bb:cc:dd:ee<br/>&nbsp;&nbsp;&nbsp;
                    Endereço mac do  NAS<br/>";

$l['Tooltip']['geocodeTooltip'] = "Exemplo: -1.002,-2.201<br/>&nbsp;&nbsp;&nbsp;
                    A localização do google maps será usuada<br/>&nbsp;&nbsp;&nbsp;
                    para o pin do NAS/HOTSPOT  (olhe GIS).";


/* ********************************************************************************** */




/* **********************************************************************************
 * Links and Buttons
 ************************************************************************************/
$l['button']['ClearSessions'] = "Limpar Sessão";

$l['button']['ListRates'] = "Lista de taxas";
$l['button']['NewRate'] = "Novas taxas";
$l['button']['EditRate'] = "Editar taxas";
$l['button']['RemoveRate'] = "Remover taxa";

$l['button']['ListPlans'] = "Listar Planos";
$l['button']['NewPlan'] = "Novo Plano";
$l['button']['EditPlan'] = "Editar Plano";
$l['button']['RemovePlan'] = "Remover Plano";

$l['button']['ListRealms'] = "Listar Reino";
$l['button']['NewRealm'] = "Novo Reino";
$l['button']['EditRealm'] = "Editar Reino";
$l['button']['RemoveRealm'] = "Remover Reino";

$l['button']['ListProxys'] = "Listar Proxys";
$l['button']['NewProxy'] = "Novo Proxy";
$l['button']['EditProxy'] = "Editar Proxy";
$l['button']['RemoveProxy'] = "Remover Proxy";

$l['button']['ListAttributesforVendor'] = "Listar atributos para vendedor:";
$l['button']['NewVendorAttribute'] = "Novo atributo para vendedor";
$l['button']['EditVendorAttribute'] = "Editar atributo do vendedor";
$l['button']['SearchVendorAttribute'] = "Procura atributos";
$l['button']['RemoveVendorAttribute'] = "Remover atributtos do vendedor";
$l['button']['ImportVendorDictionary'] = "Importar dicionario do vendedor";


$l['button']['BetweenDates'] = "Entre datas:";
$l['button']['Where'] = "Onde";
$l['button']['AccountingFieldsinQuery'] = "Campos contábeis na consulta:";
$l['button']['OrderBy'] = "Ordenar por";
$l['button']['HotspotAccounting'] = "Hotspot Conta";
$l['button']['HotspotsComparison'] = "Hotspots Comparação";

$l['button']['CleanupStaleSessions'] = "Sessões obsoletas da limpeza";
$l['button']['DeleteAccountingRecords'] = "Deletando gravações de contas";

$l['button']['ListUsers'] = "Listar Usuários";
$l['button']['NewUser'] = "Novo Usuário";
$l['button']['NewUserQuick'] = "Novo Usuário - Rapido";
$l['button']['BatchAddUsers'] = "Adicionar usuários em lote";
$l['button']['EditUser'] = "Editar Usuário";
$l['button']['SearchUsers'] = "Procurar Usuários";
$l['button']['RemoveUsers'] = "Remover Usuários";
$l['button']['ListHotspots'] = "Listar Hotspots";
$l['button']['NewHotspot'] = "Novo Hotspot";
$l['button']['EditHotspot'] = "Editar Hotspot";
$l['button']['RemoveHotspot'] = "Remover Hotspot";

$l['button']['ListIPPools'] = "Listar IP-da-faixa";
$l['button']['NewIPPool'] = "Novo IP-na-faixa";
$l['button']['EditIPPool'] = "Editar IP-da-faixa";
$l['button']['RemoveIPPool'] = "Remover IP-da-faixa";

$l['button']['ListNAS'] = "Listar NAS";
$l['button']['NewNAS'] = "Novo NAS";
$l['button']['EditNAS'] = "Editar NAS";
$l['button']['RemoveNAS'] = "Remover NAS";

$l['button']['ListUserGroup'] = "Listar Usuário-Grupos Mapeados";
$l['button']['ListUsersGroup'] = "Listar  Usuários e Grupo Mapeados";
$l['button']['NewUserGroup'] = "Novo Usuário-Grupo Mapeados";
$l['button']['EditUserGroup'] = "Editar Usuário-Grupo Mapeados";
$l['button']['RemoveUserGroup'] = "Remover Usuário-Grupo Mapeados";

$l['button']['ListProfiles'] = "Listar Perfil";
$l['button']['NewProfile'] = "Novo Perfil";
$l['button']['EditProfile'] = "Editar Perfil";
$l['button']['DuplicateProfile'] = "Duplicar Perfil";
$l['button']['RemoveProfile'] = "Remover Perfil";

$l['button']['ListGroupReply'] = "Listar Grupo Reposta Mapeadas";
$l['button']['SearchGroupReply'] = "Procurar grupo de resposta";
$l['button']['NewGroupReply'] = "Novo grupo de resposta mapeada";
$l['button']['EditGroupReply'] = "Editar Grupo Resposta Mapeada";
$l['button']['RemoveGroupReply'] = "Remover Grupo Resposta Mapeada";

$l['button']['ListGroupCheck'] = "Listar Grupo Checar Mapeados";
$l['button']['SearchGroupCheck'] = "Procura Grupo Checado";
$l['button']['NewGroupCheck'] = "Novo Grupo Checado e Mapeado";
$l['button']['EditGroupCheck'] = "Editar Grupo Checado e Mapeado";
$l['button']['RemoveGroupCheck'] = "Remover Grupo Checado Mapeado";

$l['button']['UserAccounting'] = "Conta de Usuário ";
$l['button']['IPAccounting'] = "IP da conta";
$l['button']['NASIPAccounting'] = "NAS IP Conta";
$l['button']['NASIPAccountingOnlyActive'] = "Mostre Somente ativos";
$l['button']['DateAccounting'] = "Data da conta";
$l['button']['AllRecords'] = "Todos os registros";
$l['button']['ActiveRecords'] = "Gravações ativas";

$l['button']['OnlineUsers'] = "Usuários Online";
$l['button']['LastConnectionAttempts'] = "Ultima tentativa de conexão";
$l['button']['TopUser'] = "Usuários Maior Trafego";
$l['button']['History'] = "Histórico";

$l['button']['ServerStatus'] = "Status do servidor";
$l['button']['ServicesStatus'] = "Status do serviço";

$l['button']['daloRADIUSLog'] = "daloRADIUS Log";
$l['button']['RadiusLog'] = "Radius Log";
$l['button']['SystemLog'] = "Logs do Sistema";
$l['button']['BootLog'] = "Boot Log";

$l['button']['UserLogins'] = "Logins de usuário";
$l['button']['UserDownloads'] = "Download de Usuários";
$l['button']['UserUploads'] = "Upload to usuarios";
$l['button']['TotalLogins'] = "Total de Logins";
$l['button']['TotalTraffic'] = "Total Trafego";

$l['button']['ViewMAP'] = "Visão do  MAPA";
$l['button']['EditMAP'] = "Editar MAPA";
$l['button']['RegisterGoogleMapsAPI'] = "RegisterGoogleMaps API";

$l['button']['DatabaseSettings'] = "Configurações do Banco de dados";
$l['button']['LanguageSettings'] = "Configurações de linguagem";
$l['button']['LoggingSettings'] = "Configurações de log";
$l['button']['InterfaceSettings'] = "Configurações da interface";

$l['button']['TestUserConnectivity'] = "Testar conectividade do usuário";
$l['button']['DisconnectUser'] = "Desconectar Usuário";

$l['button']['ManageBackups'] = "Gerenciar Backups";
$l['button']['CreateBackups'] = "Criar Backups";

$l['button']['ListOperators'] = "Listar Operadores";
$l['button']['NewOperator'] = "Novo Operador";
$l['button']['EditOperator'] = "Editar Operador";
$l['button']['RemoveOperator'] = "Remover Operador";

$l['button']['ProcessQuery'] = "Processar consulta";



/* ********************************************************************************** */


/* **********************************************************************************
 * Titles
 * The text related to all the title headers in captions,tables and tabbed layout text
 ************************************************************************************/

$l['title']['RateInfo'] = "Informação da taxa";
$l['title']['PlanInfo'] = "Informação do plano";
$l['title']['TimeSettings'] = "Configurações do Tempo";
$l['title']['BandwidthSettings'] = "Configurações da banda";
$l['title']['PlanRemoval'] = "Remover plano";

$l['title']['Backups'] = "Backups";
$l['title']['FreeRADIUSTables'] = "FreeRADIUS Tabelas";
$l['title']['daloRADIUSTables'] = "daloRADIUS Tabelas";

$l['title']['IPPoolInfo'] = "IP-da-faixa Informação";

$l['title']['BusinessInfo'] = "Informação do negocio";

$l['title']['CleanupRecords'] = "Limpando gravações";
$l['title']['DeleteRecords'] = "Deletar gravações";

$l['title']['RealmInfo'] = "Informação do Reino";

$l['title']['ProxyInfo'] = "Informação do proxy";

$l['title']['VendorAttribute'] = "Atributo do vendedor";

$l['title']['AccountRemoval'] = "Remover conta";
$l['title']['AccountInfo'] = "Informações da conta";

$l['title']['Profiles'] = "perfils";
$l['title']['ProfileInfo'] = "Informação dos perfils";

$l['title']['GroupInfo'] = "Informação do grupo";
$l['title']['GroupAttributes'] = "Atributos do grupo";

$l['title']['NASInfo'] = "Informação do NAS";
$l['title']['NASAdvanced'] = "Configuração avançada do NAS ";

$l['title']['UserInfo'] = "Informação do usuário";
$l['title']['BillingInfo'] = "Informação do pagamento";

$l['title']['Attributes'] = "Atributos";
$l['title']['ProfileAttributes'] = "Atributos do perfil";

$l['title']['HotspotInfo'] = "Informação do Hotspot";
$l['title']['HotspotRemoval'] = "Remover Hotspot";

$l['title']['ContactInfo'] = "Informações do Contato";

$l['title']['Plan'] = "Planos";

$l['title']['Profile'] = "Perfil";
$l['title']['Groups'] = "Grupos";
$l['title']['RADIUSCheck'] = "Checar atributos";
$l['title']['RADIUSReply'] = "Resposta Atributos";

$l['title']['Settings'] = "Configurações";
$l['title']['DatabaseSettings'] = "Configurações do Banco de Dados";
$l['title']['DatabaseTables'] = "Tabelas do Banco";
$l['title']['AdvancedSettings'] = "Configurações avançadas";

$l['title']['Advanced'] = "Avançadas";
$l['title']['Optional'] = "Opcional";

/* ********************************************************************************** */


/* **********************************************************************************
 * Text
 * General text information that is used through-out the pages
 ************************************************************************************/

$l['text']['LoginRequired'] = "Login é Requirido";
$l['text']['LoginPlease'] = "Login Por Favor";

/* ********************************************************************************** */



/* **********************************************************************************
 * Contact Info
 * Related to all contact info text, user info, hotspot owner contact information etc
 ************************************************************************************/

$l['ContactInfo']['FirstName'] = "Primeiro Nome";
$l['ContactInfo']['LastName'] = "Ultimo Nome";
$l['ContactInfo']['Email'] = "E-mail";
$l['ContactInfo']['Department'] = "Departmentos";
$l['ContactInfo']['WorkPhone'] = "Telefone do trabalho";
$l['ContactInfo']['HomePhone'] = "Telefone Residencial ";
$l['ContactInfo']['Phone'] = "Telefone";
$l['ContactInfo']['MobilePhone'] = "Telefone Celular";
$l['ContactInfo']['Notes'] = "Observações";
$l['ContactInfo']['EnableUserUpdate'] = "Habilitar atualização do usuário";

$l['ContactInfo']['OwnerName'] = "Nome do dono";
$l['ContactInfo']['OwnerEmail'] = "E-mail do dono";
$l['ContactInfo']['ManagerName'] = "Nome do gerente";
$l['ContactInfo']['ManagerEmail'] = "E-mail do gerente";
$l['ContactInfo']['Company'] = "Compania";
$l['ContactInfo']['Address'] = "Endereço";
$l['ContactInfo']['City'] = "Cidade";
$l['ContactInfo']['State'] = "Estado";
$l['ContactInfo']['Zip'] = "CEP";
$l['ContactInfo']['Phone1'] = "Telefone 1";
$l['ContactInfo']['Phone2'] = "Telefone 2";
$l['ContactInfo']['HotspotType'] = "Tipo de Hotspot";
$l['ContactInfo']['CompanyWebsite'] = "Site da empresa";
$l['ContactInfo']['CompanyPhone'] = "Telefone da empresa";
$l['ContactInfo']['CompanyEmail'] = "Email da empresa";
$l['ContactInfo']['CompanyContact'] = "Contato na empresa";

$l['ContactInfo']['PlanName'] = "Nome do plano";
$l['ContactInfo']['ContactPerson'] = "Pessoa para contato";
$l['ContactInfo']['PaymentMethod'] = "Metodo de pagamento";
$l['ContactInfo']['Cash'] = "Dinheiro";
$l['ContactInfo']['CreditCardNumber'] = "Numero do cartão";
$l['ContactInfo']['CreditCardName'] = "Nome do cartão";
$l['ContactInfo']['CreditCardVerificationNumber'] = "Codigo de segurança";
$l['ContactInfo']['CreditCardType'] = "Tipo de cartão de credito";
$l['ContactInfo']['CreditCardExpiration'] = "Validade do cartão";

/* ********************************************************************************** */


$l['Intro']['billhistorymain.php'] = "Histórico de pagamento";
$l['Intro']['msgerrorpermissions.php'] = "Erro";

$l['Intro']['mngradproxys.php'] = "Gerenciando os Proxys";
$l['Intro']['mngradproxysnew.php'] = "Novo Proxy";
$l['Intro']['mngradproxyslist.php'] = "Listar Proxy";
$l['Intro']['mngradproxysedit.php'] = "Editar Proxy";
$l['Intro']['mngradproxysdel.php'] = "Remover Proxy";

$l['Intro']['mngradrealms.php'] = "Gerenciar Reino";
$l['Intro']['mngradrealmsnew.php'] = "Novo Reino";
$l['Intro']['mngradrealmslist.php'] = "Listar Reino";
$l['Intro']['mngradrealmsedit.php'] = "Editar Reino";
$l['Intro']['mngradrealmsdel.php'] = "Remover Reino";

$l['Intro']['mngradattributes.php'] = "Atributos do vendedor gerente";
$l['Intro']['mngradattributeslist.php'] = "Lista atributos do gerente";
$l['Intro']['mngradattributesnew.php'] = "Novo atributo do vendedor";
$l['Intro']['mngradattributesedit.php'] = "Editar atributos do vendedor";
$l['Intro']['mngradattributessearch.php'] = "Procurar atributos";
$l['Intro']['mngradattributesdel.php'] = "Remover atributos do vendedor";
$l['Intro']['mngradattributesimport.php'] = "Importar dicionario do vendedor";


$l['Intro']['acctactive.php'] = "Registro ativos na conta";
$l['Intro']['acctall.php'] = "Todos os usuarios da conta";
$l['Intro']['acctdate.php'] = "Filtrar por data a conta";
$l['Intro']['accthotspot.php'] = "Conta do Hotspot";
$l['Intro']['acctipaddress.php'] = "IP da conta";
$l['Intro']['accthotspotcompare.php'] = "Comparando Hotspot";
$l['Intro']['acctmain.php'] = "Pagina da conta";
$l['Intro']['acctnasipaddress.php'] = "IP do NAS";
$l['Intro']['acctusername.php'] = "Conta do usuário";
$l['Intro']['acctcustom.php'] = "Personalizando a Conta";
$l['Intro']['acctcustomquery.php'] = "Personalizando pesquisa na conta";
$l['Intro']['acctmaintenance.php'] = "Registro de conta em manutenção";
$l['Intro']['acctmaintenancecleanup.php'] = "Limpando status da manutenção";
$l['Intro']['acctmaintenancedelete.php'] = "Deletando gravações da conta";

$l['Intro']['billmain.php'] = "Pagina de pagamento";
$l['Intro']['ratesmain.php'] = "Pagina de pagamento de taxas";
$l['Intro']['billratesdate.php'] = "Prepagamento da conta";
$l['Intro']['billratesdel.php'] = "Remover taxa de entrada";
$l['Intro']['billratesedit.php'] = "Editar detalhe das taxas";
$l['Intro']['billrateslist.php'] = "Tabela de taxas";
$l['Intro']['billratesnew.php'] = "Nova entrada de taxas";

$l['Intro']['paypalmain.php'] = "Pagina de transação do PayPal";
$l['Intro']['billpaypaltransactions.php'] = "Paginas de pagamentos do PayPal";

$l['Intro']['billhistoryquery.php'] = "Histórico de pagamento";

$l['Intro']['billplans.php'] = "Pagina de pagamento dos planos";
$l['Intro']['billplansdel.php'] = "Deletar entrada de planos";
$l['Intro']['billplansedit.php'] = "Editar detalhes do plano ";
$l['Intro']['billplanslist.php'] = "Tabelas de Planos";
$l['Intro']['billplansnew.php'] = "Nova entrada de plano";

$l['Intro']['billpos.php'] = "Pagina do ponto de vendas";
$l['Intro']['billposdel.php'] = "Deletar Usuário ";
$l['Intro']['billposedit.php'] = "Editar Usuário";
$l['Intro']['billposlist.php'] = "Listar Usuário";
$l['Intro']['billposnew.php'] = "Novo Usuário";

$l['Intro']['giseditmap.php'] = "Editar modo do  MAPA ";
$l['Intro']['gismain.php'] = "GIS Mapeado";
$l['Intro']['gisviewmap.php'] = "Visualize Modo do MAPA";

$l['Intro']['graphmain.php'] = "Grafico do uso";
$l['Intro']['graphsalltimetrafficcompare.php'] = "Comparando total trafego de uso ";
$l['Intro']['graphsalltimelogins.php'] = "Total de Logins";
$l['Intro']['graphsoveralldownload.php'] = "Download dos usuarios";
$l['Intro']['graphsoveralllogins.php'] = "Logins dos usuarios";
$l['Intro']['graphsoverallupload.php'] = "Uploads dos Usuários";

$l['Intro']['rephistory.php'] = "Histórico de ações";
$l['Intro']['replastconnect.php'] = "50 Ultimas tentativas de conexão";
$l['Intro']['repstatradius.php'] = "Informações do Daemon";
$l['Intro']['repstatserver.php'] = "Status do Servidor e informações";
$l['Intro']['reponline.php'] = "Listando usuarios logados";
$l['Intro']['replogssystem.php'] = "Logfile do sistema";
$l['Intro']['replogsradius.php'] = "Logfile do servidor RADIUS";
$l['Intro']['replogsdaloradius.php'] = "Logfile daloRADIUS";
$l['Intro']['replogsboot.php'] = "Logfile do Boot";
$l['Intro']['replogs.php'] = "Logs";

$l['Intro']['rephsall.php'] = "Lista de Hotspots";
$l['Intro']['repmain.php'] = "Pagina de relatório";
$l['Intro']['repstatus.php'] = "Pagina de Status";
$l['Intro']['replogs.php'] = "Pagina de logs";
$l['Intro']['reptopusers.php'] = "Usuários mas ativos";
$l['Intro']['repusername.php'] = "Listando usuários";

$l['Intro']['mngbatch.php'] = "Criar usuarios em lotes";
$l['Intro']['mngdel.php'] = "Remover Usuário";
$l['Intro']['mngedit.php'] = "Editar detalhes do usuário";
$l['Intro']['mnglistall.php'] = "Listando Usuários";
$l['Intro']['mngmain.php'] = "Gerenciando Usuários e HOTSPOT";
$l['Intro']['mngnew.php'] = "Novo Usuário";
$l['Intro']['mngnewquick.php'] = "Adicionar usuário Rapido";
$l['Intro']['mngsearch.php'] = "Procurar usuário";

$l['Intro']['mnghsdel.php'] = "Remover Hotspot";
$l['Intro']['mnghsedit.php'] = "Editar Detalhes do  Hotspots";
$l['Intro']['mnghslist.php'] = "Listar Hotspots";
$l['Intro']['mnghsnew.php'] = "Novo Hotspot";

$l['Intro']['mngradusergroupdel.php'] = "Remove Usuários-Grupos Mapeados";
$l['Intro']['mngradusergroup.php'] = "Configuração Usuários-Grupos Mapeados";
$l['Intro']['mngradusergroupnew.php'] = "Novo  Usuários-Grupos Mapeados";
$l['Intro']['mngradusergrouplist'] = "Mapeando Usuários-Grupos no Banco de Dados";
$l['Intro']['mngradusergrouplistuser'] = "Usuários-Grupos Mapeado no Banco de Dados";
$l['Intro']['mngradusergroupedit'] = "Editando  Usuários-Grupos Mapeado para usuario:";

$l['Intro']['mngradippool.php'] = "Configuração de Faixa de IP ";
$l['Intro']['mngradippoolnew.php'] = "Nova Faixa de ip";
$l['Intro']['mngradippoollist.php'] = "Listar Faixa de IP";
$l['Intro']['mngradippooledit.php'] = "Editar Faixa de IP";
$l['Intro']['mngradippooldel.php'] = "Remover Faixa de IP";

$l['Intro']['mngradnas.php'] = "Configuração do NAS";
$l['Intro']['mngradnasnew.php'] = "Novo registro no  NAS";
$l['Intro']['mngradnaslist.php'] = "Listando banco de dados de NAS";
$l['Intro']['mngradnasedit.php'] = "Editar registros do  NAS ";
$l['Intro']['mngradnasdel.php'] = "Remover registro do NAS";

$l['Intro']['mngradprofiles.php'] = "Configuração de Perfil";
$l['Intro']['mngradprofilesedit.php'] = "Editar Perfil";
$l['Intro']['mngradprofilesduplicate.php'] = "Duplicar Perfil";
$l['Intro']['mngradprofilesdel.php'] = "Deletar Perfil";
$l['Intro']['mngradprofileslist.php'] = "Listar Perfil";
$l['Intro']['mngradprofilesnew.php'] = "Novo Perfil";

$l['Intro']['mngradgroups.php'] = "Configuração do grupo";

$l['Intro']['mngradgroupreplynew.php'] = "Novo Grupo de resposta Mapeada";
$l['Intro']['mngradgroupreplylist.php'] = "Grupo de resposta mapeado no Banco de dados";
$l['Intro']['mngradgroupreplyedit.php'] = "Editar resposta do Grupo mapeado para o grupo:";
$l['Intro']['mngradgroupreplydel.php'] = "Remover grupo de resposta mapeada";
$l['Intro']['mngradgroupreplysearch.php'] = "Procura grupo de resposta mapeada";

$l['Intro']['mngradgroupchecknew.php'] = "Novo grupo de resposta valida";
$l['Intro']['mngradgroupchecklist.php'] = "Grupo valiido maṕeado em banco de dados";
$l['Intro']['mngradgroupcheckedit.php'] = "Editar grupo valido mapeado para grupo:";
$l['Intro']['mngradgroupcheckdel.php'] = "Remover grupo valido";
$l['Intro']['mngradgroupchecksearch.php'] = "Procura grupo valido";

$l['Intro']['configdb.php'] = "Configuração Banco de Dados";
$l['Intro']['configlang.php'] = "Configuração de Linguagem";
$l['Intro']['configlogging.php'] = "Configurações de LOGS";
$l['Intro']['configinterface.php'] = "Configuração de interface web";
$l['Intro']['configmainttestuser.php'] = "Testando conectividade do usuario";
$l['Intro']['configmain.php'] = "Configuração Banco de Dados";
$l['Intro']['configmaint.php'] = "Manutenção";
$l['Intro']['configmaintdisconnectuser.php'] = "Disconectar Usuário";
$l['Intro']['configbusiness.php'] = "Detalhes do negocio";
$l['Intro']['configbusinessinfo.php'] = "Informações do negocio";
$l['Intro']['configbackup.php'] = "Backup";
$l['Intro']['configbackupcreatebackups.php'] = "Criar Backups";
$l['Intro']['configbackupmanagebackups.php'] = "Gerenciar Backups";

$l['Intro']['configoperators.php'] = "Configurações do Operador";
$l['Intro']['configoperatorsdel.php'] = "Remover Operador";
$l['Intro']['configoperatorsedit.php'] = "Editar configurações do Operador";
$l['Intro']['configoperatorsnew.php'] = "Novo Operador";
$l['Intro']['configoperatorslist.php'] = "Lista de Operador";

$l['Intro']['login.php'] = "Login";

$l['captions']['providebillratetodel'] = "Forneça o tipo de entrada de tarifa que você deseja remover";
$l['captions']['detailsofnewrate'] = "Você pode preencher os detalhes abaixo para a nova tarifa";
$l['captions']['filldetailsofnewrate'] = "Preencha abaixo os detalhes para a nova entrada de tarifa";

/* **********************************************************************************
 * Help Pages Info
 * Each page has a header which is the Intro class, when clicking on the header
 * it will reveal/hide a helpPage div content which is a description of a specific
 * page, basically your expanded tool-tip.
 ************************************************************************************/


$l['helpPage']['login'] = "";

$l['helpPage']['billpaypaltransactions'] = "Listar todas as transações do PAYPAL";
$l['helpPage']['billhistoryquery'] = "Listando todos os pagamentos do usuario";

$l['helpPage']['billplanslist'] = "";
$l['helpPage']['billplansnew'] = "";
$l['helpPage']['billplansedit'] = "";
$l['helpPage']['billplansdel'] = "";

$l['helpPage']['billposlist'] = "";
$l['helpPage']['billposnew'] = "";
$l['helpPage']['billposedit'] = "";
$l['helpPage']['billposdel'] = "";

$l['helpPage']['billrateslist'] = "";
$l['helpPage']['billratesnew'] = "";
$l['helpPage']['billratesedit'] = "";
$l['helpPage']['billratesdel'] = "";
$l['helpPage']['billratesdate'] = "";

$l['helpPage']['mngradproxys'] = "";
$l['helpPage']['mngradproxyslist'] = "";
$l['helpPage']['mngradproxysnew'] = "";
$l['helpPage']['mngradproxysedit'] = "";
$l['helpPage']['mngradproxysdel'] = "";

$l['helpPage']['mngradrealms'] = "";
$l['helpPage']['mngradrealmslist'] = "";
$l['helpPage']['mngradrealmsnew'] = "";
$l['helpPage']['mngradrealmsedit'] = "";
$l['helpPage']['mngradrealmsdel'] = "";

$l['helpPage']['mngradattributes'] = "";
$l['helpPage']['mngradattributeslist'] = "";
$l['helpPage']['mngradattributesnew'] = "";
$l['helpPage']['mngradattributesedit'] = "";
$l['helpPage']['mngradattributessearch'] = "";
$l['helpPage']['mngradattributesdel'] = "";
$l['helpPage']['mngradattributesimport'] = "";

$l['helpPage']['msgerrorpermissions'] = "Voçe não tem permissão de acessar essa pagina <br/>
consulte o administrador do Sistema <br/>";

$l['helpPage']['mngradusergroup'] = "";
$l['helpPage']['mngradusergroupdel'] = "Para remover uma entrada de usuário do banco de dados, você deve fornecer o nome de usuário da conta";
$l['helpPage']['mngradusergroupnew'] = "";
$l['helpPage']['mngradusergrouplist'] = "";
$l['helpPage']['mngradusergrouplistuser'] = "";
$l['helpPage']['mngradusergroupedit'] = "";


$l['helpPage']['mngradprofiles'] = "
<b>Gerenciador de perfis</b> - Gerenciar perfis para usuários compondo um conjunto de atributos de resposta e atributos de verificação <br/>
Os perfis podem ser considerados como a composição da resposta do grupo e da verificação do grupo. <br/>
<h200><b>Listar Perfis </b></h200> - Listar Perfis <br/>
<h200><b>Novo Perfil </b></h200> - Adicionar um perfil <br/>
<h200><b>Editar Perfil </b></h200> - Editar um perfil <br/>
<h200><b>Deletar Perfil </b></h200> - Deletar um perfil <br/>
";
$l['helpPage']['mngradprofilesedit'] = "
<h200><b>Editar Perfil </b></h200> - Editar um perfil <br/>
";
$l['helpPage']['mngradprofilesdel'] = "
<h200><b>Deletar Perfil </b></h200> - Deletar um Perfil <br/>
";
$l['helpPage']['mngradprofilesduplicate'] = "
<h200><b>Duplicar Perfil </b></h200> - Duplicar perfil e setar atributos para um novo perfil <br/>
";
$l['helpPage']['mngradprofileslist'] = "
<h200><b>Listar Perfil </b></h200> - Listar Perfil <br/>
";
$l['helpPage']['mngradprofilesnew'] = "
<h200><b>Novo Perfil </b></h200> - Adicionar a um perfil <br/>
";

$l['helpPage']['mngradgroups'] = "
<b>Gerenciamento de grupo</b> - Gerenciando Grupo de Resposta  e  Grupos Validos Mapeados (radgroupreply/radgroupcheck tables).<br/>
<h200><b>Listar Grupos Respostas/Validos </b></h200> - Lista de Grupos De Resposta/Mapeados<br/>
<h200><b>Procurar Grupo Resposta/Valido </b></h200> - Procurar grupo Mapeado Resposta/Validos <br/>
<h200><b>Novo  Grupo Resposta/Valido </b></h200> - ADicionar Grupo Respostas/Validos <br/>
<h200><b>Editar Grupo  Respostas/Valido </b></h200> - Editar Grupo   Respostas/Valido  Mapeado <br/>
<h200><b>Deletar Grupo  Respostas/Valido  </b></h200> - Deletar Grupo   Respostas/Valido  Mapeado <br/>
";


$l['helpPage']['mngradgroupchecknew'] = "
<h200><b>Novo Grupo Valido </b></h200> - Adicionar grupo Valido mapeado<br/>
";
$l['helpPage']['mngradgroupcheckdel'] = "
<h200><b>Deletar grupo valido </b></h200> - Deletar  Grupo valido mapeado <br/>
";

$l['helpPage']['mngradgroupchecklist'] = "
<h200><b>Listar grupo valido </b></h200> - Listar grupo valido mapeado<br/>
";
$l['helpPage']['mngradgroupcheckedit'] = "
<h200><b>Editar grupo valido </b></h200> - Editar grupo valido mapeado <br/>
";
$l['helpPage']['mngradgroupchecksearch'] = "
<h200><b>Procurar Grupo Valido </b></h200> - Procurar um grupo valido Mapeado <br/>
Para usar um curinga, você pode digitar o caractere% familiar no SQL ou usar os caracteres mais comuns *
por razões de conveniência, o daloRADIUS o traduzirá para %
";

$l['helpPage']['mngradgroupreplynew'] = "
<h200><b>Novo Grupo de respota </b></h200> - Adicionar um grupo de respota Mapeado <br/>
";
$l['helpPage']['mngradgroupreplydel'] = "
<h200><b>Deletar grupo de respota </b></h200> - Deletar um grupo de respota Mapeado <br/>
";
$l['helpPage']['mngradgroupreplylist'] = "
<h200><b>Listar grupo de respota  </b></h200> - Listar grupo de respota Mapeado<br/>
";
$l['helpPage']['mngradgroupreplyedit'] = "
<h200><b>Editar grupo de respota  </b></h200> - Editar grupo de respota Mapeado <br/>
";
$l['helpPage']['mngradgroupreplysearch'] = "
<h200><b>Procurar grupo de respota  </b></h200> - Procurar grupo de respota </ Mapeado <br/>
Para usar um curinga, você pode digitar o caractere% familiar no SQL ou usar os caracteres mais comuns *
por razões de conveniência, o daloRADIUS o traduzirá para %
";


$l['helpPage']['mngradippool'] = "
<h200><b>Lista de  IP Pools</b></h200> - Listar faixe de IP configurados e seus endereços IP atribuídos<br/>
<h200><b>Nova Faixa de IP </b></h200> - Adiciona novo endereço  de   IP  para a faixa de IP <br/>
<h200><b>Editar faixa de ip </b></h200> - Editar endereço IP configurado para faixa de IP <br/>
<h200><b>Remover IP Pool</b></h200> - Remover endereço IP configurado para faixa de IP<br/>
";
$l['helpPage']['mngradippoollist'] = "<h200><b>Listar faixa IP </b></h200> - Listar IP dos endereços configurados na faixa de IP <br/>";
$l['helpPage']['mngradippoolnew'] = "<h200><b>Nova faixa de IP</b></h200> - Adicionar novo IP para a faixa de IPS <br/>";
$l['helpPage']['mngradippooledit'] = "<h200><b>Editar Faixa de  IP</b></h200> - Editar IP dos endereços configurados na faixa de IP <br/>";
$l['helpPage']['mngradippooldel'] = "<h200><b>Remover Faixa de IP</b></h200> - Remover IP dos endereços configurados na faixa de IP <br/>";


$l['helpPage']['mngradnas'] = "";
$l['helpPage']['mngradnasdel'] = "Para remover uma entrada de ip / host nas do banco de dados, você deve fornecer o ip / host da conta";
$l['helpPage']['mngradnasnew'] = "";
$l['helpPage']['mngradnaslist'] = "";
$l['helpPage']['mngradnasedit'] = "";



$l['helpPage']['mnghsdel'] = "Para remover um ponto ativo do banco de dados, você deve fornecer o nome do ponto ativo<br/>";
$l['helpPage']['mnghsedit'] = "Você pode editar abaixo os detalhes do HOTSPOT<br/>";
$l['helpPage']['mnghsnew'] = "Você pode preencher os detalhes abaixo para adicionar um novo ponto de acesso ao banco de dados";
$l['helpPage']['mnghslist'] = "Lista de todos os pontos de acesso no banco de dados. Você pode usar os links rápidos para editar ou excluir um ponto de acesso do banco de dados.";

$l['helpPage']['configdb'] = "
<b>Configuração do Banco de Dados </b> -Configure o mecanismo de banco de dados, configurações de conexão, nomes de tabelas se o
padrão não são utilizados e o tipo de criptografia de senha no banco de dados.<br/>
<h200><b>Configurações Globais</b></h200> - Engrenagem do storage do banco <br/>
<h200><b>Configurações da tabelas </b></h200> - Se não estiver usando o esquema FreeRADIUS padrão, você poderá alterar os nomes
dos nomes da tabela<br/>
<h200><b>Configurações avançadas</b></h200> -Se você deseja armazenar senhas para usuários no banco de dados não
texto simples, mas sim criptografado de alguma forma, você pode escolher um dos MD5 ou Crypt<br/>
";
$l['helpPage']['configlang'] = "
<h200><b>Configuração Linguagem</b></h200> - Configurando liguagem da interface<br/>
";
$l['helpPage']['configlogging'] = "
<h200><b>Configurando Logs </b></h200> - Configurando logs e facilitadores <br/>
Certifique-se de que o nome do arquivo especificado tenha permissões de gravação pelo servidor da webbr/>";
$l['helpPage']['configinterface'] = "
<h200><b>Configurando Interface </b></h200> - Definir configurações de layout de interface e comportamento <br/>
";
$l['helpPage']['configmain'] = "
<b>Configurações Globais</b><br/>
<h200><b>Configurações do Banco de dados  </b></h200> - Configure o mecanismo de banco de dados, configurações de conexão, nomes de tabelas se o
o padrão não é usado e o tipo de criptografia de senha no banco de dados.<br/>
<h200><b>Configurando Interface</b></h200> - Configurando interface de Linguagem.<br/>
<h200><b>Configurações de logs</b></h200> - Configurando logs e facilitadores <br/>
<h200><b>Configurações de interface </b></h200> - Definir configurações de layout de interface e comportamento <br/>

<b>Configuração de sub-categoria</b>
<h200><b>Manutenção </b></h200> - Opções de manutenção para Testar conexões de usuários ou encerrar suas sessões <br/>
<h200><b>Operadores</b></h200> - Configurar lista de controle de acesso de operadores (ACL) <br/>
";
$l['helpPage']['configbusiness'] = "
<b>Informações do negocio</b><br/>
<h200><b>Business Contact</b></h200> - defina as informações de contato da empresa (proprietários, cargo, endereço, telefone etc.)<br/>
";
$l['helpPage']['configbusinessinfo'] = "";
$l['helpPage']['configmaint'] = "
<b>Manutenção</b><br/>
<h200><b>Testar conectividade do usuario</b></h200> -
Envie uma solicitação de acesso ao servidor RADIUS para verificar se as credenciais do usuário são válidas<br/>Send a PoD (Packet of Disconnect) or CoA (Change of Authority) packets to the NAS server
to disconnect a user and terminate his/her session in a given NAS.
<h200><b>Disconectar Usuários</b></h200> - Envie um pacote PoD (Packet of Disconnect) ou CoA (Change of Authority) para o servidor NAS
desconectar um usuário e encerrar sua sessão em um determinado NAS.<br/>
";
$l['helpPage']['configmainttestuser'] = "
<h200><b>Testar conectividade do usuario</b></h200> - Envie uma solicitação de acesso ao servidor RADIUS para verificar se as credenciais do usuário são válidas.<br/>
O daloRADIUS usa o utilitário binário radclient para executar o teste e retorna os resultados do comando após a conclusão. <br/>
O daloRADIUS conta que o binário radclient está disponível na sua variável de ambiente \ PATH; caso contrário, faça
correções no arquivo library/extensions/maintenance_radclient.php.<br/><br/>

Observe que pode demorar um pouco para o teste terminar (até vários segundos [10-20 segundos]] devido a falhas e
O radclient retransmitirá os pacotes.
Na guia Avançado, é possível ajustar as opções para o teste:<br/>
Tempo limite - aguarde o tempo limite segundos antes de tentar novamente (pode ser um número de ponto flutuante) <br/>
Tentativas - Se o tempo limite expirar, tente enviar novamente o pacote 'tentativas'.  <br/>
Contagem - Envie cada pacote 'contar' vezes <br/>
Solicitações - Envie pacotes 'num' de um arquivo em paralelo <br/>
";
$l['helpPage']['configmaintdisconnectuser'] = "
<h200><b>Disconnect User</b></h200> - Envie um pacote PoD (Packet of Disconnect) ou CoA (Change of Authority) ao servidor NAS para desconectar um usuário e encerrar sua sessão em um determinado NAS.<br/>
Para encerrar a sessão de um usuário, é necessário que o NAS suporte os tipos de pacotes PoD ou CoA, consulte o fornecedor do NAS ou
documentação para isso. Além disso, é necessário conhecer as portas NAS para pacotes PoD ou CoA, enquanto os NASs mais recentes usam a porta 3799
enquanto outros estão configurados para receber o pacote na porta 1700.


O daloRADIUS usa o utilitário binário radclient para executar o teste e retorna os resultados do comando após a conclusão. <br/>
O daloRADIUS conta que o binário radclient está disponível na sua variável de ambiente \ PATH; caso contrário, faça
correções no arquivo library/extensions/maintenance_radclient.php.<br/><br/>

Observe que pode demorar um pouco para o teste terminar (até vários segundos [10-20 segundos]] devido a falhas e
O radclient retransmitirá os pacotes.

Na guia Avançado, é possível ajustar as opções para o teste:<br/>
Tempo limite - aguarde o tempo limite segundos antes de tentar novamente (pode ser um número de ponto flutuante) <br/>
Tentativas - Se o tempo limite expirar, tente enviar novamente o pacote 'tentativas'. <br/>
Contagem - Envie cada pacote 'contar' vezes <br/>
Solicitações - Envie pacotes 'num' de um arquivo em paralelo<br/>


";
$l['helpPage']['configoperatorsdel'] = "Para remover um operador do banco de dados, você deve fornecer o nome de usuário.";
$l['helpPage']['configoperatorsedit'] = "Edite os detalhes do usuário do operador abaixo";
$l['helpPage']['configoperatorsnew'] = "Você pode preencher os detalhes abaixo para adicionar um novo usuário ao banco de dados";
$l['helpPage']['configoperatorslist'] = "Listando todos os operadores no banco de dados";
$l['helpPage']['configoperators'] = "Configuração de Operadores";
$l['helpPage']['configbackup'] = "Executar backup";
$l['helpPage']['configbackupcreatebackups'] = "Criar Backups";
$l['helpPage']['configbackupmanagebackups'] = "Gerenciar Backups";


$l['helpPage']['graphmain'] = "
<b>Graficos</b><br/>
<h200><b>Logins Gerais</b></h200> -Plota um gráfico gráfico do uso de um usuário específico por um determinado período de tempo.
A quantidade de logins (ou 'ocorrências' no NAS) é exibida em um gráfico e acompanhada por uma listagem de tabela.<br/>
<h200><b>Estatiticas total dos downloads </b></h200> - Plota um gráfico gráfico do uso de um usuário específico por um determinado período de tempo.
A quantidade de dados baixados pelo cliente é o valor que está sendo calculado. O gráfico é acompanhado por uma listagem de tabela<br/>
<h200><b>Estatiticas total dos uploads</b></h200> - Plota um gráfico gráfico do uso de um usuário específico por um determinado período de tempo.
A quantidade de dados carregados pelo cliente é o valor que está sendo calculado. O gráfico é acompanhado por uma listagem de tabela<br/>
<br/>
<h200><b>Login de todos os tempos</b></h200> - PlotaPlota um gráfico gráfico dos Logins no servidor por um determinado período de tempo. um gráfico gráfico dos Logins no servidor por um determinado período de tempo.<br/>
<h200><b>Comparação de tráfego de todos os tempos</b></h200> -Traça um gráfico gráfico da estatística Downloaded and Uploaded.";
$l['helpPage']['graphsalltimelogins'] = "Estatísticas de todos os tempos de logons no servidor com base em uma distribuição por um período de tempo";
$l['helpPage']['graphsalltimetrafficcompare'] = "Estatísticas de tráfego de todos os tempos através do servidor com base em uma distribuição durante um período de tempo.";
$l['helpPage']['graphsoveralldownload'] = "Traça um gráfico gráfico dos bytes baixados para o servidor";
$l['helpPage']['graphsoverallupload'] = "Traça um gráfico gráfico dos bytes carregados no servidor";
$l['helpPage']['graphsoveralllogins'] = "Traça um gráfico gráfico das tentativas de login no servidor";



$l['helpPage']['rephistory'] = "Lista todas as atividades realizadas nos itens de gerenciamento e fornece informações sobre <br/>
Campos Data da criação, Criação por e Data atualizada e Atualização por histórico";
$l['helpPage']['replastconnect'] = "Lista todas as tentativas de logon no servidor RADIUS, logons bem-sucedidos e com falha";
$l['helpPage']['replogsboot'] = "Monitorar o log de inicialização do sistema operacional - equivalente à execução do comando dmesg.";
$l['helpPage']['replogsdaloradius'] = "Monitorando daloRADIUS's Logfile.";
$l['helpPage']['replogsradius'] = "Monitorando FreeRADIUS's Logfile.";
$l['helpPage']['replogssystem'] = "Monitorando Operating System Logfile.";
$l['helpPage']['replogs'] = "
<b>Logs</b><br/>
<h200><b>daloRADIUS Log</b></h200> - Monitorando daloRADIUS's Logfile.<br/>
<h200><b>RADIUS Log</b></h200> - Monitor FreeRADIUS's Logfile - equivalente a /var/log/freeradius/radius.log ou /usr/local/var/log/radius/radius.log.
Outros locais possíveis para o arquivo de log podem ocorrer, se este for o caso, ajuste a configuração de acordo.<br/>
<h200><b>System Log</b></h200> - Monitorando  Logs do Sistema operacional - equivalent a /var/log/syslog ou /var/log/message on most platform.
Outros locais possíveis para o arquivo de log podem ocorrer, se este for o caso, ajuste a configuração de acordo.<br/>
<h200><b>Boot Log</b></h200> - Monitorar o log de inicialização do sistema operacional - equivalente à execução do comando dmesg.
";
$l['helpPage']['repmain'] = "
<b>Rela Gerais</b><br/>
<h200><b>Usuários Online</b></h200> - Fornece uma lista de todos os usuários que são
encontrado on-line através da tabela contábil no banco de dados. A verificação que está sendo realizada é para usuários
sem hora final (AcctStopTime) definida. É importante notar que esses usuários também podem ter sessões obsoletas
o que acontece quando os NASs, por algum motivo, não conseguem enviar os pacotes de interrupção contábil.<br/>
<h200><b>Ultima Tentativa de conexão</b></h200> -Fornece uma lista de todos os logins de aceitação de acesso e rejeição de acesso (aceitos e com falha)
para usuários. <br/> Elas são extraídas da tabela postauth do banco de dados, que precisa ser definida
no arquivo de configuração do FreeRADIUS para realmente registrá-los.<br/>
<h200><b>Usuários mas ativos</b></h200> - Fornece uma lista dos principais usuários N para consumo de largura de banda e tempo de sessão usado<br/><br/>
<b>Sub-Categoria de relatórios</b><br/>
<h200><b>Logs</b></h200> - Providencia  accesso to daloRADIUS logfile, FreeRADIUSs logfile, System's logfile and Boot logfile<br/>
<h200><b>Status</b></h200> - Providencia informações do servidor  and RADIUS Components status";
$l['helpPage']['repstatradius'] = "Providencia informações sobre hardware: CPU Usage, Processes, Uptime, Memory usage, etc.
";
$l['helpPage']['repstatserver'] = "Providencia informações do  FreeRADIUS daemon and MySQL Database server";
$l['helpPage']['repstatus'] = "<b>Status</b><br/>
<h200><b>Server Status</b></h200> - Providencia informações : CPU Usage, Processes, Uptime, Memory usage, etc.<br/>
<h200><b>RADIUS Status</b></h200> - Providencia informação  FreeRADIUS daemon and MySQL Database server";
$l['helpPage']['reptopusers'] = "Registro dos usuarios  mais ativos , aqueles listados abaixo ganharam o maior consumo de sessões
uso de tempo ou largura de banda. Listando usuários da categoria: ";
$l['helpPage']['repusername'] = "Registro encontrado para usuario:";
$l['helpPage']['reponline'] = "
A tabela a seguir lista os usuários que estão conectados no momento
o sistema. É muito possível que haja conexões obsoletas,
o que significa que os usuários foram desconectados, mas o NAS não enviou ou não foi
capaz de enviar um pacote de contabilidade STOP para o servidor RADIUS.
";


$l['helpPage']['mnglistall'] = "Listando usuarios no banco de dados ";
$l['helpPage']['mngsearch'] = "Procurando por usuário: ";
$l['helpPage']['mngnew'] = "Você pode preencher os detalhes abaixo para adicionar novos usuários ao banco de dados<br/>";
$l['helpPage']['mngedit'] = "Edite os detalhes do usuário abaixo.<br/>";
$l['helpPage']['mngdel'] = "Para remover uma entrada de usuário do banco de dados, você deve fornecer o nome de usuário da conta<br/>";
$l['helpPage']['mngbatch'] = "Você pode preencher os detalhes abaixo para adicionar novos usuários ao banco de dados.<br/>
Observe que essas configurações serão aplicadas a todos os usuários que você está criando.<br/>";
$l['helpPage']['mngnewquick'] = "O seguinte usuário / cartão é do tipo pré-pago.<br/>
A quantidade de tempo especificada em Crédito por tempo será usada como o tempo limite da sessão e o máximo de todas as sessões
atributos de raio";

// accounting section
$l['helpPage']['acctactive'] = "
Fornece informações que seriam úteis para rastrear usuários ativos ou expirados no banco de dados
em termos de usuários que possuem um atributo Expiration ou Max-All-Session.
<br/>
";
$l['helpPage']['acctall'] = "
Fornece informações contábeis completas para todas as sessões no banco de dados.
<br/>
";
$l['helpPage']['acctdate'] = "
    Fornece informações contábeis completas para todas as sessões entre as duas datas especificadas para um usuário específico.
<br/>
";
$l['helpPage']['acctipaddress'] = "
Fornece informações contábeis completas para todas as sessões originadas com um endereço IP específico.
<br/>
";
$l['helpPage']['acctmain'] = "
<b>Conta Geral</b><br/>
<h200><b>Conta de Usuário</b></h200> -
Fornece informações contábeis completas para todas as sessões no banco de dados para um usuário específico.
<br/>
<h200><b>IP da Conta</b></h200> -
Fornece informações contábeis completas para todas as sessões originadas com um endereço IP específico.
<br/>
<h200><b>Conta no NAS</b></h200> -
Fornece informações contábeis completas para todas as sessões que o endereço IP do NAS específico manipulou.
<br/>
<h200><b>Data da contas</b></h200> -
Fornece informações contábeis completas para todas as sessões entre as duas datas especificadas para um usuário específico.
<br/>
<h200><b>Todos os regitros da contas</b></h200> -
Fornece informações contábeis completas para todas as sessões no banco de dados.
<br/>
<h200><b>Registros de contas atividades</b></h200> -
Fornece informações que seriam úteis para rastrear usuários ativos ou expirados no banco de dados
em termos de usuários que possuem um atributo Expiration ou Max-All-Session.
<br/>

<br/>
<b>Sub-Categoria da Contas/b><br/>
<h200><b>Custom</b></h200> -
    Fornece a consulta personalizada mais flexível para executar no banco de dados.
<br/>
<h200><b>Hotspots</b></h200> -
    Fornece informações sobre os diferentes pontos ativos gerenciados, comparação e outras informações úteis.
<br/>
";
$l['helpPage']['acctnasipaddress'] = "
    Fornece informações contábeis completas para todas as sessões que o endereço IP do NAS específico manipulou.
<br/>
";
$l['helpPage']['acctusername'] = "
Fornece informações contábeis completas para todas as sessões no banco de dados para um usuário específico.
<br/>
";
// accounting hotspot section
$l['helpPage']['accthotspotaccounting'] = "
Fornece informações contábeis completas para todas as sessões originadas neste ponto de acesso específico.
Esta lista é calculada listando apenas os registros na tabela radacct com o CalledStationId
campo que corresponde a uma entrada de Endereço MAC do Hotspot no banco de dados de gerenciamento do Hotspot.
<br/>
";
$l['helpPage']['accthotspotcompare'] = "Fornece informações contábeis básicas para comparação entre todos os pontos ativos encontrados no banco de dados.
Informações contábeis fornecidas: <br/><br/>
    Nome do Hotspot  - O nome do hopspot <br/>
  Usuários únicos - Usuários que efetuaram logon somente neste ponto de acesso <br/>
    Total de Acessos - O total de logins que foram executados neste ponto de acesso (exclusivo e não exclusivo)<br/>
  Tempo médio - o tempo médio que um usuário passou neste ponto de acesso <br/>
    Tempo total - o tempo gasto acumulado de todos os usuários neste ponto de acesso <br/>

<br/>
    Fornece um gráfico gráfico de diferentes comparações feitas<br/>
    Graficos: <br/><br/>
  Distribuição de usuários únicos por ponto de acesso <br/>
    Distribuição de hits por ponto de acesso <br/>
    Distribuição do uso do tempo por ponto de acesso <br/>
<br/>
";
$l['helpPage']['accthotspot'] = "
<h200><b>Conta do hotspot</b></h200> -
    Fornece informações contábeis completas para todas as sessões originadas neste ponto de acesso específico.
<br/>
<h200><b>comparações do hotspot </b></h200> -
Fornece informações contábeis básicas para comparação entre todos os pontos ativos encontrados no banco de dados.
Fornece um gráfico gráfico de diferentes comparações feitas.
<br/>
";
// accounting custom queries section
$l['helpPage']['acctcustom'] = "
<h200><b>Customizações</b></h200> -
Fornece a consulta personalizada mais flexível para executar no banco de dados.<br/>
    Você pode ajustar a consulta ao máximo modificando as configurações na barra lateral esquerda.<br/>
<br/>
    <b> Entre Datas </b> -Defina a data inicial e final.
<br/>
    <b> Onde </b> - Defina o campo no banco de dados que você deseja corresponder (como uma chave), escolha se o valor
para corresponder a deve ser Igual (=) ou Contém parte do valor que você procura (como uma regex). Se vocês
optar por usar o operador Contains, você não deve adicionar curingas do formulário comum '*', mas sim
o valor digitado será automaticamente pesquisado neste formato: * value * (ou no estilo mysql:% value%).
<br/>
    <b> Campos de contabilidade de consulta </b> - Você pode escolher quais campos você gostaria de apresentar no resultado
Lista.
<br/>
    <b> Ordenar por </b> - Escolha por qual campo você deseja ordenar os resultados e seu tipo (Crescente
ou descendente)
<br/>
";
$l['helpPage']['acctcustomquery'] = "";
$l['helpPage']['acctmaintenance'] = "
<h200><b>Limpando  Sess obsoletas</b></h200> -
    Em geral, podem ocorrer obsoletos porque o NAS não conseguiu fornecer um registro STOP contábil para o <br/>
  sessão de usuário, resultando em uma sessão aberta antiga nos registros contábeis, que simula um usuário logado falso
  registro (falso positivo).
<br/>
<h200><b>Deletando registros da conta </b></h200> -
Exclusão de registros contábeis no banco de dados. Pode não ser aconselhável fazer isso ou permitir que outros usuários
exceto pelo acesso de administrador supervisionado a esta página.
<br/>
";
$l['helpPage']['acctmaintenancecleanup'] = "";
$l['helpPage']['acctmaintenancedelete'] = "";



$l['helpPage']['giseditmap'] = "
Editar modo de mapa - nesse modo, você pode adicionar ou excluir pontos de acesso simplesmente clicando em
em um local do mapa ou clicando em um ponto de acesso (respectivamente).<br/><br/>
    <b> Adicionando  Hotspot </b> -Basta clicar em um local claro do mapa, você será solicitado a fornecer
o nome do ponto de acesso e o endereço MAC. Estes são 2 detalhes cruciais usados ​​posteriormente para identificar este ponto de acesso
na tabela contábil. Sempre forneça o endereço MAC correto!
<br/><br/>
    <b> Deletando Hotspot </b> - Basta clicar no ícone de um ponto de acesso e você confirmar a exclusão do
base de dados.
<br/>
";
$l['helpPage']['gisviewmap'] = "
View Map Mode - in this mode you are able to browse the Hotspots as they are layed out
in icons across the maps provided by GoogleMaps service.<br/><br/>

    <b> Clicando no Hotspot </b> -Fornecerá detalhes mais detalhados sobre o hotspot.
Como as informações de contato do ponto de acesso e detalhes das estatísticas.
<br/>
";
$l['helpPage']['gismain'] = "
<b> Informações Gerais </b>
O GIS Mapping fornece mapeamentos visuais da localização do ponto de acesso em todo o mundo usando a API do Google Maps.<br/>
Na página Gerenciamento, você pode adicionar novas entradas de ponto de acesso ao banco de dados, onde também há um campo
chamado Geolocalização, esse é o valor numérico que a API do Google Maps usa para identificar com precisão
localização desse ponto de acesso no mapa.<br/><br/>

<h200><b>2 Modos de operação do servidor:</b></h200>
Um é o <b>Visualize o  MAP</b> modo que permite 'surfing' através do mapa do mundo
e visualize os locais atuais dos pontos de acesso no banco de dados e outro - <b>Edite o  MAP</b> - qual é o modo
que você pode usar para criar visualmente pontos de acesso, simplesmente clicando com o botão esquerdo no mapa ou removendo
entradas de ponto de acesso existentes clicando com o botão esquerdo nos sinalizadores de ponto de acesso existentes.<br/><br/>

Outra questão importante é que cada computador na rede requer um código de registro exclusivo, que você
pode ser obtido na página da API do Google Maps, fornecendo o endereço da Web completo para o diretório hospedado de
aplicação daloRADIUS no seu servidor. Depois de obter esse código do Google, basta colá-lo no diretório
Registre a caixa e clique no botão 'Register code' para escrevê-lo.
Você poderá usar os serviços do Google Maps. <br/><br/>";

/* ********************************************************************************** */



$l['messages']['noCheckAttributesForUser'] = "Este usuário não possui atributos de verificação associados";
$l['messages']['noReplyAttributesForUser'] = "Este usuário não possui atributos de resposta associados";

$l['messages']['noCheckAttributesForGroup'] = "Este grupo não possui atributos de verificação associados";
$l['messages']['noReplyAttributesForGroup'] = "Este grupo não possui atributos de resposta associados";

$l['messages']['nogroupdefinedforuser'] = "Este usuário não possui Grupos associados";
$l['messages']['wouldyouliketocreategroup'] = "Gostaria de criar um?";


$l['messages']['missingratetype'] = "error: tipo de taxa ausente a ser excluído";
$l['messages']['missingtype'] = "erro: tipo ausente";
$l['messages']['missingcardbank'] = "erro: falta de cartão";
$l['messages']['missingrate'] = "erro: taxa ausente";
$l['messages']['success'] = "successo";
$l['messages']['gisedit1'] = "Bem-vindo, você está no modo de edição";
$l['messages']['gisedit2'] = "Remover marcador atual do mapa e banco de dados?";
$l['messages']['gisedit3'] = "Digite o nome do HotSpot";
$l['messages']['gisedit4'] = "Adicionar marcador atual ao banco de dados?";
$l['messages']['gisedit5'] = "Digite o nome do HotSpot";
$l['messages']['gisedit6'] = "Digite o endereço MAC do ponto de acesso";

$l['messages']['gismain1'] = "Código de registro da API do GoogleMaps atualizado com sucesso";
$l['messages']['gismain2'] = "erro: não foi possível abrir o arquivo para gravação:";
$l['messages']['gismain3'] = "Verifique as permissões de arquivo. O arquivo deve ser gravável pelo usuário / grupo do servidor da web";
$l['messages']['gisviewwelcome'] = "Bem-vindo ao Enginx Visual Maps";

$l['messages']['loginerror'] = "<br/><br/>um dos seguintes:<br/>
1. nome de usuário / senha incorretos<br/>
2. um administrador já está logado (apenas uma instância é permitida) <br/>
3. parece haver mais de um usuário 'administrador' no banco de dados<br/>
";

$l['buttons']['savesettings'] = "Salvando configurações";
$l['buttons']['apply'] = "Aplicar";

$l['menu']['Home'] = "Home";
$l['menu']['Managment'] = "Gestão";
$l['menu']['Reports'] = "Relatórios";
$l['menu']['Accounting'] = "Contas";
$l['menu']['Billing'] = "Pagamentos";
$l['menu']['Gis'] = "GIS";
$l['menu']['Graphs'] = "Gáficos";
$l['menu']['Config'] = "Configurações";
$l['menu']['Help'] = "Ajuda";

// TODO translation needed.
// once translated, delete these comment lines.
$l['submenu']['General'] = "General";
$l['submenu']['Reporting'] = "Reporting";
$l['submenu']['Maintenance'] = "Maintenance";
$l['submenu']['Operators'] = "Operators";
$l['submenu']['Backup'] = "Backup";
$l['submenu']['Logs'] = "Logs";
$l['submenu']['Status'] = "Status";
$l['submenu']['Batch Users'] = "Batch Users";
$l['submenu']['Dashboard'] = "Dashboard";
$l['submenu']['Users'] = "Users";
$l['submenu']['Hotspots'] = "Hotspots";
$l['submenu']['Nas'] = "Nas";
$l['submenu']['User-Groups'] = "User-Groups";
$l['submenu']['Profiles'] = "Profiles";
$l['submenu']['HuntGroups'] = "HuntGroups";
$l['submenu']['Attributes'] = "Attributes";
$l['submenu']['Realm/Proxy'] = "Realm/Proxy";
$l['submenu']['IP-Pool'] = "IP-Pool";
$l['submenu']['POS'] = "POS";
$l['submenu']['Plans'] = "Plans";
$l['submenu']['Rates'] = "Rates";
$l['submenu']['Merchant-Transactions'] = "Merchant-Transactions";
$l['submenu']['Billing-History'] = "Billing-History";
$l['submenu']['Invoices'] = "Invoices";
$l['submenu']['Payments'] = "Payments";
$l['submenu']['Custom'] = "Custom";
$l['submenu']['Hotspot'] = "Hotspot";

?>
