-- MySQL dump 10.11
--
-- Host: localhost    Database: radius_099
-- ------------------------------------------------------
-- Server version	5.0.51a-24+lenny3-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `batch_history`
--

DROP TABLE IF EXISTS `batch_history`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `batch_history` (
  `id` INT(32) NOT NULL AUTO_INCREMENT,
  `batch_name` VARCHAR(64) DEFAULT NULL COMMENT 'an identifier name of the batch instance',
  `batch_description` VARCHAR(256) DEFAULT NULL COMMENT 'general description of the entry',
  `hotspot_id` INT(32) DEFAULT '0' COMMENT 'the hotspot business id associated with this batch instance',
  `batch_status` VARCHAR(128) NOT NULL DEFAULT 'Pending' COMMENT 'the batch status',
  `creationdate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `creationby` VARCHAR(128) DEFAULT NULL,
  `updatedate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `updateby` VARCHAR(128) DEFAULT NULL,
  PRIMARY KEY  (`id`),
  KEY `batch_name` (`batch_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `batch_history`
--

LOCK TABLES `batch_history` WRITE;
/*!40000 ALTER TABLE `batch_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `batch_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billing_history`
--

DROP TABLE IF EXISTS `billing_history`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `billing_history` (
  `id` INT(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(128) DEFAULT NULL,
  `planId` INT(32) DEFAULT NULL,
  `billAmount` VARCHAR(200) DEFAULT NULL,
  `billAction` VARCHAR(128) NOT NULL DEFAULT 'Unavailable',
  `billPerformer` VARCHAR(200) DEFAULT NULL,
  `billReason` VARCHAR(200) DEFAULT NULL,
  `paymentmethod` VARCHAR(200) DEFAULT NULL,
  `cash` VARCHAR(200) DEFAULT NULL,
  `creditcardname` VARCHAR(200) DEFAULT NULL,
  `creditcardnumber` VARCHAR(200) DEFAULT NULL,
  `creditcardverification` VARCHAR(200) DEFAULT NULL,
  `creditcardtype` VARCHAR(200) DEFAULT NULL,
  `creditcardexp` VARCHAR(200) DEFAULT NULL,
  `coupon` VARCHAR(200) DEFAULT NULL,
  `discount` VARCHAR(200) DEFAULT NULL,
  `notes` VARCHAR(200) DEFAULT NULL,
  `creationdate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `creationby` VARCHAR(128) DEFAULT NULL,
  `updatedate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `updateby` VARCHAR(128) DEFAULT NULL,
  PRIMARY KEY  (`id`),
  KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `billing_history`
--

LOCK TABLES `billing_history` WRITE;
/*!40000 ALTER TABLE `billing_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `billing_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billing_merchant`
--

DROP TABLE IF EXISTS `billing_merchant`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `billing_merchant` (
  `id` INT(8) NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(128) NOT NULL DEFAULT '',
  `password` VARCHAR(128) NOT NULL DEFAULT '',
  `mac` VARCHAR(200) NOT NULL DEFAULT '',
  `pin` VARCHAR(200) NOT NULL DEFAULT '',
  `txnId` VARCHAR(200) NOT NULL DEFAULT '',
  `planName` VARCHAR(128) NOT NULL DEFAULT '',
  `planId` INT(32) NOT NULL,
  `quantity` VARCHAR(200) NOT NULL DEFAULT '',
  `business_email` VARCHAR(200) NOT NULL DEFAULT '',
  `business_id` VARCHAR(200) NOT NULL DEFAULT '',
  `txn_type` VARCHAR(200) NOT NULL DEFAULT '',
  `txn_id` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_type` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_tax` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_cost` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_fee` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_total` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_currency` VARCHAR(200) NOT NULL DEFAULT '',
  `first_name` VARCHAR(200) NOT NULL DEFAULT '',
  `last_name` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_email` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_address_name` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_address_street` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_address_country` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_address_country_code` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_address_city` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_address_state` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_address_zip` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payment_status` VARCHAR(200) NOT NULL DEFAULT '',
  `pending_reason` VARCHAR(200) NOT NULL DEFAULT '',
  `reason_code` VARCHAR(200) NOT NULL DEFAULT '',
  `receipt_ID` VARCHAR(200) NOT NULL DEFAULT '',
  `payment_address_status` VARCHAR(200) NOT NULL DEFAULT '',
  `vendor_type` VARCHAR(200) NOT NULL DEFAULT '',
  `payer_status` VARCHAR(200) NOT NULL DEFAULT '',
  PRIMARY KEY  (`id`),
  KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `billing_merchant`
--

LOCK TABLES `billing_merchant` WRITE;
/*!40000 ALTER TABLE `billing_merchant` DISABLE KEYS */;
/*!40000 ALTER TABLE `billing_merchant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billing_paypal`
--

DROP TABLE IF EXISTS `billing_paypal`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `billing_paypal` (
  `id` INT(8) NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(128) DEFAULT NULL,
  `password` VARCHAR(128) DEFAULT NULL,
  `mac` VARCHAR(200) DEFAULT NULL,
  `pin` VARCHAR(200) DEFAULT NULL,
  `txnId` VARCHAR(200) DEFAULT NULL,
  `planName` VARCHAR(128) DEFAULT NULL,
  `planId` VARCHAR(200) DEFAULT NULL,
  `quantity` VARCHAR(200) DEFAULT NULL,
  `receiver_email` VARCHAR(200) DEFAULT NULL,
  `business` VARCHAR(200) DEFAULT NULL,
  `tax` VARCHAR(200) DEFAULT NULL,
  `mc_gross` VARCHAR(200) DEFAULT NULL,
  `mc_fee` VARCHAR(200) DEFAULT NULL,
  `mc_currency` VARCHAR(200) DEFAULT NULL,
  `first_name` VARCHAR(200) DEFAULT NULL,
  `last_name` VARCHAR(200) DEFAULT NULL,
  `payer_email` VARCHAR(200) DEFAULT NULL,
  `address_name` VARCHAR(200) DEFAULT NULL,
  `address_street` VARCHAR(200) DEFAULT NULL,
  `address_country` VARCHAR(200) DEFAULT NULL,
  `address_country_code` VARCHAR(200) DEFAULT NULL,
  `address_city` VARCHAR(200) DEFAULT NULL,
  `address_state` VARCHAR(200) DEFAULT NULL,
  `address_zip` VARCHAR(200) DEFAULT NULL,
  `payment_date` DATETIME DEFAULT NULL,
  `payment_status` VARCHAR(200) DEFAULT NULL,
  `payment_address_status` VARCHAR(200) DEFAULT NULL,
  `payer_status` VARCHAR(200) DEFAULT NULL,
  PRIMARY KEY  (`id`),
  KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `billing_paypal`
--

LOCK TABLES `billing_paypal` WRITE;
/*!40000 ALTER TABLE `billing_paypal` DISABLE KEYS */;
/*!40000 ALTER TABLE `billing_paypal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billing_plans`
--

DROP TABLE IF EXISTS `billing_plans`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `billing_plans` (
  `id` INT(8) NOT NULL AUTO_INCREMENT,
  `planName` VARCHAR(128) DEFAULT NULL,
  `planId` VARCHAR(128) DEFAULT NULL,
  `planType` VARCHAR(128) DEFAULT NULL,
  `planTimeBank` VARCHAR(128) DEFAULT NULL,
  `planTimeType` VARCHAR(128) DEFAULT NULL,
  `planTimeRefillCost` VARCHAR(128) DEFAULT NULL,
  `planBandwidthUp` VARCHAR(128) DEFAULT NULL,
  `planBandwidthDown` VARCHAR(128) DEFAULT NULL,
  `planTrafficTotal` VARCHAR(128) DEFAULT NULL,
  `planTrafficUp` VARCHAR(128) DEFAULT NULL,
  `planTrafficDown` VARCHAR(128) DEFAULT NULL,
  `planTrafficRefillCost` VARCHAR(128) DEFAULT NULL,
  `planRecurring` VARCHAR(128) DEFAULT NULL,
  `planRecurringPeriod` VARCHAR(128) DEFAULT NULL,
  `planRecurringBillingSchedule` VARCHAR(128) NOT NULL DEFAULT 'Fixed',
  `planCost` VARCHAR(128) DEFAULT NULL,
  `planSetupCost` VARCHAR(128) DEFAULT NULL,
  `planTax` VARCHAR(128) DEFAULT NULL,
  `planCurrency` VARCHAR(128) DEFAULT NULL,
  `planGroup` VARCHAR(128) DEFAULT NULL,
  `planActive` VARCHAR(32) NOT NULL DEFAULT 'yes',
  `creationdate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `creationby` VARCHAR(128) DEFAULT NULL,
  `updatedate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `updateby` VARCHAR(128) DEFAULT NULL,
  PRIMARY KEY  (`id`),
  KEY `planName` (`planName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `billing_plans`
--

LOCK TABLES `billing_plans` WRITE;
/*!40000 ALTER TABLE `billing_plans` DISABLE KEYS */;
/*!40000 ALTER TABLE `billing_plans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billing_plans_profiles`
--

DROP TABLE IF EXISTS `billing_plans_profiles`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `billing_plans_profiles` (
  `id` INT(32) NOT NULL AUTO_INCREMENT,
  `plan_name` VARCHAR(128) NOT NULL COMMENT 'the name of the plan',
  `profile_name` VARCHAR(256) DEFAULT NULL COMMENT 'the profile/group name',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `billing_plans_profiles`
--

LOCK TABLES `billing_plans_profiles` WRITE;
/*!40000 ALTER TABLE `billing_plans_profiles` DISABLE KEYS */;
/*!40000 ALTER TABLE `billing_plans_profiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billing_rates`
--

DROP TABLE IF EXISTS `billing_rates`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `billing_rates` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `rateName` VARCHAR(128) NOT NULL DEFAULT '',
  `rateType` VARCHAR(128) NOT NULL DEFAULT '',
  `rateCost` INT(32) NOT NULL DEFAULT '0',
  `creationdate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `creationby` VARCHAR(128) DEFAULT NULL,
  `updatedate` DATETIME DEFAULT '0000-00-00 00:00:00',
  `updateby` VARCHAR(128) DEFAULT NULL,
  PRIMARY KEY  (`id`),
  KEY `rateName` (`rateName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `billing_rates`
--

LOCK TABLES `billing_rates` WRITE;
/*!40000 ALTER TABLE `billing_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `billing_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dictionary`
--

DROP TABLE IF EXISTS `dictionary`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
CREATE TABLE `dictionary` (
  `id` INT(10) NOT NULL AUTO_INCREMENT,
  `Type` VARCHAR(30) DEFAULT NULL,
  `Attribute` VARCHAR(64) DEFAULT NULL,
  `Value` VARCHAR(64) DEFAULT NULL,
  `Format` VARCHAR(20) DEFAULT NULL,
  `Vendor` VARCHAR(32) DEFAULT NULL,
  `RecommendedOP` VARCHAR(32) DEFAULT NULL,
  `RecommendedTable` VARCHAR(32) DEFAULT NULL,
  `RecommendedHelper` VARCHAR(32) DEFAULT NULL,
  `RecommendedTooltip` VARCHAR(512) DEFAULT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9718 DEFAULT CHARSET=utf8mb4;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `dictionary`
--

LOCK TABLES `dictionary` WRITE;
/*!40000 ALTER TABLE `dictionary` DISABLE KEYS */;
INSERT INTO `dictionary` VALUES (1,'ipaddr','AAT-Client-Primary-DNS',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (2,'ipaddr','AAT-Client-Primary-WINS-NBNS',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (3,'ipaddr','AAT-Client-Secondary-WINS-NBNS',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (4,'ipaddr','AAT-Client-Secondary-DNS',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (5,'ipaddr','AAT-PPP-Address',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (6,'ipaddr','AAT-PPP-Netmask',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (7,'string','AAT-Primary-Home-Agent',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (8,'string','AAT-Secondary-Home-Agent',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (9,'string','AAT-Home-Agent-Password',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (10,'string','AAT-Home-Network-Name',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (11,'integer','AAT-Home-Agent-UDP-Port',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (12,'ipaddr','AAT-IP-Direct',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (13,'integer','AAT-FR-Direct',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (14,'string','AAT-FR-Direct-Profile',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (15,'integer','AAT-FR-Direct-DLCI',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (16,'string','AAT-ATM-Direct',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (17,'integer','AAT-IP-TOS',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (18,'integer','AAT-IP-TOS-Precedence',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (19,'integer','AAT-IP-TOS-Apply-To',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (20,'integer','AAT-MCast-Client',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (21,'integer','AAT-Modem-Port-No',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (22,'integer','AAT-Modem-Slot-No',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (23,'integer','AAT-Modem-Shelf-No',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (24,'string','AAT-Filter',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (25,'string','AAT-Vrouter-Name',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (26,'integer','AAT-Require-Auth',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (27,'string','AAT-IP-Pool-Definition',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (28,'integer','AAT-Assign-IP-Pool',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (29,'string','AAT-Data-Filter',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (30,'integer','AAT-Source-IP-Check',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (31,'string','AAT-Modem-Answer-String',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (32,'integer','AAT-Auth-Type',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (33,'integer','AAT-Qos',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (34,'integer','AAT-Qoa',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (35,'integer','AAT-Client-Assign-DNS',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (36,'integer','AAT-ATM-VPI',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (37,'integer','AAT-ATM-VCI',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (38,'integer','AAT-Input-Octets-Diff',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (39,'integer','AAT-Output-Octets-Diff',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (40,'string','AAT-User-MAC-Address',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (41,'string','AAT-ATM-Traffic-Profile',NULL,NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (42,NULL,'AAT-MCast-Client','Multicast-No',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (43,NULL,'AAT-MCast-Client','Multicast-Yes',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (44,NULL,'AAT-Require-Auth','Not-Require-Auth',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (45,NULL,'AAT-Require-Auth','Require-Auth',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (46,NULL,'AAT-FR-Direct','No',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (47,NULL,'AAT-FR-Direct','Yes',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (48,NULL,'AAT-Source-IP-Check','Source-IP-Check-No',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (49,NULL,'AAT-Source-IP-Check','Source-IP-Check-Yes',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (50,NULL,'AAT-IP-TOS','IP-TOS-Normal',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (51,NULL,'AAT-IP-TOS','IP-TOS-Disabled',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (52,NULL,'AAT-IP-TOS','IP-TOS-Cost',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (53,NULL,'AAT-IP-TOS','IP-TOS-Reliability',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (54,NULL,'AAT-IP-TOS','IP-TOS-Throughput',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (55,NULL,'AAT-IP-TOS','IP-TOS-Latency',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (56,NULL,'AAT-IP-TOS-Apply-To','IP-TOS-Apply-To-Incoming',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (57,NULL,'AAT-IP-TOS-Apply-To','IP-TOS-Apply-To-Both',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (58,NULL,'AAT-IP-TOS-Apply-To','IP-TOS-Apply-To-Outgoing',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (59,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-Normal',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (60,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-One',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (61,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-Two',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (62,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-Three',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (63,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-Four',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (64,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-Five',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (65,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-Six',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (66,NULL,'AAT-IP-TOS-Precedence','IP-TOS-Precedence-Pri-Seven',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (67,NULL,'AAT-Auth-Type','AAT-Auth-None',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (68,NULL,'AAT-Auth-Type','AAT-Auth-Default',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (69,NULL,'AAT-Auth-Type','AAT-Auth-Any',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (70,NULL,'AAT-Auth-Type','AAT-Auth-PAP',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (71,NULL,'AAT-Auth-Type','AAT-Auth-CHAP',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (72,NULL,'AAT-Auth-Type','AAT-Auth-MS-CHAP',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (73,NULL,'AAT-Client-Assign-DNS','DNS-Assign-No',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (74,NULL,'AAT-Client-Assign-DNS','DNS-Assign-Yes',NULL,'Alcatel',NULL,NULL,NULL,NULL),
                                (75,'integer','Mikrotik-Recv-Limit',NULL,NULL,'Mikrotik','=','reply','volumebytes','total receive limit in bytes for the client'),
                                (76,'integer','Mikrotik-Xmit-Limit',NULL,NULL,'Mikrotik','=','reply','volumebytes','total transmit limit in bytes for the client'),
                                (77,'string','Mikrotik-Group',NULL,NULL,'Mikrotik','=','reply','','Router local user group name (defines in /user group) for local users. HotSpot default profile for HotSpot users.'),
                                (78,'integer','Mikrotik-Wireless-Forward',NULL,NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (79,'integer','Mikrotik-Wireless-Skip-Dot1x',NULL,NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (80,'integer','Mikrotik-Wireless-Enc-Algo',NULL,NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (81,'string','Mikrotik-Wireless-Enc-Key',NULL,NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (82,'string','Mikrotik-Rate-Limit',NULL,NULL,'Mikrotik',':=','reply','mikrotikRateLimit','Datarate limitation for clients. Format is: rx-rate[/tx-rate] [rx-burst-rate[/tx-burst-rate] [rx-burst-threshold[/tx-burst-threshold] [rx-burst-time[/tx-burst-time] [priority] [rx-rate-min[/tx-rate-min]]]] from the point of view of the router (so \"rx\" is client upload, and \"tx\" is client download). All rates should be numbers with optional k (1,000s) or M (1,000,000s).'),
                                (83,'string','Mikrotik-Realm',NULL,NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (84,'ipaddr','Mikrotik-Host-IP',NULL,NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (85,'string','Mikrotik-Mark-Id',NULL,NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (86,'string','Mikrotik-Advertise-URL',NULL,NULL,'Mikrotik',':=','reply','','URL of the page with advertisements that should be displayed to clients. If this attribute is specified, advertisements are enabled automatically, including transparent proxy, even if they were explicitly disabled in the corresponding user profile. Multiple attribute instances may be send by RADIUS server to specify additional URLs which are choosen in round robin fashion.'),
                                (87,'integer','Mikrotik-Advertise-Interval',NULL,NULL,'Mikrotik',':=','reply','','Time interval between two adjacent advertisements. Multiple attribute instances may be send by RADIUS server to specify additional intervals. All interval values are threated as a list and are taken one-by-one for each successful advertisement. If end of list is reached, the last value is continued to be used.'),
                                (88,'integer','Mikrotik-Recv-Limit-Gigawords',NULL,NULL,'Mikrotik','=','reply','','4G (2^32) bytes of total receive limit (bits 32..63, when bits 0..31 are delivered in Mikrotik-Recv-Limit)'),
                                (89,'integer','Mikrotik-Xmit-Limit-Gigawords',NULL,NULL,'Mikrotik','=','reply','','4G (2^32) bytes of total transmit limit (bits 32..63, when bits 0..31 are delivered in Mikrotik-Recv-Limit)'),
                                (90,NULL,'Mikrotik-Wireless-Enc-Algo','No-encryption',NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (91,NULL,'Mikrotik-Wireless-Enc-Algo','40-bit-WEP',NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (92,NULL,'Mikrotik-Wireless-Enc-Algo','104-bit-WEP',NULL,'Mikrotik',NULL,NULL,NULL,NULL),
                                (93,'string','User-Name',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (94,'string','User-Password',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (95,'octets','CHAP-Password',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (96,'ipaddr','NAS-IP-Address',NULL,NULL,'dictionary.rfc2865','==','reply','','The NAS IP address. For example: IP address of Chilli (set by the radiusnasip or radiuslisten option). If neither radiuslisten nor nasipaddress are set NAS-IP-Address is set to \"0.0.0.0\".'),
                                (97,'integer','NAS-Port',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (98,'integer','Service-Type',NULL,NULL,'dictionary.rfc2865','=','reply','servicetype','Applies both as a check or as a reply item, when used as a check item use == as the operator'),
                                (99,'integer','Framed-Protocol',NULL,NULL,'dictionary.rfc2865','=','reply','framedprotocol',''),
                                (100,'ipaddr','Framed-IP-Address',NULL,NULL,'dictionary.rfc2865','=','reply','','This Attribute indicates the address to be configured for the user.'),
                                (101,'ipaddr','Framed-IP-Netmask',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (102,'integer','Framed-Routing',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (103,'string','Filter-Id',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (104,'integer','Framed-MTU',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (105,'integer','Framed-Compression',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (106,'ipaddr','Login-IP-Host',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (107,'integer','Login-Service',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (108,'integer','Login-TCP-Port',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (109,'string','Reply-Message',NULL,NULL,'dictionary.rfc2865',':=','reply','','Reason of reject if present.'),
                                (110,'string','Callback-Number',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (111,'string','Callback-Id',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (112,'string','Framed-Route',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (113,'ipaddr','Framed-IPX-Network',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (114,'octets','State',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (115,'octets','Class',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (116,'octets','Vendor-Specific',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (117,'integer','Session-Timeout',NULL,NULL,'dictionary.rfc2865',':=','reply','seconds','attribute for setting the maximum session timeout. The user is logged out after this amount of time'),
                                (118,'integer','Idle-Timeout',NULL,NULL,'dictionary.rfc2865',':=','reply','seconds','attribute for setting the maximum idle timeout. The user is logged out after this amount of time of inactivity (no traffic).'),
                                (119,'integer','Termination-Action',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (120,'string','Called-Station-Id',NULL,NULL,'dictionary.rfc2865','==','check','','Set to the radius called command line option or the MAC address of ChilliSpot if not present. (format is: aa:bb:cc:dd:ee:ff)'),
                                (121,'string','Calling-Station-Id',NULL,NULL,'dictionary.rfc2865','==','check','','MAC address of client (format is: aa:bb:cc:dd:ee:ff)'),
                                (122,'string','NAS-Identifier',NULL,NULL,'dictionary.rfc2865','==','check','','This Attribute contains a string identifying the NAS originating the Access-Request. It is only used in Access-Request packets.'),
                                (123,'octets','Proxy-State',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (124,'string','Login-LAT-Service',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (125,'string','Login-LAT-Node',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (126,'octets','Login-LAT-Group',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (127,'integer','Framed-AppleTalk-Link',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (128,'integer','Framed-AppleTalk-Network',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (129,'string','Framed-AppleTalk-Zone',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (130,'octets','CHAP-Challenge',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (131,'integer','NAS-Port-Type',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (132,'integer','Port-Limit',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (133,'integer','Login-LAT-Port',NULL,NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (134,NULL,'Service-Type','Login-User',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (135,NULL,'Service-Type','Framed-User',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (136,NULL,'Service-Type','Callback-Login-User',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (137,NULL,'Service-Type','Callback-Framed-User',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (138,NULL,'Service-Type','Outbound-User',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (139,NULL,'Service-Type','Administrative-User',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (140,NULL,'Service-Type','NAS-Prompt-User',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (141,NULL,'Service-Type','Authenticate-Only',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (142,NULL,'Service-Type','Callback-NAS-Prompt',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (143,NULL,'Service-Type','Call-Check',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (144,NULL,'Service-Type','Callback-Administrative',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (145,NULL,'Framed-Protocol','PPP',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (146,NULL,'Framed-Protocol','SLIP',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (147,NULL,'Framed-Protocol','ARAP',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (148,NULL,'Framed-Protocol','Gandalf-SLML',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (149,NULL,'Framed-Protocol','Xylogics-IPX-SLIP',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (150,NULL,'Framed-Protocol','X.75-Synchronous',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (151,NULL,'Framed-Routing','None',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (152,NULL,'Framed-Routing','Broadcast',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (153,NULL,'Framed-Routing','Listen',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (154,NULL,'Framed-Routing','Broadcast-Listen',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (155,NULL,'Framed-Compression','None',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (156,NULL,'Framed-Compression','Van-Jacobson-TCP-IP',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (157,NULL,'Framed-Compression','IPX-Header-Compression',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (158,NULL,'Framed-Compression','Stac-LZS',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (159,NULL,'Login-Service','Telnet',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (160,NULL,'Login-Service','Rlogin',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (161,NULL,'Login-Service','TCP-Clear',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (162,NULL,'Login-Service','PortMaster',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (163,NULL,'Login-Service','LAT',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (164,NULL,'Login-Service','X25-PAD',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (165,NULL,'Login-Service','X25-T3POS',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (166,NULL,'Login-Service','TCP-Clear-Quiet',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (167,NULL,'Login-TCP-Port','Telnet',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (168,NULL,'Login-TCP-Port','Rlogin',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (169,NULL,'Login-TCP-Port','Rsh',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (170,NULL,'Termination-Action','Default',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (171,NULL,'Termination-Action','RADIUS-Request',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (172,NULL,'NAS-Port-Type','Async',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (173,NULL,'NAS-Port-Type','Sync',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (174,NULL,'NAS-Port-Type','ISDN',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (175,NULL,'NAS-Port-Type','ISDN-V120',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (176,NULL,'NAS-Port-Type','ISDN-V110',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (177,NULL,'NAS-Port-Type','Virtual',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (178,NULL,'NAS-Port-Type','PIAFS',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (179,NULL,'NAS-Port-Type','HDLC-Clear-Channel',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (180,NULL,'NAS-Port-Type','X.25',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (181,NULL,'NAS-Port-Type','X.75',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (182,NULL,'NAS-Port-Type','G.3-Fax',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (183,NULL,'NAS-Port-Type','SDSL',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (184,NULL,'NAS-Port-Type','ADSL-CAP',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (185,NULL,'NAS-Port-Type','ADSL-DMT',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (186,NULL,'NAS-Port-Type','IDSL',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (187,NULL,'NAS-Port-Type','Ethernet',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (188,NULL,'NAS-Port-Type','xDSL',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (189,NULL,'NAS-Port-Type','Cable',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (190,NULL,'NAS-Port-Type','Wireless-Other',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (191,NULL,'NAS-Port-Type','Wireless-802.11',NULL,'dictionary.rfc2865',NULL,NULL,NULL,NULL),
                                (192,'integer','NS-Admin-Privilege',NULL,NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (193,'string','NS-VSYS-Name',NULL,NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (194,'string','NS-User-Group',NULL,NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (195,'ipaddr','NS-Primary-DNS',NULL,NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (196,'ipaddr','NS-Secondary-DNS',NULL,NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (197,'ipaddr','NS-Primary-WINS',NULL,NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (198,'ipaddr','NS-Secondary-WINS',NULL,NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (199,NULL,'NS-Admin-Privilege','Root-Admin',NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (200,NULL,'NS-Admin-Privilege','All-VSYS-Root-Admin',NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (201,NULL,'NS-Admin-Privilege','VSYS-Admin',NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (202,NULL,'NS-Admin-Privilege','Read-Only-Admin',NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (203,NULL,'NS-Admin-Privilege','Read-Only-VSYS-Admin',NULL,'Netscreen',NULL,NULL,NULL,NULL),
                                (204,'string','Nokia-User-Profile',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (205,'octets','Nokia-Service-Name',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (206,'octets','Nokia-Service-Id',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (207,'octets','Nokia-Service-Username',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (208,'octets','Nokia-Service-Password',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (209,'octets','Nokia-Service-Primary-Indicator',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (210,'octets','Nokia-Service-Charging-Type',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (211,'octets','Nokia-Service-Encrypted-Password',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (212,'octets','Nokia-Session-Access-Method',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (213,'octets','Nokia-Session-Charging-Type',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (214,'ipaddr','Nokia-Primary-DNS-Server',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (215,'ipaddr','Nokia-Secondary-DNS-Server',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (216,'octets','Nokia-IMSI',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (217,'integer','Nokia-Charging-Id',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (218,'integer','Nokia-Prepaid-Ind',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (219,'ipaddr','Nokia-GGSN-IP-Address',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (220,'ipaddr','Nokia-SGSN-IP-Address',NULL,NULL,'Nokia',NULL,NULL,NULL,NULL),
                                (221,'integer','VNC-PPPoE-CBQ-RX',NULL,NULL,'ValemountNetworks',NULL,NULL,NULL,NULL),
                                (222,'integer','VNC-PPPoE-CBQ-TX',NULL,NULL,'ValemountNetworks',NULL,NULL,NULL,NULL),
                                (223,'integer','VNC-PPPoE-CBQ-RX-Fallback',NULL,NULL,'ValemountNetworks',NULL,NULL,NULL,NULL),
                                (224,'integer','VNC-PPPoE-CBQ-TX-Fallback',NULL,NULL,'ValemountNetworks',NULL,NULL,NULL,NULL),
                                (225,'integer','VNC-Splash',NULL,NULL,'ValemountNetworks',NULL,NULL,NULL,NULL),
                                (226,NULL,'VNC-Splash','Show',NULL,'ValemountNetworks',NULL,NULL,NULL,NULL),
                                (227,NULL,'VNC-Splash','No-Show',NULL,'ValemountNetworks',NULL,NULL,NULL,NULL),
                                (228,'string','SofaWare-Admin',NULL,NULL,'SofaWare',NULL,NULL,NULL,NULL),
                                (229,'string','SofaWare-VPN',NULL,NULL,'SofaWare',NULL,NULL,NULL,NULL),
                                (230,'string','SofaWare-Hotspot',NULL,NULL,'SofaWare',NULL,NULL,NULL,NULL),
                                (231,'string','SofaWare-UFP',NULL,NULL,'SofaWare',NULL,NULL,NULL,NULL),
                                (232,'string','ST-Acct-VC-Connection-Id',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (233,'string','ST-Service-Name',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (234,'integer','ST-Service-Domain',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (235,'string','ST-Policy-Name',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (236,'ipaddr','ST-Primary-DNS-Server',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (237,'ipaddr','ST-Secondary-DNS-Server',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (238,'ipaddr','ST-Primary-NBNS-Server',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (239,'ipaddr','ST-Secondary-NBNS-Server',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (240,'integer','ST-Physical-Port',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (241,'integer','ST-Physical-Slot',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (242,'integer','ST-Virtual-Path-ID',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (243,'integer','ST-Virtual-Circuit-ID',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (244,'string','ST-Realm-Name',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (245,'integer','ST-IPSec-Pfs-Group',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (246,'integer','ST-IPSec-Client-Firewall',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (247,'string','ST-IPSec-Client-Subnet',NULL,NULL,'SpringTide',NULL,NULL,NULL,NULL),
                                (248,'string','Shiva-User-Attributes',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (249,'integer','Shiva-Compression',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (250,'integer','Shiva-Dialback-Delay',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (251,'integer','Shiva-Call-Durn-Trap',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (252,'integer','Shiva-Bandwidth-Trap',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (253,'integer','Shiva-Minimum-Call',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (254,'string','Shiva-Default-Host',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (255,'string','Shiva-Menu-Name',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (256,'string','Shiva-User-Flags',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (257,'string','Shiva-Termtype',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (258,'string','Shiva-Break-Key',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (259,'string','Shiva-Fwd-Key',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (260,'string','Shiva-Bak-Key',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (261,'integer','Shiva-Dial-Timeout',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (262,'string','Shiva-LAT-Port',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (263,'integer','Shiva-Max-VCs',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (264,'integer','Shiva-DHCP-Leasetime',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (265,'string','Shiva-LAT-Groups',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (266,'integer','Shiva-RTC-Timestamp',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (267,'integer','Shiva-Circuit-Type',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (268,'string','Shiva-Called-Number',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (269,'string','Shiva-Calling-Number',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (270,'string','Shiva-Customer-Id',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (271,'integer','Shiva-Type-Of-Service',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (272,'integer','Shiva-Link-Speed',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (273,'integer','Shiva-Links-In-Bundle',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (274,'integer','Shiva-Compression-Type',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (275,'integer','Shiva-Link-Protocol',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (276,'integer','Shiva-Network-Protocols',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (277,'integer','Shiva-Session-Id',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (278,'integer','Shiva-Disconnect-Reason',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (279,'ipaddr','Shiva-Acct-Serv-Switch',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (280,'integer','Shiva-Event-Flags',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (281,'integer','Shiva-Function',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (282,'integer','Shiva-Connect-Reason',NULL,NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (283,NULL,'Shiva-Compression','None',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (284,NULL,'Shiva-Compression','Negotiate',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (285,NULL,'Shiva-Compression','Spider',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (286,NULL,'Shiva-Compression','Predictor',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (287,NULL,'Shiva-Compression','STAC',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (288,NULL,'Shiva-Circuit-Type','Primary',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (289,NULL,'Shiva-Circuit-Type','Secondary-Backup',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (290,NULL,'Shiva-Circuit-Type','Secondary-Augment',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (291,NULL,'Shiva-Circuit-Type','Secondary-Switch',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (292,NULL,'Shiva-Circuit-Type','Listener',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (293,NULL,'Shiva-Circuit-Type','RADIUS',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (294,NULL,'Shiva-Type-Of-Service','Analog',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (295,NULL,'Shiva-Type-Of-Service','Digitized-Analog',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (296,NULL,'Shiva-Type-Of-Service','Digital',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (297,NULL,'Shiva-Type-Of-Service','Digital-V110',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (298,NULL,'Shiva-Type-Of-Service','Digital-V120',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (299,NULL,'Shiva-Type-Of-Service','Digital-Leased-Line',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (300,NULL,'Shiva-Link-Protocol','HDLC',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (301,NULL,'Shiva-Link-Protocol','ARAV1',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (302,NULL,'Shiva-Link-Protocol','ARAV2',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (303,NULL,'Shiva-Link-Protocol','SHELL',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (304,NULL,'Shiva-Link-Protocol','AALAP',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (305,NULL,'Shiva-Link-Protocol','SLIP',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (306,NULL,'Shiva-Connect-Reason','Remote',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (307,NULL,'Shiva-Connect-Reason','Dialback',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (308,NULL,'Shiva-Connect-Reason','Virtual-Connection',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (309,NULL,'Shiva-Connect-Reason','Bandwidth-On-Demand',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (310,NULL,'Shiva-Disconnect-Reason','Remote',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (311,NULL,'Shiva-Disconnect-Reason','Error',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (312,NULL,'Shiva-Disconnect-Reason','Idle-Timeout',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (313,NULL,'Shiva-Disconnect-Reason','Session-Timeout',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (314,NULL,'Shiva-Disconnect-Reason','Admin-Disconnect',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (315,NULL,'Shiva-Disconnect-Reason','Dialback',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (316,NULL,'Shiva-Disconnect-Reason','Virtual-Connection',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (317,NULL,'Shiva-Disconnect-Reason','Bandwidth-On-Demand',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (318,NULL,'Shiva-Disconnect-Reason','Failed-Authentication',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (319,NULL,'Shiva-Disconnect-Reason','Preempted',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (320,NULL,'Shiva-Disconnect-Reason','Blocked',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (321,NULL,'Shiva-Disconnect-Reason','Tariff-Management',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (322,NULL,'Shiva-Disconnect-Reason','Backup',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (323,NULL,'Shiva-Function','Unknown',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (324,NULL,'Shiva-Function','Dialin',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (325,NULL,'Shiva-Function','Dialout',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (326,NULL,'Shiva-Function','Lan-To-Lan',NULL,'Shiva',NULL,NULL,NULL,NULL),
                                (327,'string','Quintum-AVPair',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (328,'string','Quintum-NAS-Port',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (329,'string','Quintum-h323-remote-address',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (330,'string','Quintum-h323-conf-id',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (331,'string','Quintum-h323-setup-time',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (332,'string','Quintum-h323-call-origin',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (333,'string','Quintum-h323-call-type',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (334,'string','Quintum-h323-connect-time',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (335,'string','Quintum-h323-disconnect-time',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (336,'string','Quintum-h323-disconnect-cause',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (337,'string','Quintum-h323-voice-quality',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (338,'string','Quintum-h323-gw-id',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (339,'string','Quintum-h323-incoming-conf-id',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (340,'string','Quintum-h323-credit-amount',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (341,'string','Quintum-h323-credit-time',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (342,'string','Quintum-h323-return-code',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (343,'string','Quintum-h323-prompt-id',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (344,'string','Quintum-h323-time-and-day',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (345,'string','Quintum-h323-redirect-number',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (346,'string','Quintum-h323-preferred-lang',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (347,'string','Quintum-h323-redirect-ip-address',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (348,'string','Quintum-h323-billing-model',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (349,'string','Quintum-h323-currency-type',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (350,'string','Quintum-Trunkid-In',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (351,'string','Quintum-Trunkid-Out',NULL,NULL,'Quintum',NULL,NULL,NULL,NULL),
                                (352,'integer','Passport-Command-Scope',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (353,'integer','Passport-Command-Impact',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (354,'integer','Passport-Customer-Identifier',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (355,'integer','Passport-Allowed-Access',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (356,'integer','Passport-AllowedOut-Access',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (357,'string','Passport-Login-Directory',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (358,'integer','Passport-Timeout-Protocol',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (359,'string','Passport-Role',NULL,NULL,'Nortel',NULL,NULL,NULL,NULL),
                                (360,'octets','MS-CHAP-Response',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (361,'string','MS-CHAP-Error',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (362,'octets','MS-CHAP-CPW-1',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (363,'octets','MS-CHAP-CPW-2',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (364,'octets','MS-CHAP-LM-Enc-PW',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (365,'octets','MS-CHAP-NT-Enc-PW',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (366,'octets','MS-MPPE-Encryption-Policy',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (367,'octets','MS-MPPE-Encryption-Type',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (368,'octets','MS-MPPE-Encryption-Types',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (369,'integer','MS-RAS-Vendor',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (370,'string','MS-CHAP-Domain',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (371,'octets','MS-CHAP-Challenge',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (372,'octets','MS-CHAP-MPPE-Keys',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (373,'integer','MS-BAP-Usage',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (374,'integer','MS-Link-Utilization-Threshold',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (375,'integer','MS-Link-Drop-Time-Limit',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (376,'octets','MS-MPPE-Send-Key',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (377,'octets','MS-MPPE-Recv-Key',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (378,'string','MS-RAS-Version',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (379,'octets','MS-Old-ARAP-Password',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (380,'octets','MS-New-ARAP-Password',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (381,'integer','MS-ARAP-PW-Change-Reason',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (382,'octets','MS-Filter',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (383,'integer','MS-Acct-Auth-Type',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (384,'integer','MS-Acct-EAP-Type',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (385,'octets','MS-CHAP2-Response',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (386,'octets','MS-CHAP2-Success',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (387,'octets','MS-CHAP2-CPW',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (388,'ipaddr','MS-Primary-DNS-Server',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (389,'ipaddr','MS-Secondary-DNS-Server',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (390,'ipaddr','MS-Primary-NBNS-Server',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (391,'ipaddr','MS-Secondary-NBNS-Server',NULL,NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (392,NULL,'MS-BAP-Usage','Not-Allowed',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (393,NULL,'MS-BAP-Usage','Allowed',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (394,NULL,'MS-BAP-Usage','Required',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (395,NULL,'MS-ARAP-PW-Change-Reason','Just-Change-Password',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (396,NULL,'MS-ARAP-PW-Change-Reason','Expired-Password',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (397,NULL,'MS-ARAP-PW-Change-Reason','Admin-Requires-Password-Change',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (398,NULL,'MS-ARAP-PW-Change-Reason','Password-Too-Short',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (399,NULL,'MS-Acct-Auth-Type','PAP',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (400,NULL,'MS-Acct-Auth-Type','CHAP',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (401,NULL,'MS-Acct-Auth-Type','MS-CHAP-1',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (402,NULL,'MS-Acct-Auth-Type','MS-CHAP-2',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (403,NULL,'MS-Acct-Auth-Type','EAP',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (404,NULL,'MS-Acct-EAP-Type','MD5',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (405,NULL,'MS-Acct-EAP-Type','OTP',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (406,NULL,'MS-Acct-EAP-Type','Generic-Token-Card',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (407,NULL,'MS-Acct-EAP-Type','TLS',NULL,'Microsoft',NULL,NULL,NULL,NULL),
                                (408,'integer','Zyxel-Callback-Option',NULL,NULL,'Zyxel',NULL,NULL,NULL,NULL),
                                (409,'integer','Zyxel-Callback-Phone-Source',NULL,NULL,'Zyxel',NULL,NULL,NULL,NULL),
                                (410,NULL,'Zyxel-Callback-Phone-Source','Preconfigured',NULL,'Zyxel',NULL,NULL,NULL,NULL),
                                (411,NULL,'Zyxel-Callback-Phone-Source','User',NULL,'Zyxel',NULL,NULL,NULL,NULL),
                                (412,NULL,'Zyxel-Callback-Option','None',NULL,'Zyxel',NULL,NULL,NULL,NULL),
                                (413,NULL,'Zyxel-Callback-Option','Optional',NULL,'Zyxel',NULL,NULL,NULL,NULL),
                                (414,NULL,'Zyxel-Callback-Option','Mandatory',NULL,'Zyxel',NULL,NULL,NULL,NULL),
                                (415,'string','Chargeable-User-Identity',NULL,NULL,'dictionary.rfc4372',NULL,NULL,NULL,NULL),
                                (416,'integer','Acct-Session-Input-Octets',NULL,NULL,'Gemtek',NULL,NULL,NULL,NULL),
                                (417,'integer','Acct-Session-Input-Gigawords',NULL,NULL,'Gemtek',NULL,NULL,NULL,NULL),
                                (418,'integer','Acct-Session-Output-Octets',NULL,NULL,'Gemtek',NULL,NULL,NULL,NULL),
                                (419,'integer','Acct-Session-Output-Gigawords',NULL,NULL,'Gemtek',NULL,NULL,NULL,NULL),
                                (420,'integer','Acct-Session-Octets',NULL,NULL,'Gemtek',NULL,NULL,NULL,NULL),
                                (421,'integer','Acct-Session-Gigawords',NULL,NULL,'Gemtek',NULL,NULL,NULL,NULL),
                                (422,'string','Gandalf-Remote-LAN-Name',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (423,'integer','Gandalf-Operational-Modes',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (424,'integer','Gandalf-Compression-Status',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (425,'integer','Gandalf-Min-Outgoing-Bearer',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (426,'string','Gandalf-Authentication-String',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (427,'integer','Gandalf-PPP-Authentication',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (428,'integer','Gandalf-PPP-NCP-Type',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (429,'integer','Gandalf-Fwd-Multicast-In',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (430,'integer','Gandalf-Fwd-Broadcast-In',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (431,'integer','Gandalf-Fwd-Unicast-In',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (432,'integer','Gandalf-Fwd-Multicast-Out',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (433,'integer','Gandalf-Fwd-Broadcast-Out',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (434,'integer','Gandalf-Fwd-Unicast-Out',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (435,'integer','Gandalf-Around-The-Corner',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (436,'string','Gandalf-Channel-Group-Name-1',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (437,'string','Gandalf-Dial-Prefix-Name-1',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (438,'string','Gandalf-Phone-Number-1',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (439,'string','Gandalf-Calling-Line-ID-1',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (440,'string','Gandalf-Channel-Group-Name-2',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (441,'string','Gandalf-Dial-Prefix-Name-2',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (442,'string','Gandalf-Phone-Number-2',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (443,'string','Gandalf-Calling-Line-ID-2',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (444,'integer','Gandalf-IPX-Spoofing-State',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (445,'integer','Gandalf-IPX-Watchdog-Spoof',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (446,'string','Gandalf-SAP-Group-Name-1',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (447,'string','Gandalf-SAP-Group-Name-2',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (448,'string','Gandalf-SAP-Group-Name-3',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (449,'string','Gandalf-SAP-Group-Name-4',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (450,'string','Gandalf-SAP-Group-Name-5',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (451,'string','Gandalf-Hunt-Group',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (452,'integer','Gandalf-Modem-Mode',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (453,'integer','Gandalf-Modem-Required-1',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (454,'integer','Gandalf-Modem-Required-2',NULL,NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (455,NULL,'Gandalf-Operational-Modes','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (456,NULL,'Gandalf-Operational-Modes','Called-Only',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (457,NULL,'Gandalf-Operational-Modes','Calling-Called',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (458,NULL,'Gandalf-Operational-Modes','Calling-Only',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (459,NULL,'Gandalf-Compression-Status','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (460,NULL,'Gandalf-Compression-Status','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (461,NULL,'Gandalf-Min-Outgoing-Bearer','Unrestricted-64K',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (462,NULL,'Gandalf-Min-Outgoing-Bearer','Digital-56K',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (463,NULL,'Gandalf-Min-Outgoing-Bearer','3100Hz-Audio',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (464,NULL,'Gandalf-PPP-Authentication','CHAP',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (465,NULL,'Gandalf-PPP-Authentication','PAP',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (466,NULL,'Gandalf-PPP-Authentication','PAP-Sending-on-Incoming-Calls',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (467,NULL,'Gandalf-PPP-NCP-Type','BCP',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (468,NULL,'Gandalf-PPP-NCP-Type','IPCP',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (469,NULL,'Gandalf-Fwd-Multicast-In','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (470,NULL,'Gandalf-Fwd-Multicast-In','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (471,NULL,'Gandalf-Fwd-Broadcast-In','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (472,NULL,'Gandalf-Fwd-Broadcast-In','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (473,NULL,'Gandalf-Fwd-Unicast-In','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (474,NULL,'Gandalf-Fwd-Unicast-In','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (475,NULL,'Gandalf-Fwd-Multicast-Out','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (476,NULL,'Gandalf-Fwd-Multicast-Out','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (477,NULL,'Gandalf-Fwd-Broadcast-Out','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (478,NULL,'Gandalf-Fwd-Broadcast-Out','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (479,NULL,'Gandalf-Fwd-Unicast-Out','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (480,NULL,'Gandalf-Fwd-Unicast-Out','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (481,NULL,'Gandalf-IPX-Spoofing-State','Forward',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (482,NULL,'Gandalf-IPX-Spoofing-State','Spoof',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (483,NULL,'Gandalf-IPX-Spoofing-State','Filter-all-outgoing-RIP-SAP',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (484,NULL,'Gandalf-IPX-Watchdog-Spoof','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (485,NULL,'Gandalf-IPX-Watchdog-Spoof','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (486,NULL,'Gandalf-Modem-Mode','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (487,NULL,'Gandalf-Modem-Mode','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (488,NULL,'Gandalf-Modem-Required-1','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (489,NULL,'Gandalf-Modem-Required-1','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (490,NULL,'Gandalf-Modem-Required-2','Disabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (491,NULL,'Gandalf-Modem-Required-2','Enabled',NULL,'Gandalf',NULL,NULL,NULL,NULL),
                                (492,'integer','Egress-VLANID',NULL,NULL,'dictionary.rfc4675',NULL,NULL,NULL,NULL),
                                (493,'integer','Ingress-Filters',NULL,NULL,'dictionary.rfc4675',NULL,NULL,NULL,NULL),
                                (494,'string','Egress-VLAN-Name',NULL,NULL,'dictionary.rfc4675',NULL,NULL,NULL,NULL),
                                (495,'octets','User-Priority-Table',NULL,NULL,'dictionary.rfc4675',NULL,NULL,NULL,NULL),
                                (496,NULL,'Ingress-Filters','Enabled',NULL,'dictionary.rfc4675',NULL,NULL,NULL,NULL),
                                (497,NULL,'Ingress-Filters','Disabled',NULL,'dictionary.rfc4675',NULL,NULL,NULL,NULL),
                                (498,'integer','Nomadix-Bw-Up',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (499,'integer','Nomadix-Bw-Down',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (500,'string','Nomadix-URL-Redirection',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (501,'integer','Nomadix-IP-Upsell',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (502,'string','Nomadix-Expiration',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (503,'string','Nomadix-Subnet',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (504,'integer','Nomadix-MaxBytesUp',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (505,'integer','Nomadix-MaxBytesDown',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (506,'integer','Nomadix-EndofSession',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (507,'string','Nomadix-Logoff-URL',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (508,'integer','Nomadix-Net-VLAN',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (509,'string','Nomadix-Config-URL',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (510,'string','Nomadix-Goodbye-URL',NULL,NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (511,NULL,'Nomadix-IP-Upsell','PrivatePool',NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (512,NULL,'Nomadix-IP-Upsell','PublicPool',NULL,'Nomadix',NULL,NULL,NULL,NULL),
                                (513,'integer','Multi-Link-Flag',NULL,NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (514,'integer','Char-Noecho',NULL,NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (515,NULL,'Termination-Action','Manage-Resources',NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (516,NULL,'Acct-Status-Type','Modem-Start',NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (517,NULL,'Acct-Status-Type','Modem-Stop',NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (518,NULL,'Acct-Status-Type','Cancel',NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (519,NULL,'Multi-Link-Flag','True',NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (520,NULL,'Multi-Link-Flag','False',NULL,'dictionary.usr',NULL,NULL,NULL,NULL),
                                (521,'string','USR-Last-Number-Dialed-Out',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (522,'string','USR-Last-Number-Dialed-In-DNIS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (523,'string','USR-Last-Callers-Number-ANI',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (524,'integer','USR-Channel',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (525,'integer','USR-Event-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (526,'date','USR-Event-Date-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (527,'date','USR-Call-Start-Date-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (528,'date','USR-Call-End-Date-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (529,'integer','USR-Default-DTE-Data-Rate',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (530,'integer','USR-Initial-Rx-Link-Data-Rate',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (531,'integer','USR-Final-Rx-Link-Data-Rate',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (532,'integer','USR-Initial-Tx-Link-Data-Rate',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (533,'integer','USR-Final-Tx-Link-Data-Rate',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (534,'integer','USR-Chassis-Temperature',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (535,'integer','USR-Chassis-Temp-Threshold',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (536,'integer','USR-Actual-Voltage',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (537,'integer','USR-Expected-Voltage',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (538,'integer','USR-Power-Supply-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (539,'integer','USR-Card-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (540,'integer','USR-Chassis-Slot',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (541,'integer','USR-Sync-Async-Mode',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (542,'integer','USR-Originate-Answer-Mode',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (543,'integer','USR-Modulation-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (544,'integer','USR-Connect-Term-Reason',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (545,'integer','USR-Failure-to-Connect-Reason',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (546,'integer','USR-Equalization-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (547,'integer','USR-Fallback-Enabled',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (548,'integer','USR-Connect-Time-Limit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (549,'integer','USR-Number-of-Rings-Limit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (550,'integer','USR-DTE-Data-Idle-Timout',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (551,'integer','USR-Characters-Sent',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (552,'integer','USR-Characters-Received',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (553,'integer','USR-Blocks-Sent',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (554,'integer','USR-Blocks-Received',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (555,'integer','USR-Blocks-Resent',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (556,'integer','USR-Retrains-Requested',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (557,'integer','USR-Retrains-Granted',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (558,'integer','USR-Line-Reversals',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (559,'integer','USR-Number-Of-Characters-Lost',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (560,'integer','USR-Number-of-Blers',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (561,'integer','USR-Number-of-Link-Timeouts',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (562,'integer','USR-Number-of-Fallbacks',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (563,'integer','USR-Number-of-Upshifts',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (564,'integer','USR-Number-of-Link-NAKs',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (565,'integer','USR-DTR-False-Timeout',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (566,'integer','USR-Fallback-Limit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (567,'integer','USR-Block-Error-Count-Limit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (568,'integer','USR-DTR-True-Timeout',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (569,'integer','USR-Security-Login-Limit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (570,'integer','USR-Security-Resp-Limit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (571,'integer','USR-DTE-Ring-No-Answer-Limit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (572,'integer','USR-Back-Channel-Data-Rate',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (573,'integer','USR-Simplified-MNP-Levels',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (574,'integer','USR-Simplified-V42bis-Usage',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (575,'integer','USR-Mbi_Ct_PRI_Card_Slot',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (576,'integer','USR-Mbi_Ct_TDM_Time_Slot',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (577,'integer','USR-Mbi_Ct_PRI_Card_Span_Line',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (578,'integer','USR-Mbi_Ct_BChannel_Used',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (579,'integer','USR-Physical-State',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (580,'integer','USR-Packet-Bus-Session',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (581,'date','USR-Server-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (582,'integer','USR-Channel-Connected-To',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (583,'integer','USR-Slot-Connected-To',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (584,'integer','USR-Device-Connected-To',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (585,'integer','USR-NFAS-ID',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (586,'integer','USR-Q931-Call-Reference-Value',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (587,'integer','USR-Call-Event-Code',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (588,'integer','USR-DS0',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (589,'string','USR-DS0s',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (590,'ipaddr','USR-Gateway-IP-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (591,'integer','CW-Version-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (592,'string','CW-Account-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (593,'integer','CW-Acct-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (594,'integer','CW-Acct-Identification-Code',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (595,'integer','CW-Service-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (596,'integer','CW-Rate-Plan-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (597,'integer','CW-Source-Identifier',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (598,'string','CW-Session-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (599,'integer','CW-Num-Call-Attempt-Session',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (600,'integer','CW-Session-Sequence-Num',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (601,'integer','CW-Session-Sequence-End',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (602,'integer','CW-Authentication-Fail-Cnt',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (603,'integer','CW-Clg-Party-E164-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (604,'string','CW-Clg-Party-E164-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (605,'integer','CW-Clg-Party-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (606,'integer','CW-Clg-Party-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (607,'ipaddr','CW-Clg-Party-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (608,'string','CW-Clg-Party-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (609,'integer','CW-Cld-Party-E164-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (610,'string','CW-Cld-Party-E164-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (611,'integer','CW-Cld-Party-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (612,'integer','CW-Cld-Party-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (613,'ipaddr','CW-Cld-Party-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (614,'string','CW-Cld-Party-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (615,'integer','CW-Orig-Line-Identifier',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (616,'integer','CW-PSTN-Interface-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (617,'integer','CW-Ingr-Gway-E164-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (618,'string','CW-Ingr-Gway-E164-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (619,'integer','CW-Ingr-Gway-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (620,'integer','CW-Ingr-Gway-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (621,'ipaddr','CW-Ingr-Gway-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (622,'string','CW-Ingr-Gway-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (623,'integer','CW-Egr-Gway-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (624,'integer','CW-Egr-Gway-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (625,'ipaddr','CW-Egr-Gway-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (626,'string','CW-Egr-Gway-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (627,'integer','CW-Ingr-Gtkpr-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (628,'integer','CW-Ingr-Gtkpr-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (629,'ipaddr','CW-Ingr-Gtkpr-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (630,'string','CW-Ingr-Gtkpr-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (631,'integer','CW-Egr-Gtkpr-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (632,'integer','CW-Egr-Gtkpr-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (633,'ipaddr','CW-Egr-Gtkpr-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (634,'string','CW-Egr-Gtkpr-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (635,'string','CW-Call-Identifier',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (636,'integer','CW-Call-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (637,'string','CW-Call-Start-Ingr-GW-Sec',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (638,'integer','CW-Call-Start-Ingr-GW-Msec',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (639,'string','CW-Call-Start-Time-Ans-Sec',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (640,'integer','CW-Call-Start-Time-Ans-Msec',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (641,'string','CW-Call-End-Time-Sec',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (642,'integer','CW-Call-End-Time-Msec',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (643,'integer','CW-Call-Durn-Connect-Disc',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (644,'integer','CW-Codec-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (645,'integer','CW-Call-Termination-Cause',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (646,'integer','CW-Audio-Packets-Sent',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (647,'integer','CW-Audio-Packets-Received',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (648,'integer','CW-Audio-Packets-Lost',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (649,'integer','CW-Audio-Packets-In-Frame',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (650,'integer','CW-Audio-Bytes-In-Frame',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (651,'integer','CW-Audio-Signal-In-Packet',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (652,'integer','CW-Port-Id-For-Call',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (653,'integer','CW-Slot-Id-For-Call',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (654,'integer','CW-Acct-Balance-Start-Curr',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (655,'integer','CW-Acct-Balance-Start-Amt',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (656,'integer','CW-Acct-Balance-Start-Dec',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (657,'integer','CW-Acct-Balance-Decr-Curr',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (658,'string','CW-LRQ-Token',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (659,'string','CW-ARQ-Token',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (660,'integer','CW-Token-Status',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (661,'integer','CW-SS7-Destn-Ptcode-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (662,'integer','CW-SS7-Destn-Ptcode-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (663,'integer','CW-SS7-Orig-Ptcode-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (664,'integer','CW-SS7-Orig-Ptcode-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (665,'integer','CW-SS7-CIC',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (666,'integer','CW-MGC-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (667,'integer','CW-MG-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (668,'integer','CW-Signaling-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (669,'integer','CW-Protocol-Transport',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (670,'integer','CW-Local-Sig-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (671,'integer','CW-Local-Sig-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (672,'ipaddr','CW-Local-Sig-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (673,'string','CW-Local-Sig-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (674,'integer','CW-Remote-Sig-Trans-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (675,'integer','CW-Remote-Sig-Trans-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (676,'ipaddr','CW-Remote-Sig-Trans-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (677,'string','CW-Remote-Sig-Trans-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (678,'integer','CW-Local-MG-RTP-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (679,'integer','CW-Local-MG-RTP-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (680,'ipaddr','CW-Local-MG-RTP-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (681,'string','CW-Local-MG-RTP-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (682,'integer','CW-Remote-MG-RTP-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (683,'integer','CW-Remote-MG-RTP-Port',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (684,'ipaddr','CW-Remote-MG-RTP-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (685,'string','CW-Remote-MG-RTP-DNS',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (686,'integer','CW-Call-Model',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (687,'integer','CW-Call-Plan-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (688,'integer','CW-Trans-Cld-Party-E164-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (689,'string','CW-Trans-Cld-Party-E164-Num',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (690,'string','CW-OSP-Source-Device',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (691,'string','USR-PW_USR_IFilter_IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (692,'string','USR-PW_USR_IFilter_IPX',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (693,'string','USR-PW_USR_OFilter_IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (694,'string','USR-PW_USR_OFilter_IPX',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (695,'string','USR-PW_USR_OFilter_SAP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (696,'string','USR-PW_VPN_ID',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (697,'string','USR-PW_VPN_Name',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (698,'ipaddr','USR-PW_VPN_Neighbor',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (699,'string','USR-PW_Framed_Routing_V2',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (700,'string','USR-PW_VPN_Gateway',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (701,'string','USR-PW_Tunnel_Authentication',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (702,'string','USR-PW_Index',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (703,'string','USR-PW_Cutoff',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (704,'string','USR-PW_Packet',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (705,'ipaddr','USR-Primary_DNS_Server',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (706,'ipaddr','USR-Secondary_DNS_Server',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (707,'ipaddr','USR-Primary_NBNS_Server',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (708,'ipaddr','USR-Secondary_NBNS_Server',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (709,'integer','USR-Syslog-Tap',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (710,'integer','USR-Chassis-Call-Slot',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (711,'integer','USR-Chassis-Call-Span',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (712,'integer','USR-Chassis-Call-Channel',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (713,'integer','USR-Keypress-Timeout',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (714,'integer','USR-Unauthenticated-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (715,'integer','USR-Connect-Speed',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (716,'string','USR-Framed_IP_Address_Pool_Name',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (717,'string','USR-MP-EDO',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (718,'integer','USR-Bearer-Capabilities',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (719,'integer','USR-Speed-Of-Connection',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (720,'integer','USR-Max-Channels',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (721,'integer','USR-Channel-Expansion',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (722,'integer','USR-Channel-Decrement',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (723,'integer','USR-Expansion-Algorithm',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (724,'integer','USR-Compression-Algorithm',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (725,'integer','USR-Receive-Acc-Map',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (726,'integer','USR-Transmit-Acc-Map',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (727,'integer','USR-Compression-Reset-Mode',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (728,'integer','USR-Min-Compression-Size',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (729,'integer','USR-IP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (730,'integer','USR-IPX',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (731,'integer','USR-Filter-Zones',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (732,'integer','USR-Appletalk',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (733,'integer','USR-Bridging',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (734,'integer','USR-Spoofing',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (735,'integer','USR-Host-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (736,'string','USR-Send-Name',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (737,'string','USR-Send-Password',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (738,'integer','USR-Start-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (739,'integer','USR-End-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (740,'string','USR-Send-Script1',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (741,'string','USR-Reply-Script1',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (742,'string','USR-Send-Script2',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (743,'string','USR-Reply-Script2',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (744,'string','USR-Send-Script3',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (745,'string','USR-Reply-Script3',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (746,'string','USR-Send-Script4',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (747,'string','USR-Reply-Script4',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (748,'string','USR-Send-Script5',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (749,'string','USR-Reply-Script5',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (750,'string','USR-Send-Script6',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (751,'string','USR-Reply-Script6',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (752,'string','USR-Terminal-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (753,'integer','USR-Appletalk-Network-Range',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (754,'string','USR-Local-IP-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (755,'integer','USR-Routing-Protocol',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (756,'integer','USR-Modem-Group',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (757,'integer','USR-Modem-Training-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (758,'integer','USR-Interface-Index',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (759,'integer','USR-MP-MRRU',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (760,'string','USR-SAP-Filter-In',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (761,'string','USR-MIC',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (762,'string','USR-Log-Filter-Packets',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (763,'integer','USR-VPN-Encrypter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (764,'integer','USR-Re-Chap-Timeout',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (765,'string','USR-Tunnel-Switch-Endpoint',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (766,'integer','USR-IP-SAA-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (767,'integer','Initial-Modulation-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (768,'string','USR-VTS-Session-Key',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (769,'string','USR-Orig-NAS-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (770,'integer','USR-Call-Arrival-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (771,'integer','USR-Call-End-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (772,'string','USR-Tunnel-Auth-Hostname',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (773,'integer','USR-Acct-Reason-Code',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (774,'integer','USR-Supports-Tags',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (775,'integer','USR-HARC-Disconnect-Code',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (776,'integer','USR-RMMIE-Status',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (777,'integer','USR-RMMIE-Last-Update-Event',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (778,'integer','USR-RMMIE-x2-Status',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (779,'integer','USR-RMMIE-Planned-Disconnect',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (780,'string','USR-VPN-GW-Location-Id',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (781,'integer','USR-CCP-Algorithm',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (782,'integer','USR-ACCM-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (783,'ipaddr','USR-Local-Framed-IP-Addr',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (784,'integer','USR-IPX-Routing',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (785,'integer','USR-IPX-WAN',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (786,'integer','USR-IP-RIP-Policies',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (787,'string','USR-IP-RIP-Simple-Auth-Password',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (788,'string','USR-IP-RIP-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (789,'string','USR-IP-Call-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (790,'string','USR-IPX-RIP-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (791,'string','USR-IPX-Call-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (792,'string','USR-AT-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (793,'string','USR-AT-RTMP-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (794,'string','USR-AT-Zip-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (795,'string','USR-AT-Call-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (796,'string','USR-ET-Bridge-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (797,'string','USR-IP-RIP-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (798,'string','USR-IP-Call-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (799,'string','USR-IPX-RIP-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (800,'string','USR-IPX-Call-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (801,'string','USR-AT-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (802,'string','USR-AT-RTMP-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (803,'string','USR-AT-Zip-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (804,'string','USR-AT-Call-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (805,'string','USR-ET-Bridge-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (806,'string','USR-ET-Bridge-Call-Output-Filte',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (807,'integer','USR-IP-Default-Route-Option',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (808,'string','USR-MP-EDO-HIPER',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (809,'integer','USR-Tunnel-Security',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (810,'integer','USR-Port-Tap',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (811,'integer','USR-Port-Tap-Format',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (812,'integer','USR-Port-Tap-Output',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (813,'integer','USR-Port-Tap-Facility',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (814,'integer','USR-Port-Tap-Priority',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (815,'ipaddr','USR-Port-Tap-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (816,'ipaddr','USR-MobileIP-Home-Agent-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (817,'integer','USR-Tunneled-MLPP',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (818,'integer','USR-Multicast-Proxy',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (819,'integer','USR-Multicast-Receive',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (820,'integer','USR-Multicast-Forwarding',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (821,'integer','USR-IGMP-Query-Interval',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (822,'integer','USR-IGMP-Maximum-Response-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (823,'integer','USR-IGMP-Robustness',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (824,'integer','USR-IGMP-Version',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (825,'integer','USR-Callback-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (826,'integer','USR-Request-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (827,'integer','USR-RMMIE-Num-Of-Updates',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (828,'integer','USR-RMMIE-Manufacturer-ID',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (829,'string','USR-RMMIE-Product-Code',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (830,'string','USR-RMMIE-Serial-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (831,'string','USR-RMMIE-Firmware-Version',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (832,'string','USR-RMMIE-Firmware-Build-Date',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (833,'date','USR-Call-Arrival-in-GMT',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (834,'date','USR-Call-Connect-in-GMT',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (835,'date','USR-Call-Terminate-in-GMT',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (836,'integer','USR-IDS0-Call-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (837,'integer','USR-Call-Reference-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (838,'integer','USR-CDMA-Call-Reference-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (839,'ipaddr','USR-Mobile-IP-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (840,'ipaddr','USR-QNC1-Service-Destination',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (841,'ipaddr','USR-IWF-IP-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (842,'string','USR-Called-Party-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (843,'string','USR-Calling-Party-Number',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (844,'integer','USR-Call-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (845,'string','USR-ESN',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (846,'integer','USR-IWF-Call-Identifier',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (847,'string','USR-IMSI',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (848,'integer','USR-Service-Option',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (849,'integer','USR-Disconnect-Cause-Indicator',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (850,'integer','USR-Mobile-NumBytes-Txed',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (851,'integer','USR-Mobile-NumBytes-Rxed',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (852,'integer','USR-Num-Fax-Pages-Processed',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (853,'integer','USR-Compression-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (854,'integer','USR-Call-Error-Code',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (855,'integer','USR-Modem-Setup-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (856,'integer','USR-Call-Connecting-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (857,'integer','USR-Connect-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (858,'integer','USR-RMMIE-Last-Update-Time',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (859,'integer','USR-RMMIE-Rcv-Tot-PwrLvl',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (860,'integer','USR-RMMIE-Rcv-PwrLvl-3300Hz',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (861,'integer','USR-RMMIE-Rcv-PwrLvl-3750Hz',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (862,'integer','USR-RMMIE-PwrLvl-NearEcho-Canc',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (863,'integer','USR-RMMIE-PwrLvl-FarEcho-Canc',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (864,'integer','USR-RMMIE-PwrLvl-Noise-Lvl',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (865,'integer','USR-RMMIE-PwrLvl-Xmit-Lvl',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (866,'ipaddr','USR-Framed-IPX-Route',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (867,'ipaddr','USR-MPIP-Tunnel-Originator',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (868,'integer','USR-IGMP-Routing',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (869,'integer','USR-Rad-Multicast-Routing-Ttl',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (870,'integer','USR-Rad-Multicast-Routing-RtLim',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (871,'integer','USR-Rad-Multicast-Routing-Proto',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (872,'string','USR-Rad-Multicast-Routing-Bound',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (873,'integer','USR-Rad-Dvmrp-Metric',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (874,'string','USR-Chat-Script-Name',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (875,'string','USR-CUSR-hat-Script-Rules',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (876,'integer','USR-Rad-Location-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (877,'integer','USR-OSPF-Addressless-Index',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (878,'integer','USR-QoS-Queuing-Mehtod',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (879,'integer','USR-PQ-Default-Priority',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (880,'integer','USR-FQ-Default-Priority',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (881,'integer','USR-IPP-Enable',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (882,'string','USR-Pre-Shared-MN-Key',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (883,'integer','USR-MIP-NAI',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (884,'integer','USR-DNIS-ReAuthentication',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (885,'integer','USR-Agent',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (886,'integer','USR-PQ-Parameters',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (887,'integer','USR-Dvmrp-Prune-Lifetime',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (888,'integer','USR-Special-Xon-Xoff-Flow',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (889,'integer','USR-Dvmrp-Advertised-Metric',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (890,'integer','USR-Dvmrp-Retransmit-Prunes',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (891,'integer','USR-Dvmrp-Non-Pruners',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (892,'integer','USR-Dvmrp-Route-Transit',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (893,'string','USR-Dvmrp-Input-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (894,'string','USR-Dvmrp-Output-Filter',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (895,'integer','USR-Policy-Access',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (896,'integer','USR-Policy-Configuration',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (897,'string','USR-Policy-Filename',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (898,'integer','USR-Policy-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (899,'integer','USR-Mobile-Session-ID',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (900,'integer','USR-Mobile-Accounting-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (901,'integer','USR-Mobile-Service-Option',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (902,'integer','USR-Wallclock-Timestamp',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (903,'integer','USR-Dvmrp-Initial-Flooding',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (904,'integer','USR-Telnet-Options',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (905,'integer','USR-CDMA-PktData-Network-ID',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (906,'ipaddr','USR-Auth-Next-Server-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (907,'integer','USR-User-PPP-AODI-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (908,'integer','USR-MLPPP-Fragmentation-Threshld',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (909,'ipaddr','USR-Unnumbered-Local-IP-Address',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (910,'integer','USR-Traffic-Threshold',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (911,'integer','USR-Keep-Alive-Interval',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (912,'integer','USR-Tunnel-Challenge-Outgoing',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (913,'string','USR-X25-Trunk-Profile',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (914,'integer','USR-X25-Acct-Input-Segment-Count',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (915,'integer','USR-X25-Acct-Output-Segment-Coun',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (916,'integer','USR-X25-Acct-Segment-Size',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (917,'integer','USR-X25-Acct-Termination-Code',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (918,'integer','USR-X25-SVC-Logical-Channel-Numb',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (919,'integer','USR-Nailed-B-Channel-Indicator',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (920,'integer','USR-X25-SVC-Call-Attributes',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (921,'ipaddr','USR-Init-Reg-Server-Addr',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (922,'ipaddr','USR-Re-Reg-Server-Addr',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (923,'integer','USR-Bytes-TX-Remain',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (924,'integer','USR-Bytes-RX-Remain',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (925,'integer','USR-Session-Time-Remain',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (926,'integer','USR-Pre-Paid-Enabled',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (927,'integer','USR-Reg-Server-Prov-Timeout',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (928,'integer','USR-Redirect',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (929,'integer','USR-VLAN-Tag',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (930,'string','USR-Rad-IP-Pool-Definition',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (931,'integer','USR-Rad-NMC-Call-Progress-Status',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (932,'integer','USR-Rad-NMC-Blocks_RX',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (933,'integer','USR-NAS-Type',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (934,'integer','USR-Auth-Mode',NULL,NULL,'USR',NULL,NULL,NULL,NULL),
                                (935,NULL,'USR-Syslog-Tap','Off',NULL,'USR',NULL,NULL,NULL,NULL),
                                (936,NULL,'USR-Syslog-Tap','On-Raw',NULL,'USR',NULL,NULL,NULL,NULL),
                                (937,NULL,'USR-Syslog-Tap','On-Framed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (938,NULL,'USR-Syslog-Tap','Unknown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (939,NULL,'USR-Event-Id','Module-Inserted',NULL,'USR',NULL,NULL,NULL,NULL),
                                (940,NULL,'USR-Event-Id','Module-Removed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (941,NULL,'USR-Event-Id','PSU-Voltage-Alarm',NULL,'USR',NULL,NULL,NULL,NULL),
                                (942,NULL,'USR-Event-Id','PSU-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (943,NULL,'USR-Event-Id','HUB-Temp-Out-of-Range',NULL,'USR',NULL,NULL,NULL,NULL),
                                (944,NULL,'USR-Event-Id','Fan-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (945,NULL,'USR-Event-Id','Watchdog-Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (946,NULL,'USR-Event-Id','Mgmt-Bus-Failure',NULL,'USR',NULL,NULL,NULL,NULL),
                                (947,NULL,'USR-Event-Id','In-Connection-Est',NULL,'USR',NULL,NULL,NULL,NULL),
                                (948,NULL,'USR-Event-Id','Out-Connection-Est',NULL,'USR',NULL,NULL,NULL,NULL),
                                (949,NULL,'USR-Event-Id','In-Connection-Term',NULL,'USR',NULL,NULL,NULL,NULL),
                                (950,NULL,'USR-Event-Id','Out-Connection-Term',NULL,'USR',NULL,NULL,NULL,NULL),
                                (951,NULL,'USR-Event-Id','Connection-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (952,NULL,'USR-Event-Id','Connection-Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (953,NULL,'USR-Event-Id','DTE-Transmit-Idle',NULL,'USR',NULL,NULL,NULL,NULL),
                                (954,NULL,'USR-Event-Id','DTR-True',NULL,'USR',NULL,NULL,NULL,NULL),
                                (955,NULL,'USR-Event-Id','DTR-False',NULL,'USR',NULL,NULL,NULL,NULL),
                                (956,NULL,'USR-Event-Id','Block-Error-at-Threshold',NULL,'USR',NULL,NULL,NULL,NULL),
                                (957,NULL,'USR-Event-Id','Fallbacks-at-Threshold',NULL,'USR',NULL,NULL,NULL,NULL),
                                (958,NULL,'USR-Event-Id','No-Dial-Tone-Detected',NULL,'USR',NULL,NULL,NULL,NULL),
                                (959,NULL,'USR-Event-Id','No-Loop-Current-Detected',NULL,'USR',NULL,NULL,NULL,NULL),
                                (960,NULL,'USR-Event-Id','Yellow-Alarm',NULL,'USR',NULL,NULL,NULL,NULL),
                                (961,NULL,'USR-Event-Id','Red-Alarm',NULL,'USR',NULL,NULL,NULL,NULL),
                                (962,NULL,'USR-Event-Id','Loss-Of-Signal',NULL,'USR',NULL,NULL,NULL,NULL),
                                (963,NULL,'USR-Event-Id','Rcv-Alrm-Ind-Signal',NULL,'USR',NULL,NULL,NULL,NULL),
                                (964,NULL,'USR-Event-Id','Timing-Source-Switch',NULL,'USR',NULL,NULL,NULL,NULL),
                                (965,NULL,'USR-Event-Id','Modem-Reset-by-DTE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (966,NULL,'USR-Event-Id','Modem-Ring-No-Answer',NULL,'USR',NULL,NULL,NULL,NULL),
                                (967,NULL,'USR-Event-Id','DTE-Ring-No-Answer',NULL,'USR',NULL,NULL,NULL,NULL),
                                (968,NULL,'USR-Event-Id','Pkt-Bus-Session-Active',NULL,'USR',NULL,NULL,NULL,NULL),
                                (969,NULL,'USR-Event-Id','Pkt-Bus-Session-Congestion',NULL,'USR',NULL,NULL,NULL,NULL),
                                (970,NULL,'USR-Event-Id','Pkt-Bus-Session-Lost',NULL,'USR',NULL,NULL,NULL,NULL),
                                (971,NULL,'USR-Event-Id','Pkt-Bus-Session-Inactive',NULL,'USR',NULL,NULL,NULL,NULL),
                                (972,NULL,'USR-Event-Id','User-Interface-Reset',NULL,'USR',NULL,NULL,NULL,NULL),
                                (973,NULL,'USR-Event-Id','Gateway-Port-Out-of-Service',NULL,'USR',NULL,NULL,NULL,NULL),
                                (974,NULL,'USR-Event-Id','Gateway-Port-Link-Active',NULL,'USR',NULL,NULL,NULL,NULL),
                                (975,NULL,'USR-Event-Id','Dial-Out-Login-Failure',NULL,'USR',NULL,NULL,NULL,NULL),
                                (976,NULL,'USR-Event-Id','Dial-In-Login-Failure',NULL,'USR',NULL,NULL,NULL,NULL),
                                (977,NULL,'USR-Event-Id','Dial-Out-Restricted-Number',NULL,'USR',NULL,NULL,NULL,NULL),
                                (978,NULL,'USR-Event-Id','Dial-Back-Restricted-Number',NULL,'USR',NULL,NULL,NULL,NULL),
                                (979,NULL,'USR-Event-Id','User-Blacklisted',NULL,'USR',NULL,NULL,NULL,NULL),
                                (980,NULL,'USR-Event-Id','Attempted-Login-Blacklisted',NULL,'USR',NULL,NULL,NULL,NULL),
                                (981,NULL,'USR-Event-Id','Response-Attempt-Limit-Exceeded',NULL,'USR',NULL,NULL,NULL,NULL),
                                (982,NULL,'USR-Event-Id','Login-Attempt-Limit-Exceeded',NULL,'USR',NULL,NULL,NULL,NULL),
                                (983,NULL,'USR-Event-Id','Dial-Out-Call-Duration',NULL,'USR',NULL,NULL,NULL,NULL),
                                (984,NULL,'USR-Event-Id','Dial-In-Call-Duration',NULL,'USR',NULL,NULL,NULL,NULL),
                                (985,NULL,'USR-Event-Id','Pkt-Bus-Session-Err-Status',NULL,'USR',NULL,NULL,NULL,NULL),
                                (986,NULL,'USR-Event-Id','NMC-AutoRespnse-Trap',NULL,'USR',NULL,NULL,NULL,NULL),
                                (987,NULL,'USR-Event-Id','Acct-Server-Contact-Loss',NULL,'USR',NULL,NULL,NULL,NULL),
                                (988,NULL,'USR-Event-Id','Yellow-Alarm-Clear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (989,NULL,'USR-Event-Id','Red-Alarm-Clear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (990,NULL,'USR-Event-Id','Loss-Of-Signal-Clear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (991,NULL,'USR-Event-Id','Rcv-Alrm-Ind-Signal-Clear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (992,NULL,'USR-Event-Id','Incoming-Connection-Established',NULL,'USR',NULL,NULL,NULL,NULL),
                                (993,NULL,'USR-Event-Id','Outgoing-Connection-Established',NULL,'USR',NULL,NULL,NULL,NULL),
                                (994,NULL,'USR-Event-Id','Incoming-Connection-Terminated',NULL,'USR',NULL,NULL,NULL,NULL),
                                (995,NULL,'USR-Event-Id','Outgoing-Connection-Terminated',NULL,'USR',NULL,NULL,NULL,NULL),
                                (996,NULL,'USR-Event-Id','Connection-Attempt-Failure',NULL,'USR',NULL,NULL,NULL,NULL),
                                (997,NULL,'USR-Event-Id','Continuous-CRC-Alarm',NULL,'USR',NULL,NULL,NULL,NULL),
                                (998,NULL,'USR-Event-Id','Continuous-CRC-Alarm-Clear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (999,NULL,'USR-Event-Id','Physical-State-Change',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1000,NULL,'USR-Event-Id','Gateway-Network-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1001,NULL,'USR-Event-Id','Gateway-Network-Restored',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1002,NULL,'USR-Event-Id','Packet-Bus-Clock-Lost',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1003,NULL,'USR-Event-Id','Packet-Bus-Clock-Restored',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1004,NULL,'USR-Event-Id','D-Channel-In-Service',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1005,NULL,'USR-Event-Id','D-Channel-Out-of-Service',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1006,NULL,'USR-Event-Id','DS0s-In-Service',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1007,NULL,'USR-Event-Id','DS0s-Out-of-Service',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1008,NULL,'USR-Event-Id','T1/T1PRI/E1PRI-Call-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1009,NULL,'USR-Event-Id','Psu-Incompatible',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1010,NULL,'USR-Event-Id','T1,T1-E1/PRI-Call-Arrive-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1011,NULL,'USR-Event-Id','T1,T1-E1/PRI-Call-Connect-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1012,NULL,'USR-Event-Id','T1,T1-E1/PRI-Call-Termina-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1013,NULL,'USR-Event-Id','T1,T1-E1/PRI-Call-Failed-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1014,NULL,'USR-Event-Id','DNS-Contact-Lost',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1015,NULL,'USR-Event-Id','NTP-Contact-Lost',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1016,NULL,'USR-Event-Id','NTP-Contact-Restored',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1017,NULL,'USR-Event-Id','IPGW-Link-Up',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1018,NULL,'USR-Event-Id','IPGW-Link-Down',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1019,NULL,'USR-Event-Id','NTP-Contact-Degraded',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1020,NULL,'USR-Event-Id','In-Connection-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1021,NULL,'USR-Event-Id','Out-Connection-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1022,NULL,'USR-Event-Id','Application-ProcessorReset',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1023,NULL,'USR-Event-Id','DSP-Reset',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1024,NULL,'USR-Event-Id','Changed-to-Maint-Srvs-State',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1025,NULL,'USR-Event-Id','Loop-Back-cleared-on-channel',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1026,NULL,'USR-Event-Id','Loop-Back-on-channel',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1027,NULL,'USR-Event-Id','Telco-Abnormal-Response',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1028,NULL,'USR-Event-Id','DNS-Contact-Restored',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1029,NULL,'USR-Event-Id','DNS-Contact-Degraded',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1030,NULL,'USR-Event-Id','RADIUS-Accounting-Restored',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1031,NULL,'USR-Event-Id','RADIUS-Accounting-Group-Restore',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1032,NULL,'USR-Event-Id','RADIUS-Accounting-Group-Degrade',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1033,NULL,'USR-Event-Id','RADIUS-Accounting-Group-NonOper',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1034,NULL,'USR-Event-Id','T1/T1-E1/PRI-InCall-Fail-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1035,NULL,'USR-Event-Id','T1/T1-E1/PRI-OutCall-Fail-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1036,NULL,'USR-Event-Id','RMMIE-Retrain-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1037,NULL,'USR-Event-Id','RMMIE-Speed-Shift-Event',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1038,NULL,'USR-Event-Id','CDMA-Call-Start',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1039,NULL,'USR-Event-Id','CDMA-Call-End',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1040,NULL,'USR-Card-Type','SlotEmpty',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1041,NULL,'USR-Card-Type','SlotUnknown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1042,NULL,'USR-Card-Type','NetwMgtCard',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1043,NULL,'USR-Card-Type','DualT1NAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1044,NULL,'USR-Card-Type','DualModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1045,NULL,'USR-Card-Type','QuadModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1046,NULL,'USR-Card-Type','TrGatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1047,NULL,'USR-Card-Type','X25GatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1048,NULL,'USR-Card-Type','DualV34ModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1049,NULL,'USR-Card-Type','QuadV32DigitalModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1050,NULL,'USR-Card-Type','QuadV32AnalogModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1051,NULL,'USR-Card-Type','QuadV32DigAnlModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1052,NULL,'USR-Card-Type','QuadV34DigModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1053,NULL,'USR-Card-Type','QuadV34AnlModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1054,NULL,'USR-Card-Type','QuadV34DigAnlModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1055,NULL,'USR-Card-Type','SingleT1NAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1056,NULL,'USR-Card-Type','EthernetGatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1057,NULL,'USR-Card-Type','AccessServer',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1058,NULL,'USR-Card-Type','486TrGatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1059,NULL,'USR-Card-Type','486EthernetGatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1060,NULL,'USR-Card-Type','DualRS232NAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1061,NULL,'USR-Card-Type','486X25GatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1062,NULL,'USR-Card-Type','ApplicationServerNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1063,NULL,'USR-Card-Type','ISDNGatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1064,NULL,'USR-Card-Type','ISDNpriT1NAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1065,NULL,'USR-Card-Type','ClkedNetMgtCard',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1066,NULL,'USR-Card-Type','ModemPoolManagementNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1067,NULL,'USR-Card-Type','ModemPoolNetserverNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1068,NULL,'USR-Card-Type','ModemPoolV34ModemNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1069,NULL,'USR-Card-Type','ModemPoolISDNNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1070,NULL,'USR-Card-Type','NTServerNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1071,NULL,'USR-Card-Type','QuadV34DigitalG2NAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1072,NULL,'USR-Card-Type','QuadV34AnalogG2NAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1073,NULL,'USR-Card-Type','QuadV34DigAnlgG2NAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1074,NULL,'USR-Card-Type','NETServerFrameRelayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1075,NULL,'USR-Card-Type','NETServerTokenRingNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1076,NULL,'USR-Card-Type','X2524ChannelNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1077,NULL,'USR-Card-Type','WirelessGatewayNac',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1078,NULL,'USR-Card-Type','EnhancedAccessServer',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1079,NULL,'USR-Card-Type','EnhancedISDNGatewayNAC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1080,NULL,'USR-Card-Type','DualT1NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1081,NULL,'USR-Card-Type','DualAlogMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1082,NULL,'USR-Card-Type','QuadDgtlMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1083,NULL,'USR-Card-Type','QuadAlogDgtlMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1084,NULL,'USR-Card-Type','TokenRingNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1085,NULL,'USR-Card-Type','SingleT1NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1086,NULL,'USR-Card-Type','EthernetNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1087,NULL,'USR-Card-Type','ShortHaulDualT1NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1088,NULL,'USR-Card-Type','DualAlogMgdIntlMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1089,NULL,'USR-Card-Type','X25NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1090,NULL,'USR-Card-Type','QuadAlogNonMgdMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1091,NULL,'USR-Card-Type','QuadAlogMgdIntlMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1092,NULL,'USR-Card-Type','QuadAlogNonMgdIntlMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1093,NULL,'USR-Card-Type','QuadLsdLiMgdMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1094,NULL,'USR-Card-Type','QuadLsdLiNonMgdMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1095,NULL,'USR-Card-Type','QuadLsdLiMgdIntlMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1096,NULL,'USR-Card-Type','QuadLsdLiNonMgdIntlMdmNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1097,NULL,'USR-Card-Type','HSEthernetWithV35NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1098,NULL,'USR-Card-Type','HSEthernetWithoutV35NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1099,NULL,'USR-Card-Type','DualHighSpeedV35NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1100,NULL,'USR-Card-Type','QuadV35RS232LowSpeedNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1101,NULL,'USR-Card-Type','DualE1NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1102,NULL,'USR-Card-Type','ShortHaulDualE1NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1103,NULL,'USR-Card-Type','BellcoreLongHaulDualT1NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1104,NULL,'USR-Card-Type','BellcoreShrtHaulDualT1NIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1105,NULL,'USR-Card-Type','SCSIEdgeServerNIC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1106,NULL,'USR-Default-DTE-Data-Rate','110-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1107,NULL,'USR-Default-DTE-Data-Rate','300-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1108,NULL,'USR-Default-DTE-Data-Rate','600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1109,NULL,'USR-Default-DTE-Data-Rate','1200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1110,NULL,'USR-Default-DTE-Data-Rate','2400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1111,NULL,'USR-Default-DTE-Data-Rate','4800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1112,NULL,'USR-Default-DTE-Data-Rate','7200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1113,NULL,'USR-Default-DTE-Data-Rate','9600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1114,NULL,'USR-Default-DTE-Data-Rate','12K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1115,NULL,'USR-Default-DTE-Data-Rate','14.4K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1116,NULL,'USR-Default-DTE-Data-Rate','16.8-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1117,NULL,'USR-Default-DTE-Data-Rate','19.2K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1118,NULL,'USR-Default-DTE-Data-Rate','38.4K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1119,NULL,'USR-Default-DTE-Data-Rate','75-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1120,NULL,'USR-Default-DTE-Data-Rate','450-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1121,NULL,'USR-Default-DTE-Data-Rate','UNKNOWN-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1122,NULL,'USR-Default-DTE-Data-Rate','57.6K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1123,NULL,'USR-Default-DTE-Data-Rate','21.6K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1124,NULL,'USR-Default-DTE-Data-Rate','24K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1125,NULL,'USR-Default-DTE-Data-Rate','26K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1126,NULL,'USR-Default-DTE-Data-Rate','28K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1127,NULL,'USR-Default-DTE-Data-Rate','115K-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1128,NULL,'USR-Initial-Rx-Link-Data-Rate','110-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1129,NULL,'USR-Initial-Rx-Link-Data-Rate','300-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1130,NULL,'USR-Initial-Rx-Link-Data-Rate','600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1131,NULL,'USR-Initial-Rx-Link-Data-Rate','1200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1132,NULL,'USR-Initial-Rx-Link-Data-Rate','2400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1133,NULL,'USR-Initial-Rx-Link-Data-Rate','4800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1134,NULL,'USR-Initial-Rx-Link-Data-Rate','7200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1135,NULL,'USR-Initial-Rx-Link-Data-Rate','9600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1136,NULL,'USR-Initial-Rx-Link-Data-Rate','12000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1137,NULL,'USR-Initial-Rx-Link-Data-Rate','14400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1138,NULL,'USR-Initial-Rx-Link-Data-Rate','16800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1139,NULL,'USR-Initial-Rx-Link-Data-Rate','19200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1140,NULL,'USR-Initial-Rx-Link-Data-Rate','38400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1141,NULL,'USR-Initial-Rx-Link-Data-Rate','75-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1142,NULL,'USR-Initial-Rx-Link-Data-Rate','450-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1143,NULL,'USR-Initial-Rx-Link-Data-Rate','UNKNOWN-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1144,NULL,'USR-Initial-Rx-Link-Data-Rate','57600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1145,NULL,'USR-Initial-Rx-Link-Data-Rate','21600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1146,NULL,'USR-Initial-Rx-Link-Data-Rate','24000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1147,NULL,'USR-Initial-Rx-Link-Data-Rate','26400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1148,NULL,'USR-Initial-Rx-Link-Data-Rate','28800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1149,NULL,'USR-Initial-Rx-Link-Data-Rate','115200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1150,NULL,'USR-Initial-Rx-Link-Data-Rate','31200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1151,NULL,'USR-Initial-Rx-Link-Data-Rate','33600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1152,NULL,'USR-Initial-Rx-Link-Data-Rate','25333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1153,NULL,'USR-Initial-Rx-Link-Data-Rate','26666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1154,NULL,'USR-Initial-Rx-Link-Data-Rate','28000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1155,NULL,'USR-Initial-Rx-Link-Data-Rate','29333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1156,NULL,'USR-Initial-Rx-Link-Data-Rate','30666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1157,NULL,'USR-Initial-Rx-Link-Data-Rate','32000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1158,NULL,'USR-Initial-Rx-Link-Data-Rate','33333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1159,NULL,'USR-Initial-Rx-Link-Data-Rate','34666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1160,NULL,'USR-Initial-Rx-Link-Data-Rate','36000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1161,NULL,'USR-Initial-Rx-Link-Data-Rate','37333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1162,NULL,'USR-Initial-Rx-Link-Data-Rate','38666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1163,NULL,'USR-Initial-Rx-Link-Data-Rate','40000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1164,NULL,'USR-Initial-Rx-Link-Data-Rate','41333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1165,NULL,'USR-Initial-Rx-Link-Data-Rate','42666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1166,NULL,'USR-Initial-Rx-Link-Data-Rate','44000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1167,NULL,'USR-Initial-Rx-Link-Data-Rate','45333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1168,NULL,'USR-Initial-Rx-Link-Data-Rate','46666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1169,NULL,'USR-Initial-Rx-Link-Data-Rate','48000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1170,NULL,'USR-Initial-Rx-Link-Data-Rate','49333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1171,NULL,'USR-Initial-Rx-Link-Data-Rate','50666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1172,NULL,'USR-Initial-Rx-Link-Data-Rate','52000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1173,NULL,'USR-Initial-Rx-Link-Data-Rate','53333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1174,NULL,'USR-Initial-Rx-Link-Data-Rate','54666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1175,NULL,'USR-Initial-Rx-Link-Data-Rate','56000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1176,NULL,'USR-Initial-Rx-Link-Data-Rate','57333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1177,NULL,'USR-Initial-Rx-Link-Data-Rate','58666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1178,NULL,'USR-Initial-Rx-Link-Data-Rate','60000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1179,NULL,'USR-Initial-Rx-Link-Data-Rate','61333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1180,NULL,'USR-Initial-Rx-Link-Data-Rate','62666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1181,NULL,'USR-Initial-Rx-Link-Data-Rate','64000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1182,NULL,'USR-Final-Rx-Link-Data-Rate','110-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1183,NULL,'USR-Final-Rx-Link-Data-Rate','300-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1184,NULL,'USR-Final-Rx-Link-Data-Rate','600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1185,NULL,'USR-Final-Rx-Link-Data-Rate','1200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1186,NULL,'USR-Final-Rx-Link-Data-Rate','2400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1187,NULL,'USR-Final-Rx-Link-Data-Rate','4800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1188,NULL,'USR-Final-Rx-Link-Data-Rate','7200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1189,NULL,'USR-Final-Rx-Link-Data-Rate','9600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1190,NULL,'USR-Final-Rx-Link-Data-Rate','12000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1191,NULL,'USR-Final-Rx-Link-Data-Rate','14400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1192,NULL,'USR-Final-Rx-Link-Data-Rate','16800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1193,NULL,'USR-Final-Rx-Link-Data-Rate','19200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1194,NULL,'USR-Final-Rx-Link-Data-Rate','38400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1195,NULL,'USR-Final-Rx-Link-Data-Rate','75-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1196,NULL,'USR-Final-Rx-Link-Data-Rate','450-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1197,NULL,'USR-Final-Rx-Link-Data-Rate','UNKNOWN-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1198,NULL,'USR-Final-Rx-Link-Data-Rate','57600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1199,NULL,'USR-Final-Rx-Link-Data-Rate','21600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1200,NULL,'USR-Final-Rx-Link-Data-Rate','24000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1201,NULL,'USR-Final-Rx-Link-Data-Rate','26400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1202,NULL,'USR-Final-Rx-Link-Data-Rate','28800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1203,NULL,'USR-Final-Rx-Link-Data-Rate','115200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1204,NULL,'USR-Final-Rx-Link-Data-Rate','31200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1205,NULL,'USR-Final-Rx-Link-Data-Rate','33600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1206,NULL,'USR-Final-Rx-Link-Data-Rate','25333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1207,NULL,'USR-Final-Rx-Link-Data-Rate','26666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1208,NULL,'USR-Final-Rx-Link-Data-Rate','28000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1209,NULL,'USR-Final-Rx-Link-Data-Rate','29333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1210,NULL,'USR-Final-Rx-Link-Data-Rate','30666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1211,NULL,'USR-Final-Rx-Link-Data-Rate','32000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1212,NULL,'USR-Final-Rx-Link-Data-Rate','33333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1213,NULL,'USR-Final-Rx-Link-Data-Rate','34666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1214,NULL,'USR-Final-Rx-Link-Data-Rate','36000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1215,NULL,'USR-Final-Rx-Link-Data-Rate','37333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1216,NULL,'USR-Final-Rx-Link-Data-Rate','38666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1217,NULL,'USR-Final-Rx-Link-Data-Rate','40000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1218,NULL,'USR-Final-Rx-Link-Data-Rate','41333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1219,NULL,'USR-Final-Rx-Link-Data-Rate','42666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1220,NULL,'USR-Final-Rx-Link-Data-Rate','44000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1221,NULL,'USR-Final-Rx-Link-Data-Rate','45333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1222,NULL,'USR-Final-Rx-Link-Data-Rate','46666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1223,NULL,'USR-Final-Rx-Link-Data-Rate','48000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1224,NULL,'USR-Final-Rx-Link-Data-Rate','49333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1225,NULL,'USR-Final-Rx-Link-Data-Rate','50666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1226,NULL,'USR-Final-Rx-Link-Data-Rate','52000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1227,NULL,'USR-Final-Rx-Link-Data-Rate','53333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1228,NULL,'USR-Final-Rx-Link-Data-Rate','54666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1229,NULL,'USR-Final-Rx-Link-Data-Rate','56000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1230,NULL,'USR-Final-Rx-Link-Data-Rate','57333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1231,NULL,'USR-Final-Rx-Link-Data-Rate','58666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1232,NULL,'USR-Final-Rx-Link-Data-Rate','60000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1233,NULL,'USR-Final-Rx-Link-Data-Rate','61333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1234,NULL,'USR-Final-Rx-Link-Data-Rate','62666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1235,NULL,'USR-Final-Rx-Link-Data-Rate','64000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1236,NULL,'USR-Initial-Tx-Link-Data-Rate','110-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1237,NULL,'USR-Initial-Tx-Link-Data-Rate','300-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1238,NULL,'USR-Initial-Tx-Link-Data-Rate','600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1239,NULL,'USR-Initial-Tx-Link-Data-Rate','1200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1240,NULL,'USR-Initial-Tx-Link-Data-Rate','2400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1241,NULL,'USR-Initial-Tx-Link-Data-Rate','4800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1242,NULL,'USR-Initial-Tx-Link-Data-Rate','7200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1243,NULL,'USR-Initial-Tx-Link-Data-Rate','9600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1244,NULL,'USR-Initial-Tx-Link-Data-Rate','12000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1245,NULL,'USR-Initial-Tx-Link-Data-Rate','14400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1246,NULL,'USR-Initial-Tx-Link-Data-Rate','16800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1247,NULL,'USR-Initial-Tx-Link-Data-Rate','19200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1248,NULL,'USR-Initial-Tx-Link-Data-Rate','38400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1249,NULL,'USR-Initial-Tx-Link-Data-Rate','75-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1250,NULL,'USR-Initial-Tx-Link-Data-Rate','450-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1251,NULL,'USR-Initial-Tx-Link-Data-Rate','UNKNOWN-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1252,NULL,'USR-Initial-Tx-Link-Data-Rate','57600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1253,NULL,'USR-Initial-Tx-Link-Data-Rate','21600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1254,NULL,'USR-Initial-Tx-Link-Data-Rate','24000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1255,NULL,'USR-Initial-Tx-Link-Data-Rate','26400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1256,NULL,'USR-Initial-Tx-Link-Data-Rate','28800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1257,NULL,'USR-Initial-Tx-Link-Data-Rate','115200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1258,NULL,'USR-Initial-Tx-Link-Data-Rate','31200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1259,NULL,'USR-Initial-Tx-Link-Data-Rate','33600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1260,NULL,'USR-Initial-Tx-Link-Data-Rate','25333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1261,NULL,'USR-Initial-Tx-Link-Data-Rate','26666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1262,NULL,'USR-Initial-Tx-Link-Data-Rate','28000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1263,NULL,'USR-Initial-Tx-Link-Data-Rate','29333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1264,NULL,'USR-Initial-Tx-Link-Data-Rate','30666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1265,NULL,'USR-Initial-Tx-Link-Data-Rate','32000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1266,NULL,'USR-Initial-Tx-Link-Data-Rate','33333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1267,NULL,'USR-Initial-Tx-Link-Data-Rate','34666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1268,NULL,'USR-Initial-Tx-Link-Data-Rate','36000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1269,NULL,'USR-Initial-Tx-Link-Data-Rate','37333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1270,NULL,'USR-Initial-Tx-Link-Data-Rate','38666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1271,NULL,'USR-Initial-Tx-Link-Data-Rate','40000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1272,NULL,'USR-Initial-Tx-Link-Data-Rate','41333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1273,NULL,'USR-Initial-Tx-Link-Data-Rate','42666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1274,NULL,'USR-Initial-Tx-Link-Data-Rate','44000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1275,NULL,'USR-Initial-Tx-Link-Data-Rate','45333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1276,NULL,'USR-Initial-Tx-Link-Data-Rate','46666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1277,NULL,'USR-Initial-Tx-Link-Data-Rate','48000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1278,NULL,'USR-Initial-Tx-Link-Data-Rate','49333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1279,NULL,'USR-Initial-Tx-Link-Data-Rate','50666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1280,NULL,'USR-Initial-Tx-Link-Data-Rate','52000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1281,NULL,'USR-Initial-Tx-Link-Data-Rate','53333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1282,NULL,'USR-Initial-Tx-Link-Data-Rate','54666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1283,NULL,'USR-Initial-Tx-Link-Data-Rate','56000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1284,NULL,'USR-Initial-Tx-Link-Data-Rate','57333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1285,NULL,'USR-Initial-Tx-Link-Data-Rate','58666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1286,NULL,'USR-Initial-Tx-Link-Data-Rate','60000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1287,NULL,'USR-Initial-Tx-Link-Data-Rate','61333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1288,NULL,'USR-Initial-Tx-Link-Data-Rate','62666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1289,NULL,'USR-Initial-Tx-Link-Data-Rate','64000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1290,NULL,'USR-Final-Tx-Link-Data-Rate','110-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1291,NULL,'USR-Final-Tx-Link-Data-Rate','300-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1292,NULL,'USR-Final-Tx-Link-Data-Rate','600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1293,NULL,'USR-Final-Tx-Link-Data-Rate','1200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1294,NULL,'USR-Final-Tx-Link-Data-Rate','2400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1295,NULL,'USR-Final-Tx-Link-Data-Rate','4800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1296,NULL,'USR-Final-Tx-Link-Data-Rate','7200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1297,NULL,'USR-Final-Tx-Link-Data-Rate','9600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1298,NULL,'USR-Final-Tx-Link-Data-Rate','12000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1299,NULL,'USR-Final-Tx-Link-Data-Rate','14400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1300,NULL,'USR-Final-Tx-Link-Data-Rate','16800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1301,NULL,'USR-Final-Tx-Link-Data-Rate','19200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1302,NULL,'USR-Final-Tx-Link-Data-Rate','38400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1303,NULL,'USR-Final-Tx-Link-Data-Rate','75-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1304,NULL,'USR-Final-Tx-Link-Data-Rate','450-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1305,NULL,'USR-Final-Tx-Link-Data-Rate','UNKNOWN-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1306,NULL,'USR-Final-Tx-Link-Data-Rate','57600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1307,NULL,'USR-Final-Tx-Link-Data-Rate','21600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1308,NULL,'USR-Final-Tx-Link-Data-Rate','24000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1309,NULL,'USR-Final-Tx-Link-Data-Rate','26400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1310,NULL,'USR-Final-Tx-Link-Data-Rate','28800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1311,NULL,'USR-Final-Tx-Link-Data-Rate','115200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1312,NULL,'USR-Final-Tx-Link-Data-Rate','31200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1313,NULL,'USR-Final-Tx-Link-Data-Rate','33600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1314,NULL,'USR-Final-Tx-Link-Data-Rate','25333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1315,NULL,'USR-Final-Tx-Link-Data-Rate','26666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1316,NULL,'USR-Final-Tx-Link-Data-Rate','28000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1317,NULL,'USR-Final-Tx-Link-Data-Rate','29333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1318,NULL,'USR-Final-Tx-Link-Data-Rate','30666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1319,NULL,'USR-Final-Tx-Link-Data-Rate','32000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1320,NULL,'USR-Final-Tx-Link-Data-Rate','33333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1321,NULL,'USR-Final-Tx-Link-Data-Rate','34666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1322,NULL,'USR-Final-Tx-Link-Data-Rate','36000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1323,NULL,'USR-Final-Tx-Link-Data-Rate','37333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1324,NULL,'USR-Final-Tx-Link-Data-Rate','38666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1325,NULL,'USR-Final-Tx-Link-Data-Rate','40000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1326,NULL,'USR-Final-Tx-Link-Data-Rate','41333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1327,NULL,'USR-Final-Tx-Link-Data-Rate','42666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1328,NULL,'USR-Final-Tx-Link-Data-Rate','44000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1329,NULL,'USR-Final-Tx-Link-Data-Rate','45333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1330,NULL,'USR-Final-Tx-Link-Data-Rate','46666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1331,NULL,'USR-Final-Tx-Link-Data-Rate','48000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1332,NULL,'USR-Final-Tx-Link-Data-Rate','49333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1333,NULL,'USR-Final-Tx-Link-Data-Rate','50666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1334,NULL,'USR-Final-Tx-Link-Data-Rate','52000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1335,NULL,'USR-Final-Tx-Link-Data-Rate','53333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1336,NULL,'USR-Final-Tx-Link-Data-Rate','54666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1337,NULL,'USR-Final-Tx-Link-Data-Rate','56000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1338,NULL,'USR-Final-Tx-Link-Data-Rate','57333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1339,NULL,'USR-Final-Tx-Link-Data-Rate','58666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1340,NULL,'USR-Final-Tx-Link-Data-Rate','60000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1341,NULL,'USR-Final-Tx-Link-Data-Rate','61333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1342,NULL,'USR-Final-Tx-Link-Data-Rate','62666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1343,NULL,'USR-Final-Tx-Link-Data-Rate','64000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1344,NULL,'USR-Connect-Speed','NONE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1345,NULL,'USR-Connect-Speed','300-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1346,NULL,'USR-Connect-Speed','1200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1347,NULL,'USR-Connect-Speed','2400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1348,NULL,'USR-Connect-Speed','4800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1349,NULL,'USR-Connect-Speed','7200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1350,NULL,'USR-Connect-Speed','9600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1351,NULL,'USR-Connect-Speed','12000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1352,NULL,'USR-Connect-Speed','14400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1353,NULL,'USR-Connect-Speed','16800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1354,NULL,'USR-Connect-Speed','19200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1355,NULL,'USR-Connect-Speed','21600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1356,NULL,'USR-Connect-Speed','28800-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1357,NULL,'USR-Connect-Speed','38400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1358,NULL,'USR-Connect-Speed','57600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1359,NULL,'USR-Connect-Speed','115200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1360,NULL,'USR-Connect-Speed','288000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1361,NULL,'USR-Connect-Speed','75-1200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1362,NULL,'USR-Connect-Speed','1200-75-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1363,NULL,'USR-Connect-Speed','24000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1364,NULL,'USR-Connect-Speed','26400-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1365,NULL,'USR-Connect-Speed','31200-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1366,NULL,'USR-Connect-Speed','33600-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1367,NULL,'USR-Connect-Speed','33333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1368,NULL,'USR-Connect-Speed','37333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1369,NULL,'USR-Connect-Speed','41333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1370,NULL,'USR-Connect-Speed','42666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1371,NULL,'USR-Connect-Speed','44000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1372,NULL,'USR-Connect-Speed','45333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1373,NULL,'USR-Connect-Speed','46666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1374,NULL,'USR-Connect-Speed','48000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1375,NULL,'USR-Connect-Speed','49333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1376,NULL,'USR-Connect-Speed','50666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1377,NULL,'USR-Connect-Speed','52000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1378,NULL,'USR-Connect-Speed','53333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1379,NULL,'USR-Connect-Speed','54666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1380,NULL,'USR-Connect-Speed','56000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1381,NULL,'USR-Connect-Speed','57333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1382,NULL,'USR-Connect-Speed','64000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1383,NULL,'USR-Connect-Speed','25333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1384,NULL,'USR-Connect-Speed','26666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1385,NULL,'USR-Connect-Speed','28000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1386,NULL,'USR-Connect-Speed','29333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1387,NULL,'USR-Connect-Speed','30666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1388,NULL,'USR-Connect-Speed','32000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1389,NULL,'USR-Connect-Speed','34666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1390,NULL,'USR-Connect-Speed','36000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1391,NULL,'USR-Connect-Speed','38666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1392,NULL,'USR-Connect-Speed','40000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1393,NULL,'USR-Connect-Speed','58666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1394,NULL,'USR-Connect-Speed','60000-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1395,NULL,'USR-Connect-Speed','61333-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1396,NULL,'USR-Connect-Speed','62666-BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1397,NULL,'USR-Sync-Async-Mode','Asynchronous',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1398,NULL,'USR-Sync-Async-Mode','Synchronous',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1399,NULL,'USR-Originate-Answer-Mode','Originate_in_Originate_Mode',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1400,NULL,'USR-Originate-Answer-Mode','Originate_in_Answer_Mode',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1401,NULL,'USR-Originate-Answer-Mode','Answer_in_Originate_Mode',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1402,NULL,'USR-Originate-Answer-Mode','Answer_in_Answer_Mode',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1403,NULL,'USR-Modulation-Type','usRoboticsHST',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1404,NULL,'USR-Modulation-Type','ccittV32',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1405,NULL,'USR-Modulation-Type','ccittV22bis',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1406,NULL,'USR-Modulation-Type','bell103',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1407,NULL,'USR-Modulation-Type','ccittV21',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1408,NULL,'USR-Modulation-Type','bell212',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1409,NULL,'USR-Modulation-Type','ccittV32bis',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1410,NULL,'USR-Modulation-Type','ccittV23',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1411,NULL,'USR-Modulation-Type','negotiationFailed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1412,NULL,'USR-Modulation-Type','bell208b',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1413,NULL,'USR-Modulation-Type','v21FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1414,NULL,'USR-Modulation-Type','v27FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1415,NULL,'USR-Modulation-Type','v29FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1416,NULL,'USR-Modulation-Type','v17FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1417,NULL,'USR-Modulation-Type','v21FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1418,NULL,'USR-Modulation-Type','v27FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1419,NULL,'USR-Modulation-Type','v29FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1420,NULL,'USR-Modulation-Type','v17FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1421,NULL,'USR-Modulation-Type','v32Terbo',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1422,NULL,'USR-Modulation-Type','v34',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1423,NULL,'USR-Modulation-Type','vFC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1424,NULL,'USR-Modulation-Type','v34plus',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1425,NULL,'USR-Modulation-Type','x2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1426,NULL,'USR-Modulation-Type','v110',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1427,NULL,'USR-Modulation-Type','v120',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1428,NULL,'USR-Modulation-Type','x75',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1429,NULL,'USR-Modulation-Type','asyncSyncPPP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1430,NULL,'USR-Modulation-Type','clearChannel',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1431,NULL,'USR-Modulation-Type','x2client',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1432,NULL,'USR-Modulation-Type','x2symmetric',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1433,NULL,'USR-Modulation-Type','piafs',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1434,NULL,'USR-Modulation-Type','x2version2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1435,NULL,'USR-Modulation-Type','v90Analog',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1436,NULL,'USR-Modulation-Type','v90Digital',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1437,NULL,'USR-Modulation-Type','v90AllDigital',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1438,NULL,'Initial-Modulation-Type','usRoboticsHST',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1439,NULL,'Initial-Modulation-Type','ccittV32',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1440,NULL,'Initial-Modulation-Type','ccittV22bis',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1441,NULL,'Initial-Modulation-Type','bell103',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1442,NULL,'Initial-Modulation-Type','ccittV21',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1443,NULL,'Initial-Modulation-Type','bell212',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1444,NULL,'Initial-Modulation-Type','ccittV32bis',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1445,NULL,'Initial-Modulation-Type','ccittV23',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1446,NULL,'Initial-Modulation-Type','negotiationFailed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1447,NULL,'Initial-Modulation-Type','bell208b',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1448,NULL,'Initial-Modulation-Type','v21FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1449,NULL,'Initial-Modulation-Type','v27FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1450,NULL,'Initial-Modulation-Type','v29FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1451,NULL,'Initial-Modulation-Type','v17FaxClass1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1452,NULL,'Initial-Modulation-Type','v21FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1453,NULL,'Initial-Modulation-Type','v27FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1454,NULL,'Initial-Modulation-Type','v29FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1455,NULL,'Initial-Modulation-Type','v17FaxClass2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1456,NULL,'Initial-Modulation-Type','v32Terbo',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1457,NULL,'Initial-Modulation-Type','v34',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1458,NULL,'Initial-Modulation-Type','vFC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1459,NULL,'Initial-Modulation-Type','v34plus',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1460,NULL,'Initial-Modulation-Type','x2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1461,NULL,'Initial-Modulation-Type','v110',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1462,NULL,'Initial-Modulation-Type','v120',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1463,NULL,'Initial-Modulation-Type','x75',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1464,NULL,'Initial-Modulation-Type','asyncSyncPPP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1465,NULL,'Initial-Modulation-Type','clearChannel',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1466,NULL,'Initial-Modulation-Type','x2client',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1467,NULL,'Initial-Modulation-Type','x2symmetric',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1468,NULL,'Initial-Modulation-Type','piafs',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1469,NULL,'Initial-Modulation-Type','x2version2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1470,NULL,'Initial-Modulation-Type','v90Analogue',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1471,NULL,'Initial-Modulation-Type','v90Digital',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1472,NULL,'Initial-Modulation-Type','v90AllDigital',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1473,NULL,'USR-Connect-Term-Reason','dtrDrop',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1474,NULL,'USR-Connect-Term-Reason','escapeSequence',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1475,NULL,'USR-Connect-Term-Reason','athCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1476,NULL,'USR-Connect-Term-Reason','carrierLoss',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1477,NULL,'USR-Connect-Term-Reason','inactivityTimout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1478,NULL,'USR-Connect-Term-Reason','mnpIncompatible',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1479,NULL,'USR-Connect-Term-Reason','undefined',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1480,NULL,'USR-Connect-Term-Reason','remotePassword',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1481,NULL,'USR-Connect-Term-Reason','linkPassword',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1482,NULL,'USR-Connect-Term-Reason','retransmitLimit',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1483,NULL,'USR-Connect-Term-Reason','linkDisconnectMsgReceived',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1484,NULL,'USR-Connect-Term-Reason','noLoopCurrent',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1485,NULL,'USR-Connect-Term-Reason','invalidSpeed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1486,NULL,'USR-Connect-Term-Reason','unableToRetrain',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1487,NULL,'USR-Connect-Term-Reason','managementCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1488,NULL,'USR-Connect-Term-Reason','noDialTone',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1489,NULL,'USR-Connect-Term-Reason','keyAbort',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1490,NULL,'USR-Connect-Term-Reason','lineBusy',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1491,NULL,'USR-Connect-Term-Reason','noAnswer',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1492,NULL,'USR-Connect-Term-Reason','voice',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1493,NULL,'USR-Connect-Term-Reason','noAnswerTone',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1494,NULL,'USR-Connect-Term-Reason','noCarrier',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1495,NULL,'USR-Connect-Term-Reason','undetermined',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1496,NULL,'USR-Connect-Term-Reason','v42SabmeTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1497,NULL,'USR-Connect-Term-Reason','v42BreakTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1498,NULL,'USR-Connect-Term-Reason','v42DisconnectCmd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1499,NULL,'USR-Connect-Term-Reason','v42IdExchangeFail',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1500,NULL,'USR-Connect-Term-Reason','v42BadSetup',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1501,NULL,'USR-Connect-Term-Reason','v42InvalidCodeWord',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1502,NULL,'USR-Connect-Term-Reason','v42StringToLong',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1503,NULL,'USR-Connect-Term-Reason','v42InvalidCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1504,NULL,'USR-Connect-Term-Reason','none',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1505,NULL,'USR-Connect-Term-Reason','v32Cleardown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1506,NULL,'USR-Connect-Term-Reason','dialSecurity',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1507,NULL,'USR-Connect-Term-Reason','remoteAccessDenied',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1508,NULL,'USR-Connect-Term-Reason','loopLoss',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1509,NULL,'USR-Connect-Term-Reason','ds0Teardown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1510,NULL,'USR-Connect-Term-Reason','promptNotEnabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1511,NULL,'USR-Connect-Term-Reason','noPromptingInSync',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1512,NULL,'USR-Connect-Term-Reason','nonArqMode',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1513,NULL,'USR-Connect-Term-Reason','modeIncompatible',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1514,NULL,'USR-Connect-Term-Reason','noPromptInNonARQ',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1515,NULL,'USR-Connect-Term-Reason','dialBackLink',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1516,NULL,'USR-Connect-Term-Reason','linkAbort',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1517,NULL,'USR-Connect-Term-Reason','autopassFailed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1518,NULL,'USR-Connect-Term-Reason','pbGenericError',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1519,NULL,'USR-Connect-Term-Reason','pbLinkErrTxPreAck',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1520,NULL,'USR-Connect-Term-Reason','pbLinkErrTxTardyACK',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1521,NULL,'USR-Connect-Term-Reason','pbTransmitBusTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1522,NULL,'USR-Connect-Term-Reason','pbReceiveBusTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1523,NULL,'USR-Connect-Term-Reason','pbLinkErrTxTAL',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1524,NULL,'USR-Connect-Term-Reason','pbLinkErrRxTAL',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1525,NULL,'USR-Connect-Term-Reason','pbTransmitMasterTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1526,NULL,'USR-Connect-Term-Reason','pbClockMissing',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1527,NULL,'USR-Connect-Term-Reason','pbReceivedLsWhileLinkUp',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1528,NULL,'USR-Connect-Term-Reason','pbOutOfSequenceFrame',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1529,NULL,'USR-Connect-Term-Reason','pbBadFrame',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1530,NULL,'USR-Connect-Term-Reason','pbAckWaitTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1531,NULL,'USR-Connect-Term-Reason','pbReceivedAckSeqErr',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1532,NULL,'USR-Connect-Term-Reason','pbReceiveOvrflwRNRFail',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1533,NULL,'USR-Connect-Term-Reason','pbReceiveMsgBufOvrflw',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1534,NULL,'USR-Connect-Term-Reason','rcvdGatewayDiscCmd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1535,NULL,'USR-Connect-Term-Reason','tokenPassingTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1536,NULL,'USR-Connect-Term-Reason','dspInterruptTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1537,NULL,'USR-Connect-Term-Reason','mnpProtocolViolation',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1538,NULL,'USR-Connect-Term-Reason','class2FaxHangupCmd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1539,NULL,'USR-Connect-Term-Reason','hstSpeedSwitchTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1540,NULL,'USR-Connect-Term-Reason','tooManyUnacked',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1541,NULL,'USR-Connect-Term-Reason','timerExpired',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1542,NULL,'USR-Connect-Term-Reason','t1Glare',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1543,NULL,'USR-Connect-Term-Reason','priDialoutRqTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1544,NULL,'USR-Connect-Term-Reason','abortAnlgDstOvrIsdn',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1545,NULL,'USR-Connect-Term-Reason','normalUserCallClear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1546,NULL,'USR-Connect-Term-Reason','normalUnspecified',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1547,NULL,'USR-Connect-Term-Reason','bearerIncompatibility',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1548,NULL,'USR-Connect-Term-Reason','protocolErrorEvent',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1549,NULL,'USR-Connect-Term-Reason','abnormalDisconnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1550,NULL,'USR-Connect-Term-Reason','invalidCauseValue',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1551,NULL,'USR-Connect-Term-Reason','resourceUnavailable',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1552,NULL,'USR-Connect-Term-Reason','remoteHungUpDuringTraining',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1553,NULL,'USR-Connect-Term-Reason','trainingTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1554,NULL,'USR-Connect-Term-Reason','incomingModemNotAvailable',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1555,NULL,'USR-Connect-Term-Reason','incomingInvalidBearerCap',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1556,NULL,'USR-Connect-Term-Reason','incomingInvalidChannelID',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1557,NULL,'USR-Connect-Term-Reason','incomingInvalidProgInd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1558,NULL,'USR-Connect-Term-Reason','incomingInvalidCallingPty',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1559,NULL,'USR-Connect-Term-Reason','incomingInvalidCalledPty',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1560,NULL,'USR-Connect-Term-Reason','incomingCallBlock',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1561,NULL,'USR-Connect-Term-Reason','incomingLoopStNoRingOff',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1562,NULL,'USR-Connect-Term-Reason','outgoingTelcoDisconnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1563,NULL,'USR-Connect-Term-Reason','outgoingEMWinkTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1564,NULL,'USR-Connect-Term-Reason','outgoingEMWinkTooShort',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1565,NULL,'USR-Connect-Term-Reason','outgoingNoChannelAvail',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1566,NULL,'USR-Connect-Term-Reason','dspReboot',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1567,NULL,'USR-Connect-Term-Reason','noDSPRespToKA',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1568,NULL,'USR-Connect-Term-Reason','noDSPRespToDisc',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1569,NULL,'USR-Connect-Term-Reason','dspTailPtrInvalid',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1570,NULL,'USR-Connect-Term-Reason','dspHeadPtrInvalid',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1571,NULL,'USR-Failure-to-Connect-Reason','dtrDrop',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1572,NULL,'USR-Failure-to-Connect-Reason','escapeSequence',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1573,NULL,'USR-Failure-to-Connect-Reason','athCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1574,NULL,'USR-Failure-to-Connect-Reason','carrierLoss',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1575,NULL,'USR-Failure-to-Connect-Reason','inactivityTimout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1576,NULL,'USR-Failure-to-Connect-Reason','mnpIncompatible',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1577,NULL,'USR-Failure-to-Connect-Reason','undefined',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1578,NULL,'USR-Failure-to-Connect-Reason','remotePassword',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1579,NULL,'USR-Failure-to-Connect-Reason','linkPassword',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1580,NULL,'USR-Failure-to-Connect-Reason','retransmitLimit',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1581,NULL,'USR-Failure-to-Connect-Reason','linkDisconnectMsgRec',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1582,NULL,'USR-Failure-to-Connect-Reason','noLoopCurrent',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1583,NULL,'USR-Failure-to-Connect-Reason','invalidSpeed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1584,NULL,'USR-Failure-to-Connect-Reason','unableToRetrain',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1585,NULL,'USR-Failure-to-Connect-Reason','managementCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1586,NULL,'USR-Failure-to-Connect-Reason','noDialTone',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1587,NULL,'USR-Failure-to-Connect-Reason','keyAbort',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1588,NULL,'USR-Failure-to-Connect-Reason','lineBusy',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1589,NULL,'USR-Failure-to-Connect-Reason','noAnswer',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1590,NULL,'USR-Failure-to-Connect-Reason','voice',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1591,NULL,'USR-Failure-to-Connect-Reason','noAnswerTone',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1592,NULL,'USR-Failure-to-Connect-Reason','noCarrier',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1593,NULL,'USR-Failure-to-Connect-Reason','undetermined',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1594,NULL,'USR-Failure-to-Connect-Reason','v42SabmeTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1595,NULL,'USR-Failure-to-Connect-Reason','v42BreakTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1596,NULL,'USR-Failure-to-Connect-Reason','v42DisconnectCmd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1597,NULL,'USR-Failure-to-Connect-Reason','v42IdExchangeFail',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1598,NULL,'USR-Failure-to-Connect-Reason','v42BadSetup',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1599,NULL,'USR-Failure-to-Connect-Reason','v42InvalidCodeWord',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1600,NULL,'USR-Failure-to-Connect-Reason','v42StringToLong',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1601,NULL,'USR-Failure-to-Connect-Reason','v42InvalidCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1602,NULL,'USR-Failure-to-Connect-Reason','none',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1603,NULL,'USR-Failure-to-Connect-Reason','v32Cleardown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1604,NULL,'USR-Failure-to-Connect-Reason','dialSecurity',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1605,NULL,'USR-Failure-to-Connect-Reason','remoteAccessDenied',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1606,NULL,'USR-Failure-to-Connect-Reason','loopLoss',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1607,NULL,'USR-Failure-to-Connect-Reason','ds0Teardown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1608,NULL,'USR-Failure-to-Connect-Reason','promptNotEnabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1609,NULL,'USR-Failure-to-Connect-Reason','noPromptingInSync',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1610,NULL,'USR-Failure-to-Connect-Reason','nonArqMode',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1611,NULL,'USR-Failure-to-Connect-Reason','modeIncompatible',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1612,NULL,'USR-Failure-to-Connect-Reason','noPromptInNonARQ',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1613,NULL,'USR-Failure-to-Connect-Reason','dialBackLink',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1614,NULL,'USR-Failure-to-Connect-Reason','linkAbort',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1615,NULL,'USR-Failure-to-Connect-Reason','autopassFailed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1616,NULL,'USR-Failure-to-Connect-Reason','pbGenericError',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1617,NULL,'USR-Failure-to-Connect-Reason','pbLinkErrTxPreAck',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1618,NULL,'USR-Failure-to-Connect-Reason','pbLinkErrTxTardyACK',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1619,NULL,'USR-Failure-to-Connect-Reason','pbTransmitBusTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1620,NULL,'USR-Failure-to-Connect-Reason','pbReceiveBusTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1621,NULL,'USR-Failure-to-Connect-Reason','pbLinkErrTxTAL',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1622,NULL,'USR-Failure-to-Connect-Reason','pbLinkErrRxTAL',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1623,NULL,'USR-Failure-to-Connect-Reason','pbTransmitMasterTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1624,NULL,'USR-Failure-to-Connect-Reason','pbClockMissing',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1625,NULL,'USR-Failure-to-Connect-Reason','pbReceivedLsWhileLinkUp',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1626,NULL,'USR-Failure-to-Connect-Reason','pbOutOfSequenceFrame',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1627,NULL,'USR-Failure-to-Connect-Reason','pbBadFrame',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1628,NULL,'USR-Failure-to-Connect-Reason','pbAckWaitTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1629,NULL,'USR-Failure-to-Connect-Reason','pbReceivedAckSeqErr',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1630,NULL,'USR-Failure-to-Connect-Reason','pbReceiveOvrflwRNRFail',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1631,NULL,'USR-Failure-to-Connect-Reason','pbReceiveMsgBufOvrflw',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1632,NULL,'USR-Failure-to-Connect-Reason','rcvdGatewayDiscCmd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1633,NULL,'USR-Failure-to-Connect-Reason','tokenPassingTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1634,NULL,'USR-Failure-to-Connect-Reason','dspInterruptTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1635,NULL,'USR-Failure-to-Connect-Reason','mnpProtocolViolation',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1636,NULL,'USR-Failure-to-Connect-Reason','class2FaxHangupCmd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1637,NULL,'USR-Failure-to-Connect-Reason','hstSpeedSwitchTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1638,NULL,'USR-Failure-to-Connect-Reason','tooManyUnacked',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1639,NULL,'USR-Failure-to-Connect-Reason','timerExpired',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1640,NULL,'USR-Failure-to-Connect-Reason','t1Glare',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1641,NULL,'USR-Failure-to-Connect-Reason','priDialoutRqTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1642,NULL,'USR-Failure-to-Connect-Reason','abortAnlgDstOvrIsdn',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1643,NULL,'USR-Failure-to-Connect-Reason','normalUserCallClear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1644,NULL,'USR-Failure-to-Connect-Reason','normalUnspecified',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1645,NULL,'USR-Failure-to-Connect-Reason','bearerIncompatibility',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1646,NULL,'USR-Failure-to-Connect-Reason','protocolErrorEvent',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1647,NULL,'USR-Failure-to-Connect-Reason','abnormalDisconnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1648,NULL,'USR-Failure-to-Connect-Reason','invalidCauseValue',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1649,NULL,'USR-Failure-to-Connect-Reason','resourceUnavailable',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1650,NULL,'USR-Failure-to-Connect-Reason','remoteHungUpDuringTraining',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1651,NULL,'USR-Failure-to-Connect-Reason','trainingTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1652,NULL,'USR-Failure-to-Connect-Reason','incomingModemNotAvailable',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1653,NULL,'USR-Failure-to-Connect-Reason','incomingInvalidBearerCap',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1654,NULL,'USR-Failure-to-Connect-Reason','incomingInvalidChannelID',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1655,NULL,'USR-Failure-to-Connect-Reason','incomingInvalidProgInd',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1656,NULL,'USR-Failure-to-Connect-Reason','incomingInvalidCallingPty',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1657,NULL,'USR-Failure-to-Connect-Reason','incomingInvalidCalledPty',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1658,NULL,'USR-Failure-to-Connect-Reason','incomingCallBlock',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1659,NULL,'USR-Failure-to-Connect-Reason','incomingLoopStNoRingOff',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1660,NULL,'USR-Failure-to-Connect-Reason','outgoingTelcoDisconnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1661,NULL,'USR-Failure-to-Connect-Reason','outgoingEMWinkTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1662,NULL,'USR-Failure-to-Connect-Reason','outgoingEMWinkTooShort',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1663,NULL,'USR-Failure-to-Connect-Reason','outgoingNoChannelAvail',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1664,NULL,'USR-Failure-to-Connect-Reason','dspReboot',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1665,NULL,'USR-Failure-to-Connect-Reason','noDSPRespToKA',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1666,NULL,'USR-Failure-to-Connect-Reason','noDSPRespToDisc',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1667,NULL,'USR-Failure-to-Connect-Reason','dspTailPtrInvalid',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1668,NULL,'USR-Failure-to-Connect-Reason','dspHeadPtrInvalid',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1669,NULL,'USR-Simplified-MNP-Levels','none',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1670,NULL,'USR-Simplified-MNP-Levels','mnpLevel3',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1671,NULL,'USR-Simplified-MNP-Levels','mnpLevel4',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1672,NULL,'USR-Simplified-MNP-Levels','ccittV42',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1673,NULL,'USR-Simplified-MNP-Levels','usRoboticsHST',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1674,NULL,'USR-Simplified-MNP-Levels','synchronousNone',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1675,NULL,'USR-Simplified-MNP-Levels','mnpLevel2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1676,NULL,'USR-Simplified-MNP-Levels','mnp10',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1677,NULL,'USR-Simplified-MNP-Levels','v42Etc',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1678,NULL,'USR-Simplified-MNP-Levels','mnp10Etc',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1679,NULL,'USR-Simplified-MNP-Levels','lapmEtc',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1680,NULL,'USR-Simplified-MNP-Levels','v42Etc2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1681,NULL,'USR-Simplified-MNP-Levels','v42SRej',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1682,NULL,'USR-Simplified-MNP-Levels','piafs',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1683,NULL,'USR-Simplified-V42bis-Usage','none',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1684,NULL,'USR-Simplified-V42bis-Usage','ccittV42bis',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1685,NULL,'USR-Simplified-V42bis-Usage','mnpLevel5',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1686,NULL,'USR-Equalization-Type','Long',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1687,NULL,'USR-Equalization-Type','Short',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1688,NULL,'USR-Fallback-Enabled','Disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1689,NULL,'USR-Fallback-Enabled','Enabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1690,NULL,'USR-Back-Channel-Data-Rate','450BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1691,NULL,'USR-Back-Channel-Data-Rate','300BPS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1692,NULL,'USR-Back-Channel-Data-Rate','None',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1693,NULL,'USR-Device-Connected-To','None',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1694,NULL,'USR-Device-Connected-To','isdnGateway',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1695,NULL,'USR-Device-Connected-To','quadModem',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1696,NULL,'USR-Call-Event-Code','notSupported',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1697,NULL,'USR-Call-Event-Code','setup',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1698,NULL,'USR-Call-Event-Code','usrSetup',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1699,NULL,'USR-Call-Event-Code','telcoDisconnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1700,NULL,'USR-Call-Event-Code','usrDisconnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1701,NULL,'USR-Call-Event-Code','noFreeModem',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1702,NULL,'USR-Call-Event-Code','modemsNotAllowed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1703,NULL,'USR-Call-Event-Code','modemsRejectCall',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1704,NULL,'USR-Call-Event-Code','modemSetupTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1705,NULL,'USR-Call-Event-Code','noFreeIGW',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1706,NULL,'USR-Call-Event-Code','igwRejectCall',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1707,NULL,'USR-Call-Event-Code','igwSetupTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1708,NULL,'USR-Call-Event-Code','noFreeTdmts',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1709,NULL,'USR-Call-Event-Code','bcReject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1710,NULL,'USR-Call-Event-Code','ieReject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1711,NULL,'USR-Call-Event-Code','chidReject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1712,NULL,'USR-Call-Event-Code','progReject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1713,NULL,'USR-Call-Event-Code','callingPartyReject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1714,NULL,'USR-Call-Event-Code','calledPartyReject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1715,NULL,'USR-Call-Event-Code','blocked',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1716,NULL,'USR-Call-Event-Code','analogBlocked',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1717,NULL,'USR-Call-Event-Code','digitalBlocked',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1718,NULL,'USR-Call-Event-Code','outOfService',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1719,NULL,'USR-Call-Event-Code','busy',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1720,NULL,'USR-Call-Event-Code','congestion',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1721,NULL,'USR-Call-Event-Code','protocolError',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1722,NULL,'USR-Call-Event-Code','noFreeBchannel',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1723,NULL,'USR-Call-Event-Code','inOutCallCollision',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1724,NULL,'USR-Call-Event-Code','inCallArrival',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1725,NULL,'USR-Call-Event-Code','outCallArrival',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1726,NULL,'USR-Call-Event-Code','inCallConnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1727,NULL,'USR-Call-Event-Code','outCallConnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1728,NULL,'USR-HARC-Disconnect-Code','No-Error',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1729,NULL,'USR-HARC-Disconnect-Code','No-Carrier',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1730,NULL,'USR-HARC-Disconnect-Code','No-DSR',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1731,NULL,'USR-HARC-Disconnect-Code','Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1732,NULL,'USR-HARC-Disconnect-Code','Reset',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1733,NULL,'USR-HARC-Disconnect-Code','Call-Drop-Req',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1734,NULL,'USR-HARC-Disconnect-Code','Idle-Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1735,NULL,'USR-HARC-Disconnect-Code','Session-Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1736,NULL,'USR-HARC-Disconnect-Code','User-Req-Drop',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1737,NULL,'USR-HARC-Disconnect-Code','Host-Req-Drop',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1738,NULL,'USR-HARC-Disconnect-Code','Service-Interruption',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1739,NULL,'USR-HARC-Disconnect-Code','Service-Unavailable',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1740,NULL,'USR-HARC-Disconnect-Code','User-Input-Error',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1741,NULL,'USR-HARC-Disconnect-Code','NAS-Drop-For-Callback',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1742,NULL,'USR-HARC-Disconnect-Code','NAS-Drop-Misc-Non-Error',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1743,NULL,'USR-HARC-Disconnect-Code','NAS-Internal-Error',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1744,NULL,'USR-HARC-Disconnect-Code','Line-Busy',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1745,NULL,'USR-HARC-Disconnect-Code','Tunnel-Term-Unreach',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1746,NULL,'USR-HARC-Disconnect-Code','Tunnel-Refused',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1747,NULL,'USR-HARC-Disconnect-Code','Tunnel-Auth-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1748,NULL,'USR-HARC-Disconnect-Code','Tunnel-Session-Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1749,NULL,'USR-HARC-Disconnect-Code','Tunnel-Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1750,NULL,'USR-HARC-Disconnect-Code','Radius-Res-Reclaim',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1751,NULL,'USR-HARC-Disconnect-Code','DNIS-Auth-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1752,NULL,'USR-HARC-Disconnect-Code','PAP-Auth-Failure',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1753,NULL,'USR-HARC-Disconnect-Code','CHAP-Auth-Failure',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1754,NULL,'USR-HARC-Disconnect-Code','PPP-LCP-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1755,NULL,'USR-HARC-Disconnect-Code','PPP-NCP-Failed',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1756,NULL,'USR-HARC-Disconnect-Code','Radius-Timeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1757,NULL,'USR-CCP-Algorithm','NONE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1758,NULL,'USR-CCP-Algorithm','Stac',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1759,NULL,'USR-CCP-Algorithm','MS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1760,NULL,'USR-CCP-Algorithm','Any',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1761,NULL,'USR-Tunnel-Security','None',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1762,NULL,'USR-Tunnel-Security','Control-Only',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1763,NULL,'USR-Tunnel-Security','Data-Only',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1764,NULL,'USR-Tunnel-Security','Both-Data-and-Control',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1765,NULL,'USR-RMMIE-Status','notEnabledInLocalModem',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1766,NULL,'USR-RMMIE-Status','notDetectedInRemoteModem',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1767,NULL,'USR-RMMIE-Status','ok',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1768,NULL,'USR-RMMIE-x2-Status','notOperational',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1769,NULL,'USR-RMMIE-x2-Status','operational',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1770,NULL,'USR-RMMIE-x2-Status','x2Disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1771,NULL,'USR-RMMIE-x2-Status','v8Disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1772,NULL,'USR-RMMIE-x2-Status','remote3200Disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1773,NULL,'USR-RMMIE-x2-Status','invalidSpeedSetting',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1774,NULL,'USR-RMMIE-x2-Status','v8NotDetected',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1775,NULL,'USR-RMMIE-x2-Status','x2NotDetected',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1776,NULL,'USR-RMMIE-x2-Status','incompatibleVersion',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1777,NULL,'USR-RMMIE-x2-Status','incompatibleModes',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1778,NULL,'USR-RMMIE-x2-Status','local3200Disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1779,NULL,'USR-RMMIE-x2-Status','excessHighFrequencyAtten',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1780,NULL,'USR-RMMIE-x2-Status','connectNotSupport3200',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1781,NULL,'USR-RMMIE-x2-Status','retrainBeforeConnection',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1782,NULL,'USR-RMMIE-Planned-Disconnect','none',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1783,NULL,'USR-RMMIE-Planned-Disconnect','dteNotReady',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1784,NULL,'USR-RMMIE-Planned-Disconnect','dteInterfaceError',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1785,NULL,'USR-RMMIE-Planned-Disconnect','dteRequest',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1786,NULL,'USR-RMMIE-Planned-Disconnect','escapeToOnlineCommandMode',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1787,NULL,'USR-RMMIE-Planned-Disconnect','athCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1788,NULL,'USR-RMMIE-Planned-Disconnect','inactivityTimeout',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1789,NULL,'USR-RMMIE-Planned-Disconnect','arqProtocolError',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1790,NULL,'USR-RMMIE-Planned-Disconnect','arqProtocolRetransmitLim',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1791,NULL,'USR-RMMIE-Planned-Disconnect','invalidComprDataCodeword',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1792,NULL,'USR-RMMIE-Planned-Disconnect','invalidComprDataStringLen',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1793,NULL,'USR-RMMIE-Planned-Disconnect','invalidComprDataCommand',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1794,NULL,'USR-RMMIE-Last-Update-Event','none',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1795,NULL,'USR-RMMIE-Last-Update-Event','initialConnection',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1796,NULL,'USR-RMMIE-Last-Update-Event','retrain',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1797,NULL,'USR-RMMIE-Last-Update-Event','speedShift',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1798,NULL,'USR-RMMIE-Last-Update-Event','plannedDisconnect',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1799,NULL,'USR-Request-Type','Access-Request',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1800,NULL,'USR-Request-Type','Access-Accept',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1801,NULL,'USR-Request-Type','Access-Reject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1802,NULL,'USR-Request-Type','Accounting-Request',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1803,NULL,'USR-Request-Type','Accounting-Response',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1804,NULL,'USR-Request-Type','Access-Password-Change',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1805,NULL,'USR-Request-Type','Access-Password-Ack',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1806,NULL,'USR-Request-Type','Access-Password-Reject',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1807,NULL,'USR-Request-Type','Access-Challenge',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1808,NULL,'USR-Request-Type','Status-Server',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1809,NULL,'USR-Request-Type','Status-Client',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1810,NULL,'USR-Request-Type','Resource-Free-Request',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1811,NULL,'USR-Request-Type','Resource-Free-Response',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1812,NULL,'USR-Request-Type','Resource-Query-Request',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1813,NULL,'USR-Request-Type','Resource-Query-Response',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1814,NULL,'USR-Request-Type','Disconnect-User',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1815,NULL,'USR-Request-Type','NAS-Reboot-Request',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1816,NULL,'USR-Request-Type','NAS-Reboot-Response',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1817,NULL,'USR-Request-Type','Tacacs-Message',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1818,NULL,'USR-Request-Type','Reserved',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1819,NULL,'USR-Speed-Of-Connection','Auto',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1820,NULL,'USR-Speed-Of-Connection','56',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1821,NULL,'USR-Speed-Of-Connection','64',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1822,NULL,'USR-Speed-Of-Connection','Voice',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1823,NULL,'USR-Expansion-Algorithm','Constant',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1824,NULL,'USR-Expansion-Algorithm','Linear',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1825,NULL,'USR-Compression-Algorithm','None',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1826,NULL,'USR-Compression-Algorithm','Stac',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1827,NULL,'USR-Compression-Algorithm','Ascend',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1828,NULL,'USR-Compression-Algorithm','Microsoft',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1829,NULL,'USR-Compression-Algorithm','Auto',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1830,NULL,'USR-Compression-Reset-Mode','Auto',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1831,NULL,'USR-Compression-Reset-Mode','Reset-Every-Packet',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1832,NULL,'USR-Compression-Reset-Mode','Reset-On-Error',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1833,NULL,'USR-Filter-Zones','enabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1834,NULL,'USR-Filter-Zones','disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1835,NULL,'USR-Bridging','enabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1836,NULL,'USR-Bridging','disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1837,NULL,'USR-Appletalk','enabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1838,NULL,'USR-Appletalk','disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1839,NULL,'USR-Spoofing','enabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1840,NULL,'USR-Spoofing','disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1841,NULL,'USR-Routing-Protocol','Rip1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1842,NULL,'USR-Routing-Protocol','Rip2',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1843,NULL,'USR-IPX-Routing','none',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1844,NULL,'USR-IPX-Routing','send',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1845,NULL,'USR-IPX-Routing','listen',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1846,NULL,'USR-IPX-Routing','respond',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1847,NULL,'USR-IPX-Routing','all',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1848,NULL,'USR-IPX-WAN','enabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1849,NULL,'USR-IPX-WAN','disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1850,NULL,'USR-IP-Default-Route-Option','enabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1851,NULL,'USR-IP-Default-Route-Option','disabled',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1852,NULL,'USR-IP-RIP-Policies','SendDefault',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1853,NULL,'USR-IP-RIP-Policies','SendRoutes',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1854,NULL,'USR-IP-RIP-Policies','SendSubnets',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1855,NULL,'USR-IP-RIP-Policies','AcceptDefault',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1856,NULL,'USR-IP-RIP-Policies','SplitHorizon',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1857,NULL,'USR-IP-RIP-Policies','PoisonReserve',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1858,NULL,'USR-IP-RIP-Policies','FlashUpdate',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1859,NULL,'USR-IP-RIP-Policies','SimpleAuth',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1860,NULL,'USR-IP-RIP-Policies','V1Send',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1861,NULL,'USR-IP-RIP-Policies','V1Receive',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1862,NULL,'USR-IP-RIP-Policies','V2Receive',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1863,NULL,'USR-IP-RIP-Policies','Silent',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1864,NULL,'USR-Callback-Type','Normal',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1865,NULL,'USR-Callback-Type','ANI',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1866,NULL,'USR-Callback-Type','Static',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1867,NULL,'USR-Callback-Type','Dynamic',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1868,NULL,'USR-Agent','FA',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1869,NULL,'USR-Agent','HA',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1870,NULL,'USR-NAS-Type','3Com-NMC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1871,NULL,'USR-NAS-Type','3Com-NETServer',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1872,NULL,'USR-NAS-Type','3Com-HiPerArc',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1873,NULL,'USR-NAS-Type','TACACS+-Server',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1874,NULL,'USR-NAS-Type','3Com-SA-Server',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1875,NULL,'USR-NAS-Type','Ascend',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1876,NULL,'USR-NAS-Type','Generic-RADIUS',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1877,NULL,'USR-NAS-Type','3Com-NETBuilder-II',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1878,NULL,'USR-Auth-Mode','Auth-3Com',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1879,NULL,'USR-Auth-Mode','Auth-Ace',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1880,NULL,'USR-Auth-Mode','Auth-Safeword',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1881,NULL,'USR-Auth-Mode','Auth-UNIX-PW',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1882,NULL,'USR-Auth-Mode','Auth-Defender',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1883,NULL,'USR-Auth-Mode','Auth-TACACSP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1884,NULL,'USR-Auth-Mode','Auth-Netware',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1885,NULL,'USR-Auth-Mode','Auth-Skey',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1886,NULL,'USR-Auth-Mode','Auth-EAP-Proxy',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1887,NULL,'USR-Auth-Mode','Auth-UNIX-Crypt',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1888,NULL,'CW-Acct-Type','COMS-UNKNOWN-ACCT-TYPE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1889,NULL,'CW-Acct-Type','COMS-PREPAID-ACCT',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1890,NULL,'CW-Acct-Type','COMS-NEW-ACCT',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1891,NULL,'CW-Acct-Type','COMS-SUSPENDED-ACCT',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1892,NULL,'CW-Acct-Type','COMS-ADMINISTRATIVE-ACCT',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1893,NULL,'CW-Source-Identifier','COMS-UNKNOWN-SOURCE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1894,NULL,'CW-Source-Identifier','COMS-INGRESS-OPEN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1895,NULL,'CW-Source-Identifier','COMS-EGRESS-OPEN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1896,NULL,'CW-Source-Identifier','COMS-GTKPR-GEN-INGR-OPEN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1897,NULL,'CW-Source-Identifier','COMS-GTKPR-GEN-EGR-OPEN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1898,NULL,'CW-Source-Identifier','COMS-INGRESS-CLOSE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1899,NULL,'CW-Source-Identifier','COMS-EGRESS-CLOSE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1900,NULL,'CW-Source-Identifier','COMS-GTKPR-GEN-INGR-CLOSE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1901,NULL,'CW-Source-Identifier','COMS-GTKPR-GEN-EGR-CLOSE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1902,NULL,'CW-Session-Sequence-End','NOT-THE-LAST-CALL',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1903,NULL,'CW-Session-Sequence-End','LAST-CALL',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1904,NULL,'CW-Clg-Party-E164-Type','comsUnknown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1905,NULL,'CW-Clg-Party-E164-Type','comsInternationalNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1906,NULL,'CW-Clg-Party-E164-Type','comsNationalNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1907,NULL,'CW-Clg-Party-E164-Type','comsNetworkSpecificNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1908,NULL,'CW-Clg-Party-E164-Type','comsSubscriberNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1909,NULL,'CW-Clg-Party-E164-Type','comsAbbreviatedNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1910,NULL,'CW-Clg-Party-E164-Type','comsReserved',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1911,NULL,'CW-Clg-Party-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1912,NULL,'CW-Clg-Party-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1913,NULL,'CW-Clg-Party-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1914,NULL,'CW-Cld-Party-E164-Type','comsUnknown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1915,NULL,'CW-Cld-Party-E164-Type','comsInternationalNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1916,NULL,'CW-Cld-Party-E164-Type','comsNationalNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1917,NULL,'CW-Cld-Party-E164-Type','comsNetworkSpecificNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1918,NULL,'CW-Cld-Party-E164-Type','comsSubscriberNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1919,NULL,'CW-Cld-Party-E164-Type','comsAbbreviatedNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1920,NULL,'CW-Cld-Party-E164-Type','comsReserved',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1921,NULL,'CW-Cld-Party-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1922,NULL,'CW-Cld-Party-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1923,NULL,'CW-Cld-Party-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1924,NULL,'CW-Ingr-Gway-E164-Type','comsUnknown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1925,NULL,'CW-Ingr-Gway-E164-Type','comsInternationalNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1926,NULL,'CW-Ingr-Gway-E164-Type','comsNationalNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1927,NULL,'CW-Ingr-Gway-E164-Type','comsNetworkSpecificNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1928,NULL,'CW-Ingr-Gway-E164-Type','comsSubscriberNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1929,NULL,'CW-Ingr-Gway-E164-Type','comsAbbreviatedNumber',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1930,NULL,'CW-Ingr-Gway-E164-Type','comsReserved',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1931,NULL,'CW-Ingr-Gway-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1932,NULL,'CW-Ingr-Gway-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1933,NULL,'CW-Ingr-Gway-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1934,NULL,'CW-Egr-Gway-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1935,NULL,'CW-Egr-Gway-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1936,NULL,'CW-Egr-Gway-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1937,NULL,'CW-Ingr-Gtkpr-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1938,NULL,'CW-Ingr-Gtkpr-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1939,NULL,'CW-Ingr-Gtkpr-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1940,NULL,'CW-Egr-Gtkpr-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1941,NULL,'CW-Egr-Gtkpr-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1942,NULL,'CW-Egr-Gtkpr-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1943,NULL,'CW-Call-Type','COMS-UNKNOWN-CALLTYPE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1944,NULL,'CW-Call-Type','COMS-PHONE-TO-PHONE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1945,NULL,'CW-Call-Type','COMS-PHONE-TO-PC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1946,NULL,'CW-Call-Type','COMS-PC-TO-PHONE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1947,NULL,'CW-Call-Type','COMS-PC-TO-PC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1948,NULL,'CW-Codec-Type','COMS-UNDEFINED-CODEC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1949,NULL,'CW-Codec-Type','COMS-G723-1',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1950,NULL,'CW-Codec-Type','COMS-G729-A',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1951,NULL,'CW-Codec-Type','COMS-G710-ALaw',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1952,NULL,'CW-Codec-Type','COMS-G711-MuLaw',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1953,NULL,'CW-Codec-Type','COMS-FAX-MODULATION',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1954,NULL,'CW-Call-Termination-Cause','CAUSE-UNKNOWN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1955,NULL,'CW-Call-Termination-Cause','CAUSE-CLD-PARTY-TERMINATE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1956,NULL,'CW-Call-Termination-Cause','CAUSE-CLG-PARTY-TERMINATE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1957,NULL,'CW-Call-Termination-Cause','CAUSE-ACCT-BAL-DEPLETED',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1958,NULL,'CW-Call-Termination-Cause','CAUSE-NO-EGR-PORTS-AVAIL',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1959,NULL,'CW-Call-Termination-Cause','CAUSE-H225-UNABLE-TO-CON',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1960,NULL,'CW-Call-Termination-Cause','CAUSE-H245-UNABLE-TO-CON',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1961,NULL,'CW-Call-Termination-Cause','CAUSE-INGR-FACILITY-DISC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1962,NULL,'CW-Call-Termination-Cause','CAUSE-EGR-FACILITY-DISC',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1963,NULL,'CW-Call-Termination-Cause','CAUSE-DIR-SERVER-DOWN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1964,NULL,'CW-Call-Termination-Cause','CAUSE-RATING-SERVER-DOWN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1965,NULL,'CW-Call-Termination-Cause','CAUSE-GATEWAY-SHUTDOWN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1966,NULL,'CW-Call-Termination-Cause','CAUSE-GTKPR-TERMINATE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1967,NULL,'CW-Call-Termination-Cause','CAUSE-GTKPR-SHUTDOWN-GTWAY',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1968,NULL,'CW-Call-Termination-Cause','CAUSE-BUSY',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1969,NULL,'CW-Call-Termination-Cause','CAUSE-ABANDON',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1970,NULL,'CW-Call-Termination-Cause','CAUSE-INVALID-LOGIN-LIMIT',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1971,NULL,'CW-Call-Termination-Cause','CAUSE-NOACCTNUMBER-ENTRY',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1972,NULL,'CW-Call-Termination-Cause','CAUSE-SUSPENDED-ACCT-LOGIN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1973,NULL,'CW-Call-Termination-Cause','CAUSE-AUTHENT-SERVER-DOWN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1974,NULL,'CW-Call-Termination-Cause','CAUSE-GATEKEEPER-TIMEOUT',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1975,NULL,'CW-Call-Termination-Cause','CAUSE-GATEWAY-NO-RESOURCES',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1976,NULL,'CW-Call-Termination-Cause','CAUSE-ACCT-INUSE',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1977,NULL,'CW-Call-Termination-Cause','CAUSE-DEBIT-ACCT-BAL-ZERO',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1978,NULL,'CW-Call-Termination-Cause','CAUSE-DEBIT-ACCTBAL-INSUFF',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1979,NULL,'CW-Call-Termination-Cause','CAUSE-INVALID-DESTNUMBER-THRESH',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1980,NULL,'CW-Call-Termination-Cause','CAUSE-NO-DESTNUMBER-ENTRY',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1981,NULL,'CW-Call-Termination-Cause','CAUSE-SEQUENCE-DIALING-THRESH',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1982,NULL,'CW-Signaling-Protocol','SIG-UNKNOWN',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1983,NULL,'CW-Signaling-Protocol','SIG-SIP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1984,NULL,'CW-Signaling-Protocol','SIG-H323',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1985,NULL,'CW-Protocol-Transport','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1986,NULL,'CW-Protocol-Transport','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1987,NULL,'CW-Protocol-Transport','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1988,NULL,'CW-Local-Sig-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1989,NULL,'CW-Local-Sig-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1990,NULL,'CW-Local-Sig-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1991,NULL,'CW-Remote-Sig-Trans-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1992,NULL,'CW-Remote-Sig-Trans-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1993,NULL,'CW-Remote-Sig-Trans-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1994,NULL,'CW-Local-MG-RTP-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1995,NULL,'CW-Local-MG-RTP-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1996,NULL,'CW-Local-MG-RTP-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1997,NULL,'CW-Remote-MG-RTP-Protocol','TCP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1998,NULL,'CW-Remote-MG-RTP-Protocol','UDP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (1999,NULL,'CW-Remote-MG-RTP-Protocol','SCTP',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2000,NULL,'CW-Trans-Cld-Party-E164-Type','Unknown',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2001,NULL,'CW-Trans-Cld-Party-E164-Type','International-Number',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2002,NULL,'CW-Trans-Cld-Party-E164-Type','National-Number',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2003,NULL,'CW-Trans-Cld-Party-E164-Type','Network-Specific-Number',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2004,NULL,'CW-Trans-Cld-Party-E164-Type','Subscriber-Number',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2005,NULL,'CW-Trans-Cld-Party-E164-Type','Abbreviated-Number',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2006,NULL,'CW-Trans-Cld-Party-E164-Type','Reserved',NULL,'USR',NULL,NULL,NULL,NULL),
                                (2007,'integer','Cajun-Service-Type',NULL,NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2008,NULL,'Cajun-Service-Type','Cajun-Read-Only-User',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2009,NULL,'Cajun-Service-Type','Cajun-Read-Write-User',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2010,NULL,'Cajun-Service-Type','Cajun-Admin-User',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2011,'string','Avaya-StaticVlan-Type',NULL,NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2012,'integer','Avaya-PortPriority-Type',NULL,NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2013,NULL,'Avaya-PortPriority-Type','Type-0',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2014,NULL,'Avaya-PortPriority-Type','Type-1',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2015,NULL,'Avaya-PortPriority-Type','Type-2',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2016,NULL,'Avaya-PortPriority-Type','Type-3',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2017,NULL,'Avaya-PortPriority-Type','Type-4',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2018,NULL,'Avaya-PortPriority-Type','Type-5',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2019,NULL,'Avaya-PortPriority-Type','Type-6',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2020,NULL,'Avaya-PortPriority-Type','Type-7',NULL,'Cajun_p330',NULL,NULL,NULL,NULL),
                                (2021,'integer','Fall-Through',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2022,'string','Exec-Program',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2023,'string','Exec-Program-Wait',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2024,'integer','Auth-Type',NULL,NULL,'dictionary.freeradius.internal',':=','check','authtype','An Authentication Type specifies which credentials the user is required to supply in order to be authenticated and where the users authentication data are stored'),
                                (2025,'string','Menu',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2026,'string','Termination-Menu',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2027,'string','Prefix',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2028,'string','Suffix',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2029,'string','Group',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2030,'string','Crypt-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2031,'integer','Connect-Rate',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2032,'string','Add-Prefix',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2033,'string','Add-Suffix',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2034,'date','Expiration',NULL,NULL,'dictionary.freeradius.internal',':=','check','date','The Expiration attribute is a date in the format shown by the `date` utility (e.g. "Thu 3 Apr 2014 13:19:52 EDT").'),
                                (2035,'integer','Autz-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2036,'integer','Acct-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2037,'integer','Session-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2038,'integer','Post-Auth-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2039,'integer','Pre-Proxy-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2040,'integer','Post-Proxy-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2041,'integer','Pre-Acct-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2042,'integer','EAP-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2043,'integer','EAP-TLS-Require-Client-Cert',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2044,'integer','EAP-Id',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2045,'integer','EAP-Code',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2046,'string','EAP-MD5-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2047,'integer','PEAP-Version',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2048,'string','User-Category',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2049,'string','Group-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2050,'string','Huntgroup-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2051,'integer','Simultaneous-Use',NULL,NULL,'dictionary.freeradius.internal',':=','check','','The number of simultaneous logins allowed for the same account login'),
                                (2052,'integer','Strip-User-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2053,'string','Hint',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2054,'string','Pam-Auth',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2055,'string','Login-Time',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2056,'string','Stripped-User-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2057,'string','Current-Time',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2058,'string','Realm',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2059,'string','No-Such-Attribute',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2060,'integer','Packet-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2061,'string','Proxy-To-Realm',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2062,'string','Replicate-To-Realm',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2063,'date','Acct-Session-Start-Time',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2064,'string','Acct-Unique-Session-Id',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2065,'ipaddr','Client-IP-Address',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2066,'string','Ldap-UserDn',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2067,'string','NS-MTA-MD5-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2068,'string','SQL-User-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2069,'octets','LM-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2070,'octets','NT-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2071,'integer','SMB-Account-CTRL',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2072,'string','SMB-Account-CTRL-TEXT',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2073,'string','User-Profile',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2074,'string','Digest-Realm',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2075,'string','Digest-Nonce',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2076,'string','Digest-Method',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2077,'string','Digest-URI',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2078,'string','Digest-QOP',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2079,'string','Digest-Algorithm',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2080,'string','Digest-Body-Digest',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2081,'string','Digest-CNonce',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2082,'string','Digest-Nonce-Count',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2083,'string','Digest-User-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2084,'string','Pool-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2085,'string','Ldap-Group',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2086,'string','Module-Success-Message',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2087,'string','Module-Failure-Message',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2088,'string','Rewrite-Rule',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2089,'string','Sql-Group',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2090,'integer','Response-Packet-Type',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2091,'string','Digest-HA1',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2092,'integer','MS-CHAP-Use-NTLM-Auth',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2093,'string','NTLM-User-Name',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2094,'ipaddr','Packet-Src-IP-Address',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2095,'ipaddr','Packet-Dst-IP-Address',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2096,'integer','Packet-Src-Port',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2097,'integer','Packet-Dst-Port',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2098,'octets','Packet-Authentication-Vector',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2099,'string','Time-Of-Day',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2100,'string','Request-Processing-Stage',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2101,'string','Cache-No-Caching',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2102,'string','Cache-Delete-Cache',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2103,'octets','SHA-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2104,'octets','SSHA-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2105,'octets','MD5-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2106,'octets','SMD5-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2107,'ipv6addr','Packet-Src-IPv6-Address',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2108,'ipv6addr','Packet-Dst-IPv6-Address',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2109,'string','Server-Identity',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2110,'string','Cleartext-Password',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2111,'string','Password-With-Header',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2112,'integer','EAP-Sim-Subtype',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2113,'octets','EAP-Sim-Rand1',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2114,'octets','EAP-Sim-Rand2',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2115,'octets','EAP-Sim-Rand3',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2116,'octets','EAP-Sim-SRES1',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2117,'octets','EAP-Sim-SRES2',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2118,'octets','EAP-Sim-SRES3',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2119,NULL,'EAP-Sim-Subtype','Start',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2120,NULL,'EAP-Sim-Subtype','Challenge',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2121,NULL,'EAP-Sim-Subtype','Notification',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2122,NULL,'EAP-Sim-Subtype','Re-authentication',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2123,'integer','EAP-Sim-State',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2124,'string','EAP-Sim-IMSI',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2125,'string','EAP-Sim-HMAC',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2126,'octets','EAP-Sim-KEY',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2127,'octets','EAP-Sim-EXTRA',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2128,'octets','EAP-Sim-KC1',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2129,'octets','EAP-Sim-KC2',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2130,'octets','EAP-Sim-KC3',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2131,'string','EAP-Type-Identity',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2132,'string','EAP-Type-Notification',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2133,'string','EAP-Type-NAK',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2134,'octets','EAP-Type-MD5',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2135,'string','EAP-Type-OTP',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2136,'string','EAP-Type-GTC',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2137,'octets','EAP-Type-TLS',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2138,'octets','EAP-Type-SIM',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2139,'octets','EAP-Type-LEAP',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2140,'octets','EAP-Type-SIM2',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2141,'octets','EAP-Type-TTLS',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2142,'octets','EAP-Type-PEAP',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2143,'octets','EAP-Sim-RAND',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2144,'octets','EAP-Sim-PADDING',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2145,'octets','EAP-Sim-NONCE_MT',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2146,'octets','EAP-Sim-PERMANENT_ID_REQ',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2147,'octets','EAP-Sim-MAC',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2148,'octets','EAP-Sim-NOTIFICATION',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2149,'octets','EAP-Sim-ANY_ID_REQ',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2150,'octets','EAP-Sim-IDENTITY',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2151,'octets','EAP-Sim-VERSION_LIST',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2152,'octets','EAP-Sim-SELECTED_VERSION',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2153,'octets','EAP-Sim-FULLAUTH_ID_REQ',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2154,'octets','EAP-Sim-COUNTER',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2155,'octets','EAP-Sim-COUNTER_TOO_SMALL',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2156,'octets','EAP-Sim-NONCE_S',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2157,'octets','EAP-Sim-IV',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2158,'octets','EAP-Sim-ENCR_DATA',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2159,'octets','EAP-Sim-NEXT_PSEUDONUM',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2160,'octets','EAP-Sim-NEXT_REAUTH_ID',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2161,'octets','EAP-Sim-CHECKCODE',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2162,'string','Tmp-String-0',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2163,'string','Tmp-String-1',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2164,'string','Tmp-String-2',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2165,'string','Tmp-String-3',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2166,'string','Tmp-String-4',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2167,'string','Tmp-String-5',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2168,'string','Tmp-String-6',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2169,'string','Tmp-String-7',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2170,'string','Tmp-String-8',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2171,'string','Tmp-String-9',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2172,'integer','Tmp-Integer-0',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2173,'integer','Tmp-Integer-1',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2174,'integer','Tmp-Integer-2',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2175,'integer','Tmp-Integer-3',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2176,'integer','Tmp-Integer-4',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2177,'integer','Tmp-Integer-5',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2178,'integer','Tmp-Integer-6',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2179,'integer','Tmp-Integer-7',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2180,'integer','Tmp-Integer-8',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2181,'integer','Tmp-Integer-9',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2182,'ipaddr','Tmp-IP-Address-0',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2183,'ipaddr','Tmp-IP-Address-1',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2184,'ipaddr','Tmp-IP-Address-2',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2185,'ipaddr','Tmp-IP-Address-3',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2186,'ipaddr','Tmp-IP-Address-4',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2187,'ipaddr','Tmp-IP-Address-5',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2188,'ipaddr','Tmp-IP-Address-6',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2189,'ipaddr','Tmp-IP-Address-7',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2190,'ipaddr','Tmp-IP-Address-8',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2191,'ipaddr','Tmp-IP-Address-9',NULL,NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2192,NULL,'Auth-Type','Local',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2193,NULL,'Auth-Type','System',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2194,NULL,'Auth-Type','SecurID',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2195,NULL,'Auth-Type','Crypt-Local',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2196,NULL,'Auth-Type','Reject',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2197,NULL,'Auth-Type','ActivCard',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2198,NULL,'Auth-Type','EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2199,NULL,'Auth-Type','ARAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2200,NULL,'Auth-Type','Accept',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2201,NULL,'Auth-Type','PAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2202,NULL,'Auth-Type','CHAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2203,NULL,'Auth-Type','PAM',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2204,NULL,'Auth-Type','MS-CHAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2205,NULL,'Auth-Type','Kerberos',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2206,NULL,'Auth-Type','CRAM',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2207,NULL,'Auth-Type','NS-MTA-MD5',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2208,NULL,'Auth-Type','SMB',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2209,NULL,'Autz-Type','Local',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2210,NULL,'Acct-Type','Local',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2211,NULL,'Session-Type','Local',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2212,NULL,'Post-Auth-Type','Local',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2213,NULL,'Fall-Through','No',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2214,NULL,'Fall-Through','Yes',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2215,NULL,'Packet-Type','Access-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2216,NULL,'Packet-Type','Access-Accept',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2217,NULL,'Packet-Type','Access-Reject',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2218,NULL,'Packet-Type','Accounting-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2219,NULL,'Packet-Type','Accounting-Response',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2220,NULL,'Packet-Type','Accounting-Status',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2221,NULL,'Packet-Type','Password-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2222,NULL,'Packet-Type','Password-Accept',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2223,NULL,'Packet-Type','Password-Reject',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2224,NULL,'Packet-Type','Accounting-Message',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2225,NULL,'Packet-Type','Access-Challenge',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2226,NULL,'Packet-Type','Status-Server',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2227,NULL,'Packet-Type','Status-Client',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2228,NULL,'Packet-Type','Resource-Free-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2229,NULL,'Packet-Type','Resource-Free-Response',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2230,NULL,'Packet-Type','Resource-Query-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2231,NULL,'Packet-Type','Resource-Query-Response',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2232,NULL,'Packet-Type','Alternate-Resource-Reclaim-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2233,NULL,'Packet-Type','NAS-Reboot-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2234,NULL,'Packet-Type','NAS-Reboot-Response',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2235,NULL,'Packet-Type','Next-Passcode',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2236,NULL,'Packet-Type','New-Pin',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2237,NULL,'Packet-Type','Terminate-Session',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2238,NULL,'Packet-Type','Password-Expired',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2239,NULL,'Packet-Type','Event-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2240,NULL,'Packet-Type','Event-Response',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2241,NULL,'Packet-Type','Disconnect-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2242,NULL,'Packet-Type','Disconnect-ACK',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2243,NULL,'Packet-Type','Disconnect-NAK',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2244,NULL,'Packet-Type','CoF-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2245,NULL,'Packet-Type','CoF-ACK',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2246,NULL,'Packet-Type','CoF-NAK',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2247,NULL,'Packet-Type','CoA-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2248,NULL,'Packet-Type','CoA-ACK',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2249,NULL,'Packet-Type','CoA-NAK',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2250,NULL,'Packet-Type','IP-Address-Allocate',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2251,NULL,'Packet-Type','IP-Address-Release',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2252,NULL,'Response-Packet-Type','Access-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2253,NULL,'Response-Packet-Type','Access-Accept',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2254,NULL,'Response-Packet-Type','Access-Reject',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2255,NULL,'Response-Packet-Type','Accounting-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2256,NULL,'Response-Packet-Type','Accounting-Response',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2257,NULL,'Response-Packet-Type','Accounting-Status',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2258,NULL,'Response-Packet-Type','Password-Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2259,NULL,'Response-Packet-Type','Password-Accept',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2260,NULL,'Response-Packet-Type','Password-Reject',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2261,NULL,'Response-Packet-Type','Accounting-Message',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2262,NULL,'Response-Packet-Type','Access-Challenge',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2263,NULL,'Response-Packet-Type','Status-Server',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2264,NULL,'Response-Packet-Type','Status-Client',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2265,NULL,'EAP-Type','None',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2266,NULL,'EAP-Type','Identity',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2267,NULL,'EAP-Type','Notification',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2268,NULL,'EAP-Type','NAK',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2269,NULL,'EAP-Type','MD5-Challenge',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2270,NULL,'EAP-Type','One-Time-Password',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2271,NULL,'EAP-Type','Generic-Token-Card',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2272,NULL,'EAP-Type','RSA-Public-Key',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2273,NULL,'EAP-Type','DSS-Unilateral',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2274,NULL,'EAP-Type','KEA',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2275,NULL,'EAP-Type','KEA-Validate',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2276,NULL,'EAP-Type','EAP-TLS',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2277,NULL,'EAP-Type','Defender-Token',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2278,NULL,'EAP-Type','RSA-SecurID-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2279,NULL,'EAP-Type','Arcot-Systems-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2280,NULL,'EAP-Type','Cisco-LEAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2281,NULL,'EAP-Type','Nokia-IP-Smart-Card',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2282,NULL,'EAP-Type','SIM',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2283,NULL,'EAP-Type','SRP-SHA1-Part-1',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2284,NULL,'EAP-Type','SRP-SHA1-Part-2',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2285,NULL,'EAP-Type','EAP-TTLS',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2286,NULL,'EAP-Type','Remote-Access-Service',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2287,NULL,'EAP-Type','UMTS',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2288,NULL,'EAP-Type','EAP-3Com-Wireless',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2289,NULL,'EAP-Type','PEAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2290,NULL,'EAP-Type','MS-EAP-Authentication',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2291,NULL,'EAP-Type','MAKE',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2292,NULL,'EAP-Type','CRYPTOCard',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2293,NULL,'EAP-Type','EAP-MSCHAP-V2',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2294,NULL,'EAP-Type','DynamID',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2295,NULL,'EAP-Type','Rob-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2296,NULL,'EAP-Type','SecurID-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2297,NULL,'EAP-Type','MS-Authentication-TLV',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2298,NULL,'EAP-Type','SentriNET',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2299,NULL,'EAP-Type','EAP-Actiontec-Wireless',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2300,NULL,'EAP-Type','Cogent-Biomentric-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2301,NULL,'EAP-Type','AirFortress-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2302,NULL,'EAP-Type','EAP-HTTP-Digest',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2303,NULL,'EAP-Type','SecuriSuite-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2304,NULL,'EAP-Type','DeviceConnect-EAP',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2305,NULL,'EAP-Type','EAP-SPEKE',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2306,NULL,'EAP-Type','EAP-MOBAC',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2307,NULL,'EAP-Type','Microsoft-MS-CHAPv2',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2308,NULL,'EAP-Type','Cisco-MS-CHAPv2',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2309,NULL,'EAP-Type','MS-CHAP-V2',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2310,NULL,'EAP-TLS-Require-Client-Cert','No',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2311,NULL,'EAP-TLS-Require-Client-Cert','Yes',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2312,NULL,'EAP-Code','Request',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2313,NULL,'EAP-Code','Response',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2314,NULL,'EAP-Code','Success',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2315,NULL,'EAP-Code','Failure',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2316,NULL,'MS-CHAP-Use-NTLM-Auth','No',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2317,NULL,'MS-CHAP-Use-NTLM-Auth','Yes',NULL,'dictionary.freeradius.internal',NULL,NULL,NULL,NULL),
                                (2318,'string','Telebit-Login-Command',NULL,NULL,'Telebit',NULL,NULL,NULL,NULL),
                                (2319,'string','Telebit-Port-Name',NULL,NULL,'Telebit',NULL,NULL,NULL,NULL),
                                (2320,'string','Telebit-Activate-Command',NULL,NULL,'Telebit',NULL,NULL,NULL,NULL),
                                (2321,'string','Telebit-Accounting-Info',NULL,NULL,'Telebit',NULL,NULL,NULL,NULL),
                                (2322,'string','Navini-AVPair',NULL,NULL,'Navini',NULL,NULL,NULL,NULL),
                                (2323,'string','Riverstone-Command',NULL,NULL,'Riverstone',NULL,NULL,NULL,NULL),
                                (2324,'string','Riverstone-System-Event',NULL,NULL,'Riverstone',NULL,NULL,NULL,NULL),
                                (2325,'string','Riverstone-SNMP-Config-Change',NULL,NULL,'Riverstone',NULL,NULL,NULL,NULL),
                                (2326,'integer','Riverstone-User-Level',NULL,NULL,'Riverstone',NULL,NULL,NULL,NULL),
                                (2327,'string','ASN-IP-Pool-Name',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2328,'integer','ASN-Kbps-Down',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2329,'integer','ASN-Kbps-Down-Localmedia',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2330,'integer','ASN-Kbps-Up',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2331,'integer','ASN-Pps-Down',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2332,'integer','ASN-Pps-Up',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2333,'integer','ASN-TCP-Connlimit',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2334,'integer','ASN-Firewall-Available',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2335,NULL,'ASN-Firewall-Available','Yes',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2336,NULL,'ASN-Firewall-Available','No',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2337,'integer','ASN-Firewall-State',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2338,NULL,'ASN-Firewall-State','Enabled',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2339,NULL,'ASN-Firewall-State','Disabled',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2340,'integer','ASN-Firewall-Block-Ping',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2341,NULL,'ASN-Firewall-Block-Ping','Enabled',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2342,NULL,'ASN-Firewall-Block-Ping','Disabled',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2343,'string','ASN-Firewall-Open',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2344,'integer','ASN-QoS-Available',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2345,NULL,'ASN-QoS-Available','Yes',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2346,NULL,'ASN-QoS-Available','No',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2347,'integer','ASN-QoS-State',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2348,NULL,'ASN-QoS-State','Enabled',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2349,NULL,'ASN-QoS-State','Disabled',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2350,'string','ASN-IP-Redirect',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2351,'integer','ASN-Webfilter-Mode',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2352,NULL,'ASN-Webfilter-Mode','Deny',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2353,NULL,'ASN-Webfilter-Mode','Allow',NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2354,'string','ASN-Webfilter-Redirect',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2355,'string','ASN-Webfilter-Destination',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2356,'string','ASN-Webfilter-Domain',NULL,NULL,'ASN',NULL,NULL,NULL,NULL),
                                (2357,'integer','Xylan-Auth-Group',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2358,'string','Xylan-Slot-Port',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2359,'string','Xylan-Time-of-Day',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2360,'ipaddr','Xylan-Client-IP-Addr',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2361,'string','Xylan-Group-Desc',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2362,'string','Xylan-Port-Desc',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2363,'integer','Xylan-Profil-Numb',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2364,'string','Xylan-Auth-Group-Protocol',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2365,'string','Xylan-Asa-Access',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2366,'integer','Xylan-Access-Priv',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2367,'octets','Xylan-Acce-Priv-R1',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2368,'octets','Xylan-Acce-Priv-R2',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2369,'octets','Xylan-Acce-Priv-W1',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2370,'octets','Xylan-Acce-Priv-W2',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2371,'octets','Xylan-Acce-Priv-G1',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2372,'octets','Xylan-Acce-Priv-G2',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2373,'octets','Xylan-Acce-Priv-F-R1',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2374,'octets','Xylan-Acce-Priv-F-R2',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2375,'octets','Xylan-Acce-Priv-F-W1',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2376,'octets','Xylan-Acce-Priv-F-W2',NULL,NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2377,NULL,'Xylan-Access-Priv','Xylan-Read-Priv',NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2378,NULL,'Xylan-Access-Priv','Xylan-Write-Priv',NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2379,NULL,'Xylan-Access-Priv','Xylan-Admin-Priv',NULL,'Xylan',NULL,NULL,NULL,NULL),
                                (2380,'string','Fortinet-Group-Name',NULL,NULL,'Fortinet',NULL,NULL,NULL,NULL),
                                (2381,'ipaddr','Fortinet-Client-IP-Address',NULL,NULL,'Fortinet',NULL,NULL,NULL,NULL),
                                (2382,'string','Fortinet-Vdom-Name',NULL,NULL,'Fortinet',NULL,NULL,NULL,NULL),
                                (2383,'ipaddr','RedCreek-Tunneled-IP-Addr',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2384,'ipaddr','RedCreek-Tunneled-IP-Netmask',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2385,'ipaddr','RedCreek-Tunneled-Gateway',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2386,'string','RedCreek-Tunneled-DNS-Server',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2387,'string','RedCreek-Tunneled-WINS-Server1',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2388,'string','RedCreek-Tunneled-WINS-Server2',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2389,'string','RedCreek-Tunneled-HostName',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2390,'string','RedCreek-Tunneled-DomainName',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2391,'string','RedCreek-Tunneled-Search-List',NULL,NULL,'RedCreek',NULL,NULL,NULL,NULL),
                                (2392,'string','Colubris-AVPair',NULL,NULL,'Colubris',NULL,NULL,NULL,NULL),
                                (2393,'integer','Colubris-Intercept',NULL,NULL,'Colubris',NULL,NULL,NULL,NULL),
                                (2394,'integer','CBBSM-Bandwidth',NULL,NULL,'Cisco-BBSM',NULL,NULL,NULL,NULL),
                                (2395,'string','WISPr-Location-ID',NULL,NULL,'WISPr',':=','check','','Location ID is set to the radiuslocationid option if present. Should be in the format: isocc=<ISO_Country_Code>, cc=<E.164_Country_Code>,ac=<E.164_Area_Code>,network=<ssid/ZONE>'),
                                (2396,'string','WISPr-Location-Name',NULL,NULL,'WISPr','','check','','Location Name is set to the radiuslocationname option if present. Should be in the format: <HOTSPOT_OPERATOR_NAME>,<LOCATION>'),
                                (2397,'string','WISPr-Logoff-URL',NULL,NULL,'WISPr','=','check','','Chilli includes this attribute in Access-Request messages in order to notify the operator of the log off URL to use for logging off clients. Defaults to \"http://192.168.182.1:3990/logoff\".'),
                                (2398,'string','WISPr-Redirection-URL',NULL,NULL,'WISPr','=','reply','','If present the client will be redirected to this URL once authenticated. This URL should include a link to WISPr-Logoff-URL in order to enable the client to log off.'),
                                (2399,'integer','WISPr-Bandwidth-Min-Up',NULL,NULL,'WISPr',':=','reply','bitspersecond','WISPr vendor specific attributes for setting the minimum bandwidth rate in bits per second.'),
                                (2400,'integer','WISPr-Bandwidth-Min-Down',NULL,NULL,'WISPr',':=','reply','bitspersecond','WISPr vendor specific attributes for setting the minimum bandwidth rate in bits per second.'),
                                (2401,'integer','WISPr-Bandwidth-Max-Up',NULL,NULL,'WISPr',':=','reply','bitspersecond','Maximum transmit rate (b/s). Limits the bandwidth of the connection. Note that this attribute is specified in bits per second. For example (256000)'),
                                (2402,'integer','WISPr-Bandwidth-Max-Down',NULL,NULL,'WISPr',':=','reply','bitspersecond','Maximum receive rate (b/s). Limits the bandwidth of the connection. Note that this attribute is specified in bits per second. For example (256000)'),
                                (2403,'string','WISPr-Session-Terminate-Time',NULL,NULL,'WISPr','=','reply','','The time when the user should be disconnected in ISO 8601 format (YYYY-MM-DDThh:mm:ssTZD). If TZD is not specified local time is assumed. For example a disconnect on 18 December 2001 at 7:00 PM UTC would be specified as 2001-12-18T19:00:00+00:00.'),
                                (2404,'string','WISPr-Session-Terminate-End-Of-Day',NULL,NULL,'WISPr',NULL,NULL,NULL,NULL),
                                (2405,'string','WISPr-Billing-Class-Of-Service',NULL,NULL,'WISPr',NULL,NULL,NULL,NULL),
                                (2406,NULL,'Service-Type','Sip-session',NULL,'dictionary.columbia_university',NULL,NULL,NULL,NULL),
                                (2407,'integer','Sip-Method',NULL,NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2408,'string','Sip-From',NULL,NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2409,'string','Sip-To',NULL,NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2410,'string','Sip-Translated-Request-URI',NULL,NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2411,NULL,'Sip-Method','INVITE',NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2412,NULL,'Sip-Method','BYE',NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2413,NULL,'Sip-Method','REGISTER',NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2414,NULL,'Sip-Method','OTHER',NULL,'Columbia-University',NULL,NULL,NULL,NULL),
                                (2415,'string','ADSL-Agent-Circuit-Id',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2416,'string','ADSL-Agent-Remote-Id',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2417,'integer','Actual-Data-Rate-Upstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2418,'integer','Actual-Data-Rate-Downstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2419,'integer','Minimum-Data-Rate-Upstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2420,'integer','Minimum-Data-Rate-Downstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2421,'integer','Attainable-Data-Rate-Upstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2422,'integer','Attainable-Data-Rate-Downstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2423,'integer','Maximum-Data-Rate-Upstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2424,'integer','Maximum-Data-Rate-Downstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2425,'integer','Minimum-Data-Rate-Upstream-Low-Power',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2426,'integer','Minimum-Data-Rate-Downstream-Low-Power',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2427,'integer','Maximum-Interleaving-Delay-Upstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2428,'integer','Actual-Interleaving-Delay-Upstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2429,'integer','Maximum-Interleaving-Delay-Downstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2430,'integer','Actual-Interleaving-Delay-Downstream',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2431,'octets','Access-Loop-Encapsulation',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2432,'octets','IWF-Session',NULL,NULL,'ADSL-Forum',NULL,NULL,NULL,NULL),
                                (2433,'string','Alvariaon-VSA-1',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2434,'string','Alvariaon-VSA-2',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2435,'string','Alvariaon-VSA-3',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2436,'string','Alvariaon-VSA-4',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2437,'string','Alvariaon-VSA-5',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2438,'string','Alvariaon-VSA-6',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2439,'string','Alvariaon-VSA-7',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2440,'string','Alvariaon-VSA-8',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2441,'string','Alvariaon-VSA-9',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2442,'string','Alvariaon-VSA-10',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2443,'string','Alvariaon-VSA-11',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2444,'string','Alvariaon-VSA-12',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2445,'string','Alvariaon-VSA-13',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2446,'string','Alvariaon-VSA-14',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2447,'string','Alvariaon-VSA-15',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2448,'string','Alvariaon-VSA-16',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2449,'string','Alvariaon-VSA-17',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2450,'string','Alvariaon-VSA-18',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2451,'string','Alvariaon-VSA-19',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2452,'string','Alvariaon-VSA-20',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2453,'string','Alvariaon-VSA-21',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2454,'string','Alvariaon-VSA-22',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2455,'string','Alvariaon-VSA-23',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2456,'string','Alvariaon-VSA-24',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2457,'string','Alvariaon-VSA-25',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2458,'string','Alvariaon-VSA-26',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2459,'string','Alvariaon-VSA-27',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2460,'string','Alvariaon-VSA-28',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2461,'string','Alvariaon-VSA-29',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2462,'string','Alvariaon-VSA-30',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2463,'string','Alvariaon-VSA-31',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2464,'string','Alvariaon-VSA-32',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2465,'string','Alvariaon-VSA-33',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2466,'string','Alvariaon-VSA-34',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2467,'string','Alvariaon-VSA-35',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2468,'string','Alvariaon-VSA-36',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2469,'string','Alvariaon-VSA-37',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2470,'string','Alvariaon-VSA-38',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2471,'string','Alvariaon-VSA-39',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2472,'string','Alvariaon-VSA-40',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2473,'string','Alvariaon-VSA-41',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2474,'string','Alvariaon-VSA-42',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2475,'string','Alvariaon-VSA-43',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2476,'string','Alvariaon-VSA-44',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2477,'string','Alvariaon-VSA-45',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2478,'string','Alvariaon-VSA-46',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2479,'string','Alvariaon-VSA-47',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2480,'string','Alvariaon-VSA-48',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2481,'string','Alvariaon-VSA-49',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2482,'string','Alvariaon-VSA-50',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2483,'string','Alvariaon-VSA-51',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2484,'string','Alvariaon-VSA-52',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2485,'string','Alvariaon-VSA-53',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2486,'string','Alvariaon-VSA-54',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2487,'string','Alvariaon-VSA-55',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2488,'string','Alvariaon-VSA-56',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2489,'string','Alvariaon-VSA-57',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2490,'string','Alvariaon-VSA-58',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2491,'string','Alvariaon-VSA-59',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2492,'string','Alvariaon-VSA-60',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2493,'string','Alvariaon-VSA-61',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2494,'string','Alvariaon-VSA-62',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2495,'string','Alvariaon-VSA-63',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2496,'string','Alvariaon-VSA-64',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2497,'string','Alvariaon-VSA-65',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2498,'string','Alvariaon-VSA-66',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2499,'string','Alvariaon-VSA-67',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2500,'string','Alvariaon-VSA-68',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2501,'string','Alvariaon-VSA-69',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2502,'string','Alvariaon-VSA-70',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2503,'string','Alvariaon-VSA-71',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2504,'string','Alvariaon-VSA-72',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2505,'string','Alvariaon-VSA-73',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2506,'string','Alvariaon-VSA-74',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2507,'string','Alvariaon-VSA-75',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2508,'string','Alvariaon-VSA-76',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2509,'string','Alvariaon-VSA-77',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2510,'string','Alvariaon-VSA-78',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2511,'string','Alvariaon-VSA-79',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2512,'string','Alvariaon-VSA-80',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2513,'string','Alvariaon-VSA-81',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2514,'string','Alvariaon-VSA-82',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2515,'string','Alvariaon-VSA-83',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2516,'string','Alvariaon-VSA-84',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2517,'string','Alvariaon-VSA-85',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2518,'string','Alvariaon-VSA-86',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2519,'string','Alvariaon-VSA-87',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2520,'string','Alvariaon-VSA-88',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2521,'string','Alvariaon-VSA-89',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2522,'string','Alvariaon-VSA-90',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2523,'string','Alvariaon-VSA-91',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2524,'string','Alvariaon-VSA-92',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2525,'string','Alvariaon-VSA-93',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2526,'string','Alvariaon-VSA-94',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2527,'string','Alvariaon-VSA-95',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2528,'string','Alvariaon-VSA-96',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2529,'string','Alvariaon-VSA-97',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2530,'string','Alvariaon-VSA-98',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2531,'string','Alvariaon-VSA-99',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2532,'string','Alvariaon-VSA-100',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2533,'string','Alvariaon-VSA-101',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2534,'string','Alvariaon-VSA-102',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2535,'string','Alvariaon-VSA-103',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2536,'string','Alvariaon-VSA-104',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2537,'string','Alvariaon-VSA-105',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2538,'string','Alvariaon-VSA-106',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2539,'string','Alvariaon-VSA-107',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2540,'string','Alvariaon-VSA-108',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2541,'string','Alvariaon-VSA-109',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2542,'string','Alvariaon-VSA-110',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2543,'string','Alvariaon-VSA-111',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2544,'string','Alvariaon-VSA-112',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2545,'string','Alvariaon-VSA-113',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2546,'string','Alvariaon-VSA-114',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2547,'string','Alvariaon-VSA-115',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2548,'string','Alvariaon-VSA-116',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2549,'string','Alvariaon-VSA-117',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2550,'string','Alvariaon-VSA-118',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2551,'string','Alvariaon-VSA-119',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2552,'string','Alvariaon-VSA-120',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2553,'string','Alvariaon-VSA-121',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2554,'string','Alvariaon-VSA-122',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2555,'string','Alvariaon-VSA-123',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2556,'string','Alvariaon-VSA-124',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2557,'string','Alvariaon-VSA-125',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2558,'string','Alvariaon-VSA-126',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2559,'string','Alvariaon-VSA-127',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2560,'string','Alvariaon-VSA-128',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2561,'string','Alvariaon-VSA-129',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2562,'string','Alvariaon-VSA-130',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2563,'string','Alvariaon-VSA-131',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2564,'string','Alvariaon-VSA-132',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2565,'string','Alvariaon-VSA-133',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2566,'string','Alvariaon-VSA-134',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2567,'string','Alvariaon-VSA-135',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2568,'string','Alvariaon-VSA-136',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2569,'string','Alvariaon-VSA-137',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2570,'string','Alvariaon-VSA-138',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2571,'string','Alvariaon-VSA-139',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2572,'string','Alvariaon-VSA-140',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2573,'string','Alvariaon-VSA-141',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2574,'string','Alvariaon-VSA-142',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2575,'string','Alvariaon-VSA-143',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2576,'string','Alvariaon-VSA-144',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2577,'string','Alvariaon-VSA-145',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2578,'string','Alvariaon-VSA-146',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2579,'string','Alvariaon-VSA-147',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2580,'string','Alvariaon-VSA-148',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2581,'string','Alvariaon-VSA-149',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2582,'string','Alvariaon-VSA-150',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2583,'string','Alvariaon-VSA-151',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2584,'string','Alvariaon-VSA-152',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2585,'string','Alvariaon-VSA-153',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2586,'string','Alvariaon-VSA-154',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2587,'string','Alvariaon-VSA-155',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2588,'string','Alvariaon-VSA-156',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2589,'string','Alvariaon-VSA-157',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2590,'string','Alvariaon-VSA-158',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2591,'string','Alvariaon-VSA-159',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2592,'string','Alvariaon-VSA-160',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2593,'string','Alvariaon-VSA-161',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2594,'string','Alvariaon-VSA-162',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2595,'string','Alvariaon-VSA-163',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2596,'string','Alvariaon-VSA-164',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2597,'string','Alvariaon-VSA-165',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2598,'string','Alvariaon-VSA-166',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2599,'string','Alvariaon-VSA-167',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2600,'string','Alvariaon-VSA-168',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2601,'string','Alvariaon-VSA-169',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2602,'string','Alvariaon-VSA-170',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2603,'string','Alvariaon-VSA-171',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2604,'string','Alvariaon-VSA-172',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2605,'string','Alvariaon-VSA-173',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2606,'string','Alvariaon-VSA-174',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2607,'string','Alvariaon-VSA-175',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2608,'string','Alvariaon-VSA-176',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2609,'string','Alvariaon-VSA-177',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2610,'string','Alvariaon-VSA-178',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2611,'string','Alvariaon-VSA-179',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2612,'string','Alvariaon-VSA-180',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2613,'string','Alvariaon-VSA-181',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2614,'string','Alvariaon-VSA-182',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2615,'string','Alvariaon-VSA-183',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2616,'string','Alvariaon-VSA-184',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2617,'string','Alvariaon-VSA-185',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2618,'string','Alvariaon-VSA-186',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2619,'string','Alvariaon-VSA-187',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2620,'string','Alvariaon-VSA-188',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2621,'string','Alvariaon-VSA-189',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2622,'string','Alvariaon-VSA-190',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2623,'string','Alvariaon-VSA-191',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2624,'string','Alvariaon-VSA-192',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2625,'string','Alvariaon-VSA-193',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2626,'string','Alvariaon-VSA-194',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2627,'string','Alvariaon-VSA-195',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2628,'string','Alvariaon-VSA-196',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2629,'string','Alvariaon-VSA-197',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2630,'string','Alvariaon-VSA-198',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2631,'string','Alvariaon-VSA-199',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2632,'string','Alvariaon-VSA-200',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2633,'string','Alvariaon-VSA-201',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2634,'string','Alvariaon-VSA-202',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2635,'string','Alvariaon-VSA-203',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2636,'string','Alvariaon-VSA-204',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2637,'string','Alvariaon-VSA-205',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2638,'string','Alvariaon-VSA-206',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2639,'string','Alvariaon-VSA-207',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2640,'string','Alvariaon-VSA-208',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2641,'string','Alvariaon-VSA-209',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2642,'string','Alvariaon-VSA-210',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2643,'string','Alvariaon-VSA-211',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2644,'string','Alvariaon-VSA-212',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2645,'string','Alvariaon-VSA-213',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2646,'string','Alvariaon-VSA-214',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2647,'string','Alvariaon-VSA-215',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2648,'string','Alvariaon-VSA-216',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2649,'string','Alvariaon-VSA-217',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2650,'string','Alvariaon-VSA-218',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2651,'string','Alvariaon-VSA-219',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2652,'string','Alvariaon-VSA-220',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2653,'string','Alvariaon-VSA-221',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2654,'string','Alvariaon-VSA-222',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2655,'string','Alvariaon-VSA-223',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2656,'string','Alvariaon-VSA-224',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2657,'string','Alvariaon-VSA-225',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2658,'string','Alvariaon-VSA-226',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2659,'string','Alvariaon-VSA-227',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2660,'string','Alvariaon-VSA-228',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2661,'string','Alvariaon-VSA-229',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2662,'string','Alvariaon-VSA-230',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2663,'string','Alvariaon-VSA-231',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2664,'string','Alvariaon-VSA-232',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2665,'string','Alvariaon-VSA-233',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2666,'string','Alvariaon-VSA-234',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2667,'string','Alvariaon-VSA-235',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2668,'string','Alvariaon-VSA-236',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2669,'string','Alvariaon-VSA-237',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2670,'string','Alvariaon-VSA-238',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2671,'string','Alvariaon-VSA-239',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2672,'string','Alvariaon-VSA-240',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2673,'string','Alvariaon-VSA-241',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2674,'string','Alvariaon-VSA-242',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2675,'string','Alvariaon-VSA-243',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2676,'string','Alvariaon-VSA-244',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2677,'string','Alvariaon-VSA-245',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2678,'string','Alvariaon-VSA-246',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2679,'string','Alvariaon-VSA-247',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2680,'string','Alvariaon-VSA-248',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2681,'string','Alvariaon-VSA-249',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2682,'string','Alvariaon-VSA-250',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2683,'string','Alvariaon-VSA-251',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2684,'string','Alvariaon-VSA-252',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2685,'string','Alvariaon-VSA-253',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2686,'string','Alvariaon-VSA-254',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2687,'string','Alvariaon-VSA-255',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2688,'string','Breezecom-Attr1',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2689,'string','Breezecom-Attr2',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2690,'string','Breezecom-Attr3',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2691,'string','Breezecom-Attr4',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2692,'string','Breezecom-Attr5',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2693,'string','Breezecom-Attr6',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2694,'string','Breezecom-Attr7',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2695,'string','Breezecom-Attr8',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2696,'string','Breezecom-Attr9',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2697,'string','Breezecom-Attr10',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2698,'string','Breezecom-Attr11',NULL,NULL,'Alvarion',NULL,NULL,NULL,NULL),
                                (2699,'string','Acct-Tunnel-Connection',NULL,NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2700,'integer','Acct-Tunnel-Packets-Lost',NULL,NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2701,NULL,'Acct-Status-Type','Tunnel-Start',NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2702,NULL,'Acct-Status-Type','Tunnel-Stop',NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2703,NULL,'Acct-Status-Type','Tunnel-Reject',NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2704,NULL,'Acct-Status-Type','Tunnel-Link-Start',NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2705,NULL,'Acct-Status-Type','Tunnel-Link-Stop',NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2706,NULL,'Acct-Status-Type','Tunnel-Link-Reject',NULL,'dictionary.rfc2867',NULL,NULL,NULL,NULL),
                                (2707,'string','LE-Terminate-Detail',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2708,'string','LE-Advice-of-Charge',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2709,'string','LE-Connect-Detail',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2710,'string','LE-IP-Pool',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2711,'ipaddr','LE-IP-Gateway',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2712,'string','LE-Modem-Info',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2713,'integer','LE-IPSec-Log-Options',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2714,'integer','LE-IPSec-Deny-Action',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2715,'string','LE-IPSec-Active-Profile',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2716,'string','LE-IPSec-Outsource-Profile',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2717,'string','LE-IPSec-Passive-Profile',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2718,'integer','LE-NAT-TCP-Session-Timeout',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2719,'integer','LE-NAT-Other-Session-Timeout',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2720,'integer','LE-NAT-Log-Options',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2721,'integer','LE-NAT-Sess-Dir-Fail-Action',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2722,'string','LE-NAT-Inmap',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2723,'string','LE-NAT-Outmap',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2724,'string','LE-NAT-Outsource-Inmap',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2725,'string','LE-NAT-Outsource-Outmap',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2726,'string','LE-Admin-Group',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2727,'integer','LE-Multicast-Client',NULL,NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2728,NULL,'LE-IPSec-Deny-Action','Drop',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2729,NULL,'LE-IPSec-Deny-Action','ICMP-Reject',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2730,NULL,'LE-IPSec-Deny-Action','Pass-Through',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2731,NULL,'LE-IPSec-Log-Options','SA-Success-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2732,NULL,'LE-IPSec-Log-Options','SA-Failure-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2733,NULL,'LE-IPSec-Log-Options','Console-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2734,NULL,'LE-IPSec-Log-Options','Syslog-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2735,NULL,'LE-IPSec-Log-Options','SA-Success-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2736,NULL,'LE-IPSec-Log-Options','SA-Failure-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2737,NULL,'LE-IPSec-Log-Options','Console-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2738,NULL,'LE-IPSec-Log-Options','Syslog-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2739,NULL,'LE-NAT-Sess-Dir-Fail-Action','Drop',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2740,NULL,'LE-NAT-Sess-Dir-Fail-Action','ICMP-Reject',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2741,NULL,'LE-NAT-Sess-Dir-Fail-Action','Pass-Through',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2742,NULL,'LE-NAT-Log-Options','Session-Success-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2743,NULL,'LE-NAT-Log-Options','Session-Failure-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2744,NULL,'LE-NAT-Log-Options','Console-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2745,NULL,'LE-NAT-Log-Options','Syslog-On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2746,NULL,'LE-NAT-Log-Options','Success-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2747,NULL,'LE-NAT-Log-Options','Failure-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2748,NULL,'LE-NAT-Log-Options','Console-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2749,NULL,'LE-NAT-Log-Options','Syslog-Off',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2750,NULL,'LE-Multicast-Client','On',NULL,'Livingston',NULL,NULL,NULL,NULL),
                                (2751,'integer','Extreme-CLI-Authorization',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2752,'string','Extreme-Shell-Command',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2753,'string','Extreme-Netlogin-Vlan',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2754,'string','Extreme-Netlogin-Url',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2755,'string','Extreme-Netlogin-Url-Desc',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2756,'integer','Extreme-Netlogin-Only',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2757,'string','Extreme-User-Location',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2758,'integer','Extreme-Netlogin-Vlan-Tag',NULL,NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2759,NULL,'Extreme-CLI-Authorization','Disabled',NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2760,NULL,'Extreme-CLI-Authorization','Enabled',NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2761,NULL,'Extreme-Netlogin-Only','Disabled',NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2762,NULL,'Extreme-Netlogin-Only','Enabled',NULL,'Extreme',NULL,NULL,NULL,NULL),
                                (2763,'string','3GPP-IMSI',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2764,'integer','3GPP-Charging-ID',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2765,'integer','3GPP-PDP-Type',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2766,'ipaddr','3GPP-Charging-Gateway-Address',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2767,'string','3GPP-GPRS-Negotiated-QoS-profile',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2768,'ipaddr','3GPP-SGSN-Address',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2769,'ipaddr','3GPP-GGSN-Address',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2770,'string','3GPP-IMSI-MCC-MNC',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2771,'string','3GPP-GGSN-MCC-MNC',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2772,'string','3GPP-NSAPI',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2773,'octets','3GPP-Session-Stop-Indicator',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2774,'string','3GPP-Selection-Mode',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2775,'string','3GPP-Charging-Characteristics',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2776,'ipv6addr','3GPP-Charging-Gateway-IPv6-Address',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2777,'ipv6addr','3GPP-SGSN-IPv6-Address',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2778,'ipv6addr','3GPP-GGSN-IPv6-Address',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2779,'octets','3GPP-IPv6-DNS-Servers',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2780,'string','3GPP-SGSN-MCC-MNC',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2781,'octets','3GPP-Teardown-Indicator',NULL,NULL,'3GPP',NULL,NULL,NULL,NULL),
                                (2782,'string','Cosine-Connection-Profile-Name',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2783,'string','Cosine-Enterprise-ID',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2784,'string','Cosine-Address-Pool-Name',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2785,'integer','Cosine-DS-Byte',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2786,'octets','Cosine-VPI-VCI',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2787,'integer','Cosine-DLCI',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2788,'ipaddr','Cosine-LNS-IP-Address',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2789,'string','Cosine-CLI-User-Permission-ID',NULL,NULL,'Cosine',NULL,NULL,NULL,NULL),
                                (2790,'string','Digest-Response',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2791,'octets','Digest-Attributes',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2792,'string','Digest-Realm',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2793,'string','Digest-Nonce',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2794,'string','Digest-Method',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2795,'string','Digest-URI',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2796,'string','Digest-QOP',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2797,'string','Digest-Algorithm',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2798,'string','Digest-Body-Digest',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2799,'string','Digest-CNonce',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2800,'string','Digest-Nonce-Count',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2801,'string','Digest-User-Name',NULL,NULL,'dictionary.rfc4590',NULL,NULL,NULL,NULL),
                                (2802,'integer','Waverider-Grade-Of-Service',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2803,'integer','Waverider-Priority-Enabled',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2804,'string','Waverider-Current-Password',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2805,'string','Waverider-New-Password',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2806,'integer','Waverider-Radio-Frequency',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2807,'string','Waverider-SNMP-Read-Community',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2808,'string','Waverider-SNMP-Write-Community',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2809,'string','Waverider-SNMP-Trap-Server',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2810,'string','Waverider-SNMP-Contact',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2811,'string','Waverider-SNMP-Location',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2812,'string','Waverider-SNMP-Name',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2813,'integer','Waverider-Max-Customers',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2814,'integer','Waverider-Rf-Power',NULL,NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2815,NULL,'Waverider-Grade-Of-Service','be',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2816,NULL,'Waverider-Grade-Of-Service','bronze',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2817,NULL,'Waverider-Grade-Of-Service','silver',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2818,NULL,'Waverider-Grade-Of-Service','gold',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2819,NULL,'Waverider-Priority-Enabled','disabled',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2820,NULL,'Waverider-Priority-Enabled','enabled',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2821,NULL,'Waverider-Radio-Frequency','auto',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2822,NULL,'Waverider-Radio-Frequency','nomadic',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2823,NULL,'Waverider-Radio-Frequency','f_9050',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2824,NULL,'Waverider-Radio-Frequency','f_9116',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2825,NULL,'Waverider-Radio-Frequency','f_9184',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2826,NULL,'Waverider-Radio-Frequency','f_9250',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2827,NULL,'Waverider-Radio-Frequency','f_9084',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2828,NULL,'Waverider-Radio-Frequency','f_9150',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2829,NULL,'Waverider-Radio-Frequency','f_9216',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2830,NULL,'Waverider-Rf-Power','p_15',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2831,NULL,'Waverider-Rf-Power','p_16',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2832,NULL,'Waverider-Rf-Power','p_17',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2833,NULL,'Waverider-Rf-Power','p_18',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2834,NULL,'Waverider-Rf-Power','p_19',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2835,NULL,'Waverider-Rf-Power','p_20',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2836,NULL,'Waverider-Rf-Power','p_21',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2837,NULL,'Waverider-Rf-Power','p_22',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2838,NULL,'Waverider-Rf-Power','p_23',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2839,NULL,'Waverider-Rf-Power','p_24',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2840,NULL,'Waverider-Rf-Power','p_25',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2841,NULL,'Waverider-Rf-Power','p_26',NULL,'Waverider',NULL,NULL,NULL,NULL),
                                (2842,'integer','SS3-Firewall-User-Privilege',NULL,NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2843,'integer','SonicWall-User-Privilege',NULL,NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2844,NULL,'SonicWall-User-Privilege','Remote-Access',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2845,NULL,'SonicWall-User-Privilege','Bypass-Filters',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2846,NULL,'SonicWall-User-Privilege','VPN-Client-Access',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2847,NULL,'SonicWall-User-Privilege','Access-To-VPN',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2848,NULL,'SonicWall-User-Privilege','Limited-Management',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2849,NULL,'SonicWall-User-Privilege','L2TP-Client-Access',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2850,NULL,'SonicWall-User-Privilege','Wireless-Guest',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2851,NULL,'SonicWall-User-Privilege','Wireless-Add-ACL',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2852,NULL,'SonicWall-User-Privilege','Internet-Access',NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2853,'string','SonicWall-User-Group',NULL,NULL,'SonicWall',NULL,NULL,NULL,NULL),
                                (2854,'string','Garderos-Location-Name',NULL,NULL,'Garderos',NULL,NULL,NULL,NULL),
                                (2855,'string','Garderos-Service-Name',NULL,NULL,'Garderos',NULL,NULL,NULL,NULL),
                                (2856,'string','Garderos-MSISDN',NULL,NULL,'Garderos',NULL,NULL,NULL,NULL),
                                (2857,'string','Garderos-Proxy',NULL,NULL,'Garderos',NULL,NULL,NULL,NULL),
                                (2858,NULL,'Acct-Status-Type','WB-Login',NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2859,NULL,'Acct-Status-Type','WB-Logout',NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2860,NULL,'Acct-Status-Type','WB-WRitelog',NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2861,'integer','WB-AUTH-Time-Left',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2862,'integer','WB-Auth-Accum-BW',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2863,'integer','WB-Auth-BW-Quota',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2864,'integer','WB-Auth-BW-Count',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2865,'integer','WB-Auth-Upload-Limit',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2866,'integer','WB-Auth-Download-Limit',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2867,'integer','WB-Auth-Login-Time',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2868,'integer','WB-Auth-Logout-Time',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2869,'integer','WB-Auth-Time-Diff',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2870,'integer','WB-Auth-BW-Usage',NULL,NULL,'Walabi',NULL,NULL,NULL,NULL),
                                (2871,'string','Issanni-SoftFlow-Template',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2872,'string','Issanni-NAT-Support',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2873,'string','Issanni-Routing-Context',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2874,'string','Issanni-Tunnel-Name',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2875,'string','Issanni-IP-Pool-Name',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2876,'string','Issanni-PPPoE-URL',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2877,'string','Issanni-PPPoE-MOTM',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2878,'string','Issanni-Service',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2879,'ipaddr','Issanni-Pri-DNS',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2880,'ipaddr','Issanni-Sec-DNS',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2881,'ipaddr','Issanni-Pri-NBNS',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2882,'ipaddr','Issanni-Sec-NBNS',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2883,'string','Issanni-Traffic-Class',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2884,'integer','Issanni-Tunnel-Type',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2885,'integer','Issanni-NAT-Type',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2886,'string','Issanni-QOS-Class',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2887,'string','Issanni-Interface-Name',NULL,NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2888,NULL,'Issanni-Tunnel-Type','IP-IP',NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2889,NULL,'Issanni-Tunnel-Type','ESP',NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2890,NULL,'Issanni-Tunnel-Type','L2TP',NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2891,NULL,'Issanni-NAT-Type','NAT',NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2892,NULL,'Issanni-NAT-Type','NAPT',NULL,'Issanni',NULL,NULL,NULL,NULL),
                                (2893,'string','Alteon-Group-Mapping',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2894,'integer','Alteon-VPN-Id',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2895,'string','Alteon-Client-IP-Address',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2896,'string','Alteon-Client-Netmask',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2897,'string','Alteon-Primary-NBNS-Server',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2898,'string','Alteon-Secondary-NBNS-Server',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2899,'string','Alteon-Primary-DNS-Server',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2900,'string','Alteon-Secondary-DNS-Server',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2901,'string','Alteon-Domain-Name',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2902,'integer','Alteon-Service-Type',NULL,NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2903,NULL,'Alteon-Service-Type','Alteon-L4admin',NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2904,NULL,'Alteon-Service-Type','Alteon-Slbadmin',NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2905,NULL,'Alteon-Service-Type','Alteon-Oper',NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2906,NULL,'Alteon-Service-Type','Alteon-L4oper',NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2907,NULL,'Alteon-Service-Type','Alteon-Slboper',NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2908,NULL,'Alteon-Service-Type','Alteon-User',NULL,'Alteon',NULL,NULL,NULL,NULL),
                                (2909,'string','Merit-Proxy-Action',NULL,NULL,'Merit',NULL,NULL,NULL,NULL),
                                (2910,'string','Merit-User-Id',NULL,NULL,'Merit',NULL,NULL,NULL,NULL),
                                (2911,'string','Merit-User-Realm',NULL,NULL,'Merit',NULL,NULL,NULL,NULL),
                                (2912,'string','Altiga-Access-Hours-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2913,'integer','Altiga-Simultaneous-Logins-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2914,'integer','Altiga-Min-Password-Length-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2915,'integer','Altiga-Allow-Alpha-Only-Passwords-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2916,'ipaddr','Altiga-Primary-DNS-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2917,'ipaddr','Altiga-Secondary-DNS-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2918,'ipaddr','Altiga-Primary-WINS-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2919,'ipaddr','Altiga-Secondary-WINS-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2920,'integer','Altiga-SEP-Card-Assignment-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2921,'integer','Altiga-Priority-on-SEP-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2922,'integer','Altiga-Tunneling-Protocols-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2923,'string','Altiga-IPSec-Sec-Association-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2924,'integer','Altiga-IPSec-Authentication-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2925,'string','Altiga-IPSec-Banner-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2926,'integer','Altiga-IPSec-Allow-Passwd-Store-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2927,'integer','Altiga-Use-Client-Address-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2928,'integer','Altiga-PPTP-Min-Authentication-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2929,'integer','Altiga-L2TP-Min-Authentication-G/U',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2930,'integer','Altiga-PPTP-Encryption-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2931,'integer','Altiga-L2TP-Encryption-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2932,'integer','Altiga-IPSec-L2L-Keepalives-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2933,'string','Altiga-IPSec-Split-Tunnel-List-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2934,'string','Altiga-IPSec-Default-Domain-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2935,'string','Altiga-IPSec-Secondary-Domains-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2936,'integer','Altiga-IPSec-Tunnel-Type-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2937,'integer','Altiga-IPSec-Mode-Config-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2938,'integer','Altiga-IPSec-User-Group-Lock-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2939,'integer','Altiga-IPSec-Over-NAT-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2940,'integer','Altiga-IPSec-Over-NAT-Port-Num-G',NULL,NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2941,NULL,'Altiga-Allow-Alpha-Only-Passwords-G','Allow',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2942,NULL,'Altiga-Allow-Alpha-Only-Passwords-G','Disallow',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2943,NULL,'Altiga-SEP-Card-Assignment-G/U','SEP1',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2944,NULL,'Altiga-SEP-Card-Assignment-G/U','SEP2',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2945,NULL,'Altiga-SEP-Card-Assignment-G/U','SEP3',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2946,NULL,'Altiga-SEP-Card-Assignment-G/U','SEP4',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2947,NULL,'Altiga-SEP-Card-Assignment-G/U','Any-SEP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2948,NULL,'Altiga-Priority-on-SEP-G/U','High',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2949,NULL,'Altiga-Priority-on-SEP-G/U','Med-High',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2950,NULL,'Altiga-Priority-on-SEP-G/U','Medium',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2951,NULL,'Altiga-Priority-on-SEP-G/U','Med-Low',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2952,NULL,'Altiga-Priority-on-SEP-G/U','Low',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2953,NULL,'Altiga-Tunneling-Protocols-G/U','PPTP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2954,NULL,'Altiga-Tunneling-Protocols-G/U','L2TP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2955,NULL,'Altiga-Tunneling-Protocols-G/U','IPSec',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2956,NULL,'Altiga-Tunneling-Protocols-G/U','L2TP/IPSec',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2957,NULL,'Altiga-Tunneling-Protocols-G/U','PPTP-and-IPSec',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2958,NULL,'Altiga-Tunneling-Protocols-G/U','All',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2959,NULL,'Altiga-IPSec-Authentication-G','None',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2960,NULL,'Altiga-IPSec-Authentication-G','RADIUS',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2961,NULL,'Altiga-IPSec-Authentication-G','LDAP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2962,NULL,'Altiga-IPSec-Authentication-G','NTDomain',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2963,NULL,'Altiga-IPSec-Authentication-G','SDI',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2964,NULL,'Altiga-IPSec-Authentication-G','Internal',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2965,NULL,'Altiga-IPSec-Allow-Passwd-Store-G/U','Allow',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2966,NULL,'Altiga-IPSec-Allow-Passwd-Store-G/U','Disallow',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2967,NULL,'Altiga-Use-Client-Address-G/U','Allow',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2968,NULL,'Altiga-Use-Client-Address-G/U','Disallow',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2969,NULL,'Altiga-PPTP-Min-Authentication-G/U','PAP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2970,NULL,'Altiga-PPTP-Min-Authentication-G/U','CHAP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2971,NULL,'Altiga-PPTP-Min-Authentication-G/U','EAP-MD5',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2972,NULL,'Altiga-PPTP-Min-Authentication-G/U','EAP-GTC',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2973,NULL,'Altiga-PPTP-Min-Authentication-G/U','EAP-TLS',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2974,NULL,'Altiga-PPTP-Min-Authentication-G/U','MSCHAPv1',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2975,NULL,'Altiga-PPTP-Min-Authentication-G/U','MSCHAPv2',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2976,NULL,'Altiga-PPTP-Min-Authentication-G/U','Default',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2977,NULL,'Altiga-L2TP-Min-Authentication-G/U','PAP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2978,NULL,'Altiga-L2TP-Min-Authentication-G/U','CHAP',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2979,NULL,'Altiga-L2TP-Min-Authentication-G/U','EAP-MD5',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2980,NULL,'Altiga-L2TP-Min-Authentication-G/U','EAP-GTC',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2981,NULL,'Altiga-L2TP-Min-Authentication-G/U','EAP-TLS',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2982,NULL,'Altiga-L2TP-Min-Authentication-G/U','MSCHAPv1',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2983,NULL,'Altiga-L2TP-Min-Authentication-G/U','MSCHAPv2',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2984,NULL,'Altiga-L2TP-Min-Authentication-G/U','Default',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2985,NULL,'Altiga-PPTP-Encryption-G','PPTP-40bit',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2986,NULL,'Altiga-PPTP-Encryption-G','PPTP-40-Encryption-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2987,NULL,'Altiga-PPTP-Encryption-G','PPTP-128',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2988,NULL,'Altiga-PPTP-Encryption-G','PPTP-128-Encryption-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2989,NULL,'Altiga-PPTP-Encryption-G','PPTP-40-or-128',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2990,NULL,'Altiga-PPTP-Encryption-G','PPTP-40-or-128-Encry-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2991,NULL,'Altiga-PPTP-Encryption-G','PPTP-40-Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2992,NULL,'Altiga-PPTP-Encryption-G','PPTP-40-Enc/Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2993,NULL,'Altiga-PPTP-Encryption-G','PPTP-128-Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2994,NULL,'Altiga-PPTP-Encryption-G','PPTP-128-Enc/Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2995,NULL,'Altiga-PPTP-Encryption-G','PPTP-40/128-Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2996,NULL,'Altiga-PPTP-Encryption-G','PPTP-40/128-Enc/Statls-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2997,NULL,'Altiga-L2TP-Encryption-G','L2TP-40bit',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2998,NULL,'Altiga-L2TP-Encryption-G','L2TP-40-Encryption-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (2999,NULL,'Altiga-L2TP-Encryption-G','L2TP-128',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3000,NULL,'Altiga-L2TP-Encryption-G','L2TP-128-Encryption-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3001,NULL,'Altiga-L2TP-Encryption-G','L2TP-40-or-128',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3002,NULL,'Altiga-L2TP-Encryption-G','L2TP-40-or-128-Encry-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3003,NULL,'Altiga-L2TP-Encryption-G','L2TP-40-Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3004,NULL,'Altiga-L2TP-Encryption-G','L2TP-40-Enc/Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3005,NULL,'Altiga-L2TP-Encryption-G','L2TP-128-Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3006,NULL,'Altiga-L2TP-Encryption-G','L2TP-128-Enc/Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3007,NULL,'Altiga-L2TP-Encryption-G','L2TP-40/128-Stateless-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3008,NULL,'Altiga-L2TP-Encryption-G','L2TP-40/128-Enc/Statls-Req',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3009,NULL,'Altiga-IPSec-L2L-Keepalives-G','ON',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3010,NULL,'Altiga-IPSec-L2L-Keepalives-G','OFF',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3011,NULL,'Altiga-IPSec-Tunnel-Type-G','LAN-to-LAN',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3012,NULL,'Altiga-IPSec-Tunnel-Type-G','Remote-Access',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3013,NULL,'Altiga-IPSec-Mode-Config-G','ON',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3014,NULL,'Altiga-IPSec-Mode-Config-G','OFF',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3015,NULL,'Altiga-IPSec-User-Group-Lock-G','ON',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3016,NULL,'Altiga-IPSec-User-Group-Lock-G','OFF',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3017,NULL,'Altiga-IPSec-Over-NAT-G','ON',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3018,NULL,'Altiga-IPSec-Over-NAT-G','OFF',NULL,'Altiga',NULL,NULL,NULL,NULL),
                                (3019,'string','Cisco-AVPair',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3020,'string','Cisco-NAS-Port',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3021,'string','Cisco-Fax-Account-Id-Origin',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3022,'string','Cisco-Fax-Msg-Id',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3023,'string','Cisco-Fax-Pages',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3024,'string','Cisco-Fax-Coverpage-Flag',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3025,'string','Cisco-Fax-Modem-Time',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3026,'string','Cisco-Fax-Connect-Speed',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3027,'string','Cisco-Fax-Recipient-Count',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3028,'string','Cisco-Fax-Process-Abort-Flag',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3029,'string','Cisco-Fax-Dsn-Address',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3030,'string','Cisco-Fax-Dsn-Flag',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3031,'string','Cisco-Fax-Mdn-Address',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3032,'string','Cisco-Fax-Mdn-Flag',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3033,'string','Cisco-Fax-Auth-Status',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3034,'string','Cisco-Email-Server-Address',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3035,'string','Cisco-Email-Server-Ack-Flag',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3036,'string','Cisco-Gateway-Id',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3037,'string','Cisco-Call-Type',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3038,'string','Cisco-Port-Used',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3039,'string','Cisco-Abort-Cause',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3040,'string','h323-remote-address',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3041,'string','h323-conf-id',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3042,'string','h323-setup-time',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3043,'string','h323-call-origin',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3044,'string','h323-call-type',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3045,'string','h323-connect-time',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3046,'string','h323-disconnect-time',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3047,'string','h323-disconnect-cause',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3048,'string','h323-voice-quality',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3049,'string','h323-gw-id',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3050,'string','h323-incoming-conf-id',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3051,'string','h323-credit-amount',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3052,'string','h323-credit-time',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3053,'string','h323-return-code',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3054,'string','h323-prompt-id',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3055,'string','h323-time-and-day',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3056,'string','h323-redirect-number',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3057,'string','h323-preferred-lang',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3058,'string','h323-redirect-ip-address',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3059,'string','h323-billing-model',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3060,'string','h323-currency',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3061,'string','subscriber',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3062,'string','gw-rxd-cdn',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3063,'string','gw-final-xlated-cdn',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3064,'string','remote-media-address',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3065,'string','release-source',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3066,'string','gw-rxd-cgn',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3067,'string','gw-final-xlated-cgn',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3068,'string','call-id',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3069,'string','session-protocol',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3070,'string','method',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3071,'string','prev-hop-via',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3072,'string','prev-hop-ip',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3073,'string','incoming-req-uri',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3074,'string','outgoing-req-uri',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3075,'string','next-hop-ip',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3076,'string','next-hop-dn',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3077,'string','sip-hdr',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3078,'integer','Cisco-Multilink-ID',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3079,'integer','Cisco-Num-In-Multilink',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3080,'integer','Cisco-Pre-Input-Octets',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3081,'integer','Cisco-Pre-Output-Octets',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3082,'integer','Cisco-Pre-Input-Packets',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3083,'integer','Cisco-Pre-Output-Packets',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3084,'integer','Cisco-Maximum-Time',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3085,'integer','Cisco-Disconnect-Cause',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3086,'integer','Cisco-Data-Rate',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3087,'integer','Cisco-PreSession-Time',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3088,'integer','Cisco-PW-Lifetime',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3089,'integer','Cisco-IP-Direct',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3090,'integer','Cisco-PPP-VJ-Slot-Comp',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3091,'integer','Cisco-PPP-Async-Map',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3092,'string','Cisco-IP-Pool-Definition',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3093,'integer','Cisco-Assign-IP-Pool',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3094,'integer','Cisco-Route-IP',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3095,'integer','Cisco-Link-Compression',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3096,'integer','Cisco-Target-Util',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3097,'integer','Cisco-Maximum-Channels',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3098,'integer','Cisco-Data-Filter',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3099,'integer','Cisco-Call-Filter',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3100,'integer','Cisco-Idle-Limit',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3101,'string','Cisco-Account-Info',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3102,'string','Cisco-Service-Info',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3103,'string','Cisco-Command-Code',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3104,'string','Cisco-Control-Info',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3105,'integer','Cisco-Xmit-Rate',NULL,NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3106,NULL,'Cisco-Disconnect-Cause','Unknown',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3107,NULL,'Cisco-Disconnect-Cause','CLID-Authentication-Failure',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3108,NULL,'Cisco-Disconnect-Cause','No-Carrier',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3109,NULL,'Cisco-Disconnect-Cause','Lost-Carrier',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3110,NULL,'Cisco-Disconnect-Cause','No-Detected-Result-Codes',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3111,NULL,'Cisco-Disconnect-Cause','User-Ends-Session',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3112,NULL,'Cisco-Disconnect-Cause','Idle-Timeout',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3113,NULL,'Cisco-Disconnect-Cause','Exit-Telnet-Session',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3114,NULL,'Cisco-Disconnect-Cause','No-Remote-IP-Addr',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3115,NULL,'Cisco-Disconnect-Cause','Exit-Raw-TCP',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3116,NULL,'Cisco-Disconnect-Cause','Password-Fail',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3117,NULL,'Cisco-Disconnect-Cause','Raw-TCP-Disabled',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3118,NULL,'Cisco-Disconnect-Cause','Control-C-Detected',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3119,NULL,'Cisco-Disconnect-Cause','EXEC-Program-Destroyed',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3120,NULL,'Cisco-Disconnect-Cause','Timeout-PPP-LCP',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3121,NULL,'Cisco-Disconnect-Cause','Failed-PPP-LCP-Negotiation',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3122,NULL,'Cisco-Disconnect-Cause','Failed-PPP-PAP-Auth-Fail',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3123,NULL,'Cisco-Disconnect-Cause','Failed-PPP-CHAP-Auth',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3124,NULL,'Cisco-Disconnect-Cause','Failed-PPP-Remote-Auth',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3125,NULL,'Cisco-Disconnect-Cause','PPP-Remote-Terminate',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3126,NULL,'Cisco-Disconnect-Cause','PPP-Closed-Event',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3127,NULL,'Cisco-Disconnect-Cause','Session-Timeout',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3128,NULL,'Cisco-Disconnect-Cause','Session-Failed-Security',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3129,NULL,'Cisco-Disconnect-Cause','Session-End-Callback',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3130,NULL,'Cisco-Disconnect-Cause','Invalid-Protocol',NULL,'Cisco',NULL,NULL,NULL,NULL),
                                (3131,'ipaddr','ITK-Auth-Serv-IP',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3132,'integer','ITK-Auth-Serv-Prot',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3133,'integer','ITK-Provider-Id',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3134,'integer','ITK-Usergroup',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3135,'string','ITK-Banner',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3136,'string','ITK-Username-Prompt',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3137,'string','ITK-Password-Prompt',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3138,'string','ITK-Welcome-Message',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3139,'string','ITK-Prompt',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3140,'integer','ITK-IP-Pool',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3141,'ipaddr','ITK-Tunnel-IP',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3142,'integer','ITK-Tunnel-Prot',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3143,'ipaddr','ITK-Acct-Serv-IP',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3144,'integer','ITK-Acct-Serv-Prot',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3145,'string','ITK-Filter-Rule',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3146,'integer','ITK-Channel-Binding',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3147,'integer','ITK-Start-Delay',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3148,'string','ITK-NAS-Name',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3149,'integer','ITK-ISDN-Prot',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3150,'integer','ITK-PPP-Auth-Type',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3151,'integer','ITK-Dialout-Type',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3152,'ipaddr','ITK-Ftp-Auth-IP',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3153,'string','ITK-Users-Default-Entry',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3154,'string','ITK-Users-Default-Pw',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3155,'string','ITK-Auth-Req-Type',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3156,'integer','ITK-Modem-Pool-Id',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3157,'string','ITK-Modem-Init-String',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3158,'integer','ITK-PPP-Client-Server-Mode',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3159,'string','ITK-PPP-Compression-Prot',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3160,'string','ITK-Username',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3161,'string','ITK-Dest-No',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3162,'string','ITK-DDI',NULL,NULL,'ITK',NULL,NULL,NULL,NULL),
                                (3163,'string','Annex-Filter',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3164,'string','Annex-CLI-Command',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3165,'string','Annex-CLI-Filter',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3166,'string','Annex-Host-Restrict',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3167,'string','Annex-Host-Allow',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3168,'string','Annex-Product-Name',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3169,'string','Annex-SW-Version',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3170,'ipaddr','Annex-Local-IP-Address',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3171,'integer','Annex-Callback-Portlist',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3172,'integer','Annex-Sec-Profile-Index',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3173,'integer','Annex-Tunnel-Authen-Type',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3174,'integer','Annex-Tunnel-Authen-Mode',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3175,'string','Annex-Authen-Servers',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3176,'string','Annex-Acct-Servers',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3177,'integer','Annex-User-Server-Location',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3178,'string','Annex-Local-Username',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3179,'integer','Annex-System-Disc-Reason',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3180,'integer','Annex-Modem-Disc-Reason',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3181,'integer','Annex-Disconnect-Reason',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3182,'integer','Annex-Addr-Resolution-Protocol',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3183,'string','Annex-Addr-Resolution-Servers',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3184,'string','Annex-Domain-Name',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3185,'integer','Annex-Transmit-Speed',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3186,'integer','Annex-Receive-Speed',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3187,'string','Annex-Input-Filter',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3188,'string','Annex-Output-Filter',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3189,'ipaddr','Annex-Primary-DNS-Server',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3190,'ipaddr','Annex-Secondary-DNS-Server',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3191,'ipaddr','Annex-Primary-NBNS-Server',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3192,'ipaddr','Annex-Secondary-NBNS-Server',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3193,'integer','Annex-Syslog-Tap',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3194,'integer','Annex-Keypress-Timeout',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3195,'integer','Annex-Unauthenticated-Time',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3196,'integer','Annex-Re-CHAP-Timeout',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3197,'integer','Annex-MRRU',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3198,'string','Annex-EDO',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3199,'integer','Annex-PPP-Trace-Level',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3200,'integer','Annex-Pre-Input-Octets',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3201,'integer','Annex-Pre-Output-Octets',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3202,'integer','Annex-Pre-Input-Packets',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3203,'integer','Annex-Pre-Output-Packets',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3204,'integer','Annex-Connect-Progress',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3205,'integer','Annex-Multicast-Rate-Limit',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3206,'integer','Annex-Maximum-Call-Duration',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3207,'integer','Annex-Multilink-Id',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3208,'integer','Annex-Num-In-Multilink',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3209,'string','Annex-Secondary-Srv-Endpoint',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3210,'integer','Annex-Gwy-Selection-Mode',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3211,'integer','Annex-Logical-Channel-Number',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3212,'integer','Annex-Wan-Number',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3213,'integer','Annex-Port',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3214,'integer','Annex-Pool-Id',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3215,'string','Annex-Compression-Protocol',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3216,'integer','Annex-Transmitted-Packets',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3217,'integer','Annex-Retransmitted-Packets',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3218,'integer','Annex-Signal-to-Noise-Ratio',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3219,'integer','Annex-Retrain-Requests-Sent',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3220,'integer','Annex-Retrain-Requests-Rcvd',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3221,'integer','Annex-Rate-Reneg-Req-Sent',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3222,'integer','Annex-Rate-Reneg-Req-Rcvd',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3223,'integer','Annex-Begin-Receive-Line-Level',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3224,'integer','Annex-End-Receive-Line-Level',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3225,'string','Annex-Begin-Modulation',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3226,'string','Annex-Error-Correction-Prot',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3227,'string','Annex-End-Modulation',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3228,'integer','Annex-User-Level',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3229,'integer','Annex-Audit-Level',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3230,'string','CES-Group',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3231,'integer','Passport-Access-Priority',NULL,NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3232,NULL,'Passport-Access-Priority','None-Access',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3233,NULL,'Passport-Access-Priority','Read-Only-Access',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3234,NULL,'Passport-Access-Priority','L1-Read-Write-Access',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3235,NULL,'Passport-Access-Priority','L2-Read-Write-Access',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3236,NULL,'Passport-Access-Priority','L3-Read-Write-Access',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3237,NULL,'Passport-Access-Priority','Read-Write-Access',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3238,NULL,'Passport-Access-Priority','Read-Write-All-Access',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3239,NULL,'Annex-Tunnel-Authen-Type','none',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3240,NULL,'Annex-Tunnel-Authen-Type','kmd5-128',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3241,NULL,'Annex-Tunnel-Authen-Mode','none',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3242,NULL,'Annex-Tunnel-Authen-Mode','prefix-suffix',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3243,NULL,'Annex-User-Server-Location','local',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3244,NULL,'Annex-User-Server-Location','remote',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3245,NULL,'Annex-Addr-Resolution-Protocol','none',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3246,NULL,'Annex-Addr-Resolution-Protocol','DHCP',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3247,NULL,'Annex-System-Disc-Reason','Unknown',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3248,NULL,'Annex-System-Disc-Reason','Line-disconnected',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3249,NULL,'Annex-System-Disc-Reason','Dial-failed',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3250,NULL,'Annex-System-Disc-Reason','WAN-manager-error',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3251,NULL,'Annex-System-Disc-Reason','Disconnect-reset',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3252,NULL,'Annex-System-Disc-Reason','Error-from-adm_notify',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3253,NULL,'Annex-System-Disc-Reason','Modem-down-adm_notify',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3254,NULL,'Annex-System-Disc-Reason','PPP-protocol-disconnect',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3255,NULL,'Annex-System-Disc-Reason','Inactivity-timer',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3256,NULL,'Annex-System-Disc-Reason','CLI-Hangup-command',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3257,NULL,'Annex-System-Disc-Reason','CLI-last-job',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3258,NULL,'Annex-System-Disc-Reason','Session-timeout',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3259,NULL,'Annex-System-Disc-Reason','Slave-termination',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3260,NULL,'Annex-System-Disc-Reason','Abnormal-termination',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3261,NULL,'Annex-System-Disc-Reason','DCD-wait-failed',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3262,NULL,'Annex-System-Disc-Reason','CLI-inactivity',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3263,NULL,'Annex-System-Disc-Reason','Admin-port-reset',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3264,NULL,'Annex-System-Disc-Reason','CLI-auth-failed',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3265,NULL,'Annex-System-Disc-Reason','Slave-auth-failed',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3266,NULL,'Annex-System-Disc-Reason','PAP-auth-failed',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3267,NULL,'Annex-System-Disc-Reason','CHAP-auth-failed',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3268,NULL,'Annex-System-Disc-Reason','Local-modem-reset',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3269,NULL,'Annex-System-Disc-Reason','Modem-dead',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3270,NULL,'Annex-System-Disc-Reason','PPP-LCP-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3271,NULL,'Annex-System-Disc-Reason','PPP-IPCP-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3272,NULL,'Annex-System-Disc-Reason','PPP-IPXCP-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3273,NULL,'Annex-System-Disc-Reason','PPP-ATCP-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3274,NULL,'Annex-System-Disc-Reason','PPP-CCP-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3275,NULL,'Annex-System-Disc-Reason','PPP-MP-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3276,NULL,'Annex-System-Disc-Reason','PPP-IPCP-timeout',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3277,NULL,'Annex-System-Disc-Reason','PPP-IPXCP-timeout',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3278,NULL,'Annex-System-Disc-Reason','PPP-ATCP-timeout',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3279,NULL,'Annex-System-Disc-Reason','PPP-CCP-timeout',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3280,NULL,'Annex-System-Disc-Reason','PPP-MP-timeout',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3281,NULL,'Annex-System-Disc-Reason','PPP-init-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3282,NULL,'Annex-System-Disc-Reason','PPP-Unknown',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3283,NULL,'Annex-System-Disc-Reason','PPP-Dialback-failed',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3284,NULL,'Annex-System-Disc-Reason','PPP-Address-In-Use',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3285,NULL,'Annex-System-Disc-Reason','PPP-No-device',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3286,NULL,'Annex-System-Disc-Reason','PPP-Modem-hangup-rcvd',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3287,NULL,'Annex-System-Disc-Reason','PPP-Hangup-rcvd',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3288,NULL,'Annex-System-Disc-Reason','PPP-Termination-rcvd',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3289,NULL,'Annex-System-Disc-Reason','PPP-Kill-rcvd',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3290,NULL,'Annex-System-Disc-Reason','PPP-Time-rcvd',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3291,NULL,'Annex-System-Disc-Reason','PPP-No-memory',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3292,NULL,'Annex-System-Disc-Reason','PPP-Connection-Abort',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3293,NULL,'Annex-System-Disc-Reason','PPP-VPN-LCP-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3294,NULL,'Annex-System-Disc-Reason','PPP-VPN-Auth-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3295,NULL,'Annex-System-Disc-Reason','PPP-MP-invalid-port',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3296,NULL,'Annex-System-Disc-Reason','PPP-Invalid-device',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3297,NULL,'Annex-System-Disc-Reason','PPP-MMP-bundle-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3298,NULL,'Annex-System-Disc-Reason','DVS-Registration-failure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3299,NULL,'Annex-System-Disc-Reason','DVS-Home-agent-dereg',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3300,NULL,'Annex-System-Disc-Reason','DVS-Tunnel-no-renew',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3301,NULL,'Annex-System-Disc-Reason','DVS-Tunnel-expired',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3302,NULL,'Annex-Modem-Disc-Reason','Unknown',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3303,NULL,'Annex-Modem-Disc-Reason','Local-disconnect',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3304,NULL,'Annex-Modem-Disc-Reason','CD-Timer-Expired',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3305,NULL,'Annex-Modem-Disc-Reason','Remote-protocol-disc',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3306,NULL,'Annex-Modem-Disc-Reason','Clear-down',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3307,NULL,'Annex-Modem-Disc-Reason','Long-Space-disconnect',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3308,NULL,'Annex-Modem-Disc-Reason','Carrier-Lost',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3309,NULL,'Annex-Modem-Disc-Reason','Modem-Retrain-Timeout',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3310,NULL,'Annex-User-Level','Manager',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3311,NULL,'Annex-User-Level','User',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3312,NULL,'Annex-User-Level','Operator',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3313,NULL,'Annex-Audit-Level','Manager',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3314,NULL,'Annex-Audit-Level','User',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3315,NULL,'Annex-Audit-Level','Operator',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3316,NULL,'Service-Type','Annex-Authorize-Only',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3317,NULL,'Service-Type','Annex-Framed-Tunnel',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3318,NULL,'Acct-Status-Type','Annex-User-Reject',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3319,NULL,'Acct-Status-Type','Annex-Call-Reject',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3320,NULL,'Acct-Status-Type','Annex-IPCP-Start',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3321,NULL,'Acct-Status-Type','Annex-IPXCP-Start',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3322,NULL,'Acct-Status-Type','Annex-ATCP-Start',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3323,NULL,'Acct-Status-Type','Annex-Accounting-Restart',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3324,NULL,'Acct-Status-Type','Annex-Accounting-Shutoff',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3325,NULL,'Acct-Status-Type','Annex-Tunnel-Start',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3326,NULL,'Acct-Status-Type','Annex-Tunnel-Stop',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3327,NULL,'Acct-Status-Type','Annex-Tunnel-Reject',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3328,NULL,'Acct-Status-Type','Annex-Tunnel-Link-Start',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3329,NULL,'Acct-Status-Type','Annex-Tunnel-Link-Stop',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3330,NULL,'Acct-Status-Type','Annex-MP-Start',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3331,NULL,'Acct-Status-Type','Annex-MP-Stop',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3332,NULL,'Acct-Status-Type','Annex-Line-Seizure',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3333,NULL,'Acct-Status-Type','Annex-Rlogin-Start',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3334,NULL,'Acct-Status-Type','Annex-Rlogin-Stop',NULL,'Bay-Networks',NULL,NULL,NULL,NULL),
                                (3335,'integer','Error-Cause',NULL,NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3336,NULL,'Service-Type','Authorize-Only',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3337,NULL,'Error-Cause','Residual-Context-Removed',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3338,NULL,'Error-Cause','Invalid-EAP-Packet',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3339,NULL,'Error-Cause','Unsupported-Attribute',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3340,NULL,'Error-Cause','Missing-Attribute',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3341,NULL,'Error-Cause','NAS-Identification-Mismatch',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3342,NULL,'Error-Cause','Invalid-Request',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3343,NULL,'Error-Cause','Unsupported-Service',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3344,NULL,'Error-Cause','Unsupported-Extension',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3345,NULL,'Error-Cause','Administratively-Prohibited',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3346,NULL,'Error-Cause','Proxy-Request-Not-Routable',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3347,NULL,'Error-Cause','Session-Context-Not-Found',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3348,NULL,'Error-Cause','Session-Context-Not-Removable',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3349,NULL,'Error-Cause','Proxy-Processing-Error',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3350,NULL,'Error-Cause','Resources-Unavailable',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3351,NULL,'Error-Cause','Request-Initiated',NULL,'dictionary.rfc3576',NULL,NULL,NULL,NULL),
                                (3352,'string','CVX-Identification',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3353,'integer','CVX-VPOP-ID',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3354,'integer','CVX-SS7-Session-ID-Type',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3355,'integer','CVX-Radius-Redirect',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3356,'integer','CVX-IPSVC-AZNLVL',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3357,'integer','CVX-IPSVC-Mask',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3358,'integer','CVX-Multilink-Match-Info',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3359,'integer','CVX-Multilink-Group-Number',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3360,'integer','CVX-PPP-Log-Mask',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3361,'string','CVX-Modem-Begin-Modulation',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3362,'string','CVX-Modem-End-Modulation',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3363,'string','CVX-Modem-Error-Correction',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3364,'string','CVX-Modem-Data-Compression',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3365,'integer','CVX-Modem-Tx-Packets',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3366,'integer','CVX-Modem-ReTx-Packets',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3367,'integer','CVX-Modem-SNR',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3368,'integer','CVX-Modem-Local-Retrains',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3369,'integer','CVX-Modem-Remote-Retrains',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3370,'integer','CVX-Modem-Local-Rate-Negs',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3371,'integer','CVX-Modem-Remote-Rate-Negs',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3372,'integer','CVX-Modem-Begin-Recv-Line-Lvl',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3373,'integer','CVX-Modem-End-Recv-Line-Lvl',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3374,'integer','CVX-Terminate-Component',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3375,'integer','CVX-Terminate-Cause',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3376,'integer','CVX-Reject-Reason',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3377,'ipaddr','CVX-Primary-DNS',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3378,'ipaddr','CVX-Secondary-DNS',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3379,'integer','CVX-Client-Assign-DNS',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3380,'integer','CVX-Multicast-Rate-Limit',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3381,'integer','CVX-Multicast-Client',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3382,'integer','CVX-Disconnect-Cause',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3383,'integer','CVX-Data-Rate',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3384,'integer','CVX-PreSession-Time',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3385,'integer','CVX-Assign-IP-Pool',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3386,'integer','CVX-Maximum-Channels',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3387,'string','CVX-Data-Filter',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3388,'integer','CVX-Idle-Limit',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3389,'ipaddr','CVX-PPP-Address',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3390,'integer','CVX-Xmit-Rate',NULL,NULL,'Aptis',NULL,NULL,NULL,NULL),
                                (3391,'string','Password',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3392,'ipaddr','Client-Id',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3393,'integer','Client-Port-Id',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3394,'integer','User-Service-Type',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3395,'ipaddr','Framed-Address',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3396,'ipaddr','Framed-Netmask',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3397,'string','Framed-Filter-Id',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3398,'ipaddr','Login-Host',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3399,'integer','Login-Port',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3400,'string','Old-Password',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3401,'string','Port-Message',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3402,'string','Dialback-No',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3403,'string','Dialback-Name',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3404,'string','Challenge-State',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3405,NULL,'Framed-Compression','Van-Jacobsen-TCP-IP',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3406,NULL,'Framed-Compression','VJ-TCP-IP',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3407,NULL,'Service-Type','Shell-User',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3408,NULL,'Auth-Type','Unix',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3409,NULL,'Service-Type','Dialback-Login-User',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3410,NULL,'Service-Type','Dialback-Framed-User',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3411,'string','Login-Callback-Number',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3412,'string','Framed-Callback-Id',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3413,'string','Client-Port-DNIS',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3414,'string','Caller-ID',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3415,NULL,'Service-Type','Login',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3416,NULL,'Service-Type','Framed',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3417,NULL,'Service-Type','Callback-Login',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3418,NULL,'Service-Type','Callback-Framed',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3419,NULL,'Service-Type','Exec-User',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3420,'integer','Session',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3421,'integer','User-Name-Is-Star',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3422,NULL,'User-Name-Is-Star','No',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3423,NULL,'User-Name-Is-Star','Yes',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3424,NULL,'Auth-Type','None',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3425,'integer','PostAuth-Type',NULL,NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3426,NULL,'PostAuth-Type','Local',NULL,'dictionary.compat',NULL,NULL,NULL,NULL),
                                (3427,'string','Patton-Setup-Time',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3428,'string','Patton-Connect-Time',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3429,'string','Patton-Disconnect-Time',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3430,'integer','Patton-Disconnect-Cause',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3431,'string','Patton-Disconnect-Source',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3432,'string','Patton-Called-Unique-Id',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3433,'ipaddr','Patton-Called-IP-Address',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3434,'string','Patton-Called-Numbering-Plan',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3435,'string','Patton-Called-Type-Of-Number',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3436,'string','Patton-Calling-Unique-Id',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3437,'ipaddr','Patton-Calling-IP-Address',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3438,'string','Patton-Calling-Numbering-Plan',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3439,'string','Patton-Calling-Type-Of-Number',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3440,'string','Patton-Calling-Presentation-Indicator',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3441,'string','Patton-Calling-Screening-Indicator',NULL,NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3442,NULL,'Patton-Disconnect-Cause','Valid-cause-code-not-yet-received',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3443,NULL,'Patton-Disconnect-Cause','Unallocated-runassigned-number',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3444,NULL,'Patton-Disconnect-Cause','No-route-to-specified-transit-network-WAN',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3445,NULL,'Patton-Disconnect-Cause','No-route-to-destination',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3446,NULL,'Patton-Disconnect-Cause','send-special-information-tone',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3447,NULL,'Patton-Disconnect-Cause','misdialled-trunk-prefix',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3448,NULL,'Patton-Disconnect-Cause','Channel-unacceptable',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3449,NULL,'Patton-Disconnect-Cause','Call-awarded-and-being-delivered-in-an-established-channel',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3450,NULL,'Patton-Disconnect-Cause','Prefix-0-dialed-but-not-allowed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3451,NULL,'Patton-Disconnect-Cause','Prefix-1-dialed-but-not-allowed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3452,NULL,'Patton-Disconnect-Cause','Prefix-1-dialed-but-not-required',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3453,NULL,'Patton-Disconnect-Cause','More-digits-received-than-allowed-call-is-proceeding',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3454,NULL,'Patton-Disconnect-Cause','Normal-call-clearing',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3455,NULL,'Patton-Disconnect-Cause','User-busy',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3456,NULL,'Patton-Disconnect-Cause','No-user-responding',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3457,NULL,'Patton-Disconnect-Cause','no-answer-from-user',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3458,NULL,'Patton-Disconnect-Cause','Call-rejected',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3459,NULL,'Patton-Disconnect-Cause','Number-changed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3460,NULL,'Patton-Disconnect-Cause','Reverse-charging-rejected',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3461,NULL,'Patton-Disconnect-Cause','Call-suspended',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3462,NULL,'Patton-Disconnect-Cause','Call-resumed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3463,NULL,'Patton-Disconnect-Cause','Non-selected-user-clearing',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3464,NULL,'Patton-Disconnect-Cause','Destination-out-of-order',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3465,NULL,'Patton-Disconnect-Cause','Invalid-number-format-incomplete-number',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3466,NULL,'Patton-Disconnect-Cause','Facility-rejected',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3467,NULL,'Patton-Disconnect-Cause','Response-to-STATUS-ENQUIRY',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3468,NULL,'Patton-Disconnect-Cause','Normal-unspecified',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3469,NULL,'Patton-Disconnect-Cause','Circuit-out-of-order',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3470,NULL,'Patton-Disconnect-Cause','No-circuit/channel-available',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3471,NULL,'Patton-Disconnect-Cause','Destination-unattainable',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3472,NULL,'Patton-Disconnect-Cause','Degraded-service',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3473,NULL,'Patton-Disconnect-Cause','Network-WAN-out-of-order',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3474,NULL,'Patton-Disconnect-Cause','Transit-delay-range-cannot-be-achieved',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3475,NULL,'Patton-Disconnect-Cause','Throughput-range-cannot-be-achieved',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3476,NULL,'Patton-Disconnect-Cause','Temporary-failure',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3477,NULL,'Patton-Disconnect-Cause','Switching-equipment-congestion',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3478,NULL,'Patton-Disconnect-Cause','Access-information-discarded',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3479,NULL,'Patton-Disconnect-Cause','Requested-circuit-channel-not-available',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3480,NULL,'Patton-Disconnect-Cause','Pre-empted',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3481,NULL,'Patton-Disconnect-Cause','Precedence-call-blocked',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3482,NULL,'Patton-Disconnect-Cause','Resource-unavailable-unspecified',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3483,NULL,'Patton-Disconnect-Cause','Quality-of-service-unavailable',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3484,NULL,'Patton-Disconnect-Cause','Requested-facility-not-subscribed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3485,NULL,'Patton-Disconnect-Cause','Reverse-charging-not-allowed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3486,NULL,'Patton-Disconnect-Cause','Outgoing-calls-barred',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3487,NULL,'Patton-Disconnect-Cause','Outgoing-calls-barred-within-CUG',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3488,NULL,'Patton-Disconnect-Cause','Incoming-calls-barred',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3489,NULL,'Patton-Disconnect-Cause','Incoming-calls-barred-within-CUG',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3490,NULL,'Patton-Disconnect-Cause','Call-waiting-not-subscribed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3491,NULL,'Patton-Disconnect-Cause','Bearer-capability-not-authorized',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3492,NULL,'Patton-Disconnect-Cause','Bearer-capability-not-presently-available',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3493,NULL,'Patton-Disconnect-Cause','Service-or-option-not-available-unspecified',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3494,NULL,'Patton-Disconnect-Cause','Bearer-service-not-implemented',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3495,NULL,'Patton-Disconnect-Cause','Channel-type-not-implemented',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3496,NULL,'Patton-Disconnect-Cause','Transit-network-selection-not-implemented',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3497,NULL,'Patton-Disconnect-Cause','Message-not-implemented',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3498,NULL,'Patton-Disconnect-Cause','Requested-facility-not-implemented',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3499,NULL,'Patton-Disconnect-Cause','Only-restricted-digital-information-bearer-capability-is-avail',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3500,NULL,'Patton-Disconnect-Cause','Service-or-option-not-implemented-unspecified',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3501,NULL,'Patton-Disconnect-Cause','Invalid-call-reference-value',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3502,NULL,'Patton-Disconnect-Cause','Identified-channel-does-not-exist',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3503,NULL,'Patton-Disconnect-Cause','A-suspended-call-exists-but-this-call-identity-does-not',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3504,NULL,'Patton-Disconnect-Cause','Call-identity-in-use',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3505,NULL,'Patton-Disconnect-Cause','No-call-suspended',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3506,NULL,'Patton-Disconnect-Cause','Call-having-the-requested-call-identity-has-been-cleared',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3507,NULL,'Patton-Disconnect-Cause','Called-user-not-member-of-CUG',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3508,NULL,'Patton-Disconnect-Cause','Incompatible-destination',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3509,NULL,'Patton-Disconnect-Cause','Non-existent-abbreviated-address-entry',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3510,NULL,'Patton-Disconnect-Cause','Destination-address-missing-and-direct-call-not-subscribed',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3511,NULL,'Patton-Disconnect-Cause','Invalid-transit-network-selection-national-use',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3512,NULL,'Patton-Disconnect-Cause','Invalid-facility-parameter',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3513,NULL,'Patton-Disconnect-Cause','Mandatory-information-element-is-missing',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3514,NULL,'Patton-Disconnect-Cause','Invalid-message-unspecified',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3515,NULL,'Patton-Disconnect-Cause','Mandatory-information-element-is-missing-2',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3516,NULL,'Patton-Disconnect-Cause','Message-type-non-existent-or-not-implemented',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3517,NULL,'Patton-Disconnect-Cause','Message-not-compatible-with-call-state',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3518,NULL,'Patton-Disconnect-Cause','information-element-nonexistant-or-not-implemented',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3519,NULL,'Patton-Disconnect-Cause','Invalid-information-element-contents',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3520,NULL,'Patton-Disconnect-Cause','Message-not-compatible-with-call-state-2',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3521,NULL,'Patton-Disconnect-Cause','Recovery-on-timer-expiry',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3522,NULL,'Patton-Disconnect-Cause','parameter-non-existent-or-not-implemented-passed-on',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3523,NULL,'Patton-Disconnect-Cause','Protocol-error-unspecified',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3524,NULL,'Patton-Disconnect-Cause','Internetworking-unspecified',NULL,'Patton',NULL,NULL,NULL,NULL),
                                (3525,'integer','IPU-MIP-Spi',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3526,'string','IPU-MIP-Key',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3527,'integer','IPU-MIP-Alg-Type',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3528,'integer','IPU-MIP-Alg-Mode',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3529,'integer','IPU-MIP-Replay-Prot',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3530,'ipaddr','IPU-IKE-Remote-Addr',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3531,'ipaddr','IPU-IKE-Local-Addr',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3532,'string','IPU-IKE-Auth',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3533,'string','IPU-IKE-Conf-Name',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3534,'string','IPU-IKE-Cmd',NULL,NULL,'ipUnplugged',NULL,NULL,NULL,NULL),
                                (3535,'integer','Versanet-Termination-Cause',NULL,NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3536,NULL,'Versanet-Termination-Cause','Normal-Hangup-No-Error-Occurred',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3537,NULL,'Versanet-Termination-Cause','Call-Waiting-Caused-Disconnect',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3538,NULL,'Versanet-Termination-Cause','Physical-Carrier-Loss',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3539,NULL,'Versanet-Termination-Cause','No-err-correction-at-other-end',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3540,NULL,'Versanet-Termination-Cause','No-resp-to-feature-negotiation',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3541,NULL,'Versanet-Termination-Cause','1st-modem-async-only-2nd-sync',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3542,NULL,'Versanet-Termination-Cause','No-framing-technique-in-common',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3543,NULL,'Versanet-Termination-Cause','No-protocol-in-common',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3544,NULL,'Versanet-Termination-Cause','Bad-resp-to-feature-negotiation',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3545,NULL,'Versanet-Termination-Cause','No-sync-info-from-remote-modem',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3546,NULL,'Versanet-Termination-Cause','Normal-Hangup-by-Remote-modem',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3547,NULL,'Versanet-Termination-Cause','Retransmission-limit-reached',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3548,NULL,'Versanet-Termination-Cause','Protocol-violation-occurred',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3549,NULL,'Versanet-Termination-Cause','Lost-DTR',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3550,NULL,'Versanet-Termination-Cause','Received-GSTN-cleardown',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3551,NULL,'Versanet-Termination-Cause','Inactivity-timeout',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3552,NULL,'Versanet-Termination-Cause','Speed-not-supported',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3553,NULL,'Versanet-Termination-Cause','Long-space-disconnect',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3554,NULL,'Versanet-Termination-Cause','Key-abort-disconnect',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3555,NULL,'Versanet-Termination-Cause','Clears-previous-disc-reason',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3556,NULL,'Versanet-Termination-Cause','No-connection-established',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3557,NULL,'Versanet-Termination-Cause','Disconnect-after-three-retrains',NULL,'Versanet',NULL,NULL,NULL,NULL),
                                (3558,'string','Aruba-User-Role',NULL,NULL,'Aruba',NULL,NULL,NULL,NULL),
                                (3559,'integer','Aruba-User-Vlan',NULL,NULL,'Aruba',NULL,NULL,NULL,NULL),
                                (3560,'integer','Aruba-Priv-Admin-User',NULL,NULL,'Aruba',NULL,NULL,NULL,NULL),
                                (3561,'string','Aruba-Admin-Role',NULL,NULL,'Aruba',NULL,NULL,NULL,NULL),
                                (3562,'string','Aruba-Essid-Name',NULL,NULL,'Aruba',NULL,NULL,NULL,NULL),
                                (3563,'string','Aruba-Location-Id',NULL,NULL,'Aruba',NULL,NULL,NULL,NULL),
                                (3564,'integer','Cabletron-Protocol-Enable',NULL,NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3565,'integer','Cabletron-Protocol-Callable',NULL,NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3566,NULL,'Cabletron-Protocol-Enable','IP-Enable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3567,NULL,'Cabletron-Protocol-Enable','Bridge-Enable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3568,NULL,'Cabletron-Protocol-Enable','IP-BR-Enable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3569,NULL,'Cabletron-Protocol-Enable','BR-IPX-Enable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3570,NULL,'Cabletron-Protocol-Enable','IP-BR-IPX-Enable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3571,NULL,'Cabletron-Protocol-Callable','IP-Callable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3572,NULL,'Cabletron-Protocol-Callable','Bridge-Callable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3573,NULL,'Cabletron-Protocol-Callable','IP-BR-Callable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3574,NULL,'Cabletron-Protocol-Callable','BR-IPX-Callable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3575,NULL,'Cabletron-Protocol-Callable','IP-BR-IPX-Callable',NULL,'Cabletron',NULL,NULL,NULL,NULL),
                                (3576,'ipv6addr','NAS-IPv6-Address',NULL,NULL,'dictionary.rfc3162',NULL,NULL,NULL,NULL),
                                (3577,'ifid','Framed-Interface-Id',NULL,NULL,'dictionary.rfc3162',NULL,NULL,NULL,NULL),
                                (3578,'ipv6prefix','Framed-IPv6-Prefix',NULL,NULL,'dictionary.rfc3162',NULL,NULL,NULL,NULL),
                                (3579,'ipv6addr','Login-IPv6-Host',NULL,NULL,'dictionary.rfc3162',NULL,NULL,NULL,NULL),
                                (3580,'string','Framed-IPv6-Route',NULL,NULL,'dictionary.rfc3162',NULL,NULL,NULL,NULL),
                                (3581,'string','Framed-IPv6-Pool',NULL,NULL,'dictionary.rfc3162',NULL,NULL,NULL,NULL),
                                (3582,'integer','SN-VPN-ID',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3583,'string','SN-VPN-Name',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3584,'integer','SN-Disconnect-Reason',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3585,'integer','SN-PPP-Progress-Code',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3586,'ipaddr','SN-Primary-DNS-Server',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3587,'ipaddr','SN-Secondary-DNS-Server',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3588,'integer','SN-Re-CHAP-Interval',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3589,'string','SN-IP-Pool-Name',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3590,'integer','SN-PPP-Data-Compression',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3591,'string','SN-IP-Filter-In',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3592,'string','SN-IP-Filter-Out',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3593,'ipaddr','SN-Local-IP-Address',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3594,'integer','SN-IP-Source-Validation',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3595,'string','SN-PPP-Outbound-Password',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3596,'integer','SN-PPP-Keepalive',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3597,'string','SN-IP-In-ACL',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3598,'string','SN-IP-Out-ACL',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3599,'integer','SN-PPP-Data-Compression-Mode',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3600,'integer','SN-Subscriber-Permission',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3601,'integer','SN-Admin-Permission',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3602,'integer','SN-Simultaneous-SIP-MIP',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3603,'integer','SN-Min-Compress-Size',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3604,'integer','SNA-PPP-Unfr-data-In-Oct',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3605,'integer','SNA-PPP-Unfr-data-Out-Oct',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3606,'integer','SNA-PPP-Ctrl-Input-Octets',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3607,'integer','SNA-PPP-Ctrl-Output-Octets',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3608,'integer','SNA-PPP-Ctrl-Input-Packets',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3609,'integer','SNA-PPP-Ctrl-Output-Packets',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3610,'integer','SNA-PPP-Framed-Input-Octets',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3611,'integer','SNA-PPP-Framed-Output-Octets',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3612,'integer','SNA-PPP-Discards-Input',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3613,'integer','SNA-PPP-Discards-Output',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3614,'integer','SNA-PPP-Errors-Input',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3615,'integer','SNA-PPP-Errors-Output',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3616,'integer','SNA-PPP-Bad-Addr',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3617,'integer','SNA-PPP-Bad-Ctrl',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3618,'integer','SNA-PPP-Packet-Too-Long',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3619,'integer','SNA-PPP-Bad-FCS',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3620,'integer','SNA-PPP-Echo-Req-Input',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3621,'integer','SNA-PPP-Echo-Req-Output',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3622,'integer','SNA-PPP-Echo-Rsp-Input',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3623,'integer','SNA-PPP-Echo-Rsp-Output',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3624,'integer','SNA-RPRRQ-Rcvd-Total',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3625,'integer','SNA-RPRRQ-Rcvd-Acc-Reg',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3626,'integer','SNA-RPRRQ-Rcvd-Acc-Dereg',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3627,'integer','SNA-RPRRQ-Rcvd-Msg-Auth-Fail',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3628,'integer','SNA-RPRRQ-Rcvd-Mis-ID',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3629,'integer','SNA-RPRRQ-Rcvd-Badly-Formed',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3630,'integer','SNA-RPRRQ-Rcvd-VID-Unsupported',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3631,'integer','SNA-RPRRQ-Rcvd-T-Bit-Not-Set',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3632,'integer','SNA-RPRAK-Rcvd-Total',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3633,'integer','SNA-RPRAK-Rcvd-Acc-Ack',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3634,'integer','SNA-RPRAK-Rcvd-Msg-Auth-Fail',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3635,'integer','SNA-RPRAK-Rcvd-Mis-ID',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3636,'integer','SNA-RP-Reg-Reply-Sent-Total',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3637,'integer','SNA-RP-Reg-Reply-Sent-Acc-Reg',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3638,'integer','SNA-RP-Reg-Reply-Sent-Acc-Dereg',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3639,'integer','SNA-RP-Reg-Reply-Sent-Bad-Req',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3640,'integer','SNA-RP-Reg-Reply-Sent-Denied',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3641,'integer','SNA-RP-Reg-Reply-Sent-Mis-ID',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3642,'integer','SNA-RP-Reg-Reply-Sent-Send-Err',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3643,'integer','SNA-RP-Reg-Upd-Sent',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3644,'integer','SNA-RP-Reg-Upd-Re-Sent',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3645,'integer','SNA-RP-Reg-Upd-Send-Err',NULL,NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3646,NULL,'SN-Disconnect-Reason','Not-Defined',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3647,NULL,'SN-Disconnect-Reason','Admin-Disconnect',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3648,NULL,'SN-Disconnect-Reason','Remote-Disconnect',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3649,NULL,'SN-Disconnect-Reason','Local-Disconnect',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3650,NULL,'SN-Disconnect-Reason','Disc-No-Resource',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3651,NULL,'SN-Disconnect-Reason','Disc-Excd-Service-Limit',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3652,NULL,'SN-Disconnect-Reason','PPP-LCP-Neg-Failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3653,NULL,'SN-Disconnect-Reason','PPP-LCP-No-Response',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3654,NULL,'SN-Disconnect-Reason','PPP-LCP-Loopback',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3655,NULL,'SN-Disconnect-Reason','PPP-LCP-Max-Retry',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3656,NULL,'SN-Disconnect-Reason','PPP-Echo-Failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3657,NULL,'SN-Disconnect-Reason','PPP-Auth-Failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3658,NULL,'SN-Disconnect-Reason','PPP-Auth-Failed-No-AAA-Resp',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3659,NULL,'SN-Disconnect-Reason','PPP-Auth-No-Response',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3660,NULL,'SN-Disconnect-Reason','PPP-Auth-Max-Retry',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3661,NULL,'SN-Disconnect-Reason','Invalid-AAA-Attr',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3662,NULL,'SN-Disconnect-Reason','Failed-User-Filter',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3663,NULL,'SN-Disconnect-Reason','Failed-Provide-Service',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3664,NULL,'SN-Disconnect-Reason','Invalid-IP-Address-AAA',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3665,NULL,'SN-Disconnect-Reason','Invalid-IP-Pool-AAA',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3666,NULL,'SN-Disconnect-Reason','PPP-IPCP-Neg-Failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3667,NULL,'SN-Disconnect-Reason','PPP-IPCP-No-Response',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3668,NULL,'SN-Disconnect-Reason','PPP-IPCP-Max-Retry',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3669,NULL,'SN-Disconnect-Reason','PPP-No-Rem-IP-Address',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3670,NULL,'SN-Disconnect-Reason','Inactivity-Timeout',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3671,NULL,'SN-Disconnect-Reason','Session-Timeout',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3672,NULL,'SN-Disconnect-Reason','Max-Data-Excd',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3673,NULL,'SN-Disconnect-Reason','Invalid-IP-Source-Address',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3674,NULL,'SN-Disconnect-Reason','MSID-Auth-Failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3675,NULL,'SN-Disconnect-Reason','MSID-Auth-Fauiled-No-AAA-Resp',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3676,NULL,'SN-Disconnect-Reason','A11-Max-Retry',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3677,NULL,'SN-Disconnect-Reason','A11-Lifetime-Expired',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3678,NULL,'SN-Disconnect-Reason','A11-Message-Integrity-Failure',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3679,NULL,'SN-Disconnect-Reason','PPP-lcp-remote-disc',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3680,NULL,'SN-Disconnect-Reason','Session-setup-timeout',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3681,NULL,'SN-Disconnect-Reason','PPP-keepalive-failure',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3682,NULL,'SN-Disconnect-Reason','Flow-add-failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3683,NULL,'SN-Disconnect-Reason','Call-type-detection-failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3684,NULL,'SN-Disconnect-Reason','Wrong-ipcp-params',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3685,NULL,'SN-Disconnect-Reason','MIP-remote-dereg',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3686,NULL,'SN-Disconnect-Reason','MIP-lifetime-expiry',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3687,NULL,'SN-Disconnect-Reason','MIP-proto-error',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3688,NULL,'SN-Disconnect-Reason','MIP-auth-failure',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3689,NULL,'SN-Disconnect-Reason','MIP-reg-timeout',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3690,NULL,'SN-Disconnect-Reason','Invalid-dest-context',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3691,NULL,'SN-Disconnect-Reason','Source-context-removed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3692,NULL,'SN-Disconnect-Reason','Destination-context-removed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3693,NULL,'SN-Disconnect-Reason','Req-service-addr-unavailable',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3694,NULL,'SN-Disconnect-Reason','Demux-mgr-failed',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3695,NULL,'SN-Disconnect-Reason','Internal-error',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3696,NULL,'SN-PPP-Progress-Code','Not-Defined',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3697,NULL,'SN-PPP-Progress-Code','Call-Lcp-Down',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3698,NULL,'SN-PPP-Progress-Code','Call-Disconnecting',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3699,NULL,'SN-PPP-Progress-Code','Call-Ppp-Renegotiating',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3700,NULL,'SN-PPP-Progress-Code','Call-Arrived',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3701,NULL,'SN-PPP-Progress-Code','Call-Lcp-Up',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3702,NULL,'SN-PPP-Progress-Code','Call-Authenticating',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3703,NULL,'SN-PPP-Progress-Code','Call-Authenticated',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3704,NULL,'SN-PPP-Progress-Code','Call-Ipcp-Up',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3705,NULL,'SN-PPP-Progress-Code','Call-Simple-IP-Connected',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3706,NULL,'SN-PPP-Progress-Code','Call-Mobile-IP-Connected',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3707,NULL,'SN-PPP-Data-Compression','None',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3708,NULL,'SN-PPP-Data-Compression','Stac-LZS',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3709,NULL,'SN-PPP-Data-Compression','MPPC',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3710,NULL,'SN-PPP-Data-Compression','MPCC-Stac-LZS',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3711,NULL,'SN-PPP-Data-Compression','Deflate',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3712,NULL,'SN-PPP-Data-Compression','Deflate-Stac-LZS',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3713,NULL,'SN-PPP-Data-Compression','Deflate-MPCC',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3714,NULL,'SN-PPP-Data-Compression','Deflate-MPCC-Stac-LZS',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3715,NULL,'SN-IP-Source-Validation','No',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3716,NULL,'SN-IP-Source-Validation','Yes',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3717,NULL,'SN-Subscriber-Permission','None',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3718,NULL,'SN-Subscriber-Permission','Simple-IP',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3719,NULL,'SN-Subscriber-Permission','Mobile-IP',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3720,NULL,'SN-Subscriber-Permission','Simple-IP-Mobile-IP',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3721,NULL,'SN-Subscriber-Permission','HA-Mobile-IP',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3722,NULL,'SN-Subscriber-Permission','Simple-IP-HA-Mobile-IP',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3723,NULL,'SN-Subscriber-Permission','Mobile-IP-HA-Mobile-IP',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3724,NULL,'SN-Subscriber-Permission','All',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3725,NULL,'SN-Admin-Permission','None',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3726,NULL,'SN-Admin-Permission','CLI',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3727,NULL,'SN-Admin-Permission','FTP',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3728,NULL,'SN-Simultaneous-SIP-MIP','Disabled',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3729,NULL,'SN-Simultaneous-SIP-MIP','Enabled',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3730,NULL,'SN-PPP-Data-Compression-Mode','Normal',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3731,NULL,'SN-PPP-Data-Compression-Mode','Stateless',NULL,'Starent',NULL,NULL,NULL,NULL),
                                (3732,'ipaddr','Xedia-DNS-Server',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3733,'ipaddr','Xedia-NetBios-Server',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3734,'string','Xedia-Address-Pool',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3735,'integer','Xedia-PPP-Echo-Interval',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3736,'integer','Xedia-SSH-Privileges',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3737,'string','Xedia-Client-Access-Network',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3738,'integer','Xedia-Client-Firewall-Setting',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3739,'integer','Xedia-Save-Password',NULL,NULL,'Xedia',NULL,NULL,NULL,NULL),
                                (3740,'integer','NN-Data-Rate',NULL,NULL,'Bristol',NULL,NULL,NULL,NULL),
                                (3741,'integer','NN-Data-Rate-Ceiling',NULL,NULL,'Bristol',NULL,NULL,NULL,NULL),
                                (3742,'ipaddr','NN-Homenode',NULL,NULL,'Bristol',NULL,NULL,NULL,NULL),
                                (3743,'ipaddr','NN-Homeservice',NULL,NULL,'Bristol',NULL,NULL,NULL,NULL),
                                (3744,'string','NN-Homeservice-Name',NULL,NULL,'Bristol',NULL,NULL,NULL,NULL),
                                (3745,'integer','CVPN5000-Tunnel-Throughput',NULL,NULL,'Cisco-VPN5000',NULL,NULL,NULL,NULL),
                                (3746,'string','CVPN5000-Client-Assigned-IP',NULL,NULL,'Cisco-VPN5000',NULL,NULL,NULL,NULL),
                                (3747,'string','CVPN5000-Client-Real-IP',NULL,NULL,'Cisco-VPN5000',NULL,NULL,NULL,NULL),
                                (3748,'string','CVPN5000-VPN-GroupInfo',NULL,NULL,'Cisco-VPN5000',NULL,NULL,NULL,NULL),
                                (3749,'string','CVPN5000-VPN-Password',NULL,NULL,'Cisco-VPN5000',NULL,NULL,NULL,NULL),
                                (3750,'integer','CVPN5000-Echo',NULL,NULL,'Cisco-VPN5000',NULL,NULL,NULL,NULL),
                                (3751,'integer','CVPN5000-Client-Assigned-IPX',NULL,NULL,'Cisco-VPN5000',NULL,NULL,NULL,NULL),
                                (3752,'string','Motorola-Canopy-Shared-Secret',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3753,'string','Motorola-Canopy-SULDR',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3754,'string','Motorola-Canopy-SDLDR',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3755,'string','Motorola-Canopy-ULBA',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3756,'string','Motorola-Canopy-DLBA',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3757,'string','Motorola-Canopy-Enable',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3758,'string','Motorola-Canopy-LPSULDR',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3759,'string','Motorola-Canopy-LPSDLDR',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3760,'string','Motorola-Canopy-HPCENABLE',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3761,'string','Motorola-Canopy-HPSULDR',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3762,'string','Motorola-Canopy-HPSDLDR',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3763,'string','Motorola-Canopy-HIGHERBW',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3764,'string','Motorola-Canopy-CIRENABLE',NULL,NULL,'Motorola',NULL,NULL,NULL,NULL),
                                (3765,'integer','Airespace-Wlan-Id',NULL,NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3766,'integer','Airespace-QOS-Level',NULL,NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3767,'integer','Airespace-DSCP',NULL,NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3768,'integer','Airespace-8021p-Tag',NULL,NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3769,'string','Airespace-Interface-Name',NULL,NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3770,'string','Airespace-ACL-Name',NULL,NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3771,NULL,'Airespace-QOS-Level','Bronze',NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3772,NULL,'Airespace-QOS-Level','Silver',NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3773,NULL,'Airespace-QOS-Level','Gold',NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3774,NULL,'Airespace-QOS-Level','Platinum',NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3775,NULL,'Airespace-QOS-Level','Uranium',NULL,'Airespace',NULL,NULL,NULL,NULL),
                                (3776,'integer','Unix-FTP-UID',NULL,NULL,'Unix',NULL,NULL,NULL,NULL),
                                (3777,'integer','Unix-FTP-GID',NULL,NULL,'Unix',NULL,NULL,NULL,NULL),
                                (3778,'string','Unix-FTP-Home',NULL,NULL,'Unix',NULL,NULL,NULL,NULL),
                                (3779,'string','Unix-FTP-Shell',NULL,NULL,'Unix',NULL,NULL,NULL,NULL),
                                (3780,'string','Unix-FTP-Group-Names',NULL,NULL,'Unix',NULL,NULL,NULL,NULL),
                                (3781,'string','Unix-FTP-Group-Ids',NULL,NULL,'Unix',NULL,NULL,NULL,NULL),
                                (3782,'integer','Acct-Input-Gigawords',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3783,'integer','Acct-Output-Gigawords',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3784,'date','Event-Timestamp',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3785,'octets','ARAP-Password',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3786,'octets','ARAP-Features',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3787,'integer','ARAP-Zone-Access',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3788,'integer','ARAP-Security',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3789,'string','ARAP-Security-Data',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3790,'integer','Password-Retry',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3791,'integer','Prompt',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3792,'string','Connect-Info',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3793,'string','Configuration-Token',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3794,'octets','EAP-Message',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3795,'octets','Message-Authenticator',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3796,'octets','ARAP-Challenge-Response',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3797,'integer','Acct-Interim-Interval',NULL,NULL,'dictionary.rfc2869',':=','reply','','If present in Access-Accept (in the reply packet) the NAS will generate interim accounting records every specified interval (seconds).'),
                                (3798,'string','NAS-Port-Id',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3799,'string','Framed-Pool',NULL,NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3800,NULL,'ARAP-Zone-Access','Default-Zone',NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3801,NULL,'ARAP-Zone-Access','Zone-Filter-Inclusive',NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3802,NULL,'ARAP-Zone-Access','Zone-Filter-Exclusive',NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3803,NULL,'Prompt','No-Echo',NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3804,NULL,'Prompt','Echo',NULL,'dictionary.rfc2869',NULL,NULL,NULL,NULL),
                                (3805,'integer','Acc-Reason-Code',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3806,'integer','Acc-Ccp-Option',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3807,'integer','Acc-Input-Errors',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3808,'integer','Acc-Output-Errors',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3809,'string','Acc-Access-Partition',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3810,'string','Acc-Customer-Id',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3811,'ipaddr','Acc-Ip-Gateway-Pri',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3812,'ipaddr','Acc-Ip-Gateway-Sec',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3813,'integer','Acc-Route-Policy',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3814,'integer','Acc-ML-MLX-Admin-State',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3815,'integer','Acc-ML-Call-Threshold',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3816,'integer','Acc-ML-Clear-Threshold',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3817,'integer','Acc-ML-Damping-Factor',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3818,'string','Acc-Tunnel-Secret',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3819,'integer','Acc-Clearing-Cause',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3820,'integer','Acc-Clearing-Location',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3821,'string','Acc-Service-Profile',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3822,'integer','Acc-Request-Type',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3823,'integer','Acc-Bridging-Support',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3824,'integer','Acc-Apsm-Oversubscribed',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3825,'integer','Acc-Acct-On-Off-Reason',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3826,'integer','Acc-Tunnel-Port',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3827,'ipaddr','Acc-Dns-Server-Pri',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3828,'ipaddr','Acc-Dns-Server-Sec',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3829,'ipaddr','Acc-Nbns-Server-Pri',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3830,'ipaddr','Acc-Nbns-Server-Sec',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3831,'integer','Acc-Dial-Port-Index',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3832,'integer','Acc-Ip-Compression',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3833,'integer','Acc-Ipx-Compression',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3834,'integer','Acc-Connect-Tx-Speed',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3835,'integer','Acc-Connect-Rx-Speed',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3836,'string','Acc-Modem-Modulation-Type',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3837,'string','Acc-Modem-Error-Protocol',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3838,'integer','Acc-Callback-Delay',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3839,'string','Acc-Callback-Num-Valid',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3840,'integer','Acc-Callback-Mode',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3841,'integer','Acc-Callback-CBCP-Type',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3842,'integer','Acc-Dialout-Auth-Mode',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3843,'string','Acc-Dialout-Auth-Password',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3844,'string','Acc-Dialout-Auth-Username',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3845,'integer','Acc-Access-Community',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3846,'integer','Acc-Vpsm-Reject-Cause',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3847,'string','Acc-Ace-Token',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3848,'integer','Acc-Ace-Token-Ttl',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3849,'string','Acc-Ip-Pool-Name',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3850,'integer','Acc-Igmp-Admin-State',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3851,'integer','Acc-Igmp-Version',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3852,'string','Acc-MN-HA-Secret',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3853,'string','Acc-Location-Id',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3854,'integer','Acc-Calling-Station-Category',NULL,NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3855,NULL,'Acc-Reason-Code','No-reason-No-Failure',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3856,NULL,'Acc-Reason-Code','Resource-shortage',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3857,NULL,'Acc-Reason-Code','Session-already-open',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3858,NULL,'Acc-Reason-Code','Too-many-RADIUS-users',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3859,NULL,'Acc-Reason-Code','No-authentification-server',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3860,NULL,'Acc-Reason-Code','No-authentification-response',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3861,NULL,'Acc-Reason-Code','No-accounting-server',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3862,NULL,'Acc-Reason-Code','No-accounting-response',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3863,NULL,'Acc-Reason-Code','Access-Denied',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3864,NULL,'Acc-Reason-Code','Temporary-buffer-shortage',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3865,NULL,'Acc-Reason-Code','Protocol-error',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3866,NULL,'Acc-Reason-Code','Invalid-attribute',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3867,NULL,'Acc-Reason-Code','Invalid-service-type',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3868,NULL,'Acc-Reason-Code','Invalid-framed-protocol',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3869,NULL,'Acc-Reason-Code','Invalid-attribute-value',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3870,NULL,'Acc-Reason-Code','Invalid-user-information',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3871,NULL,'Acc-Reason-Code','Invalid-IP-address',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3872,NULL,'Acc-Reason-Code','Invalid-integer-syntax',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3873,NULL,'Acc-Reason-Code','Invalid-NAS-port',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3874,NULL,'Acc-Reason-Code','Requested-by-user',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3875,NULL,'Acc-Reason-Code','Network-disconnect',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3876,NULL,'Acc-Reason-Code','Service-interruption',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3877,NULL,'Acc-Reason-Code','Physical-port-error',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3878,NULL,'Acc-Reason-Code','Idle-timeout',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3879,NULL,'Acc-Reason-Code','Session-timeout',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3880,NULL,'Acc-Reason-Code','Administrative-reset',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3881,NULL,'Acc-Reason-Code','NAS-reload-or-reset',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3882,NULL,'Acc-Reason-Code','NAS-error',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3883,NULL,'Acc-Reason-Code','NAS-request',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3884,NULL,'Acc-Reason-Code','Undefined-reason-given',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3885,NULL,'Acc-Reason-Code','Conflicting-attributes',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3886,NULL,'Acc-Reason-Code','Port-limit-exceeded',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3887,NULL,'Acc-Reason-Code','Facility-not-available',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3888,NULL,'Acc-Reason-Code','Internal-config-error',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3889,NULL,'Acc-Reason-Code','Bad-route-specification',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3890,NULL,'Acc-Reason-Code','Access-Partition-bind-failure',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3891,NULL,'Acc-Reason-Code','Security-violation',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3892,NULL,'Acc-Reason-Code','Request-type-conflict',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3893,NULL,'Acc-Reason-Code','Configuration-disallowed',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3894,NULL,'Acc-Reason-Code','Missing-attribute',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3895,NULL,'Acc-Reason-Code','Invalid-request',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3896,NULL,'Acc-Reason-Code','Missing-parameter',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3897,NULL,'Acc-Reason-Code','Invalid-parameter',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3898,NULL,'Acc-Reason-Code','Call-cleared-with-cause',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3899,NULL,'Acc-Reason-Code','Inopportune-config-request',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3900,NULL,'Acc-Reason-Code','Invalid-config-parameter',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3901,NULL,'Acc-Reason-Code','Missing-config-parameter',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3902,NULL,'Acc-Reason-Code','Incompatible-service-profile',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3903,NULL,'Acc-Reason-Code','Administrative-reset-2',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3904,NULL,'Acc-Reason-Code','Administrative-reload',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3905,NULL,'Acc-Reason-Code','Port-unneeded',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3906,NULL,'Acc-Reason-Code','Port-preempted',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3907,NULL,'Acc-Reason-Code','Port-suspended',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3908,NULL,'Acc-Reason-Code','Service-unavailable',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3909,NULL,'Acc-Reason-Code','Callback',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3910,NULL,'Acc-Reason-Code','User-error',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3911,NULL,'Acc-Reason-Code','Host-request',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3912,NULL,'Acc-Ccp-Option','Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3913,NULL,'Acc-Ccp-Option','Enabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3914,NULL,'Acc-Route-Policy','Funnel',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3915,NULL,'Acc-Route-Policy','Direct',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3916,NULL,'Acc-ML-MLX-Admin-State','Enabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3917,NULL,'Acc-ML-MLX-Admin-State','Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3918,NULL,'Acc-Clearing-Cause','Cause-unspecified',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3919,NULL,'Acc-Clearing-Cause','Unassigned-number',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3920,NULL,'Acc-Clearing-Cause','No-route-to-transit-network',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3921,NULL,'Acc-Clearing-Cause','No-route-to-destination',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3922,NULL,'Acc-Clearing-Cause','Channel-unacceptable',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3923,NULL,'Acc-Clearing-Cause','Call-awarded-being-delivered',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3924,NULL,'Acc-Clearing-Cause','Normal-clearing',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3925,NULL,'Acc-Clearing-Cause','User-busy',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3926,NULL,'Acc-Clearing-Cause','No-user-responding',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3927,NULL,'Acc-Clearing-Cause','User-alerted-no-answer',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3928,NULL,'Acc-Clearing-Cause','Call-rejected',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3929,NULL,'Acc-Clearing-Cause','Number-changed',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3930,NULL,'Acc-Clearing-Cause','Non-selected-user-clearing',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3931,NULL,'Acc-Clearing-Cause','Destination-out-of-order',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3932,NULL,'Acc-Clearing-Cause','Invalid-or-incomplete-number',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3933,NULL,'Acc-Clearing-Cause','Facility-rejected',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3934,NULL,'Acc-Clearing-Cause','Response-to-status-inquiry',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3935,NULL,'Acc-Clearing-Cause','Normal-unspecified-cause',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3936,NULL,'Acc-Clearing-Cause','No-circuit-or-channel-available',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3937,NULL,'Acc-Clearing-Cause','Network-out-of-order',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3938,NULL,'Acc-Clearing-Cause','Temporary-failure',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3939,NULL,'Acc-Clearing-Cause','Switching-equipment-congestion',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3940,NULL,'Acc-Clearing-Cause','Access-information-discarded',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3941,NULL,'Acc-Clearing-Cause','Circuit-or-channel-unavailable',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3942,NULL,'Acc-Clearing-Cause','Circuit-or-channed-preempted',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3943,NULL,'Acc-Clearing-Cause','Resources-unavailable',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3944,NULL,'Acc-Clearing-Cause','Quality-of-service-unavailable',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3945,NULL,'Acc-Clearing-Cause','Facility-not-subscribed',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3946,NULL,'Acc-Clearing-Cause','Outgoing-calls-barred',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3947,NULL,'Acc-Clearing-Cause','Incoming-calls-barred',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3948,NULL,'Acc-Clearing-Cause','Bearer-capability-unauthorized',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3949,NULL,'Acc-Clearing-Cause','Bearer-capability-not-available',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3950,NULL,'Acc-Clearing-Cause','Service-not-available',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3951,NULL,'Acc-Clearing-Cause','Bearer-capablity-not-implmented',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3952,NULL,'Acc-Clearing-Cause','Channel-type-not-implemented',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3953,NULL,'Acc-Clearing-Cause','Facility-not-implemented',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3954,NULL,'Acc-Clearing-Cause','Restrcted-digtal-infrmtion-only',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3955,NULL,'Acc-Clearing-Cause','Service-not-implemented',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3956,NULL,'Acc-Clearing-Cause','Invalid-call-reference',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3957,NULL,'Acc-Clearing-Cause','Identified-channel-doesnt-exist',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3958,NULL,'Acc-Clearing-Cause','Call-identify-in-use',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3959,NULL,'Acc-Clearing-Cause','No-call-suspended',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3960,NULL,'Acc-Clearing-Cause','Suspended-call-cleared',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3961,NULL,'Acc-Clearing-Cause','Incompatible-destination',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3962,NULL,'Acc-Clearing-Cause','Invalid-transit-network-selctin',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3963,NULL,'Acc-Clearing-Cause','Invalid-message',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3964,NULL,'Acc-Clearing-Cause','Mandtory-infrmtion-elment-miss',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3965,NULL,'Acc-Clearing-Cause','Message-not-implemented',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3966,NULL,'Acc-Clearing-Cause','Inopportune-message',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3967,NULL,'Acc-Clearing-Cause','Infrmtion-elemnt-not-implmented',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3968,NULL,'Acc-Clearing-Cause','Invlid-infrmtion-element-contnt',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3969,NULL,'Acc-Clearing-Cause','Message-incompatible-with-state',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3970,NULL,'Acc-Clearing-Cause','Recovery-on-timer-expiration',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3971,NULL,'Acc-Clearing-Cause','Mndtry-infrmtion-elmnt-lngt-err',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3972,NULL,'Acc-Clearing-Cause','Protocol-error',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3973,NULL,'Acc-Clearing-Cause','Interworking',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3974,NULL,'Acc-Clearing-Location','Local-or-remote-user',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3975,NULL,'Acc-Clearing-Location','Prvte-ntwork-serving-local-user',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3976,NULL,'Acc-Clearing-Location','Pblic-ntwork-serving-local-user',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3977,NULL,'Acc-Clearing-Location','Transit-network',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3978,NULL,'Acc-Clearing-Location','Prvte-ntwork-serv-remote-user',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3979,NULL,'Acc-Clearing-Location','Pblic-ntwork-serv-remote-user',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3980,NULL,'Acc-Clearing-Location','International-network',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3981,NULL,'Acc-Clearing-Location','Beyond-interworking-point',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3982,NULL,'Acc-Request-Type','Ring-Indication',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3983,NULL,'Acc-Request-Type','Dial-Request',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3984,NULL,'Acc-Request-Type','User-Authentification',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3985,NULL,'Acc-Request-Type','Tunnel-Authentification',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3986,NULL,'Acc-Bridging-Support','Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3987,NULL,'Acc-Bridging-Support','Enabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3988,NULL,'Acc-Apsm-Oversubscribed','False',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3989,NULL,'Acc-Apsm-Oversubscribed','True',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3990,NULL,'Acc-Acct-On-Off-Reason','NAS-Reset',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3991,NULL,'Acc-Acct-On-Off-Reason','NAS-Reload',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3992,NULL,'Acc-Acct-On-Off-Reason','Configuration-Reset',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3993,NULL,'Acc-Acct-On-Off-Reason','Configuration-Reload',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3994,NULL,'Acc-Acct-On-Off-Reason','Enabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3995,NULL,'Acc-Acct-On-Off-Reason','Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3996,NULL,'Acc-Ip-Compression','Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3997,NULL,'Acc-Ip-Compression','Enabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3998,NULL,'Acc-Ipx-Compression','Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (3999,NULL,'Acc-Ipx-Compression','Enabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4000,NULL,'Acc-Callback-Mode','User-Auth',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4001,NULL,'Acc-Callback-Mode','User-Specified-E-164',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4002,NULL,'Acc-Callback-Mode','CBCP-Callback',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4003,NULL,'Acc-Callback-Mode','CLI-Callback',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4004,NULL,'Acc-Callback-CBCP-Type','CBCP-None',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4005,NULL,'Acc-Callback-CBCP-Type','CBCP-User-Specified',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4006,NULL,'Acc-Callback-CBCP-Type','CBCP-Pre-Specified',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4007,NULL,'Acc-Dialout-Auth-Mode','PAP',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4008,NULL,'Acc-Dialout-Auth-Mode','CHAP',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4009,NULL,'Acc-Dialout-Auth-Mode','CHAP-PAP',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4010,NULL,'Acc-Dialout-Auth-Mode','NONE',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4011,NULL,'Acc-Access-Community','PUBLIC',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4012,NULL,'Acc-Access-Community','NETMAN',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4013,NULL,'Acc-Vpsm-Reject-Cause','No-Access-Partition',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4014,NULL,'Acc-Vpsm-Reject-Cause','Access-Partition-Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4015,NULL,'Acc-Vpsm-Reject-Cause','Partition-Portlimit-Exceeded',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4016,NULL,'Acc-Vpsm-Reject-Cause','License-Portlimit-Exceeded',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4017,NULL,'Acc-Vpsm-Reject-Cause','Home-Server-Down',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4018,NULL,'Acc-Vpsm-Reject-Cause','Rejected-By-Home-Server',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4019,NULL,'Acc-Vpsm-Reject-Cause','NAS-Administratively-Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4020,NULL,'Acc-Igmp-Admin-State','Enabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4021,NULL,'Acc-Igmp-Admin-State','Disabled',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4022,NULL,'Acc-Igmp-Version','V1',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4023,NULL,'Acc-Igmp-Version','V2',NULL,'Acc',NULL,NULL,NULL,NULL),
                                (4024,'ipaddr','Client_DNS_Pri',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4025,'ipaddr','Client_DNS_Sec',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4026,'integer','DHCP_Max_Leases',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4027,'string','Context_Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4028,'string','Bridge_Group',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4029,'string','BG_Aging_Time',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4030,'string','BG_Path_Cost',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4031,'string','BG_Span_Dis',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4032,'string','BG_Trans_BPDU',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4033,'integer','Rate_Limit_Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4034,'integer','Rate_Limit_Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4035,'integer','Police_Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4036,'integer','Police_Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4037,'integer','Source_Validation',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4038,'integer','Tunnel_Domain',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4039,'string','Tunnel_Local_Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4040,'string','Tunnel_Remote_Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4041,'integer','Tunnel_Function',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4042,'integer','Tunnel_Max_Sessions',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4043,'integer','Tunnel_Max_Tunnels',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4044,'integer','Tunnel_Session_Auth',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4045,'integer','Tunnel_Window',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4046,'integer','Tunnel_Retransmit',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4047,'integer','Tunnel_Cmd_Timeout',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4048,'string','PPPOE_URL',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4049,'string','PPPOE_MOTM',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4050,'integer','Tunnel_Group',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4051,'string','Tunnel_Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4052,'integer','Tunnel_Algorithm',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4053,'integer','Tunnel_Deadtime',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4054,'integer','Mcast_Send',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4055,'integer','Mcast_Receive',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4056,'integer','Mcast_MaxGroups',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4057,'string','Ip_Address_Pool_Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4058,'integer','Tunnel_DNIS',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4059,'integer','Medium_Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4060,'integer','PVC_Encapsulation_Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4061,'string','PVC_Profile_Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4062,'integer','PVC_Circuit_Padding',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4063,'integer','Bind_Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4064,'integer','Bind_Auth_Protocol',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4065,'integer','Bind_Auth_Max_Sessions',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4066,'string','Bind_Bypass_Bypass',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4067,'string','Bind_Auth_Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4068,'string','Bind_Auth_Service_Grp',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4069,'string','Bind_Bypass_Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4070,'string','Bind_Int_Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4071,'string','Bind_Tun_Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4072,'string','Bind_Ses_Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4073,'integer','Bind_Dot1q_Slot',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4074,'integer','Bind_Dot1q_Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4075,'integer','Bind_Dot1q_Vlan_Tag_Id',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4076,'string','Bind_Int_Interface_Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4077,'string','Bind_L2TP_Tunnel_Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4078,'integer','Bind_L2TP_Flow_Control',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4079,'string','Bind_Sub_User_At_Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4080,'string','Bind_Sub_Password',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4081,'string','Ip_Host_Addr',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4082,'integer','IP_TOS_Field',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4083,'integer','NAS_Real_Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4084,'string','Tunnel_Session_Auth_Ctx',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4085,'string','Tunnel_Session_Auth_Service_Grp',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4086,'integer','Tunnel_Rate_Limit_Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4087,'integer','Tunnel_Rate_Limit_Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4088,'integer','Tunnel_Police_Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4089,'integer','Tunnel_Police_Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4090,'string','Tunnel_L2F_Second_Password',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4091,'integer','TTY_Level_Max',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4092,'integer','TTY_Level_Start',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4093,'string','Qos-Policy-Policing',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4094,'string','Qos-Policy-Metering',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4095,'string','Qos-Policy-Queuing',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4096,'string','Igmp-Service-Profile',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4097,'string','Sub-Profile-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4098,'string','Forward-Policy',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4099,'string','Reauth-String',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4100,'integer','Reauth-More',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4101,'string','Agent-Remote-Id',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4102,'string','Agent-Circuit-Id',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4103,'integer','Platform-Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4104,'ipaddr','RB-Client-NBNS-Pri',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4105,'ipaddr','RB-Client-NBNS-Sec',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4106,'string','Shaping-Profile-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4107,'string','IP-Interface',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4108,'string','NAT-Policy-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4109,'string','HTTP-Redirect-Profile-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4110,'string','OS-Version',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4111,'string','Session-Traffic-Limit',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4112,'octets','Acct_Input_Octets_64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4113,'octets','Acct_Output_Octets_64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4114,'octets','Acct_Input_Packets_64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4115,'octets','Acct_Output_Packets_64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4116,'ipaddr','Assigned_IP_Address',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4117,'integer','Acct_Mcast_In_Octets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4118,'integer','Acct_Mcast_Out_Octets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4119,'integer','Acct_Mcast_In_Packets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4120,'integer','Acct_Mcast_Out_Packets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4121,'integer','LAC_Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4122,'integer','LAC_Real_Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4123,'integer','LAC_Port_Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4124,'integer','LAC_Real_Port_Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4125,'string','Acct_Dyn_Ac_Ent',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4126,'integer','Session_Error_Code',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4127,'string','Session_Error_Msg',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4128,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_RAW',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4129,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_ROUTE1483',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4130,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_AUTO1483',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4131,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_MULTI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4132,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_BRIDGE1483',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4133,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_PPP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4134,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_PPP_SERIAL',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4135,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_PPP_NLPID',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4136,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_PPP_AUTO',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4137,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4138,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_L2TP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4139,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ATM_PPP_LLC',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4140,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_AUTO1490',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4141,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_MULTI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4142,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_BRIDGE1490',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4143,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_PPP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4144,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_PPP_AUTO',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4145,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4146,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_ROUTE1490',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4147,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_FRAME_L2TP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4148,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_L2TP_VC_MUXED',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4149,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ETH',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4150,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ETH_PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4151,NULL,'PVC_Encapsulation_Type','AAA_ENCAPS_ETH_MULTI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4152,NULL,'PVC_Circuit_Padding','AAA_CIRCUIT_PADDING',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4153,NULL,'PVC_Circuit_Padding','AAA_CIRCUIT_NO_PADDING',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4154,NULL,'Bind_Type','AAA_AUTH_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4155,NULL,'Bind_Type','AAA_BYPASS_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4156,NULL,'Bind_Type','AAA_INTERFACE_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4157,NULL,'Bind_Type','AAA_SUBSCRIBE_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4158,NULL,'Bind_Type','AAA_TUNNEL_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4159,NULL,'Bind_Type','AAA_SESSION_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4160,NULL,'Bind_Type','AAA_Q8021_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4161,NULL,'Bind_Type','AAA_MULTI_BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4162,NULL,'Bind_Auth_Protocol','AAA_PPP_PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4163,NULL,'Bind_Auth_Protocol','AAA_PPP_CHAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4164,NULL,'Bind_Auth_Protocol','AAA_PPP_CHAP_WAIT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4165,NULL,'Bind_Auth_Protocol','AAA_PPP_CHAP_PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4166,NULL,'Bind_Auth_Protocol','AAA_PPP_CHAP_WAIT_PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4167,NULL,'Tunnel_Function','LAC-Only',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4168,NULL,'Tunnel_Function','LNS-Only',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4169,NULL,'Tunnel_Function','LAC-LNS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4170,NULL,'Tunnel_Session_Auth','CHAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4171,NULL,'Tunnel_Session_Auth','PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4172,NULL,'Tunnel_Session_Auth','CHAP-PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4173,NULL,'Mcast_Send','NO-SEND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4174,NULL,'Mcast_Send','SEND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4175,NULL,'Mcast_Send','UNSOLICITED-SEND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4176,NULL,'Mcast_Receive','NO-RECEIVE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4177,NULL,'Mcast_Receive','RECEIVE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4178,NULL,'Tunnel_DNIS','DNIS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4179,NULL,'Tunnel_DNIS','DNIS-Only',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4180,NULL,'LAC_Port_Type','NAS_PORT_TYPE_10BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4181,NULL,'LAC_Port_Type','NAS_PORT_TYPE_100BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4182,NULL,'LAC_Port_Type','NAS_PORT_TYPE_DS3_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4183,NULL,'LAC_Port_Type','NAS_PORT_TYPE_DS3_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4184,NULL,'LAC_Port_Type','NAS_PORT_TYPE_OC3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4185,NULL,'LAC_Port_Type','NAS_PORT_TYPE_HSSI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4186,NULL,'LAC_Port_Type','NAS_PORT_TYPE_EIA530',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4187,NULL,'LAC_Port_Type','NAS_PORT_TYPE_T1',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4188,NULL,'LAC_Port_Type','NAS_PORT_TYPE_CHAN_T3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4189,NULL,'LAC_Port_Type','NAS_PORT_TYPE_DS1_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4190,NULL,'LAC_Port_Type','NAS_PORT_TYPE_E3_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4191,NULL,'LAC_Port_Type','NAS_PORT_TYPE_IMA_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4192,NULL,'LAC_Port_Type','NAS_PORT_TYPE_DS3_ATM_2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4193,NULL,'LAC_Port_Type','NAS_PORT_TYPE_OC3_ATM_2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4194,NULL,'LAC_Port_Type','NAS_PORT_TYPE_1000BSX',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4195,NULL,'LAC_Port_Type','NAS_PORT_TYPE_E1_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4196,NULL,'LAC_Port_Type','NAS_PORT_TYPE_E1_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4197,NULL,'LAC_Port_Type','NAS_PORT_TYPE_E3_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4198,NULL,'LAC_Port_Type','NAS_PORT_TYPE_OC3_POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4199,NULL,'LAC_Port_Type','NAS_PORT_TYPE_OC12_POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4200,NULL,'LAC_Port_Type','NAS_PORT_TYPE_PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4201,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_10BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4202,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_100BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4203,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_DS3_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4204,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_DS3_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4205,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_OC3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4206,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_HSSI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4207,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_EIA530',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4208,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_T1',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4209,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_CHAN_T3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4210,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_DS1_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4211,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_E3_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4212,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_IMA_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4213,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_DS3_ATM_2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4214,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_OC3_ATM_2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4215,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_1000BSX',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4216,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_E1_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4217,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_E1_ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4218,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_E3_FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4219,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_OC3_POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4220,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_OC12_POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4221,NULL,'LAC_Real_Port_Type','NAS_PORT_TYPE_PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4222,'ipaddr','Client-DNS-Pri',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4223,'ipaddr','Client-DNS-Sec',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4224,'integer','DHCP-Max-Leases',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4225,'string','Context-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4226,'string','Bridge-Group',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4227,'string','BG-Aging-Time',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4228,'string','BG-Path-Cost',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4229,'string','BG-Span-Dis',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4230,'string','BG-Trans-BPDU',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4231,'integer','Rate-Limit-Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4232,'integer','Rate-Limit-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4233,'integer','Police-Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4234,'integer','Police-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4235,'integer','Source-Validation',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4236,'integer','Tunnel-Domain',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4237,'string','Tunnel-Local-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4238,'string','Tunnel-Remote-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4239,'integer','Tunnel-Function',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4240,'integer','Tunnel-Max-Sessions',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4241,'integer','Tunnel-Max-Tunnels',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4242,'integer','Tunnel-Session-Auth',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4243,'integer','Tunnel-Window',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4244,'integer','Tunnel-Retransmit',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4245,'integer','Tunnel-Cmd-Timeout',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4246,'string','PPPOE-URL',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4247,'string','PPPOE-MOTM',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4248,'integer','Tunnel-Group',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4249,'string','Tunnel-Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4250,'integer','Tunnel-Algorithm',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4251,'integer','Tunnel-Deadtime',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4252,'integer','Mcast-Send',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4253,'integer','Mcast-Receive',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4254,'integer','Mcast-MaxGroups',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4255,'string','Ip-Address-Pool-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4256,'integer','Tunnel-DNIS',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4257,'integer','Medium-Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4258,'integer','PVC-Encapsulation-Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4259,'string','PVC-Profile-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4260,'integer','PVC-Circuit-Padding',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4261,'integer','Bind-Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4262,'integer','Bind-Auth-Protocol',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4263,'integer','Bind-Auth-Max-Sessions',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4264,'string','Bind-Bypass-Bypass',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4265,'string','Bind-Auth-Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4266,'string','Bind-Auth-Service-Grp',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4267,'string','Bind-Bypass-Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4268,'string','Bind-Int-Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4269,'string','Bind-Tun-Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4270,'string','Bind-Ses-Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4271,'integer','Bind-Dot1q-Slot',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4272,'integer','Bind-Dot1q-Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4273,'integer','Bind-Dot1q-Vlan-Tag-Id',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4274,'string','Bind-Int-Interface-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4275,'string','Bind-L2TP-Tunnel-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4276,'integer','Bind-L2TP-Flow-Control',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4277,'string','Bind-Sub-User-At-Context',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4278,'string','Bind-Sub-Password',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4279,'string','Ip-Host-Addr',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4280,'integer','IP-TOS-Field',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4281,'integer','NAS-Real-Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4282,'string','Tunnel-Session-Auth-Ctx',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4283,'string','Tunnel-Session-Auth-Service-Grp',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4284,'integer','Tunnel-Rate-Limit-Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4285,'integer','Tunnel-Rate-Limit-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4286,'integer','Tunnel-Police-Rate',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4287,'integer','Tunnel-Police-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4288,'string','Tunnel-L2F-Second-Password',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4289,'string','ACL-Definition',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4290,'string','PPPoE-IP-Route-Add',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4291,'integer','TTY-Level-Max',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4292,'integer','TTY-Level-Start',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4293,'integer','Tunnel-Checksum',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4294,'string','Tunnel-Profile',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4295,'string','Tunnel-Client-VPN',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4296,'string','Tunnel-Server-VPN',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4297,'string','Tunnel-Client-Rhost',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4298,'string','Tunnel-Server-Rhost',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4299,'ipaddr','Tunnel-Client-Int-Addr',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4300,'ipaddr','Tunnel-Server-Int-Addr',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4301,'string','Agent-Remote-Id',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4302,'string','Agent-Circuit-Id',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4303,'integer','Platform-Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4304,'ipaddr','Client-NBNS-Pri',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4305,'ipaddr','Client-NBNS-Sec',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4306,'integer','BG-Cct-Addr-Max',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4307,'string','IP-Interface-Name',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4308,'octets','Rate-Limit-Excess-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4309,'octets','Police-Excess-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4310,'octets','Tunnel-Rate-Limit-Excess-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4311,'octets','Tunnel-Police-Excess-Burst',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4312,'octets','Acct-Input-Octets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4313,'octets','Acct-Output-Octets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4314,'octets','Acct-Input-Packets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4315,'octets','Acct-Output-Packets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4316,'ipaddr','Assigned-IP-Address',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4317,'octets','Acct-Mcast-In-Octets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4318,'octets','Acct-Mcast-Out-Octets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4319,'octets','Acct-Mcast-In-Packets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4320,'octets','Acct-Mcast-Out-Packets-64',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4321,'integer','LAC-Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4322,'integer','LAC-Real-Port',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4323,'integer','LAC-Port-Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4324,'integer','LAC-Real-Port-Type',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4325,'string','Acct-Dyn-Ac-Ent',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4326,'integer','Session-Error-Code',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4327,'string','Session-Error-Msg',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4328,'integer','Acct-Update-Reason',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4329,'string','Mac-Addr',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4330,'string','Vlan-Source-Info',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4331,'integer','Acct-Mcast-In-Octets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4332,'integer','Acct-Mcast-Out-Octets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4333,'integer','Acct-Mcast-In-Packets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4334,'integer','Acct-Mcast-Out-Packets',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4335,'string','Reauth-Session-Id',NULL,NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4336,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-RAW',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4337,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-ROUTE1483',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4338,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-AUTO1483',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4339,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-MULTI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4340,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-BRIDGE1483',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4341,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-PPP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4342,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-PPP-SERIAL',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4343,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-PPP-NLPID',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4344,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-PPP-AUTO',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4345,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4346,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-L2TP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4347,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ATM-PPP-LLC',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4348,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-AUTO1490',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4349,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-MULTI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4350,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-BRIDGE1490',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4351,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-PPP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4352,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-PPP-AUTO',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4353,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4354,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-ROUTE1490',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4355,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-FRAME-L2TP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4356,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-L2TP-VC-MUXED',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4357,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ETH',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4358,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ETH-PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4359,NULL,'PVC-Encapsulation-Type','AAA-ENCAPS-ETH-MULTI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4360,NULL,'PVC-Circuit-Padding','AAA-CIRCUIT-PADDING',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4361,NULL,'PVC-Circuit-Padding','AAA-CIRCUIT-NO-PADDING',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4362,NULL,'Bind-Type','AAA-AUTH-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4363,NULL,'Bind-Type','AAA-BYPASS-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4364,NULL,'Bind-Type','AAA-INTERFACE-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4365,NULL,'Bind-Type','AAA-SUBSCRIBE-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4366,NULL,'Bind-Type','AAA-TUNNEL-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4367,NULL,'Bind-Type','AAA-SESSION-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4368,NULL,'Bind-Type','AAA-Q8021-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4369,NULL,'Bind-Type','AAA-MULTI-BIND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4370,NULL,'Bind-Auth-Protocol','AAA-PPP-PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4371,NULL,'Bind-Auth-Protocol','AAA-PPP-CHAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4372,NULL,'Bind-Auth-Protocol','AAA-PPP-CHAP-WAIT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4373,NULL,'Bind-Auth-Protocol','AAA-PPP-CHAP-PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4374,NULL,'Bind-Auth-Protocol','AAA-PPP-CHAP-WAIT-PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4375,NULL,'Tunnel-Function','LAC-Only',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4376,NULL,'Tunnel-Function','LNS-Only',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4377,NULL,'Tunnel-Function','LAC-LNS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4378,NULL,'Tunnel-Session-Auth','CHAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4379,NULL,'Tunnel-Session-Auth','PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4380,NULL,'Tunnel-Session-Auth','CHAP-PAP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4381,NULL,'Mcast-Send','NO-SEND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4382,NULL,'Mcast-Send','SEND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4383,NULL,'Mcast-Send','UNSOLICITED-SEND',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4384,NULL,'Mcast-Receive','NO-RECEIVE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4385,NULL,'Mcast-Receive','RECEIVE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4386,NULL,'Tunnel-DNIS','DNIS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4387,NULL,'Tunnel-DNIS','DNIS-Only',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4388,NULL,'Platform-Type','SMS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4389,NULL,'Platform-Type','SmartEdge-800',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4390,NULL,'Medium-Type','DSL',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4391,NULL,'Medium-Type','Cable',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4392,NULL,'Medium-Type','Wireless',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4393,NULL,'Medium-Type','Satellite',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4394,NULL,'LAC-Port-Type','NAS-PORT-TYPE-10BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4395,NULL,'LAC-Port-Type','NAS-PORT-TYPE-100BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4396,NULL,'LAC-Port-Type','NAS-PORT-TYPE-DS3-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4397,NULL,'LAC-Port-Type','NAS-PORT-TYPE-DS3-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4398,NULL,'LAC-Port-Type','NAS-PORT-TYPE-OC3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4399,NULL,'LAC-Port-Type','NAS-PORT-TYPE-HSSI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4400,NULL,'LAC-Port-Type','NAS-PORT-TYPE-EIA530',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4401,NULL,'LAC-Port-Type','NAS-PORT-TYPE-T1',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4402,NULL,'LAC-Port-Type','NAS-PORT-TYPE-CHAN-T3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4403,NULL,'LAC-Port-Type','NAS-PORT-TYPE-DS1-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4404,NULL,'LAC-Port-Type','NAS-PORT-TYPE-E3-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4405,NULL,'LAC-Port-Type','NAS-PORT-TYPE-IMA-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4406,NULL,'LAC-Port-Type','NAS-PORT-TYPE-DS3-ATM-2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4407,NULL,'LAC-Port-Type','NAS-PORT-TYPE-OC3-ATM-2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4408,NULL,'LAC-Port-Type','NAS-PORT-TYPE-1000BSX',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4409,NULL,'LAC-Port-Type','NAS-PORT-TYPE-E1-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4410,NULL,'LAC-Port-Type','NAS-PORT-TYPE-E1-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4411,NULL,'LAC-Port-Type','NAS-PORT-TYPE-E3-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4412,NULL,'LAC-Port-Type','NAS-PORT-TYPE-OC3-POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4413,NULL,'LAC-Port-Type','NAS-PORT-TYPE-OC12-POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4414,NULL,'LAC-Port-Type','NAS-PORT-TYPE-PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4415,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-10BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4416,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-100BT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4417,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-DS3-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4418,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-DS3-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4419,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-OC3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4420,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-HSSI',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4421,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-EIA530',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4422,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-T1',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4423,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-CHAN-T3',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4424,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-DS1-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4425,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-E3-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4426,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-IMA-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4427,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-DS3-ATM-2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4428,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-OC3-ATM-2',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4429,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-1000BSX',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4430,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-E1-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4431,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-E1-ATM',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4432,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-E3-FR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4433,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-OC3-POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4434,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-OC12-POS',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4435,NULL,'LAC-Real-Port-Type','NAS-PORT-TYPE-PPPOE',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4436,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_SESSION_UP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4437,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_SESSION_DOWN',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4438,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_PERIODIC',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4439,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_DYN_AC_ENT_START',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4440,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_DYN_AC_ENT_STOP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4441,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_DYN_AC_ENT_TIMEOUT',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4442,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_SUBSCRIBER_REAUTHOR',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4443,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_PPP_IPCP_UP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4444,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_PPP_MP_LINK_UP',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4445,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_DHCP_IP_ADDR_GRANTED',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4446,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_DHCP_IP_ADDR_RELEASED',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4447,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_ACL_TIMERED_ACTION',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4448,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_ACL_ACTION',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4449,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_CMD',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4450,NULL,'Acct-Update-Reason','AAA_LOAD_ACCT_TEST',NULL,'Redback',NULL,NULL,NULL,NULL),
                                (4451,'integer','Ericsson-ViG-Balance',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4452,'integer','Ericsson-ViG-Codec',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4453,'string','Ericsson-ViG-Currency',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4454,'string','Ericsson-ViG-Currency-Quote',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4455,'integer','Ericsson-ViG-Endpoint-Type',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4456,'integer','Ericsson-ViG-Sequence-Number',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4457,'ipaddr','Ericsson-ViG-Access-Agent-IP-Address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4458,'integer','Ericsson-ViG-QoS-Class',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4459,'string','Ericsson-ViG-Digest-Response',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4460,'octets','Ericsson-ViG-Digest-Attributes',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4461,'string','Ericsson-ViG-Business-Agreement-Name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4462,'integer','Ericsson-ViG-Call-Role',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4463,'ipaddr','Ericsson-ViG-Remote-SK-UA-IP-Address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4464,'string','Ericsson-ViG-Site',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4465,'integer','Ericsson-ViG-TTL-relative',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4466,'integer','Ericsson-ViG-Account-error-reason',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4467,'integer','Ericsson-ViG-Layer-identity',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4468,'integer','Ericsson-ViG-Major-protocol-version',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4469,'integer','Ericsson-ViG-Minor-protocol-version',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4470,'integer','Ericsson-ViG-Authentication-type',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4471,'integer','Ericsson-ViG-Trusted-access',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4472,'string','Ericsson-ViG-User-name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4473,'string','Ericsson-ViG-Global-unique-call-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4474,'string','Ericsson-ViG-Global-unique-service-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4475,'integer','Ericsson-ViG-Interim-interval',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4476,'integer','Ericsson-ViG-Alive-Indicator',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4477,'integer','Ericsson-ViG-TTL-Absolute',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4478,'integer','Ericsson-ViG-TTL-Start-Event',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4479,'ipaddr','Ericsson-ViG-SK-IP-address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4480,'ipaddr','Ericsson-ViG-UA-IP-address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4481,'ipaddr','Ericsson-ViG-SA-IP-address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4482,'string','Ericsson-ViG-Calling-e164-number',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4483,'string','Ericsson-ViG-Calling-H323Id',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4484,'string','Ericsson-ViG-Calling-Email-address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4485,'string','Ericsson-ViG-Dialled-e164-number',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4486,'string','Ericsson-ViG-Dialled-H323Id',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4487,'string','Ericsson-ViG-Dialled-Email-address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4488,'string','Ericsson-ViG-Routed-e164-number',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4489,'string','Ericsson-ViG-Routed-H323Id',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4490,'string','Ericsson-ViG-Routed-Email-address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4491,'string','Ericsson-ViG-SiteKeeper-name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4492,'string','Ericsson-ViG-Access-Group-name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4493,'string','Ericsson-ViG-Access-Agent-name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4494,'string','Ericsson-ViG-User-agent-group-name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4495,'string','Ericsson-ViG-User-agent-name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4496,'integer','Ericsson-ViG-Routing-tariff',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4497,'integer','Ericsson-ViG-Re-selection-counter',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4498,'string','Ericsson-ViG-CPN-digits',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4499,'integer','Ericsson-ViG-CPN-TON',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4500,'integer','Ericsson-ViG-CPN-NP',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4501,'integer','Ericsson-ViG-CPN-PI',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4502,'integer','Ericsson-ViG-CPN-SI',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4503,'string','Ericsson-ViG-Dialled-num-digits',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4504,'integer','Ericsson-ViG-Dialled-num-TON',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4505,'integer','Ericsson-ViG-Dialled-num-NP',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4506,'string','Ericsson-ViG-Routing-num-digits',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4507,'integer','Ericsson-ViG-Routing-num-TON',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4508,'integer','Ericsson-ViG-Routing-num-NP',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4509,'string','Ericsson-ViG-Redirecting-num-digits',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4510,'integer','Ericsson-ViG-Redirecting-num-TON',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4511,'integer','Ericsson-ViG-Redirecting-num-NP',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4512,'integer','Ericsson-ViG-Redirecting-num-PI',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4513,'integer','Ericsson-ViG-Redirecting-num-RFD',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4514,'integer','Ericsson-ViG-Time-stamp-UTC',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4515,'integer','Ericsson-ViG-Time-stamp-UTC',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4516,'integer','Ericsson-ViG-Time-stamp-TZ',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4517,'integer','Ericsson-ViG-Time-stamp-DST',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4518,'integer','Ericsson-ViG-Session-routing-duration',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4519,'integer','Ericsson-ViG-Session-ringing-duration',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4520,'integer','Ericsson-ViG-Access-type',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4521,'integer','Ericsson-ViG-Requested-bandwidth',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4522,'integer','Ericsson-ViG-Allowed-bandwidth',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4523,'integer','Ericsson-ViG-Media-channel-count',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4524,'string','Ericsson-ViG-Voice-media-rec-forward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4525,'string','Ericsson-ViG-Voice-media-rec-backward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4526,'string','Ericsson-ViG-Video-media-rec-forward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4527,'string','Ericsson-ViG-Video-media-rec-backward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4528,'string','Ericsson-ViG-Fax-media-rec-forward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4529,'string','Ericsson-ViG-Fax-media-rec-backward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4530,'string','Ericsson-ViG-Data-media-rec-forward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4531,'string','Ericsson-ViG-Data-media-rec-backward',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4532,'integer','Ericsson-ViG-Charging-Case',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4533,'integer','Ericsson-ViG-Rel-cause-coding-std',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4534,'integer','Ericsson-ViG-Rel-cause-location',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4535,'integer','Ericsson-ViG-Rel-cause-class',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4536,'integer','Ericsson-ViG-Rel-cause-value',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4537,'integer','Ericsson-ViG-Rel-reason',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4538,'integer','Ericsson-ViG-Internal-Rel-reason-val',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4539,'integer','Ericsson-ViG-Internal-Rel-reason-orig',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4540,'integer','Ericsson-ViG-Service-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4541,'string','Ericsson-ViG-User-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4542,'string','Ericsson-ViG-Service-Name',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4543,'integer','Ericsson-ViG-Test-Call-Indicator',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4544,'integer','Ericsson-ViG-Test-Call-Indicator',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4545,'integer','Ericsson-ViG-Emergency-Call-Indicator',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4546,'string','Ericsson-ViG-Calling-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4547,'string','Ericsson-ViG-Called-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4548,'string','Ericsson-ViG-Translated-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4549,'string','Ericsson-ViG-Calling-User-Group-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4550,'string','Ericsson-ViG-Calling-Usr-Sub-Group-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4551,'string','Ericsson-ViG-Called-Usr-Group-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4552,'string','Ericsson-ViG-Called-Usr-Sub-Group-ID',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4553,'string','Ericsson-ViG-Terminal-Type',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4554,'integer','Ericsson-ViG-Service-Duration',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4555,'integer','Ericsson-ViG-Service-Execution-Result',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4556,'string','Ericsson-ViG-Service-Exe-Rslt-Desc',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4557,'string','Ericsson-ViG-Service-Description',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4558,'string','Ericsson-ViG-Service-Specific-Info',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4559,'ipaddr','Ericsson-ViG-Proxy-IP-Address',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4560,'integer','Ericsson-ViG-Auth-DataRequest',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4561,'integer','Ericsson-ViG-IPT-Time-Stamp',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4562,'integer','Ericsson-ViG-User-Name-Info',NULL,NULL,'Ericsson',NULL,NULL,NULL,NULL),
                                (4563,'string','Local-Web-Client-Ip',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4564,'string','Local-Web-Border-Router',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4565,'integer','Local-Web-Tx-Limit',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4566,'integer','Local-Web-Rx-Limit',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4567,'integer','Local-Web-Acct-Time',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4568,'integer','Local-Web-Acct-Duration',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4569,'integer','Local-Web-Acct-Interim-Tx-Bytes',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4570,'integer','Local-Web-Acct-Interim-Rx-Bytes',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4571,'integer','Local-Web-Acct-Interim-Tx-Gigawords',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4572,'integer','Local-Web-Acct-Interim-Rx-Gigawords',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4573,'integer','Local-Web-Acct-Interim-Tx-Mgmt',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4574,'integer','Local-Web-Acct-Interim-Rx-Mgmt',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4575,'integer','Local-Web-Acct-Tx-Mgmt',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4576,'integer','Local-Web-Acct-Rx-Mgmt',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4577,'integer','Local-Web-Reauth-Counter',NULL,NULL,'Local-Web',NULL,NULL,NULL,NULL),
                                (4578,'integer','HP-Privelege-Level',NULL,NULL,'HP',NULL,NULL,NULL,NULL),
                                (4579,'string','HP-Command-String',NULL,NULL,'HP',NULL,NULL,NULL,NULL),
                                (4580,'integer','HP-Command-Exception',NULL,NULL,'HP',NULL,NULL,NULL,NULL),
                                (4581,'string','HP-Port-Priority-Regeneration-Table',NULL,NULL,'HP',NULL,NULL,NULL,NULL),
                                (4582,'integer','HP-Bandwidth-Max-Ingress',NULL,NULL,'HP',NULL,NULL,NULL,NULL),
                                (4583,'string','HP-Nas-Filter-Rule',NULL,NULL,'HP',NULL,NULL,NULL,NULL),
                                (4584,'octets','CableLabs-Reserved',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4585,'octets','CableLabs-Event-Message',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4586,'string','CableLabs-MTA-Endpoint-Name',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4587,'string','CableLabs-Calling-Party-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4588,'string','CableLabs-Called-Party-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4589,'string','CableLabs-Database-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4590,'integer','CableLabs-Query-Type',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4591,'string','CableLabs-Returned-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4592,'octets','CableLabs-Call-Termination-Cause',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4593,'octets','CableLabs-Related-Call-Billing-Crl-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4594,'string','CableLabs-First-Call-Calling-Party-Num',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4595,'string','CableLabs-Second-Call-Calling-Party-Num',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4596,'string','CableLabs-Charge-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4597,'string','CableLabs-Forwarded-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4598,'string','CableLabs-Service-Name',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4599,'string','CableLabs-Intl-Code',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4600,'string','CableLabs-Dial-Around-Code',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4601,'string','CableLabs-Location-Routing-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4602,'string','CableLabs-Carrier-Identification-Code',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4603,'octets','CableLabs-Trunk-Group-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4604,'string','CableLabs-Routing-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4605,'integer','CableLabs-MTA-UDP-Portnum',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4606,'integer','CableLabs-Channel-State',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4607,'integer','CableLabs-SF-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4608,'string','CableLabs-Error-Description',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4609,'octets','CableLabs-QoS-Descriptor',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4610,'integer','CableLabs-Direction-indicator',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4611,'octets','CableLabs-Time-Adjustment',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4612,'string','CableLabs-SDP-Upstream',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4613,'string','CableLabs-SDP-Downstream',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4614,'string','CableLabs-User-Input',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4615,'string','CableLabs-Translation-Input',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4616,'octets','CableLabs-Redirected-From-Info',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4617,'octets','CableLabs-Electronic-Surveillance-Ind',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4618,'string','CableLabs-Redirected-From-Party-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4619,'string','CableLabs-Redirected-To-Party-Number',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4620,'octets','CableLabs-El-Surveillance-DF-Security',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4621,'octets','CableLabs-CCC-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4622,'string','CableLabs-Financial-Entity-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4623,'integer','CableLabs-Flow-Direction',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4624,'integer','CableLabs-Signal-Type',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4625,'integer','CableLabs-Alerting-Signal',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4626,'integer','CableLabs-Subject-Audible-Signal',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4627,'octets','CableLabs-Terminal-Display-Info',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4628,'string','CableLabs-Switch-Hook-Flash',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4629,'string','CableLabs-Dialed-Digits',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4630,'string','CableLabs-Misc-Signaling-Information',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4631,'integer','CableLabs-AM-Opaque-Data',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4632,'integer','CableLabs-Subscriber-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4633,'integer','CableLabs-Volume-Usage-Limit',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4634,'integer','CableLabs-Gate-Usage-Info',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4635,'integer','CableLabs-Element-Requesting-QoS',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4636,'integer','CableLabs-QoS-Release-Reason',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4637,'integer','CableLabs-Policy-Denied-Reason',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4638,'integer','CableLabs-Policy-Deleted-Reason',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4639,'integer','CableLabs-Policy-Update-Reason',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4640,'integer','CableLabs-Policy-Decision-Status',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4641,'integer','CableLabs-Application-Manager-ID',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4642,'integer','CableLabs-Time-Usage-Limit',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4643,'integer','CableLabs-Gate-Time-Info',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4644,'string','CableLabs-Account-Code',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4645,'string','CableLabs-Authorization-Code',NULL,NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4646,NULL,'CableLabs-Event-Message','Reserved',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4647,NULL,'CableLabs-Event-Message','Signaling-Start',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4648,NULL,'CableLabs-Event-Message','Signaling-Stop',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4649,NULL,'CableLabs-Event-Message','Database-Query',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4650,NULL,'CableLabs-Event-Message','Intelligent-Peripheral-Usage-Start',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4651,NULL,'CableLabs-Event-Message','Intelligent-Peripheral-Usage-Stop',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4652,NULL,'CableLabs-Event-Message','Service-Instance',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4653,NULL,'CableLabs-Event-Message','QoS-Reserve',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4654,NULL,'CableLabs-Event-Message','QoS-Release',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4655,NULL,'CableLabs-Event-Message','Service-Activation',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4656,NULL,'CableLabs-Event-Message','Service-Deactivation',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4657,NULL,'CableLabs-Event-Message','Media-Report',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4658,NULL,'CableLabs-Event-Message','Signal-Instance',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4659,NULL,'CableLabs-Event-Message','Interconnect-Signaling-Start',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4660,NULL,'CableLabs-Event-Message','Interconnect-Signaling-Stop',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4661,NULL,'CableLabs-Event-Message','Call-Answer',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4662,NULL,'CableLabs-Event-Message','Call-Disconnect',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4663,NULL,'CableLabs-Event-Message','Time-Change',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4664,NULL,'CableLabs-Event-Message','QoS-Commit',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4665,NULL,'CableLabs-Event-Message','Media-Alive',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4666,NULL,'CableLabs-Event-Message','Policy-Request',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4667,NULL,'CableLabs-Event-Message','Policy-Delete',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4668,NULL,'CableLabs-Event-Message','Policy-Update',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4669,NULL,'CableLabs-Query-Type','Reserved',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4670,NULL,'CableLabs-Query-Type','Toll-Free-Number-Looukp',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4671,NULL,'CableLabs-Query-Type','LNP-Number-Lookup',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4672,NULL,'CableLabs-Query-Type','Calling-Name-Delivery-Lookup',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4673,NULL,'CableLabs-Channel-State','Reserved',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4674,NULL,'CableLabs-Channel-State','Open',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4675,NULL,'CableLabs-Channel-State','Change',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4676,NULL,'CableLabs-Channel-State','Close',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4677,NULL,'CableLabs-Direction-indicator','Undefined',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4678,NULL,'CableLabs-Direction-indicator','Originating',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4679,NULL,'CableLabs-Direction-indicator','Terminating',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4680,NULL,'CableLabs-Flow-Direction','Reserved',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4681,NULL,'CableLabs-Flow-Direction','Upstream',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4682,NULL,'CableLabs-Flow-Direction','Downstream',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4683,NULL,'CableLabs-Signal-Type','Reserved',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4684,NULL,'CableLabs-Signal-Type','Network-Signal',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4685,NULL,'CableLabs-Signal-Type','Subject-Signal',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4686,NULL,'CableLabs-Alerting-Signal','Reserved-0',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4687,NULL,'CableLabs-Alerting-Signal','Ringing',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4688,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-2',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4689,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-3',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4690,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-4',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4691,NULL,'CableLabs-Alerting-Signal','Ringsplash',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4692,NULL,'CableLabs-Alerting-Signal','Call-Waiting-Tone-1',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4693,NULL,'CableLabs-Alerting-Signal','Call-Waiting-Tone-2',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4694,NULL,'CableLabs-Alerting-Signal','Call-Waiting-Tone-3',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4695,NULL,'CableLabs-Alerting-Signal','Call-Waiting-Tone-4',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4696,NULL,'CableLabs-Alerting-Signal','Reserved-10',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4697,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-0',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4698,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-1',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4699,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-5',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4700,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-6',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4701,NULL,'CableLabs-Alerting-Signal','Distinctive-Ringing-7',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4702,NULL,'CableLabs-AM-Opaque-Data','Reserved-0',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4703,NULL,'CableLabs-AM-Opaque-Data','Dial-Tone',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4704,NULL,'CableLabs-AM-Opaque-Data','Stutter-Dial-Tone',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4705,NULL,'CableLabs-AM-Opaque-Data','Ring-Back-Tone',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4706,NULL,'CableLabs-AM-Opaque-Data','Reorder-Tone',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4707,NULL,'CableLabs-AM-Opaque-Data','Busy-Tone',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4708,NULL,'CableLabs-AM-Opaque-Data','Confirmation-Tone',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4709,NULL,'CableLabs-AM-Opaque-Data','Reserved-7',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4710,NULL,'CableLabs-AM-Opaque-Data','Message-Waiting-Indicator',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4711,NULL,'CableLabs-AM-Opaque-Data','Off-hook-Warning-Tone',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4712,NULL,'CableLabs-Element-Requesting-QoS','Client',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4713,NULL,'CableLabs-Element-Requesting-QoS','Policy-Server',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4714,NULL,'CableLabs-Element-Requesting-QoS','Embedded-Client',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4715,NULL,'CableLabs-QoS-Release-Reason','Gate-Closed-By-PS',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4716,NULL,'CableLabs-QoS-Release-Reason','Inactivity-Resource-Recovery-Timer-Expiration',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4717,NULL,'CableLabs-QoS-Release-Reason','CM-Failure',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4718,NULL,'CableLabs-QoS-Release-Reason','Pre-Empted',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4719,NULL,'CableLabs-QoS-Release-Reason','RSVP-PathTear-request',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4720,NULL,'CableLabs-QoS-Release-Reason','CM-Request',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4721,NULL,'CableLabs-QoS-Release-Reason','Admitted-Timer-Expiration',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4722,NULL,'CableLabs-QoS-Release-Reason','Other',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4723,NULL,'CableLabs-Policy-Denied-Reason','Policy-Server-Admission-Control-Failure',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4724,NULL,'CableLabs-Policy-Denied-Reason','Insufficient-Resources',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4725,NULL,'CableLabs-Policy-Denied-Reason','Unknown-Subscriber',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4726,NULL,'CableLabs-Policy-Denied-Reason','Unauthorized-AMID',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4727,NULL,'CableLabs-Policy-Denied-Reason','Undefined-Service-Class-Name',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4728,NULL,'CableLabs-Policy-Denied-Reason','Incompatible-Envelope',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4729,NULL,'CableLabs-Policy-Denied-Reason','Other',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4730,NULL,'CableLabs-Policy-Deleted-Reason','Application-Manager-Request',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4731,NULL,'CableLabs-Policy-Deleted-Reason','CMTS-Decistion',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4732,NULL,'CableLabs-Policy-Deleted-Reason','Other',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4733,NULL,'CableLabs-Policy-Update-Reason','Traffic-Profile',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4734,NULL,'CableLabs-Policy-Update-Reason','Classifier',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4735,NULL,'CableLabs-Policy-Update-Reason','Volume-Limit',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4736,NULL,'CableLabs-Policy-Update-Reason','Time-Limit',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4737,NULL,'CableLabs-Policy-Update-Reason','Opaque-Data',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4738,NULL,'CableLabs-Policy-Update-Reason','Multiple-Updates',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4739,NULL,'CableLabs-Policy-Update-Reason','Other',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4740,NULL,'CableLabs-Policy-Decision-Status','Policy-Approved',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4741,NULL,'CableLabs-Policy-Decision-Status','Policy-Denied',NULL,'CableLabs',NULL,NULL,NULL,NULL),
                                (4742,'integer','RP-Upstream-Speed-Limit',NULL,NULL,'Roaring-Penguin',NULL,NULL,NULL,NULL),
                                (4743,'integer','RP-Downstream-Speed-Limit',NULL,NULL,'Roaring-Penguin',NULL,NULL,NULL,NULL),
                                (4744,'string','RP-HURL',NULL,NULL,'Roaring-Penguin',NULL,NULL,NULL,NULL),
                                (4745,'string','RP-MOTM',NULL,NULL,'Roaring-Penguin',NULL,NULL,NULL,NULL),
                                (4746,'integer','RP-Max-Sessions-Per-User',NULL,NULL,'Roaring-Penguin',NULL,NULL,NULL,NULL),
                                (4747,'integer','3GPP2-Ike-Preshared-Secret-Request',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4748,'integer','3GPP2-Security-Level',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4749,'string','3GPP2-Pre-Shared-Secret',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4750,'integer','3GPP2-Reverse-Tunnel-Spec',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4751,'integer','3GPP2-Diffserv-Class-Option',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4752,'octets','3GPP2-Accounting-Container',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4753,'ipaddr','3GPP2-Home-Agent-IP-Address',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4754,'string','3GPP2-KeyID',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4755,'ipaddr','3GPP2-PCF-IP-Address',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4756,'string','3GPP2-BSID',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4757,'integer','3GPP2-User-Id',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4758,'integer','3GPP2-Forward-FCH-Mux-Option',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4759,'integer','3GPP2-Reverse-FCH-Mux-Option',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4760,'integer','3GPP2-Service-Option',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4761,'integer','3GPP2-Forward-Traffic-Type',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4762,'integer','3GPP2-Reverse-Traffic-Type',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4763,'integer','3GPP2-FCH-Frame-Size',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4764,'integer','3GPP2-Forward-FCH-RC',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4765,'integer','3GPP2-Reverse-FCH-RC',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4766,'integer','3GPP2-IP-Technology',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4767,'integer','3GPP2-Compulsory-Tunnel-Indicator',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4768,'integer','3GPP2-Release-Indicator',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4769,'integer','3GPP2-Bad-PPP-Frame-Count',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4770,'integer','3GPP2-Number-Active-Transitions',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4771,'integer','3GPP2-Terminating-SDB-Octet-Count',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4772,'integer','3GPP2-Originating-SDB-OCtet-Count',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4773,'integer','3GPP2-Terminating-Number-SDBs',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4774,'integer','3GPP2-Originating-Number-SDBs',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4775,'integer','3GPP2-IP-QoS',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4776,'integer','3GPP2-Airlink-Priority',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4777,'integer','3GPP2-Airlink-Record-Type',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4778,'integer','3GPP2-Airlink-Sequence-Number',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4779,'integer','3GPP2-Received-HDLC-Octets',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4780,'string','3GPP2-Correlation-Id',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4781,'octets','3GPP2-Module-Orig-Term-Indicator',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4782,'integer','3GPP2-Inbound-Mobile-IP-Sig-Octets',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4783,'integer','3GPP2-Outbound-Mobile-IP-Sig-Octets',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4784,'integer','3GPP2-Session-Continue',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4785,'integer','3GPP2-Active-Time',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4786,'integer','3GPP2-DCCH-Frame-Size',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4787,'integer','3GPP2-Begin-Session',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4788,'string','3GPP2-ESN',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4789,'octets','3GPP2-S-Key',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4790,'integer','3GPP2-S-Request',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4791,'date','3GPP2-S-Lifetime',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4792,'integer','3GPP2-MN-HA-SPI',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4793,'string','3GPP2-MN-HA-Shared-Key',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4794,'octets','3GPP2-Remote-IP-Address',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4795,'octets','3GPP2-Remote-IPv6-Address',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4796,'octets','3GPP2-Remote-Address-Table-Index',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4797,'octets','3GPP2-Remote-IPv4-Addr-Octet-Count',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4798,'octets','3GPP2-Allowed-Diffserv-Marking',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4799,'octets','3GPP2-Service-Option-Profile',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4800,'integer','3GPP2-DNS-Update-Required',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4801,'ipaddr','3GPP2-Foreign-Agent-Address',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4802,'integer','3GPP2-Last-User-Activity-Time',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4803,'integer','3GPP2-MN-AAA-Removal-Indication',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4804,'integer','3GPP2-RN-Packet-Data-Inactivity-Timer',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4805,'integer','3GPP2-Forward-PDCH-RC',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4806,'integer','3GPP2-Forward-DCCH-Mux-Option',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4807,'integer','3GPP2-Reverse-DCCH-Mux-Option',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4808,'integer','3GPP2-Forward-DCCH-RC',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4809,'integer','3GPP2-Reverse-DHHC-RC',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4810,'integer','3GPP2-Session-Termination-Capability',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4811,'integer','3GPP2-Allowed-Persistent-TFTs',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4812,'octets','3GPP2-Prepaid-Acct-Quota',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4813,'octets','3GPP2-Prepaid-acct-Capability',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4814,'octets','3GPP2-MIP-Lifetime',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4815,'integer','3GPP2-Acct-Stop-Trigger',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4816,'octets','3GPP2-Service-Reference-Id',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4817,'integer','3GPP2-DNS-Update-Capability',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4818,'integer','3GPP2-Disconnect-Reason',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4819,'octets','3GPP2-Remote-IPv6-Octet-Count',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4820,'octets','3GPP2-PrePaid-Tariff-Switching',NULL,NULL,'3GPP2',NULL,NULL,NULL,NULL),
                                (4821,'string','Epygi-AVPair',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4822,'string','Epygi-NAS-Port',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4823,'string','Epygi-h323-remote-address',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4824,'string','Epygi-h323-conf-id',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4825,'string','Epygi-h323-setup-time',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4826,'string','Epygi-h323-call-origin',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4827,'string','Epygi-h323-call-type',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4828,'string','Epygi-h323-connect-time',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4829,'string','Epygi-h323-disconnect-time',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4830,'string','Epygi-h323-disconnect-cause',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4831,'string','Epygi-h323-voice-quality',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4832,'string','Epygi-h323-gw-id',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4833,'string','Epygi-h323-incoming-conf-id',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4834,'string','Epygi-h323-credit-amount',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4835,'string','Epygi-h323-credit-time',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4836,'string','Epygi-h323-return-code',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4837,'string','Epygi-h323-prompt-id',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4838,'string','Epygi-h323-time-and-day',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4839,'string','Epygi-h323-redirect-number',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4840,'string','Epygi-h323-preferred-lang',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4841,'string','Epygi-h323-redirect-ip-address',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4842,'string','Epygi-h323-billing-model',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4843,'string','Epygi-h323-currency',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4844,'string','Epygi-RegExpDate',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4845,'string','Epygi-FiadID',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4846,'string','Epygi-PortID',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4847,'string','Epygi-AccessType',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4848,'string','Epygi-CallInfo',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4849,'string','Epygi-OrigCallID',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4850,'string','Epygi-ParentCallID',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4851,'integer','Epygi-CallType',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4852,'string','Epygi-DeviceName',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4853,'integer','Epygi-InterfaceName',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4854,'integer','Epygi-InterfaceNumber',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4855,'integer','Epygi-TimeslotNumber',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4856,'integer','Epygi-OrigIpAddr',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4857,'integer','Epygi-DestIpAddr',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4858,'integer','Epygi-OrigIpPort',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4859,'integer','Epygi-DestIpPort',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4860,'string','Epygi-CallingPartyNumber',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4861,'string','Epygi-CalledPartyNumber',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4862,'integer','Epygi-DateTimeOrigination',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4863,'integer','Epygi-DateTimeConnect',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4864,'integer','Epygi-DateTimeDisconnect',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4865,'integer','Epygi-Duration',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4866,'integer','Epygi-OutSourceRTP_IP',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4867,'integer','Epygi-OutDestRTP_IP',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4868,'integer','Epygi-InSourceRTP_IP',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4869,'integer','Epygi-InDestRTP_IP',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4870,'integer','Epygi-OutSourceRTP_port',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4871,'integer','Epygi-OutDestRTP_port',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4872,'integer','Epygi-InSourceRTP_port',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4873,'integer','Epygi-InDestRTP_port',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4874,'integer','Epygi-CallRedirectReason',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4875,'integer','Epygi-CallDisconnectReason',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4876,'integer','Epygi-OutRTP_Payload',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4877,'integer','Epygi-OutRTP_PacketSize',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4878,'integer','Epygi-OutRTP_Packets',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4879,'integer','Epygi-OutRTP_Octets',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4880,'integer','Epygi-InRTP_Payload',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4881,'integer','Epygi-InRTP_PacketSize',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4882,'integer','Epygi-InRTP_Packets',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4883,'integer','Epygi-InRTP_Octets',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4884,'integer','Epygi-InRTP_PacketsLost',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4885,'integer','Epygi-InRTP_PacketsDupl',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4886,'integer','Epygi-InRTP_Jitter',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4887,'integer','Epygi-InRTP_Latency',NULL,NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4888,NULL,'Epygi-CallType','Internal',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4889,NULL,'Epygi-CallType','SIP',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4890,NULL,'Epygi-CallType','H.323',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4891,NULL,'Epygi-CallType','FXO',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4892,NULL,'Epygi-CallType','T1-E1-CAS',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4893,NULL,'Epygi-CallType','T1-E1-CCS',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4894,NULL,'Epygi-CallType','ISDN-PRI',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4895,NULL,'Epygi-InterfaceName','Ethernet',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4896,NULL,'Epygi-InterfaceName','FXO',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4897,NULL,'Epygi-InterfaceName','T1-E1-User',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4898,NULL,'Epygi-InterfaceName','T1-E1-Network',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4899,NULL,'Epygi-InterfaceName','ISDN',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4900,NULL,'Epygi-CallRedirectReason','No-Reason',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4901,NULL,'Epygi-CallRedirectReason','Call-Forward-Uncondit',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4902,NULL,'Epygi-CallRedirectReason','Call-Forward-Busy',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4903,NULL,'Epygi-CallRedirectReason','Call-Forward-NoAnswer',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4904,NULL,'Epygi-CallRedirectReason','Call-Tranfer',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4905,NULL,'Epygi-CallRedirectReason','Call-Park',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4906,NULL,'Epygi-CallRedirectReason','Call-Pickup',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4907,NULL,'Epygi-CallRedirectReason','ManyExtension-Ringing',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4908,NULL,'Epygi-CallRedirectReason','Hunt-Group',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4909,NULL,'Epygi-CallDisconnectReason','Call-Is-Redirected',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4910,NULL,'Epygi-CallDisconnectReason','Call-Origin-OnHook',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4911,NULL,'Epygi-CallDisconnectReason','Call-Temin-OnHook',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4912,NULL,'Epygi-CallDisconnectReason','Disconected-by-CAC',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4913,NULL,'Epygi-CallDisconnectReason','Other',NULL,'Epygi',NULL,NULL,NULL,NULL),
                                (4914,NULL,'Acct-Terminate-Cause','Supplicant-Restart',NULL,'dictionary.rfc3580',NULL,NULL,NULL,NULL),
                                (4915,NULL,'Acct-Terminate-Cause','Reauthentication-Failure',NULL,'dictionary.rfc3580',NULL,NULL,NULL,NULL),
                                (4916,NULL,'Acct-Terminate-Cause','Port-Reinit',NULL,'dictionary.rfc3580',NULL,NULL,NULL,NULL),
                                (4917,NULL,'Acct-Terminate-Cause','Port-Disabled',NULL,'dictionary.rfc3580',NULL,NULL,NULL,NULL),
                                (4918,NULL,'NAS-Port-Type','Token-Ring',NULL,'dictionary.rfc3580',NULL,NULL,NULL,NULL),
                                (4919,NULL,'NAS-Port-Type','FDDI',NULL,'dictionary.rfc3580',NULL,NULL,NULL,NULL),
                                (4920,NULL,'Tunnel-Type','VLAN',NULL,'dictionary.rfc3580',NULL,NULL,NULL,NULL),
                                (4921,'integer','Foundry-Privilege-Level',NULL,NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4922,'string','Foundry-Command-String',NULL,NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4923,'integer','Foundry-Command-Exception-Flag',NULL,NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4924,'integer','Foundry-INM-Privilege',NULL,NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4925,NULL,'Foundry-INM-Privilege','AAA_pri_0',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4926,NULL,'Foundry-INM-Privilege','AAA_pri_1',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4927,NULL,'Foundry-INM-Privilege','AAA_pri_2',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4928,NULL,'Foundry-INM-Privilege','AAA_pri_3',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4929,NULL,'Foundry-INM-Privilege','AAA_pri_4',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4930,NULL,'Foundry-INM-Privilege','AAA_pri_5',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4931,NULL,'Foundry-INM-Privilege','AAA_pri_6',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4932,NULL,'Foundry-INM-Privilege','AAA_pri_7',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4933,NULL,'Foundry-INM-Privilege','AAA_pri_8',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4934,NULL,'Foundry-INM-Privilege','AAA_pri_9',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4935,NULL,'Foundry-INM-Privilege','AAA_pri_10',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4936,NULL,'Foundry-INM-Privilege','AAA_pri_11',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4937,NULL,'Foundry-INM-Privilege','AAA_pri_12',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4938,NULL,'Foundry-INM-Privilege','AAA_pri_13',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4939,NULL,'Foundry-INM-Privilege','AAA_pri_14',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4940,NULL,'Foundry-INM-Privilege','AAA_pri_15',NULL,'Foundry',NULL,NULL,NULL,NULL),
                                (4941,'integer','3Com-User-Access-Level',NULL,NULL,'3com',NULL,NULL,NULL,NULL),
                                (4942,NULL,'3Com-User-Access-Level','3Com-Visitor',NULL,'3com',NULL,NULL,NULL,NULL),
                                (4943,NULL,'3Com-User-Access-Level','3Com-Monitor',NULL,'3com',NULL,NULL,NULL,NULL),
                                (4944,NULL,'3Com-User-Access-Level','3Com-Manager',NULL,'3com',NULL,NULL,NULL,NULL),
                                (4945,NULL,'3Com-User-Access-Level','3Com-Administrator',NULL,'3com',NULL,NULL,NULL,NULL),
                                (4946,'integer','3Com-Connect_Id',NULL,NULL,'3com',NULL,NULL,NULL,NULL),
                                (4947,'integer','3Com-NAS-Startup-Timestamp',NULL,NULL,'3com',NULL,NULL,NULL,NULL),
                                (4948,'string','3Com-Ip-Host-Addr',NULL,NULL,'3com',NULL,NULL,NULL,NULL),
                                (4949,'string','3Com-Product-ID',NULL,NULL,'3com',NULL,NULL,NULL,NULL),
                                (4950,'string','Trapeze-VLAN-Name',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4951,'string','Trapeze-Mobility-Profile',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4952,'string','Trapeze-Encryption-Type',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4953,'string','Trapeze-Time-Of-Day',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4954,'string','Trapeze-SSID',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4955,'string','Trapeze-End-Date',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4956,'string','Trapeze-Start-Date',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4957,'string','Trapeze-URL',NULL,NULL,'Trapeze',NULL,NULL,NULL,NULL),
                                (4958,'string','T-Systems-Nova-Location-ID',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4959,'string','T-Systems-Nova-Location-Name',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4960,'string','T-Systems-Nova-Logoff-URL',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4961,'string','T-Systems-Nova-Redirection-URL',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4962,'integer','T-Systems-Nova-Bandwidth-Min-Up',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4963,'integer','T-Systems-Nova-Bandwidth-Min-Down',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4964,'integer','T-Systems-Nova-Bandwidth-Max-Up',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4965,'integer','T-Systems-Nova-Bandwidth-Max-Down',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4966,'integer','T-Systems-Nova-Session-Terminate-Time',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4967,'integer','T-Systems-Nova-Session-Terminate-EoD',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4968,'string','T-Systems-Nova-Billing-Class-Of-Service',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4969,'string','T-Systems-Nova-Service-Name',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4970,'integer','T-Systems-Nova-Price-Of-Service',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4971,'string','T-Systems-Nova-Visiting-Provider-Code',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4972,'string','T-Systems-Nova-UnknownAVP',NULL,NULL,'T-Systems-Nova',NULL,NULL,NULL,NULL),
                                (4973,'integer','Tunnel-Type',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4974,'integer','Tunnel-Medium-Type',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4975,'string','Tunnel-Client-Endpoint',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4976,'string','Tunnel-Server-Endpoint',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4977,'string','Tunnel-Password',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4978,'string','Tunnel-Private-Group-Id',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4979,'string','Tunnel-Assignment-Id',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4980,'integer','Tunnel-Preference',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4981,'string','Tunnel-Client-Auth-Id',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4982,'string','Tunnel-Server-Auth-Id',NULL,NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4983,NULL,'Tunnel-Type','PPTP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4984,NULL,'Tunnel-Type','L2F',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4985,NULL,'Tunnel-Type','L2TP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4986,NULL,'Tunnel-Type','ATMP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4987,NULL,'Tunnel-Type','VTP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4988,NULL,'Tunnel-Type','AH',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4989,NULL,'Tunnel-Type','IP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4990,NULL,'Tunnel-Type','MIN-IP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4991,NULL,'Tunnel-Type','ESP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4992,NULL,'Tunnel-Type','GRE',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4993,NULL,'Tunnel-Type','DVS',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4994,NULL,'Tunnel-Type','IP-in-IP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4995,NULL,'Tunnel-Medium-Type','IP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4996,NULL,'Tunnel-Medium-Type','IPv4',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4997,NULL,'Tunnel-Medium-Type','IPv6',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4998,NULL,'Tunnel-Medium-Type','NSAP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (4999,NULL,'Tunnel-Medium-Type','HDLC',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5000,NULL,'Tunnel-Medium-Type','BBN-1822',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5001,NULL,'Tunnel-Medium-Type','IEEE-802',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5002,NULL,'Tunnel-Medium-Type','E.163',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5003,NULL,'Tunnel-Medium-Type','E.164',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5004,NULL,'Tunnel-Medium-Type','F.69',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5005,NULL,'Tunnel-Medium-Type','X.121',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5006,NULL,'Tunnel-Medium-Type','IPX',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5007,NULL,'Tunnel-Medium-Type','Appletalk',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5008,NULL,'Tunnel-Medium-Type','DecNet-IV',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5009,NULL,'Tunnel-Medium-Type','Banyan-Vines',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5010,NULL,'Tunnel-Medium-Type','E.164-NSAP',NULL,'dictionary.rfc2868',NULL,NULL,NULL,NULL),
                                (5011,'string','CVPN3000-Access-Hours',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5012,'integer','CVPN3000-Simultaneous-Logins',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5013,'integer','CVPN3000-Min-Password-Length',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5014,'integer','CVPN3000-Allow-Alpha-Only-Passwords',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5015,'ipaddr','CVPN3000-Primary-DNS',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5016,'ipaddr','CVPN3000-Secondary-DNS',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5017,'ipaddr','CVPN3000-Primary-WINS',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5018,'ipaddr','CVPN3000-Secondary-WINS',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5019,'integer','CVPN3000-SEP-Card-Assignment',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5020,'ipaddr','CVPN3000-Priority-On-SEP',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5021,'integer','CVPN3000-Tunneling-Protocols',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5022,'string','CVPN3000-IPSec-Sec-Association',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5023,'integer','CVPN3000-IPSec-Authentication',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5024,'string','CVPN3000-IPSec-Banner1',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5025,'integer','CVPN3000-IPSec-Allow-Passwd-Store',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5026,'integer','CVPN3000-Use-Client-Address',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5027,'integer','CVPN3000-PPTP-Min-Auth-Protocol',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5028,'integer','CVPN3000-L2TP-Min-Auth-Protocol',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5029,'integer','CVPN3000-PPTP-Encryption',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5030,'integer','CVPN3000-L2TP-Encryption',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5031,'integer','CVPN3000-Auth-Server-Type',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5032,'string','CVPN3000-Auth-Server-Password',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5033,'string','CVPN3000-Request-Auth-Vector',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5034,'integer','CVPN3000-IPSec-LTL-Keepalives',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5035,'string','CVPN3000-IPSec-Group-Name',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5036,'string','CVPN3000-IPSec-Split-Tunnel-List',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5037,'string','CVPN3000-IPSec-Default-Domain',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5038,'string','CVPN3000-IPSec-Split-DNS-Names',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5039,'integer','CVPN3000-IPSec-Tunnel-Type',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5040,'integer','CVPN3000-IPSec-Mode-Config',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5041,'integer','CVPN3000-Auth-Server-Priority',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5042,'integer','CVPN3000-IPSec-User-Group-Lock',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5043,'integer','CVPN3000-IPSec-Over-UDP',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5044,'integer','CVPN3000-IPSec-Over-UDP-Port',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5045,'string','CVPN3000-IPSec-Banner2',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5046,'integer','CVPN3000-PPTP-MPPC-Compression',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5047,'integer','CVPN3000-L2TP-MPPC-Compression',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5048,'integer','CVPN3000-IPSec-IP-Compression',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5049,'integer','CVPN3000-IPSec-IKE-Peer-ID-Check',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5050,'integer','CVPN3000-IKE-Keep-Alives',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5051,'integer','CVPN3000-IPSec-Auth-On-Rekey',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5052,'integer','CVPN3000-Reqrd-Client-Fw-Vendor-Code',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5053,'integer','CVPN3000-Reqrd-Client-Fw-Product-Code',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5054,'string','CVPN3000-Reqrd-Client-Fw-Description',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5055,'integer','CVPN3000-Require-HW-Client-Auth',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5056,'integer','CVPN3000-Require-Individual-User-Auth',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5057,'integer','CVPN3000-Authd-User-Idle-Timeout',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5058,'integer','CVPN3000-Cisco-IP-Phone-Bypass',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5059,'string','CVPN3000-User-Auth-Server-Name',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5060,'integer','CVPN3000-User-Auth-Server-Port',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5061,'string','CVPN3000-User-Auth-Server-Secret',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5062,'integer','CVPN3000-IPSec-Split-Tunneling-Policy',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5063,'integer','CVPN3000-IPSec-Reqrd-Client-Fw-Cap',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5064,'string','CVPN3000-IPSec-Client-Fw-Filter-Name',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5065,'integer','CVPN3000-IPSec-Client-Fw-Filter-Opt',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5066,'integer','CVPN3000-IPSec-Backup-Servers',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5067,'string','CVPN3000-IPSec-Backup-Server-List',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5068,'ipaddr','CVPN3000-DHCP-Network-Scope',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5069,'integer','CVPN3000-MS-Client-Icpt-DHCP-Conf-Msg',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5070,'ipaddr','CVPN3000-MS-Client-Subnet-Mask',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5071,'integer','CVPN3000-Allow-Network-Extension-Mode',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5072,'integer','CVPN3000-IPSec-Authorization-Type',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5073,'integer','CVPN3000-IPSec-Authorization-Required',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5074,'string','CVPN3000-IPSec-DN-Field',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5075,'integer','CVPN3000-IPSec-Confidence-Level',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5076,'integer','CVPN3000-WebVPN-Content-Filter',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5077,'integer','CVPN3000-WebVPN-Enable-functions',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5078,'string','CVPN3000-WebVPN-Exchange-Addr',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5079,'integer','CVPN3000-LEAP-Bypass',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5080,'string','CVPN3000-WebVPN-Exchange-NETBIOS-name',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5081,'string','CVPN3000-Port-Forwarding-Name',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5082,'ipaddr','CVPN3000-Partition-Primary-DHCP',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5083,'ipaddr','CVPN3000-Partition-Secondary-DHCP',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5084,'ipaddr','CVPN3000-Partition-Premise-Router',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5085,'integer','CVPN3000-Partition-Max-Sessions',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5086,'string','CVPN3000-Partition-Mobile-IP-Key',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5087,'ipaddr','CVPN3000-Partition-Mobile-IP-Address',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5088,'integer','CVPN3000-Partition-Mobile-IP-SPI',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5089,'integer','CVPN3000-Strip-Realm',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5090,'integer','CVPN3000-Group-Name',NULL,NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5091,NULL,'CVPN3000-Allow-Alpha-Only-Passwords','Disallow',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5092,NULL,'CVPN3000-Allow-Alpha-Only-Passwords','Allow',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5093,NULL,'CVPN3000-SEP-Card-Assignment','SEP1',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5094,NULL,'CVPN3000-SEP-Card-Assignment','SEP2',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5095,NULL,'CVPN3000-SEP-Card-Assignment','SEP3',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5096,NULL,'CVPN3000-SEP-Card-Assignment','SEP4',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5097,NULL,'CVPN3000-SEP-Card-Assignment','Any-SEP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5098,NULL,'CVPN3000-Priority-On-SEP','High',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5099,NULL,'CVPN3000-Priority-On-SEP','Med-High',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5100,NULL,'CVPN3000-Priority-On-SEP','Medium',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5101,NULL,'CVPN3000-Priority-On-SEP','Med-Low',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5102,NULL,'CVPN3000-Priority-On-SEP','Low',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5103,NULL,'CVPN3000-Tunneling-Protocols','PPTP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5104,NULL,'CVPN3000-Tunneling-Protocols','L2TP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5105,NULL,'CVPN3000-Tunneling-Protocols','IPSec',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5106,NULL,'CVPN3000-Tunneling-Protocols','PPTP-and-IPSec',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5107,NULL,'CVPN3000-Tunneling-Protocols','L2TP/IPSec',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5108,NULL,'CVPN3000-Tunneling-Protocols','All',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5109,NULL,'CVPN3000-IPSec-Authentication','None',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5110,NULL,'CVPN3000-IPSec-Authentication','RADIUS',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5111,NULL,'CVPN3000-IPSec-Authentication','LDAP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5112,NULL,'CVPN3000-IPSec-Authentication','NTDomain',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5113,NULL,'CVPN3000-IPSec-Authentication','SDI',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5114,NULL,'CVPN3000-IPSec-Authentication','Internal',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5115,NULL,'CVPN3000-IPSec-Allow-Passwd-Store','Disallow',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5116,NULL,'CVPN3000-IPSec-Allow-Passwd-Store','Allow',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5117,NULL,'CVPN3000-Use-Client-Address','Disallow',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5118,NULL,'CVPN3000-Use-Client-Address','Allow',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5119,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','PAP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5120,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','CHAP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5121,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','EAP-MD5',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5122,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','EAP-GTC',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5123,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','EAP-TLS',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5124,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','MSCHAPv1',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5125,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','MSCHAPv2',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5126,NULL,'CVPN3000-PPTP-Min-Auth-Protocol','Default',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5127,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','PAP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5128,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','CHAP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5129,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','EAP-MD5',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5130,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','EAP-GTC',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5131,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','EAP-TLS',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5132,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','MSCHAPv1',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5133,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','MSCHAPv2',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5134,NULL,'CVPN3000-L2TP-Min-Auth-Protocol','Default',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5135,NULL,'CVPN3000-PPTP-Encryption','PPTP-40bit',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5136,NULL,'CVPN3000-PPTP-Encryption','PPTP-40-Encryption-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5137,NULL,'CVPN3000-PPTP-Encryption','PPTP-128',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5138,NULL,'CVPN3000-PPTP-Encryption','PPTP-128-Encryption-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5139,NULL,'CVPN3000-PPTP-Encryption','PPTP-40-or-128',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5140,NULL,'CVPN3000-PPTP-Encryption','PPTP-40-or-128-Encry-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5141,NULL,'CVPN3000-PPTP-Encryption','PPTP-40-Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5142,NULL,'CVPN3000-PPTP-Encryption','PPTP-40-Enc/Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5143,NULL,'CVPN3000-PPTP-Encryption','PPTP-128-Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5144,NULL,'CVPN3000-PPTP-Encryption','PPTP-128-Enc/Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5145,NULL,'CVPN3000-PPTP-Encryption','PPTP-40/128-Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5146,NULL,'CVPN3000-PPTP-Encryption','PPTP-40/128-Enc/Statls-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5147,NULL,'CVPN3000-L2TP-Encryption','L2TP-40bit',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5148,NULL,'CVPN3000-L2TP-Encryption','L2TP-40-Encryption-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5149,NULL,'CVPN3000-L2TP-Encryption','L2TP-128',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5150,NULL,'CVPN3000-L2TP-Encryption','L2TP-128-Encryption-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5151,NULL,'CVPN3000-L2TP-Encryption','L2TP-40-or-128',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5152,NULL,'CVPN3000-L2TP-Encryption','L2TP-40-or-128-Encry-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5153,NULL,'CVPN3000-L2TP-Encryption','L2TP-40-Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5154,NULL,'CVPN3000-L2TP-Encryption','L2TP-40-Enc/Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5155,NULL,'CVPN3000-L2TP-Encryption','L2TP-128-Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5156,NULL,'CVPN3000-L2TP-Encryption','L2TP-128-Enc/Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5157,NULL,'CVPN3000-L2TP-Encryption','L2TP-40/128-Stateless-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5158,NULL,'CVPN3000-L2TP-Encryption','L2TP-40/128-Enc/Statls-Req',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5159,NULL,'CVPN3000-Auth-Server-Type','First-Active-Server',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5160,NULL,'CVPN3000-Auth-Server-Type','RADIUS',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5161,NULL,'CVPN3000-Auth-Server-Type','LDAP',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5162,NULL,'CVPN3000-Auth-Server-Type','NT',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5163,NULL,'CVPN3000-Auth-Server-Type','SDI',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5164,NULL,'CVPN3000-Auth-Server-Type','Internal',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5165,NULL,'CVPN3000-IPSec-LTL-Keepalives','OFF',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5166,NULL,'CVPN3000-IPSec-LTL-Keepalives','ON',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5167,NULL,'CVPN3000-IPSec-Tunnel-Type','LAN-to-LAN',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5168,NULL,'CVPN3000-IPSec-Tunnel-Type','Remote-Access',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5169,NULL,'CVPN3000-IPSec-Mode-Config','ON',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5170,NULL,'CVPN3000-IPSec-Mode-Config','OFF',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5171,NULL,'CVPN3000-IPSec-User-Group-Lock','OFF',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5172,NULL,'CVPN3000-IPSec-User-Group-Lock','ON',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5173,NULL,'CVPN3000-IPSec-Over-UDP','OFF',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5174,NULL,'CVPN3000-IPSec-Over-UDP','ON',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5175,NULL,'CVPN3000-Strip-Realm','FALSE',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5176,NULL,'CVPN3000-Strip-Realm','TRUE',NULL,'Cisco-VPN3000',NULL,NULL,NULL,NULL),
                                (5177,'string','Juniper-Local-User-Name',NULL,NULL,'Juniper',NULL,NULL,NULL,NULL),
                                (5178,'string','Juniper-Allow-Commands',NULL,NULL,'Juniper',NULL,NULL,NULL,NULL),
                                (5179,'string','Juniper-Deny-Commands',NULL,NULL,'Juniper',NULL,NULL,NULL,NULL),
                                (5180,'string','Juniper-Allow-Configuration',NULL,NULL,'Juniper',NULL,NULL,NULL,NULL),
                                (5181,'string','Juniper-Deny-Configuration',NULL,NULL,'Juniper',NULL,NULL,NULL,NULL),
                                (5182,'integer','Sip-Method',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5183,'integer','Sip-Response-Code',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5184,'string','Sip-Cseq',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5185,'string','Sip-To-Tag',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5186,'string','Sip-From-Tag',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5187,'string','Sip-Branch-ID',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5188,'string','Sip-Translated-Request-ID',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5189,'ipaddr','Sip-Source-IP-Address',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5190,'integer','Sip-Source-Port',NULL,NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5191,NULL,'Service-Type','Sip-Session',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5192,NULL,'Sip-Method','INVITE',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5193,NULL,'Sip-Method','BYE',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5194,NULL,'Sip-Method','REGISTER',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5195,NULL,'Sip-Method','CANCEL',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5196,NULL,'Sip-Method','OPTIONS',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5197,NULL,'Sip-Method','ACK',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5198,NULL,'Sip-Method','SUBSCRIBE',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5199,NULL,'Sip-Method','NOTIFY',NULL,'dictionary.schulzrinne-sipping',NULL,NULL,NULL,NULL),
                                (5200,'integer','Tropos-Unicast-Cipher',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5201,'integer','Tropos-Layer2-Input-Octets',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5202,'integer','Tropos-Layer2-Output-Octets',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5203,'integer','Tropos-Layer2-Input-Frames',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5204,'integer','Tropos-Layer2-Output-Frames',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5205,'integer','Tropos-Layer2-Input-Drops',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5206,'ifid','Tropos-Noise-Floor',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5207,'ifid','Tropos-Noise-Upper-Bound',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5208,'string','Tropos-Release',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5209,'octets','Tropos-Secondary-IP',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5210,'integer','Tropos-Terminate-Cause',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5211,'integer','Tropos-Average-RSSI',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5212,'ifid','Tropos-Channel',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5213,'integer','Tropos-Retries-Sent',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5214,'integer','Tropos-Retry-Bits',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5215,'octets','Tropos-Rates-Sent',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5216,'octets','Tropos-Rates-Received',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5217,'integer','Tropos-Routed-Time',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5218,'integer','Tropos-Routless-Since',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5219,'octets','Tropos-Capability-Info',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5220,'integer','Tropos-Input-Cap',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5221,'integer','Tropos-Output-Cap',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5222,'integer','Tropos-Class-Mult',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5223,'string','Tropos-Cell-Name',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5224,'string','Tropos-Cell-Location',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5225,'string','Tropos-Serial-Number',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5226,'string','Tropos-Latitude',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5227,'string','Tropos-Longitude',NULL,NULL,'Tropos',NULL,NULL,NULL,NULL),
                                (5228,'integer','Acct-Status-Type',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5229,'integer','Acct-Delay-Time',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5230,'integer','Acct-Input-Octets',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5231,'integer','Acct-Output-Octets',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5232,'string','Acct-Session-Id',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5233,'integer','Acct-Authentic',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5234,'integer','Acct-Session-Time',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5235,'integer','Acct-Input-Packets',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5236,'integer','Acct-Output-Packets',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5237,'integer','Acct-Terminate-Cause',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5238,'string','Acct-Multi-Session-Id',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5239,'integer','Acct-Link-Count',NULL,NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5240,NULL,'Acct-Status-Type','Start',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5241,NULL,'Acct-Status-Type','Stop',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5242,NULL,'Acct-Status-Type','Alive',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5243,NULL,'Acct-Status-Type','Interim-Update',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5244,NULL,'Acct-Status-Type','Accounting-On',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5245,NULL,'Acct-Status-Type','Accounting-Off',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5246,NULL,'Acct-Status-Type','Failed',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5247,NULL,'Acct-Authentic','RADIUS',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5248,NULL,'Acct-Authentic','Local',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5249,NULL,'Acct-Authentic','Remote',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5250,NULL,'Acct-Authentic','Diameter',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5251,NULL,'Acct-Terminate-Cause','User-Request',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5252,NULL,'Acct-Terminate-Cause','Lost-Carrier',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5253,NULL,'Acct-Terminate-Cause','Lost-Service',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5254,NULL,'Acct-Terminate-Cause','Idle-Timeout',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5255,NULL,'Acct-Terminate-Cause','Session-Timeout',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5256,NULL,'Acct-Terminate-Cause','Admin-Reset',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5257,NULL,'Acct-Terminate-Cause','Admin-Reboot',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5258,NULL,'Acct-Terminate-Cause','Port-Error',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5259,NULL,'Acct-Terminate-Cause','NAS-Error',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5260,NULL,'Acct-Terminate-Cause','NAS-Request',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5261,NULL,'Acct-Terminate-Cause','NAS-Reboot',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5262,NULL,'Acct-Terminate-Cause','Port-Unneeded',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5263,NULL,'Acct-Terminate-Cause','Port-Preempted',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5264,NULL,'Acct-Terminate-Cause','Port-Suspended',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5265,NULL,'Acct-Terminate-Cause','Service-Unavailable',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5266,NULL,'Acct-Terminate-Cause','Callback',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5267,NULL,'Acct-Terminate-Cause','User-Error',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5268,NULL,'Acct-Terminate-Cause','Host-Request',NULL,'dictionary.rfc2866',NULL,NULL,NULL,NULL),
                                (5269,'string','ERX-Virtual-Router-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5270,'string','ERX-Address-Pool-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5271,'string','ERX-Local-Loopback-Interface',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5272,'ipaddr','ERX-Primary-Dns',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5273,'ipaddr','ERX-Secondary-Dns',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5274,'ipaddr','ERX-Primary-Wins',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5275,'ipaddr','ERX-Secondary-Wins',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5276,'string','ERX-Tunnel-Virtual-Router',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5277,'string','ERX-Tunnel-Password',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5278,'string','ERX-Ingress-Policy-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5279,'string','ERX-Egress-Policy-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5280,'integer','ERX-Ingress-Statistics',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5281,'integer','ERX-Egress-Statistics',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5282,'integer','ERX-Atm-Service-Category',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5283,'integer','ERX-Atm-PCR',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5284,'integer','ERX-Atm-SCR',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5285,'integer','ERX-Atm-MBS',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5286,'string','ERX-Cli-Initial-Access-Level',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5287,'integer','ERX-Cli-Allow-All-VR-Access',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5288,'string','ERX-Alternate-Cli-Access-Level',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5289,'string','ERX-Alternate-Cli-Vrouter-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5290,'integer','ERX-Sa-Validate',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5291,'integer','ERX-Igmp-Enable',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5292,'string','ERX-Pppoe-Description',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5293,'string','ERX-Redirect-VR-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5294,'string','ERX-Qos-Profile-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5295,'integer','ERX-Pppoe-Max-Sessions',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5296,'string','ERX-Pppoe-Url',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5297,'integer','ERX-Qos-Profile-Interface-Type',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5298,'integer','ERX-Tunnel-Nas-Port-Method',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5299,'string','ERX-Service-Bundle',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5300,'integer','ERX-Tunnel-Tos',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5301,'integer','ERX-Tunnel-Maximum-Sessions',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5302,'string','ERX-Framed-Ip-Route-Tag',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5303,'string','ERX-Dial-Out-Number',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5304,'string','ERX-PPP-Username',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5305,'string','ERX-PPP-Password',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5306,'integer','ERX-PPP-Auth-Protocol',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5307,'integer','ERX-Minimum-BPS',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5308,'integer','ERX-Maximum-BPS',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5309,'integer','ERX-Bearer-Type',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5310,'integer','ERX-Input-Gigapkts',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5311,'integer','ERX-Output-Gigapkts',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5312,'string','ERX-Tunnel-Interface-Id',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5313,'string','ERX-IpV6-Virtual-Router',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5314,'string','ERX-IpV6-Local-Interface',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5315,'string','ERX-Ipv6-Primary-Dns',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5316,'string','ERX-Ipv6-Secondary-Dns',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5317,'string','Sdx-Service-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5318,'string','Sdx-Session-Volume-Quota',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5319,'string','Sdx-Tunnel-Disconnect-Cause-Info',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5320,'ipaddr','ERX-Radius-Client-Address',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5321,'string','ERX-Service-Description',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5322,'integer','ERX-L2tp-Recv-Window-Size',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5323,'string','ERX-Dhcp-Options',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5324,'string','ERX-Dhcp-Mac-Addr',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5325,'ipaddr','ERX-Dhcp-Gi-Address',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5326,'integer','ERX-LI-Action',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5327,'octets','ERX-Med-Dev-Handle',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5328,'ipaddr','ERX-Med-Ip-Address',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5329,'integer','ERX-Med-Port-Number',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5330,'string','ERX-MLPPP-Bundle-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5331,'string','ERX-Interface-Desc',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5332,'string','ERX-Tunnel-Group',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5333,'string','ERX-Service-Activate',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5334,'string','ERX-Service-Deactivate',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5335,'integer','ERX-Service-Volume',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5336,'integer','ERX-Service-Timeout',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5337,'integer','ERX-Service-Statistics',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5338,'integer','ERX-DF-Bit',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5339,'string','ERX-IGMP-Access-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5340,'string','ERX-IGMP-Access-Src-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5341,'string','ERX-IGMP-OIF-Map-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5342,'string','ERX-MLD-Access-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5343,'string','ERX-MLD-Access-Src-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5344,'string','ERX-MLD-OIF-Map-Name',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5345,'integer','ERX-MLD-Version',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5346,'integer','ERX-IGMP-Version',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5347,'integer','ERX-IP-Mcast-Adm-Bw-Limit',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5348,'integer','ERX-IPv6-Mcast-Adm-Bw-Limit',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5349,'string','ERX-Qos-Parameters',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5350,'string','ERX-Service-Session',NULL,NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5351,NULL,'ERX-Ingress-Statistics','disable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5352,NULL,'ERX-Ingress-Statistics','enable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5353,NULL,'ERX-Egress-Statistics','disable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5354,NULL,'ERX-Egress-Statistics','enable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5355,NULL,'ERX-Atm-Service-Category','UBR',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5356,NULL,'ERX-Atm-Service-Category','UBRPCR',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5357,NULL,'ERX-Atm-Service-Category','nrtVBR',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5358,NULL,'ERX-Atm-Service-Category','CBR',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5359,NULL,'ERX-Cli-Allow-All-VR-Access','disable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5360,NULL,'ERX-Cli-Allow-All-VR-Access','enable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5361,NULL,'ERX-Sa-Validate','disable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5362,NULL,'ERX-Sa-Validate','enable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5363,NULL,'ERX-Igmp-Enable','disable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5364,NULL,'ERX-Igmp-Enable','enable',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5365,NULL,'ERX-Qos-Profile-Interface-Type','IP',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5366,NULL,'ERX-Qos-Profile-Interface-Type','ATM',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5367,NULL,'ERX-Qos-Profile-Interface-Type','HDLC',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5368,NULL,'ERX-Qos-Profile-Interface-Type','ETHERNET',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5369,NULL,'ERX-Qos-Profile-Interface-Type','SERVER-PORT',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5370,NULL,'ERX-Qos-Profile-Interface-Type','ATM-1483',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5371,NULL,'ERX-Qos-Profile-Interface-Type','FRAME-RELAY',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5372,NULL,'ERX-Qos-Profile-Interface-Type','MPLS-MINOR',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5373,NULL,'ERX-Qos-Profile-Interface-Type','CBF',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5374,NULL,'ERX-Qos-Profile-Interface-Type','IP-TUNNEL',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5375,NULL,'ERX-Qos-Profile-Interface-Type','VLAN-SUB',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5376,NULL,'ERX-Qos-Profile-Interface-Type','PPPOE-SUB',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5377,NULL,'ERX-Tunnel-Nas-Port-Method','None',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5378,NULL,'ERX-Tunnel-Nas-Port-Method','CISCO-CLID',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5379,NULL,'ERX-PPP-Auth-Protocol','None',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5380,NULL,'ERX-PPP-Auth-Protocol','PAP',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5381,NULL,'ERX-PPP-Auth-Protocol','CHAP',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5382,NULL,'ERX-PPP-Auth-Protocol','PAP-CHAP',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5383,NULL,'ERX-PPP-Auth-Protocol','CHAP-PAP',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5384,NULL,'ERX-Bearer-Type','None',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5385,NULL,'ERX-Bearer-Type','Analog',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5386,NULL,'ERX-Bearer-Type','Digital',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5387,NULL,'ERX-LI-Action','off',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5388,NULL,'ERX-LI-Action','on',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5389,NULL,'ERX-LI-Action','noop',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5390,NULL,'ERX-DF-Bit','dont-ignore-df-bit',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5391,NULL,'ERX-DF-Bit','ignore-df-bit',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5392,NULL,'ERX-MLD-Version','v1',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5393,NULL,'ERX-MLD-Version','v2',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5394,NULL,'ERX-IGMP-Version','v1',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5395,NULL,'ERX-IGMP-Version','v2',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5396,NULL,'ERX-IGMP-Version','v3',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5397,NULL,'ERX-Service-Statistics','disabled',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5398,NULL,'ERX-Service-Statistics','time',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5399,NULL,'ERX-Service-Statistics','time-volume',NULL,'ERX',NULL,NULL,NULL,NULL),
                                (5400,'integer','Propel-Accelerate',NULL,NULL,'Propel',NULL,NULL,NULL,NULL),
                                (5401,'string','Propel-Dialed-Digits',NULL,NULL,'Propel',NULL,NULL,NULL,NULL),
                                (5402,'ipaddr','Propel-Client-IP-Address',NULL,NULL,'Propel',NULL,NULL,NULL,NULL),
                                (5403,'ipaddr','Propel-Client-NAS-IP-Address',NULL,NULL,'Propel',NULL,NULL,NULL,NULL),
                                (5404,'integer','Propel-Client-Source-ID',NULL,NULL,'Propel',NULL,NULL,NULL,NULL),
                                (5405,'integer','Propel-Content-Filter-ID',NULL,NULL,'Propel',NULL,NULL,NULL,NULL),
                                (5406,'string','Asterisk-Acc-Code',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5407,'string','Asterisk-Src',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5408,'string','Asterisk-Dst',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5409,'string','Asterisk-Dst-Ctx',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5410,'string','Asterisk-Clid',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5411,'string','Asterisk-Chan',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5412,'string','Asterisk-Dst-Chan',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5413,'string','Asterisk-Last-App',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5414,'string','Asterisk-Last-Data',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5415,'string','Asterisk-Start-Time',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5416,'string','Asterisk-Answer-Time',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5417,'string','Asterisk-End-Time',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5418,'integer','Asterisk-Duration',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5419,'integer','Asterisk-Bill-Sec',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5420,'string','Asterisk-Disposition',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5421,'string','Asterisk-AMA-Flags',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5422,'string','Asterisk-Unique-ID',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5423,'string','Asterisk-User-Field',NULL,NULL,'Digium',NULL,NULL,NULL,NULL),
                                (5424,'integer','UserLogon-Uid',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5425,'integer','UserLogon-Gid',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5426,'string','UserLogon-HomeDir',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5427,'integer','UserLogon-Type',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5428,'integer','UserLogon-QuotaBytes',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5429,'integer','UserLogon-QuotaFiles',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5430,'string','UserLogon-Shell',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5431,'integer','UserLogon-Restriction',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5432,'string','UserLogon-GroupNames',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5433,'string','UserLogon-DriveNames',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5434,'string','UserLogon-UserDescription',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5435,'string','UserLogon-UserFullName',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5436,'string','UserLogon-UserDomain',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5437,'string','UserLogon-LogonTask',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5438,'string','UserLogon-LogoffTask',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5439,'string','UserLogon-Expiration',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5440,'string','UserLogon-UserProfile',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5441,'string','UserLogon-Acct-TerminateCause',NULL,NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5442,NULL,'UserLogon-Type','FTP',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5443,NULL,'UserLogon-Type','WEB',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5444,NULL,'UserLogon-Type','POP',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5445,NULL,'UserLogon-Type','IMAP',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5446,NULL,'UserLogon-Type','Windows-Logon',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5447,NULL,'UserLogon-Type','Unix-Logon',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5448,NULL,'UserLogon-Type','SMTP-Auth',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5449,NULL,'UserLogon-Type','Other',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5450,NULL,'UserLogon-Restriction','Anonymous-User',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5451,NULL,'UserLogon-Restriction','Admin-User',NULL,'NTUA',NULL,NULL,NULL,NULL),
                                (5452,'integer','Lucent-Max-Shared-Users',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5453,'integer','Lucent-IP-DSCP',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5454,'string','Lucent-X25-X121-Source-Address',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5455,'integer','Lucent-PPP-Circuit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5456,'string','Lucent-PPP-Circuit-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5457,'string','Lucent-UU-Info',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5458,'integer','Lucent-User-Priority',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5459,'integer','Lucent-CIR-Timer',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5460,'integer','Lucent-FR-08-Mode',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5461,'integer','Lucent-Destination-NAS-Port',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5462,'string','Lucent-FR-SVC-Addr',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5463,'integer','Lucent-NAS-Port-Format',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5464,'integer','Lucent-ATM-Fault-Management',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5465,'integer','Lucent-ATM-Loopback-Cell-Loss',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5466,'integer','Lucent-Ckt-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5467,'integer','Lucent-SVC-Enabled',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5468,'integer','Lucent-Session-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5469,'ipaddr','Lucent-H323-Gatekeeper',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5470,'string','Lucent-Global-Call-Id',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5471,'integer','Lucent-H323-Conference-Id',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5472,'ipaddr','Lucent-H323-Destination-NAS-ID',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5473,'integer','Lucent-H323-Dialed-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5474,'string','Lucent-Dialed-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5475,'integer','Lucent-Inter-Arrival-Jitter',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5476,'integer','Lucent-Dropped-Octets',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5477,'integer','Lucent-Dropped-Packets',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5478,'integer','Lucent-Auth-Delay',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5479,'integer','Lucent-X25-Pad-X3-Profile',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5480,'string','Lucent-X25-Pad-X3-Parameters',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5481,'string','Lucent-Tunnel-VRouter-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5482,'integer','Lucent-X25-Reverse-Charging',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5483,'string','Lucent-X25-Nui-Prompt',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5484,'string','Lucent-X25-Nui-Password-Prompt',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5485,'string','Lucent-X25-Cug',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5486,'string','Lucent-X25-Pad-Alias-1',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5487,'string','Lucent-X25-Pad-Alias-2',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5488,'string','Lucent-X25-Pad-Alias-3',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5489,'string','Lucent-X25-X121-Address',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5490,'string','Lucent-X25-Nui',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5491,'string','Lucent-X25-Rpoa',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5492,'string','Lucent-X25-Pad-Prompt',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5493,'string','Lucent-X25-Pad-Banner',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5494,'string','Lucent-X25-Profile-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5495,'string','Lucent-Recv-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5496,'integer','Lucent-Bi-Directional-Auth',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5497,'integer','Lucent-MTU',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5498,'integer','Lucent-Call-Direction',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5499,'integer','Lucent-Service-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5500,'integer','Lucent-Filter-Required',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5501,'integer','Lucent-Traffic-Shaper',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5502,'string','Lucent-Access-Intercept-LEA',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5503,'string','Lucent-Access-Intercept-Log',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5504,'string','Lucent-Private-Route-Table-ID',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5505,'integer','Lucent-Private-Route-Required',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5506,'integer','Lucent-Cache-Refresh',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5507,'integer','Lucent-Cache-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5508,'integer','Lucent-Egress-Enabled',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5509,'string','Lucent-QOS-Upstream',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5510,'string','Lucent-QOS-Downstream',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5511,'integer','Lucent-ATM-Connect-Vpi',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5512,'integer','Lucent-ATM-Connect-Vci',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5513,'integer','Lucent-ATM-Connect-Group',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5514,'integer','Lucent-ATM-Group',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5515,'integer','Lucent-IPX-Header-Compression',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5516,'integer','Lucent-Calling-Id-Type-Of-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5517,'integer','Lucent-Calling-Id-Numbering-Plan',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5518,'integer','Lucent-Calling-Id-Presentation',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5519,'integer','Lucent-Calling-Id-Screening',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5520,'integer','Lucent-BIR-Enable',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5521,'integer','Lucent-BIR-Proxy',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5522,'integer','Lucent-BIR-Bridge-Group',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5523,'string','Lucent-IPSEC-Profile',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5524,'integer','Lucent-PPPoE-Enable',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5525,'integer','Lucent-Bridge-Non-PPPoE',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5526,'integer','Lucent-ATM-Direct',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5527,'string','Lucent-ATM-Direct-Profile',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5528,'ipaddr','Lucent-Client-Primary-WINS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5529,'ipaddr','Lucent-Client-Secondary-WINS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5530,'integer','Lucent-Client-Assign-WINS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5531,'integer','Lucent-Auth-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5532,'integer','Lucent-Port-Redir-Protocol',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5533,'integer','Lucent-Port-Redir-Portnum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5534,'ipaddr','Lucent-Port-Redir-Server',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5535,'integer','Lucent-IP-Pool-Chaining',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5536,'ipaddr','Lucent-Owner-IP-Addr',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5537,'integer','Lucent-IP-TOS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5538,'integer','Lucent-IP-TOS-Precedence',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5539,'integer','Lucent-IP-TOS-Apply-To',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5540,'string','Lucent-Filter',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5541,'string','Lucent-Telnet-Profile',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5542,'integer','Lucent-Dsl-Rate-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5543,'string','Lucent-Redirect-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5544,'integer','Lucent-ATM-Vpi',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5545,'integer','Lucent-ATM-Vci',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5546,'integer','Lucent-Source-IP-Check',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5547,'integer','Lucent-Dsl-Rate-Mode',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5548,'integer','Lucent-Dsl-Upstream-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5549,'integer','Lucent-Dsl-Downstream-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5550,'integer','Lucent-Dsl-CIR-Recv-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5551,'integer','Lucent-Dsl-CIR-Xmit-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5552,'string','Lucent-VRouter-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5553,'string','Lucent-Source-Auth',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5554,'string','Lucent-Private-Route',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5555,'integer','Lucent-Numbering-Plan-ID',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5556,'integer','Lucent-FR-Link-Status-DLCI',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5557,'string','Lucent-Calling-Subaddress',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5558,'integer','Lucent-Callback-Delay',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5559,'octets','Lucent-Endpoint-Disc',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5560,'string','Lucent-Remote-FW',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5561,'integer','Lucent-Multicast-GLeave-Delay',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5562,'integer','Lucent-CBCP-Enable',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5563,'integer','Lucent-CBCP-Mode',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5564,'integer','Lucent-CBCP-Delay',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5565,'integer','Lucent-CBCP-Trunk-Group',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5566,'string','Lucent-Appletalk-Route',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5567,'integer','Lucent-Appletalk-Peer-Mode',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5568,'integer','Lucent-Route-Appletalk',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5569,'string','Lucent-FCP-Parameter',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5570,'integer','Lucent-Modem-PortNo',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5571,'integer','Lucent-Modem-SlotNo',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5572,'integer','Lucent-Modem-ShelfNo',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5573,'integer','Lucent-Call-Attempt-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5574,'integer','Lucent-Call-Block-Duration',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5575,'integer','Lucent-Maximum-Call-Duration',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5576,'integer','Lucent-Route-Preference',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5577,'integer','Lucent-Tunneling-Protocol',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5578,'integer','Lucent-Shared-Profile-Enable',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5579,'string','Lucent-Primary-Home-Agent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5580,'string','Lucent-Secondary-Home-Agent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5581,'integer','Lucent-Dialout-Allowed',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5582,'ipaddr','Lucent-Client-Gateway',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5583,'integer','Lucent-BACP-Enable',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5584,'integer','Lucent-DHCP-Maximum-Leases',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5585,'ipaddr','Lucent-Client-Primary-DNS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5586,'ipaddr','Lucent-Client-Secondary-DNS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5587,'integer','Lucent-Client-Assign-DNS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5588,'integer','Lucent-User-Acct-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5589,'ipaddr','Lucent-User-Acct-Host',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5590,'integer','Lucent-User-Acct-Port',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5591,'string','Lucent-User-Acct-Key',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5592,'integer','Lucent-User-Acct-Base',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5593,'integer','Lucent-User-Acct-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5594,'ipaddr','Lucent-Assign-IP-Client',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5595,'ipaddr','Lucent-Assign-IP-Server',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5596,'string','Lucent-Assign-IP-Global-Pool',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5597,'integer','Lucent-DHCP-Reply',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5598,'integer','Lucent-DHCP-Pool-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5599,'integer','Lucent-Expect-Callback',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5600,'integer','Lucent-Event-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5601,'string','Lucent-Session-Svr-Key',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5602,'integer','Lucent-Multicast-Rate-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5603,'ipaddr','Lucent-IF-Netmask',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5604,'ipaddr','Lucent-Remote-Addr',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5605,'integer','Lucent-Multicast-Client',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5606,'string','Lucent-FR-Circuit-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5607,'integer','Lucent-FR-LinkUp',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5608,'integer','Lucent-FR-Nailed-Grp',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5609,'integer','Lucent-FR-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5610,'integer','Lucent-FR-Link-Mgt',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5611,'integer','Lucent-FR-N391',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5612,'integer','Lucent-FR-DCE-N392',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5613,'integer','Lucent-FR-DTE-N392',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5614,'integer','Lucent-FR-DCE-N393',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5615,'integer','Lucent-FR-DTE-N393',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5616,'integer','Lucent-FR-T391',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5617,'integer','Lucent-FR-T392',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5618,'string','Lucent-Bridge-Address',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5619,'integer','Lucent-TS-Idle-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5620,'integer','Lucent-TS-Idle-Mode',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5621,'integer','Lucent-DBA-Monitor',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5622,'integer','Lucent-Base-Channel-Count',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5623,'integer','Lucent-Minimum-Channels',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5624,'string','Lucent-IPX-Route',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5625,'integer','Lucent-FT1-Caller',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5626,'string','Lucent-Backup',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5627,'integer','Lucent-Call-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5628,'string','Lucent-Group',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5629,'integer','Lucent-FR-DLCI',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5630,'string','Lucent-FR-Profile-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5631,'string','Lucent-Ara-PW',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5632,'string','Lucent-IPX-Node-Addr',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5633,'ipaddr','Lucent-Home-Agent-IP-Addr',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5634,'string','Lucent-Home-Agent-Password',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5635,'string','Lucent-Home-Network-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5636,'integer','Lucent-Home-Agent-UDP-Port',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5637,'integer','Lucent-Multilink-ID',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5638,'integer','Lucent-Num-In-Multilink',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5639,'ipaddr','Lucent-First-Dest',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5640,'integer','Lucent-Pre-Input-Octets',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5641,'integer','Lucent-Pre-Output-Octets',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5642,'integer','Lucent-Pre-Input-Packets',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5643,'integer','Lucent-Pre-Output-Packets',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5644,'integer','Lucent-Maximum-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5645,'integer','Lucent-Disconnect-Cause',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5646,'integer','Lucent-Connect-Progress',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5647,'integer','Lucent-Data-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5648,'integer','Lucent-PreSession-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5649,'integer','Lucent-Token-Idle',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5650,'integer','Lucent-Token-Immediate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5651,'integer','Lucent-Require-Auth',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5652,'string','Lucent-Number-Sessions',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5653,'string','Lucent-Authen-Alias',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5654,'integer','Lucent-Token-Expiry',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5655,'string','Lucent-Menu-Selector',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5656,'string','Lucent-Menu-Item',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5657,'integer','Lucent-PW-Warntime',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5658,'integer','Lucent-PW-Lifetime',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5659,'ipaddr','Lucent-IP-Direct',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5660,'integer','Lucent-PPP-VJ-Slot-Comp',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5661,'integer','Lucent-PPP-VJ-1172',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5662,'integer','Lucent-PPP-Async-Map',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5663,'string','Lucent-Third-Prompt',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5664,'string','Lucent-Send-Secret',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5665,'string','Lucent-Receive-Secret',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5666,'integer','Lucent-IPX-Peer-Mode',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5667,'string','Lucent-IP-Pool-Definition',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5668,'integer','Lucent-Assign-IP-Pool',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5669,'integer','Lucent-FR-Direct',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5670,'string','Lucent-FR-Direct-Profile',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5671,'integer','Lucent-FR-Direct-DLCI',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5672,'integer','Lucent-Handle-IPX',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5673,'integer','Lucent-Netware-timeout',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5674,'integer','Lucent-IPX-Alias',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5675,'integer','Lucent-Metric',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5676,'integer','Lucent-PRI-Number-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5677,'string','Lucent-Dial-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5678,'integer','Lucent-Route-IP',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5679,'integer','Lucent-Route-IPX',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5680,'integer','Lucent-Bridge',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5681,'integer','Lucent-Send-Auth',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5682,'string','Lucent-Send-Passwd',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5683,'integer','Lucent-Link-Compression',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5684,'integer','Lucent-Target-Util',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5685,'integer','Lucent-Maximum-Channels',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5686,'integer','Lucent-Inc-Channel-Count',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5687,'integer','Lucent-Dec-Channel-Count',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5688,'integer','Lucent-Seconds-Of-History',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5689,'integer','Lucent-History-Weigh-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5690,'integer','Lucent-Add-Seconds',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5691,'integer','Lucent-Remove-Seconds',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5692,'abinary','Lucent-Data-Filter',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5693,'abinary','Lucent-Call-Filter',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5694,'integer','Lucent-Idle-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5695,'integer','Lucent-Preempt-Limit',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5696,'integer','Lucent-Callback',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5697,'integer','Lucent-Data-Svc',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5698,'integer','Lucent-Force-56',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5699,'string','Lucent-Billing-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5700,'integer','Lucent-Call-By-Call',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5701,'string','Lucent-Transit-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5702,'string','Lucent-Host-Info',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5703,'ipaddr','Lucent-PPP-Address',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5704,'integer','Lucent-MPP-Idle-Percent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5705,'integer','Lucent-Xmit-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5706,'integer','Lucent-Fr05-Traffic-Shaper',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5707,'integer','Lucent-Fr05-Vpi',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5708,'integer','Lucent-Fr05-Vci',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5709,'integer','Lucent-Fr05-Enabled',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5710,'octets','Lucent-Tunnel-Auth-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5711,'integer','Lucent-MOH-Timeout',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5712,'string','Lucent-ATM-Circuit-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5713,'integer','Lucent-Priority-For-PPP',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5714,'integer','Lucent-Max-RTP-Delay',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5715,'string','Lucent-RTP-Port-Range',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5716,'integer','Lucent-TOS-Copying',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5717,'integer','Lucent-Packet-Classification',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5718,'integer','Lucent-No-High-Prio-Pkt-Duratio',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5719,'string','Lucent-AT-Answer-String',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5720,'integer','Lucent-IP-OUTGOING-TOS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5721,'integer','Lucent-IP-OUTGOING-TOS-Precedence',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5722,'integer','Lucent-IP-OUTGOING-DSCP',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5723,'string','Lucent-TermSrv-Login-Prompt',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5724,'string','Lucent-Multicast-Service-Profile-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5725,'integer','Lucent-Multicast-Max-Groups',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5726,'string','Lucent-Multicast-Service-Name',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5727,'integer','Lucent-Multicast-Service-Active',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5728,'integer','Lucent-Multicast-Service-Snmp-Trap',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5729,'integer','Lucent-Multicast-Service-Filter-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5730,'integer','Lucent-Multicast-Filter-Active',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5731,'ipaddr','Lucent-Multicast-Filter-Address',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5732,'integer','Lucent-Tunnel-TOS',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5733,'integer','Lucent-Tunnel-TOS-Precedence',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5734,'integer','Lucent-Tunnel-DSCP',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5735,'string','Lucent-Tunnel-TOS-Filter',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5736,'integer','Lucent-Tunnel-TOS-Copy',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5737,'string','Lucent-Http-Redirect-URL',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5738,'integer','Lucent-Http-Redirect-Port',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5739,'integer','Lucent-L2TP-DCI-Disconnect-Code',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5740,'integer','Lucent-L2TP-DCI-Protocol-Number',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5741,'integer','Lucent-L2TP-DCI-Direction',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5742,'string','Lucent-L2TP-DCI-Message',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5743,'integer','Lucent-L2TP-Q931-Cause-Code',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5744,'integer','Lucent-L2TP-Q931-Cause-Message',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5745,'string','Lucent-L2TP-Q931-Advisory-Message',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5746,'integer','Lucent-L2TP-RC-Result-Code',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5747,'integer','Lucent-L2TP-RC-Error-Code',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5748,'string','Lucent-L2TP-RC-Error-Message',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5749,'integer','Lucent-L2TP-Disconnect-Scenario',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5750,'integer','Lucent-L2TP-Peer-Disconnect-Cause',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5751,'integer','Lucent-L2TP-Peer-Connect-Progress',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5752,'integer','Lucent-QuickConnect-Attempted',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5753,'integer','Lucent-Num-Moh-Sessions',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5754,'integer','Lucent-Cumulative-Hold-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5755,'integer','Lucent-Modem-Modulation',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5756,'date','Lucent-User-Acct-Expiration',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5757,'integer','Lucent-User-Login-Level',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5758,'string','Lucent-First-Level-User',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5759,'string','Lucent-IP-Source-If',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5760,'integer','Lucent-Reverse-Path-Check',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5761,'integer','Lucent-Dsl-Atuc-Chan-Uncorrect-Blks',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5762,'integer','Lucent-Dsl-Atuc-Chan-Corrected-Blks',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5763,'integer','Lucent-Dsl-Atuc-Chan-Xmit-Blks',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5764,'integer','Lucent-Dsl-Atuc-Chan-Recd-Blks',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5765,'integer','Lucent-Dsl-Atuc-Perf-Inits',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5766,'integer','Lucent-Dsl-Atuc-Perf-ESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5767,'integer','Lucent-Dsl-Atuc-Perf-Lprs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5768,'integer','Lucent-Dsl-Atuc-Perf-Lols',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5769,'integer','Lucent-Dsl-Atuc-Perf-Loss',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5770,'integer','Lucent-Dsl-Atuc-Perf-Lofs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5771,'integer','Lucent-Dsl-Atuc-Curr-Attainable-Rate-Dn',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5772,'integer','Lucent-Dsl-Atuc-Curr-Output-Pwr-Dn',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5773,'integer','Lucent-Dsl-Atuc-Curr-Atn-Up',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5774,'integer','Lucent-Dsl-Atuc-Curr-Snr-Mgn-Up',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5775,'integer','Lucent-Dsl-Atuc-PS-Fast-Retrains',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5776,'integer','Lucent-Dsl-Atuc-PS-Failed-Fast-Retrains',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5777,'integer','Lucent-Dsl-Code-Violations',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5778,'integer','Lucent-Line-Type',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5779,'integer','Lucent-Dsl-Curr-Up-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5780,'integer','Lucent-Dsl-Curr-Dn-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5781,'integer','Lucent-Dsl-Physical-Slot',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5782,'integer','Lucent-Dsl-Physical-Line',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5783,'integer','Lucent-Dsl-If-Index',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5784,'integer','Lucent-Dsl-Oper-Status',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5785,'integer','Lucent-Dsl-Related-If-Index',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5786,'integer','Lucent-Dsl-Atuc-Curr-Attainable-Rate-Up',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5787,'integer','Lucent-Dsl-Atuc-Curr-Output-Pwr-Up',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5788,'integer','Lucent-Dsl-Atuc-Curr-Atn-Dn',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5789,'integer','Lucent-Dsl-Atuc-Curr-Snr-Mgn-D',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5790,'integer','Lucent-Dsl-Related-Slot',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5791,'integer','Lucent-Dsl-Related-Port',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5792,'integer','Lucent-Dsl-Sparing-Role',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5793,'integer','Lucent-Absolute-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5794,'integer','Lucent-Configured-Rate-Up-Min',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5795,'integer','Lucent-Configured-Rate-Up-Max',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5796,'integer','Lucent-Configured-Rate-Dn-Min',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5797,'integer','Lucent-Configured-Rate-Dn-Max',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5798,'integer','Lucent-Dsl-Physical-Channel',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5799,'integer','Lucent-Sonet-Section-ESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5800,'integer','Lucent-Sonet-Section-SESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5801,'integer','Lucent-Sonet-Section-SEFSs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5802,'integer','Lucent-Sonet-Section-CVs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5803,'integer','Lucent-Sonet-Line-ESs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5804,'integer','Lucent-Sonet-Line-SESs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5805,'integer','Lucent-Sonet-Line-CVs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5806,'integer','Lucent-Sonet-Line-USs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5807,'integer','Lucent-Sonet-Line-ESs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5808,'integer','Lucent-Sonet-Line-SESs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5809,'integer','Lucent-Sonet-Line-CVs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5810,'integer','Lucent-Sonet-Line-USs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5811,'integer','Lucent-Sonet-Path-ESs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5812,'integer','Lucent-Sonet-Path-SESs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5813,'integer','Lucent-Sonet-Path-CVs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5814,'integer','Lucent-Sonet-Path-USs-Near',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5815,'integer','Lucent-Sonet-Path-ESs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5816,'integer','Lucent-Sonet-Path-SESs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5817,'integer','Lucent-Sonet-Path-CVs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5818,'integer','Lucent-Sonet-Path-USs-Far',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5819,'integer','Lucent-Ds3-F-Bit-Err',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5820,'integer','Lucent-Ds3-P-Bit-Err',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5821,'integer','Lucent-Ds3-CCVs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5822,'integer','Lucent-Ds3-PESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5823,'integer','Lucent-Ds3-PSESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5824,'integer','Lucent-Ds3-SEFs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5825,'integer','Lucent-Ds3-UASs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5826,'integer','Lucent-Ds3-LCVs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5827,'integer','Lucent-Ds3-PCVs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5828,'integer','Lucent-Ds3-LESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5829,'integer','Lucent-Ds3-CESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5830,'integer','Lucent-Ds3-CSESs',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5831,'integer','Lucent-Rtp-Local-Number-Of-Samples',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5832,'integer','Lucent-Rtp-Remote-Number-Of-Samples',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5833,'integer','Lucent-Rtp-Local-Jitter-Minimum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5834,'integer','Lucent-Rtp-Local-Jitter-Maximum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5835,'integer','Lucent-Rtp-Local-Jitter-Mean',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5836,'integer','Lucent-Rtp-Local-Jitter-Variance',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5837,'integer','Lucent-Rtp-Local-Delay-Minimum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5838,'integer','Lucent-Rtp-Local-Delay-Maximum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5839,'integer','Lucent-Rtp-Local-Delay-Mean',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5840,'integer','Lucent-Rtp-Local-Delay-Variance',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5841,'integer','Lucent-Rtp-Local-Packets-Sent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5842,'integer','Lucent-Rtp-Local-Packets-Lost',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5843,'integer','Lucent-Rtp-Local-Packets-Late',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5844,'integer','Lucent-Rtp-Local-Bytes-Sent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5845,'integer','Lucent-Rtp-Local-Silence-Percent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5846,'integer','Lucent-Rtp-Remote-Jitter-Minimum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5847,'integer','Lucent-Rtp-Remote-Jitter-Maximum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5848,'integer','Lucent-Rtp-Remote-Jitter-Mean',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5849,'integer','Lucent-Rtp-Remote-Jitter-Variance',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5850,'integer','Lucent-Rtp-Remote-Delay-Minimum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5851,'integer','Lucent-Rtp-Remote-Delay-Maximum',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5852,'integer','Lucent-Rtp-Remote-Delay-Mean',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5853,'integer','Lucent-Rtp-Remote-Delay-Variance',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5854,'integer','Lucent-Rtp-Remote-Packets-Sent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5855,'integer','Lucent-Rtp-Remote-Packets-Lost',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5856,'integer','Lucent-Rtp-Remote-Packets-Late',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5857,'integer','Lucent-Rtp-Remote-Bytes-Sent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5858,'integer','Lucent-Rtp-Remote-Silence-Percent',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5859,'integer','Lucent-Tunnel-Auth-Type2',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5860,'integer','Lucent-Multi-Packet-Separator',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5861,'integer','Lucent-Min-Xmit-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5862,'integer','Lucent-Max-Xmit-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5863,'integer','Lucent-Min-Recv-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5864,'integer','Lucent-Max-Recv-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5865,'integer','Lucent-Error-Correction-Protocol',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5866,'integer','Lucent-Compression-Protocol',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5867,'integer','Lucent-Modulation',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5868,'integer','Lucent-Xmit-Symbol-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5869,'integer','Lucent-Recv-Symbol-Rate',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5870,'integer','Lucent-Current-Xmit-Level',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5871,'integer','Lucent-Current-Recv-Level',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5872,'integer','Lucent-Current-Line-Quality',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5873,'integer','Lucent-Current-SNR',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5874,'integer','Lucent-Min-SNR',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5875,'integer','Lucent-Max-SNR',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5876,'integer','Lucent-Local-Retrain-Requested',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5877,'integer','Lucent-Remote-Retrain-Requested',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5878,'integer','Lucent-Connection-Time',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5879,'integer','Lucent-Modem-Disconnect-Reason',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5880,'integer','Lucent-Retrain-Reason',NULL,NULL,'Lucent',NULL,NULL,NULL,NULL),
                                (5881,'integer','Shasta-User-Privilege',NULL,NULL,'Shasta',NULL,NULL,NULL,NULL),
                                (5882,'string','Shasta-Service-Profile',NULL,NULL,'Shasta',NULL,NULL,NULL,NULL),
                                (5883,'string','Shasta-VPN-Name',NULL,NULL,'Shasta',NULL,NULL,NULL,NULL),
                                (5884,NULL,'Shasta-User-Privilege','User',NULL,'Shasta',NULL,NULL,NULL,NULL),
                                (5885,NULL,'Shasta-User-Privilege','Super-User',NULL,'Shasta',NULL,NULL,NULL,NULL),
                                (5886,NULL,'Shasta-User-Privilege','SSuper-User',NULL,'Shasta',NULL,NULL,NULL,NULL),
                                (5887,NULL,'Framed-Protocol','Bintec-X25',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5888,NULL,'Framed-Protocol','Bintec-X25-PPP',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5889,NULL,'Framed-Protocol','Bintec-IP-LAPB',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5890,NULL,'Framed-Protocol','Bintec-IP-HDLC',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5891,NULL,'Framed-Protocol','Bintec-MPR-LAPB',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5892,NULL,'Framed-Protocol','Bintec-MPR-HDLC',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5893,NULL,'Framed-Protocol','Bintec-FRAME-RELAY',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5894,NULL,'Framed-Protocol','Bintec-X31-BCHAN',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5895,NULL,'Framed-Protocol','Bintec-X75-PPP',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5896,NULL,'Framed-Protocol','Bintec-X75BTX-PPP',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5897,NULL,'Framed-Protocol','Bintec-X25-NOSIG',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5898,NULL,'Framed-Protocol','Bintec-X25-PPP-OPT',NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5899,'string','BinTec-biboPPPTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5900,'string','BinTec-biboDialTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5901,'string','BinTec-ipExtIfTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5902,'string','BinTec-ipRouteTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5903,'string','BinTec-ipExtRtTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5904,'string','BinTec-ipNatPresetTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5905,'string','BinTec-ipxCircTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5906,'string','BinTec-ripCircTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5907,'string','BinTec-sapCircTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5908,'string','BinTec-ipxStaticRouteTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5909,'string','BinTec-ipxStaticServTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5910,'string','BinTec-ospfIfTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5911,'string','BinTec-pppExtIfTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5912,'string','BinTec-ipFilterTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5913,'string','BinTec-ipQoSTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5914,'string','BinTec-qosIfTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5915,'string','BinTec-qosPolicyTable',NULL,NULL,'BinTec',NULL,NULL,NULL,NULL),
                                (5916,'string','KarlNet-TurboCell-Name',NULL,NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5917,'integer','KarlNet-TurboCell-TxRate',NULL,NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5918,NULL,'KarlNet-TurboCell-TxRate','TxRate-Local',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5919,NULL,'KarlNet-TurboCell-TxRate','TxRate-MaxSpeed',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5920,NULL,'KarlNet-TurboCell-TxRate','TxRate-11k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5921,NULL,'KarlNet-TurboCell-TxRate','TxRate-12k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5922,NULL,'KarlNet-TurboCell-TxRate','TxRate-13k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5923,NULL,'KarlNet-TurboCell-TxRate','TxRate-14k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5924,NULL,'KarlNet-TurboCell-TxRate','TxRate-15k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5925,NULL,'KarlNet-TurboCell-TxRate','TxRate-16k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5926,NULL,'KarlNet-TurboCell-TxRate','TxRate-17k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5927,NULL,'KarlNet-TurboCell-TxRate','TxRate-18k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5928,NULL,'KarlNet-TurboCell-TxRate','TxRate-19k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5929,NULL,'KarlNet-TurboCell-TxRate','TxRate-20k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5930,NULL,'KarlNet-TurboCell-TxRate','TxRate-21k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5931,NULL,'KarlNet-TurboCell-TxRate','TxRate-22k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5932,NULL,'KarlNet-TurboCell-TxRate','TxRate-23k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5933,NULL,'KarlNet-TurboCell-TxRate','TxRate-24k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5934,NULL,'KarlNet-TurboCell-TxRate','TxRate-25k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5935,NULL,'KarlNet-TurboCell-TxRate','TxRate-26k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5936,NULL,'KarlNet-TurboCell-TxRate','TxRate-27k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5937,NULL,'KarlNet-TurboCell-TxRate','TxRate-28k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5938,NULL,'KarlNet-TurboCell-TxRate','TxRate-29k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5939,NULL,'KarlNet-TurboCell-TxRate','TxRate-30k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5940,NULL,'KarlNet-TurboCell-TxRate','TxRate-31k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5941,NULL,'KarlNet-TurboCell-TxRate','TxRate-32k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5942,NULL,'KarlNet-TurboCell-TxRate','TxRate-33k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5943,NULL,'KarlNet-TurboCell-TxRate','TxRate-34k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5944,NULL,'KarlNet-TurboCell-TxRate','TxRate-35k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5945,NULL,'KarlNet-TurboCell-TxRate','TxRate-36k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5946,NULL,'KarlNet-TurboCell-TxRate','TxRate-37k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5947,NULL,'KarlNet-TurboCell-TxRate','TxRate-38k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5948,NULL,'KarlNet-TurboCell-TxRate','TxRate-39k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5949,NULL,'KarlNet-TurboCell-TxRate','TxRate-40k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5950,NULL,'KarlNet-TurboCell-TxRate','TxRate-41k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5951,NULL,'KarlNet-TurboCell-TxRate','TxRate-42k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5952,NULL,'KarlNet-TurboCell-TxRate','TxRate-43k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5953,NULL,'KarlNet-TurboCell-TxRate','TxRate-44k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5954,NULL,'KarlNet-TurboCell-TxRate','TxRate-45k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5955,NULL,'KarlNet-TurboCell-TxRate','TxRate-46k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5956,NULL,'KarlNet-TurboCell-TxRate','TxRate-47k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5957,NULL,'KarlNet-TurboCell-TxRate','TxRate-48k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5958,NULL,'KarlNet-TurboCell-TxRate','TxRate-49k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5959,NULL,'KarlNet-TurboCell-TxRate','TxRate-50k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5960,NULL,'KarlNet-TurboCell-TxRate','TxRate-51k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5961,NULL,'KarlNet-TurboCell-TxRate','TxRate-52k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5962,NULL,'KarlNet-TurboCell-TxRate','TxRate-53k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5963,NULL,'KarlNet-TurboCell-TxRate','TxRate-54k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5964,NULL,'KarlNet-TurboCell-TxRate','TxRate-55k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5965,NULL,'KarlNet-TurboCell-TxRate','TxRate-56k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5966,NULL,'KarlNet-TurboCell-TxRate','TxRate-57k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5967,NULL,'KarlNet-TurboCell-TxRate','TxRate-58k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5968,NULL,'KarlNet-TurboCell-TxRate','TxRate-59k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5969,NULL,'KarlNet-TurboCell-TxRate','TxRate-60k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5970,NULL,'KarlNet-TurboCell-TxRate','TxRate-61k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5971,NULL,'KarlNet-TurboCell-TxRate','TxRate-62k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5972,NULL,'KarlNet-TurboCell-TxRate','TxRate-63k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5973,NULL,'KarlNet-TurboCell-TxRate','TxRate-64k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5974,NULL,'KarlNet-TurboCell-TxRate','TxRate-65k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5975,NULL,'KarlNet-TurboCell-TxRate','TxRate-66k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5976,NULL,'KarlNet-TurboCell-TxRate','TxRate-67k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5977,NULL,'KarlNet-TurboCell-TxRate','TxRate-68k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5978,NULL,'KarlNet-TurboCell-TxRate','TxRate-69k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5979,NULL,'KarlNet-TurboCell-TxRate','TxRate-70k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5980,NULL,'KarlNet-TurboCell-TxRate','TxRate-71k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5981,NULL,'KarlNet-TurboCell-TxRate','TxRate-72k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5982,NULL,'KarlNet-TurboCell-TxRate','TxRate-73k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5983,NULL,'KarlNet-TurboCell-TxRate','TxRate-74k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5984,NULL,'KarlNet-TurboCell-TxRate','TxRate-75k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5985,NULL,'KarlNet-TurboCell-TxRate','TxRate-76k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5986,NULL,'KarlNet-TurboCell-TxRate','TxRate-77k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5987,NULL,'KarlNet-TurboCell-TxRate','TxRate-78k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5988,NULL,'KarlNet-TurboCell-TxRate','TxRate-79k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5989,NULL,'KarlNet-TurboCell-TxRate','TxRate-80k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5990,NULL,'KarlNet-TurboCell-TxRate','TxRate-81k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5991,NULL,'KarlNet-TurboCell-TxRate','TxRate-82k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5992,NULL,'KarlNet-TurboCell-TxRate','TxRate-83k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5993,NULL,'KarlNet-TurboCell-TxRate','TxRate-84k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5994,NULL,'KarlNet-TurboCell-TxRate','TxRate-85k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5995,NULL,'KarlNet-TurboCell-TxRate','TxRate-86k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5996,NULL,'KarlNet-TurboCell-TxRate','TxRate-87k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5997,NULL,'KarlNet-TurboCell-TxRate','TxRate-88k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5998,NULL,'KarlNet-TurboCell-TxRate','TxRate-89k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (5999,NULL,'KarlNet-TurboCell-TxRate','TxRate-90k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6000,NULL,'KarlNet-TurboCell-TxRate','TxRate-91k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6001,NULL,'KarlNet-TurboCell-TxRate','TxRate-92k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6002,NULL,'KarlNet-TurboCell-TxRate','TxRate-93k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6003,NULL,'KarlNet-TurboCell-TxRate','TxRate-94k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6004,NULL,'KarlNet-TurboCell-TxRate','TxRate-95k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6005,NULL,'KarlNet-TurboCell-TxRate','TxRate-96k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6006,NULL,'KarlNet-TurboCell-TxRate','TxRate-97k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6007,NULL,'KarlNet-TurboCell-TxRate','TxRate-98k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6008,NULL,'KarlNet-TurboCell-TxRate','TxRate-99k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6009,NULL,'KarlNet-TurboCell-TxRate','TxRate-100k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6010,NULL,'KarlNet-TurboCell-TxRate','TxRate-101k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6011,NULL,'KarlNet-TurboCell-TxRate','TxRate-102k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6012,NULL,'KarlNet-TurboCell-TxRate','TxRate-103k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6013,NULL,'KarlNet-TurboCell-TxRate','TxRate-104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6014,NULL,'KarlNet-TurboCell-TxRate','TxRate-105k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6015,NULL,'KarlNet-TurboCell-TxRate','TxRate-106k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6016,NULL,'KarlNet-TurboCell-TxRate','TxRate-107k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6017,NULL,'KarlNet-TurboCell-TxRate','TxRate-108k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6018,NULL,'KarlNet-TurboCell-TxRate','TxRate-109k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6019,NULL,'KarlNet-TurboCell-TxRate','TxRate-110k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6020,NULL,'KarlNet-TurboCell-TxRate','TxRate-111k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6021,NULL,'KarlNet-TurboCell-TxRate','TxRate-112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6022,NULL,'KarlNet-TurboCell-TxRate','TxRate-113k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6023,NULL,'KarlNet-TurboCell-TxRate','TxRate-114k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6024,NULL,'KarlNet-TurboCell-TxRate','TxRate-115k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6025,NULL,'KarlNet-TurboCell-TxRate','TxRate-116k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6026,NULL,'KarlNet-TurboCell-TxRate','TxRate-117k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6027,NULL,'KarlNet-TurboCell-TxRate','TxRate-118k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6028,NULL,'KarlNet-TurboCell-TxRate','TxRate-119k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6029,NULL,'KarlNet-TurboCell-TxRate','TxRate-120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6030,NULL,'KarlNet-TurboCell-TxRate','TxRate-121k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6031,NULL,'KarlNet-TurboCell-TxRate','TxRate-122k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6032,NULL,'KarlNet-TurboCell-TxRate','TxRate-123k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6033,NULL,'KarlNet-TurboCell-TxRate','TxRate-124k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6034,NULL,'KarlNet-TurboCell-TxRate','TxRate-125k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6035,NULL,'KarlNet-TurboCell-TxRate','TxRate-126k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6036,NULL,'KarlNet-TurboCell-TxRate','TxRate-127k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6037,NULL,'KarlNet-TurboCell-TxRate','TxRate-128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6038,NULL,'KarlNet-TurboCell-TxRate','TxRate-129k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6039,NULL,'KarlNet-TurboCell-TxRate','TxRate-130k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6040,NULL,'KarlNet-TurboCell-TxRate','TxRate-131k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6041,NULL,'KarlNet-TurboCell-TxRate','TxRate-132k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6042,NULL,'KarlNet-TurboCell-TxRate','TxRate-133k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6043,NULL,'KarlNet-TurboCell-TxRate','TxRate-134k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6044,NULL,'KarlNet-TurboCell-TxRate','TxRate-135k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6045,NULL,'KarlNet-TurboCell-TxRate','TxRate-136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6046,NULL,'KarlNet-TurboCell-TxRate','TxRate-137k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6047,NULL,'KarlNet-TurboCell-TxRate','TxRate-138k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6048,NULL,'KarlNet-TurboCell-TxRate','TxRate-139k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6049,NULL,'KarlNet-TurboCell-TxRate','TxRate-140k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6050,NULL,'KarlNet-TurboCell-TxRate','TxRate-141k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6051,NULL,'KarlNet-TurboCell-TxRate','TxRate-142k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6052,NULL,'KarlNet-TurboCell-TxRate','TxRate-143k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6053,NULL,'KarlNet-TurboCell-TxRate','TxRate-144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6054,NULL,'KarlNet-TurboCell-TxRate','TxRate-145k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6055,NULL,'KarlNet-TurboCell-TxRate','TxRate-146k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6056,NULL,'KarlNet-TurboCell-TxRate','TxRate-147k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6057,NULL,'KarlNet-TurboCell-TxRate','TxRate-148k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6058,NULL,'KarlNet-TurboCell-TxRate','TxRate-149k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6059,NULL,'KarlNet-TurboCell-TxRate','TxRate-150k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6060,NULL,'KarlNet-TurboCell-TxRate','TxRate-151k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6061,NULL,'KarlNet-TurboCell-TxRate','TxRate-152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6062,NULL,'KarlNet-TurboCell-TxRate','TxRate-153k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6063,NULL,'KarlNet-TurboCell-TxRate','TxRate-154k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6064,NULL,'KarlNet-TurboCell-TxRate','TxRate-155k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6065,NULL,'KarlNet-TurboCell-TxRate','TxRate-156k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6066,NULL,'KarlNet-TurboCell-TxRate','TxRate-157k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6067,NULL,'KarlNet-TurboCell-TxRate','TxRate-158k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6068,NULL,'KarlNet-TurboCell-TxRate','TxRate-159k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6069,NULL,'KarlNet-TurboCell-TxRate','TxRate-160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6070,NULL,'KarlNet-TurboCell-TxRate','TxRate-161k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6071,NULL,'KarlNet-TurboCell-TxRate','TxRate-162k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6072,NULL,'KarlNet-TurboCell-TxRate','TxRate-163k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6073,NULL,'KarlNet-TurboCell-TxRate','TxRate-164k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6074,NULL,'KarlNet-TurboCell-TxRate','TxRate-165k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6075,NULL,'KarlNet-TurboCell-TxRate','TxRate-166k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6076,NULL,'KarlNet-TurboCell-TxRate','TxRate-167k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6077,NULL,'KarlNet-TurboCell-TxRate','TxRate-168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6078,NULL,'KarlNet-TurboCell-TxRate','TxRate-169k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6079,NULL,'KarlNet-TurboCell-TxRate','TxRate-170k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6080,NULL,'KarlNet-TurboCell-TxRate','TxRate-171k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6081,NULL,'KarlNet-TurboCell-TxRate','TxRate-172k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6082,NULL,'KarlNet-TurboCell-TxRate','TxRate-173k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6083,NULL,'KarlNet-TurboCell-TxRate','TxRate-174k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6084,NULL,'KarlNet-TurboCell-TxRate','TxRate-175k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6085,NULL,'KarlNet-TurboCell-TxRate','TxRate-176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6086,NULL,'KarlNet-TurboCell-TxRate','TxRate-177k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6087,NULL,'KarlNet-TurboCell-TxRate','TxRate-178k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6088,NULL,'KarlNet-TurboCell-TxRate','TxRate-179k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6089,NULL,'KarlNet-TurboCell-TxRate','TxRate-180k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6090,NULL,'KarlNet-TurboCell-TxRate','TxRate-181k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6091,NULL,'KarlNet-TurboCell-TxRate','TxRate-182k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6092,NULL,'KarlNet-TurboCell-TxRate','TxRate-183k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6093,NULL,'KarlNet-TurboCell-TxRate','TxRate-184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6094,NULL,'KarlNet-TurboCell-TxRate','TxRate-185k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6095,NULL,'KarlNet-TurboCell-TxRate','TxRate-186k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6096,NULL,'KarlNet-TurboCell-TxRate','TxRate-187k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6097,NULL,'KarlNet-TurboCell-TxRate','TxRate-188k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6098,NULL,'KarlNet-TurboCell-TxRate','TxRate-189k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6099,NULL,'KarlNet-TurboCell-TxRate','TxRate-190k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6100,NULL,'KarlNet-TurboCell-TxRate','TxRate-191k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6101,NULL,'KarlNet-TurboCell-TxRate','TxRate-192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6102,NULL,'KarlNet-TurboCell-TxRate','TxRate-193k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6103,NULL,'KarlNet-TurboCell-TxRate','TxRate-194k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6104,NULL,'KarlNet-TurboCell-TxRate','TxRate-195k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6105,NULL,'KarlNet-TurboCell-TxRate','TxRate-196k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6106,NULL,'KarlNet-TurboCell-TxRate','TxRate-197k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6107,NULL,'KarlNet-TurboCell-TxRate','TxRate-198k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6108,NULL,'KarlNet-TurboCell-TxRate','TxRate-199k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6109,NULL,'KarlNet-TurboCell-TxRate','TxRate-200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6110,NULL,'KarlNet-TurboCell-TxRate','TxRate-201k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6111,NULL,'KarlNet-TurboCell-TxRate','TxRate-202k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6112,NULL,'KarlNet-TurboCell-TxRate','TxRate-203k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6113,NULL,'KarlNet-TurboCell-TxRate','TxRate-204k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6114,NULL,'KarlNet-TurboCell-TxRate','TxRate-205k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6115,NULL,'KarlNet-TurboCell-TxRate','TxRate-206k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6116,NULL,'KarlNet-TurboCell-TxRate','TxRate-207k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6117,NULL,'KarlNet-TurboCell-TxRate','TxRate-208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6118,NULL,'KarlNet-TurboCell-TxRate','TxRate-209k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6119,NULL,'KarlNet-TurboCell-TxRate','TxRate-210k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6120,NULL,'KarlNet-TurboCell-TxRate','TxRate-211k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6121,NULL,'KarlNet-TurboCell-TxRate','TxRate-212k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6122,NULL,'KarlNet-TurboCell-TxRate','TxRate-213k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6123,NULL,'KarlNet-TurboCell-TxRate','TxRate-214k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6124,NULL,'KarlNet-TurboCell-TxRate','TxRate-215k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6125,NULL,'KarlNet-TurboCell-TxRate','TxRate-216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6126,NULL,'KarlNet-TurboCell-TxRate','TxRate-217k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6127,NULL,'KarlNet-TurboCell-TxRate','TxRate-218k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6128,NULL,'KarlNet-TurboCell-TxRate','TxRate-219k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6129,NULL,'KarlNet-TurboCell-TxRate','TxRate-220k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6130,NULL,'KarlNet-TurboCell-TxRate','TxRate-221k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6131,NULL,'KarlNet-TurboCell-TxRate','TxRate-222k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6132,NULL,'KarlNet-TurboCell-TxRate','TxRate-223k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6133,NULL,'KarlNet-TurboCell-TxRate','TxRate-224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6134,NULL,'KarlNet-TurboCell-TxRate','TxRate-225k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6135,NULL,'KarlNet-TurboCell-TxRate','TxRate-226k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6136,NULL,'KarlNet-TurboCell-TxRate','TxRate-227k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6137,NULL,'KarlNet-TurboCell-TxRate','TxRate-228k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6138,NULL,'KarlNet-TurboCell-TxRate','TxRate-229k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6139,NULL,'KarlNet-TurboCell-TxRate','TxRate-230k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6140,NULL,'KarlNet-TurboCell-TxRate','TxRate-231k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6141,NULL,'KarlNet-TurboCell-TxRate','TxRate-232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6142,NULL,'KarlNet-TurboCell-TxRate','TxRate-233k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6143,NULL,'KarlNet-TurboCell-TxRate','TxRate-234k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6144,NULL,'KarlNet-TurboCell-TxRate','TxRate-235k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6145,NULL,'KarlNet-TurboCell-TxRate','TxRate-236k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6146,NULL,'KarlNet-TurboCell-TxRate','TxRate-237k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6147,NULL,'KarlNet-TurboCell-TxRate','TxRate-238k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6148,NULL,'KarlNet-TurboCell-TxRate','TxRate-239k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6149,NULL,'KarlNet-TurboCell-TxRate','TxRate-240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6150,NULL,'KarlNet-TurboCell-TxRate','TxRate-241k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6151,NULL,'KarlNet-TurboCell-TxRate','TxRate-242k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6152,NULL,'KarlNet-TurboCell-TxRate','TxRate-243k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6153,NULL,'KarlNet-TurboCell-TxRate','TxRate-244k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6154,NULL,'KarlNet-TurboCell-TxRate','TxRate-245k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6155,NULL,'KarlNet-TurboCell-TxRate','TxRate-246k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6156,NULL,'KarlNet-TurboCell-TxRate','TxRate-247k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6157,NULL,'KarlNet-TurboCell-TxRate','TxRate-248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6158,NULL,'KarlNet-TurboCell-TxRate','TxRate-249k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6159,NULL,'KarlNet-TurboCell-TxRate','TxRate-250k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6160,NULL,'KarlNet-TurboCell-TxRate','TxRate-251k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6161,NULL,'KarlNet-TurboCell-TxRate','TxRate-252k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6162,NULL,'KarlNet-TurboCell-TxRate','TxRate-253k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6163,NULL,'KarlNet-TurboCell-TxRate','TxRate-254k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6164,NULL,'KarlNet-TurboCell-TxRate','TxRate-255k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6165,NULL,'KarlNet-TurboCell-TxRate','TxRate-256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6166,NULL,'KarlNet-TurboCell-TxRate','TxRate-257k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6167,NULL,'KarlNet-TurboCell-TxRate','TxRate-258k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6168,NULL,'KarlNet-TurboCell-TxRate','TxRate-259k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6169,NULL,'KarlNet-TurboCell-TxRate','TxRate-260k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6170,NULL,'KarlNet-TurboCell-TxRate','TxRate-261k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6171,NULL,'KarlNet-TurboCell-TxRate','TxRate-262k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6172,NULL,'KarlNet-TurboCell-TxRate','TxRate-263k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6173,NULL,'KarlNet-TurboCell-TxRate','TxRate-264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6174,NULL,'KarlNet-TurboCell-TxRate','TxRate-265k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6175,NULL,'KarlNet-TurboCell-TxRate','TxRate-266k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6176,NULL,'KarlNet-TurboCell-TxRate','TxRate-267k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6177,NULL,'KarlNet-TurboCell-TxRate','TxRate-268k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6178,NULL,'KarlNet-TurboCell-TxRate','TxRate-269k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6179,NULL,'KarlNet-TurboCell-TxRate','TxRate-270k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6180,NULL,'KarlNet-TurboCell-TxRate','TxRate-271k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6181,NULL,'KarlNet-TurboCell-TxRate','TxRate-272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6182,NULL,'KarlNet-TurboCell-TxRate','TxRate-273k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6183,NULL,'KarlNet-TurboCell-TxRate','TxRate-274k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6184,NULL,'KarlNet-TurboCell-TxRate','TxRate-275k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6185,NULL,'KarlNet-TurboCell-TxRate','TxRate-276k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6186,NULL,'KarlNet-TurboCell-TxRate','TxRate-277k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6187,NULL,'KarlNet-TurboCell-TxRate','TxRate-278k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6188,NULL,'KarlNet-TurboCell-TxRate','TxRate-279k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6189,NULL,'KarlNet-TurboCell-TxRate','TxRate-280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6190,NULL,'KarlNet-TurboCell-TxRate','TxRate-281k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6191,NULL,'KarlNet-TurboCell-TxRate','TxRate-282k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6192,NULL,'KarlNet-TurboCell-TxRate','TxRate-283k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6193,NULL,'KarlNet-TurboCell-TxRate','TxRate-284k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6194,NULL,'KarlNet-TurboCell-TxRate','TxRate-285k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6195,NULL,'KarlNet-TurboCell-TxRate','TxRate-286k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6196,NULL,'KarlNet-TurboCell-TxRate','TxRate-287k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6197,NULL,'KarlNet-TurboCell-TxRate','TxRate-288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6198,NULL,'KarlNet-TurboCell-TxRate','TxRate-289k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6199,NULL,'KarlNet-TurboCell-TxRate','TxRate-290k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6200,NULL,'KarlNet-TurboCell-TxRate','TxRate-291k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6201,NULL,'KarlNet-TurboCell-TxRate','TxRate-292k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6202,NULL,'KarlNet-TurboCell-TxRate','TxRate-293k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6203,NULL,'KarlNet-TurboCell-TxRate','TxRate-294k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6204,NULL,'KarlNet-TurboCell-TxRate','TxRate-295k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6205,NULL,'KarlNet-TurboCell-TxRate','TxRate-296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6206,NULL,'KarlNet-TurboCell-TxRate','TxRate-297k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6207,NULL,'KarlNet-TurboCell-TxRate','TxRate-298k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6208,NULL,'KarlNet-TurboCell-TxRate','TxRate-299k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6209,NULL,'KarlNet-TurboCell-TxRate','TxRate-300k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6210,NULL,'KarlNet-TurboCell-TxRate','TxRate-301k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6211,NULL,'KarlNet-TurboCell-TxRate','TxRate-302k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6212,NULL,'KarlNet-TurboCell-TxRate','TxRate-303k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6213,NULL,'KarlNet-TurboCell-TxRate','TxRate-304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6214,NULL,'KarlNet-TurboCell-TxRate','TxRate-305k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6215,NULL,'KarlNet-TurboCell-TxRate','TxRate-306k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6216,NULL,'KarlNet-TurboCell-TxRate','TxRate-307k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6217,NULL,'KarlNet-TurboCell-TxRate','TxRate-308k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6218,NULL,'KarlNet-TurboCell-TxRate','TxRate-309k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6219,NULL,'KarlNet-TurboCell-TxRate','TxRate-310k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6220,NULL,'KarlNet-TurboCell-TxRate','TxRate-311k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6221,NULL,'KarlNet-TurboCell-TxRate','TxRate-312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6222,NULL,'KarlNet-TurboCell-TxRate','TxRate-313k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6223,NULL,'KarlNet-TurboCell-TxRate','TxRate-314k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6224,NULL,'KarlNet-TurboCell-TxRate','TxRate-315k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6225,NULL,'KarlNet-TurboCell-TxRate','TxRate-316k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6226,NULL,'KarlNet-TurboCell-TxRate','TxRate-317k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6227,NULL,'KarlNet-TurboCell-TxRate','TxRate-318k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6228,NULL,'KarlNet-TurboCell-TxRate','TxRate-319k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6229,NULL,'KarlNet-TurboCell-TxRate','TxRate-320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6230,NULL,'KarlNet-TurboCell-TxRate','TxRate-321k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6231,NULL,'KarlNet-TurboCell-TxRate','TxRate-322k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6232,NULL,'KarlNet-TurboCell-TxRate','TxRate-323k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6233,NULL,'KarlNet-TurboCell-TxRate','TxRate-324k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6234,NULL,'KarlNet-TurboCell-TxRate','TxRate-325k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6235,NULL,'KarlNet-TurboCell-TxRate','TxRate-326k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6236,NULL,'KarlNet-TurboCell-TxRate','TxRate-327k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6237,NULL,'KarlNet-TurboCell-TxRate','TxRate-328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6238,NULL,'KarlNet-TurboCell-TxRate','TxRate-329k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6239,NULL,'KarlNet-TurboCell-TxRate','TxRate-330k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6240,NULL,'KarlNet-TurboCell-TxRate','TxRate-331k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6241,NULL,'KarlNet-TurboCell-TxRate','TxRate-332k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6242,NULL,'KarlNet-TurboCell-TxRate','TxRate-333k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6243,NULL,'KarlNet-TurboCell-TxRate','TxRate-334k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6244,NULL,'KarlNet-TurboCell-TxRate','TxRate-335k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6245,NULL,'KarlNet-TurboCell-TxRate','TxRate-336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6246,NULL,'KarlNet-TurboCell-TxRate','TxRate-337k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6247,NULL,'KarlNet-TurboCell-TxRate','TxRate-338k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6248,NULL,'KarlNet-TurboCell-TxRate','TxRate-339k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6249,NULL,'KarlNet-TurboCell-TxRate','TxRate-340k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6250,NULL,'KarlNet-TurboCell-TxRate','TxRate-341k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6251,NULL,'KarlNet-TurboCell-TxRate','TxRate-342k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6252,NULL,'KarlNet-TurboCell-TxRate','TxRate-343k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6253,NULL,'KarlNet-TurboCell-TxRate','TxRate-344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6254,NULL,'KarlNet-TurboCell-TxRate','TxRate-345k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6255,NULL,'KarlNet-TurboCell-TxRate','TxRate-346k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6256,NULL,'KarlNet-TurboCell-TxRate','TxRate-347k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6257,NULL,'KarlNet-TurboCell-TxRate','TxRate-348k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6258,NULL,'KarlNet-TurboCell-TxRate','TxRate-349k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6259,NULL,'KarlNet-TurboCell-TxRate','TxRate-350k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6260,NULL,'KarlNet-TurboCell-TxRate','TxRate-351k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6261,NULL,'KarlNet-TurboCell-TxRate','TxRate-352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6262,NULL,'KarlNet-TurboCell-TxRate','TxRate-353k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6263,NULL,'KarlNet-TurboCell-TxRate','TxRate-354k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6264,NULL,'KarlNet-TurboCell-TxRate','TxRate-355k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6265,NULL,'KarlNet-TurboCell-TxRate','TxRate-356k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6266,NULL,'KarlNet-TurboCell-TxRate','TxRate-357k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6267,NULL,'KarlNet-TurboCell-TxRate','TxRate-358k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6268,NULL,'KarlNet-TurboCell-TxRate','TxRate-359k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6269,NULL,'KarlNet-TurboCell-TxRate','TxRate-360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6270,NULL,'KarlNet-TurboCell-TxRate','TxRate-361k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6271,NULL,'KarlNet-TurboCell-TxRate','TxRate-362k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6272,NULL,'KarlNet-TurboCell-TxRate','TxRate-363k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6273,NULL,'KarlNet-TurboCell-TxRate','TxRate-364k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6274,NULL,'KarlNet-TurboCell-TxRate','TxRate-365k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6275,NULL,'KarlNet-TurboCell-TxRate','TxRate-366k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6276,NULL,'KarlNet-TurboCell-TxRate','TxRate-367k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6277,NULL,'KarlNet-TurboCell-TxRate','TxRate-368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6278,NULL,'KarlNet-TurboCell-TxRate','TxRate-369k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6279,NULL,'KarlNet-TurboCell-TxRate','TxRate-370k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6280,NULL,'KarlNet-TurboCell-TxRate','TxRate-371k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6281,NULL,'KarlNet-TurboCell-TxRate','TxRate-372k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6282,NULL,'KarlNet-TurboCell-TxRate','TxRate-373k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6283,NULL,'KarlNet-TurboCell-TxRate','TxRate-374k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6284,NULL,'KarlNet-TurboCell-TxRate','TxRate-375k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6285,NULL,'KarlNet-TurboCell-TxRate','TxRate-376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6286,NULL,'KarlNet-TurboCell-TxRate','TxRate-377k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6287,NULL,'KarlNet-TurboCell-TxRate','TxRate-378k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6288,NULL,'KarlNet-TurboCell-TxRate','TxRate-379k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6289,NULL,'KarlNet-TurboCell-TxRate','TxRate-380k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6290,NULL,'KarlNet-TurboCell-TxRate','TxRate-381k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6291,NULL,'KarlNet-TurboCell-TxRate','TxRate-382k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6292,NULL,'KarlNet-TurboCell-TxRate','TxRate-383k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6293,NULL,'KarlNet-TurboCell-TxRate','TxRate-384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6294,NULL,'KarlNet-TurboCell-TxRate','TxRate-385k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6295,NULL,'KarlNet-TurboCell-TxRate','TxRate-386k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6296,NULL,'KarlNet-TurboCell-TxRate','TxRate-387k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6297,NULL,'KarlNet-TurboCell-TxRate','TxRate-388k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6298,NULL,'KarlNet-TurboCell-TxRate','TxRate-389k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6299,NULL,'KarlNet-TurboCell-TxRate','TxRate-390k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6300,NULL,'KarlNet-TurboCell-TxRate','TxRate-391k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6301,NULL,'KarlNet-TurboCell-TxRate','TxRate-392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6302,NULL,'KarlNet-TurboCell-TxRate','TxRate-393k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6303,NULL,'KarlNet-TurboCell-TxRate','TxRate-394k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6304,NULL,'KarlNet-TurboCell-TxRate','TxRate-395k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6305,NULL,'KarlNet-TurboCell-TxRate','TxRate-396k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6306,NULL,'KarlNet-TurboCell-TxRate','TxRate-397k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6307,NULL,'KarlNet-TurboCell-TxRate','TxRate-398k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6308,NULL,'KarlNet-TurboCell-TxRate','TxRate-399k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6309,NULL,'KarlNet-TurboCell-TxRate','TxRate-400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6310,NULL,'KarlNet-TurboCell-TxRate','TxRate-401k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6311,NULL,'KarlNet-TurboCell-TxRate','TxRate-402k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6312,NULL,'KarlNet-TurboCell-TxRate','TxRate-403k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6313,NULL,'KarlNet-TurboCell-TxRate','TxRate-404k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6314,NULL,'KarlNet-TurboCell-TxRate','TxRate-405k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6315,NULL,'KarlNet-TurboCell-TxRate','TxRate-406k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6316,NULL,'KarlNet-TurboCell-TxRate','TxRate-407k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6317,NULL,'KarlNet-TurboCell-TxRate','TxRate-408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6318,NULL,'KarlNet-TurboCell-TxRate','TxRate-409k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6319,NULL,'KarlNet-TurboCell-TxRate','TxRate-410k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6320,NULL,'KarlNet-TurboCell-TxRate','TxRate-411k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6321,NULL,'KarlNet-TurboCell-TxRate','TxRate-412k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6322,NULL,'KarlNet-TurboCell-TxRate','TxRate-413k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6323,NULL,'KarlNet-TurboCell-TxRate','TxRate-414k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6324,NULL,'KarlNet-TurboCell-TxRate','TxRate-415k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6325,NULL,'KarlNet-TurboCell-TxRate','TxRate-416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6326,NULL,'KarlNet-TurboCell-TxRate','TxRate-417k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6327,NULL,'KarlNet-TurboCell-TxRate','TxRate-418k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6328,NULL,'KarlNet-TurboCell-TxRate','TxRate-419k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6329,NULL,'KarlNet-TurboCell-TxRate','TxRate-420k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6330,NULL,'KarlNet-TurboCell-TxRate','TxRate-421k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6331,NULL,'KarlNet-TurboCell-TxRate','TxRate-422k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6332,NULL,'KarlNet-TurboCell-TxRate','TxRate-423k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6333,NULL,'KarlNet-TurboCell-TxRate','TxRate-424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6334,NULL,'KarlNet-TurboCell-TxRate','TxRate-425k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6335,NULL,'KarlNet-TurboCell-TxRate','TxRate-426k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6336,NULL,'KarlNet-TurboCell-TxRate','TxRate-427k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6337,NULL,'KarlNet-TurboCell-TxRate','TxRate-428k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6338,NULL,'KarlNet-TurboCell-TxRate','TxRate-429k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6339,NULL,'KarlNet-TurboCell-TxRate','TxRate-430k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6340,NULL,'KarlNet-TurboCell-TxRate','TxRate-431k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6341,NULL,'KarlNet-TurboCell-TxRate','TxRate-432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6342,NULL,'KarlNet-TurboCell-TxRate','TxRate-433k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6343,NULL,'KarlNet-TurboCell-TxRate','TxRate-434k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6344,NULL,'KarlNet-TurboCell-TxRate','TxRate-435k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6345,NULL,'KarlNet-TurboCell-TxRate','TxRate-436k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6346,NULL,'KarlNet-TurboCell-TxRate','TxRate-437k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6347,NULL,'KarlNet-TurboCell-TxRate','TxRate-438k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6348,NULL,'KarlNet-TurboCell-TxRate','TxRate-439k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6349,NULL,'KarlNet-TurboCell-TxRate','TxRate-440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6350,NULL,'KarlNet-TurboCell-TxRate','TxRate-441k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6351,NULL,'KarlNet-TurboCell-TxRate','TxRate-442k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6352,NULL,'KarlNet-TurboCell-TxRate','TxRate-443k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6353,NULL,'KarlNet-TurboCell-TxRate','TxRate-444k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6354,NULL,'KarlNet-TurboCell-TxRate','TxRate-445k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6355,NULL,'KarlNet-TurboCell-TxRate','TxRate-446k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6356,NULL,'KarlNet-TurboCell-TxRate','TxRate-447k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6357,NULL,'KarlNet-TurboCell-TxRate','TxRate-448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6358,NULL,'KarlNet-TurboCell-TxRate','TxRate-449k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6359,NULL,'KarlNet-TurboCell-TxRate','TxRate-450k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6360,NULL,'KarlNet-TurboCell-TxRate','TxRate-451k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6361,NULL,'KarlNet-TurboCell-TxRate','TxRate-452k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6362,NULL,'KarlNet-TurboCell-TxRate','TxRate-453k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6363,NULL,'KarlNet-TurboCell-TxRate','TxRate-454k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6364,NULL,'KarlNet-TurboCell-TxRate','TxRate-455k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6365,NULL,'KarlNet-TurboCell-TxRate','TxRate-456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6366,NULL,'KarlNet-TurboCell-TxRate','TxRate-457k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6367,NULL,'KarlNet-TurboCell-TxRate','TxRate-458k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6368,NULL,'KarlNet-TurboCell-TxRate','TxRate-459k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6369,NULL,'KarlNet-TurboCell-TxRate','TxRate-460k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6370,NULL,'KarlNet-TurboCell-TxRate','TxRate-461k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6371,NULL,'KarlNet-TurboCell-TxRate','TxRate-462k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6372,NULL,'KarlNet-TurboCell-TxRate','TxRate-463k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6373,NULL,'KarlNet-TurboCell-TxRate','TxRate-464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6374,NULL,'KarlNet-TurboCell-TxRate','TxRate-465k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6375,NULL,'KarlNet-TurboCell-TxRate','TxRate-466k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6376,NULL,'KarlNet-TurboCell-TxRate','TxRate-467k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6377,NULL,'KarlNet-TurboCell-TxRate','TxRate-468k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6378,NULL,'KarlNet-TurboCell-TxRate','TxRate-469k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6379,NULL,'KarlNet-TurboCell-TxRate','TxRate-470k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6380,NULL,'KarlNet-TurboCell-TxRate','TxRate-471k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6381,NULL,'KarlNet-TurboCell-TxRate','TxRate-472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6382,NULL,'KarlNet-TurboCell-TxRate','TxRate-473k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6383,NULL,'KarlNet-TurboCell-TxRate','TxRate-474k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6384,NULL,'KarlNet-TurboCell-TxRate','TxRate-475k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6385,NULL,'KarlNet-TurboCell-TxRate','TxRate-476k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6386,NULL,'KarlNet-TurboCell-TxRate','TxRate-477k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6387,NULL,'KarlNet-TurboCell-TxRate','TxRate-478k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6388,NULL,'KarlNet-TurboCell-TxRate','TxRate-479k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6389,NULL,'KarlNet-TurboCell-TxRate','TxRate-480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6390,NULL,'KarlNet-TurboCell-TxRate','TxRate-481k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6391,NULL,'KarlNet-TurboCell-TxRate','TxRate-482k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6392,NULL,'KarlNet-TurboCell-TxRate','TxRate-483k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6393,NULL,'KarlNet-TurboCell-TxRate','TxRate-484k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6394,NULL,'KarlNet-TurboCell-TxRate','TxRate-485k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6395,NULL,'KarlNet-TurboCell-TxRate','TxRate-486k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6396,NULL,'KarlNet-TurboCell-TxRate','TxRate-487k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6397,NULL,'KarlNet-TurboCell-TxRate','TxRate-488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6398,NULL,'KarlNet-TurboCell-TxRate','TxRate-489k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6399,NULL,'KarlNet-TurboCell-TxRate','TxRate-490k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6400,NULL,'KarlNet-TurboCell-TxRate','TxRate-491k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6401,NULL,'KarlNet-TurboCell-TxRate','TxRate-492k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6402,NULL,'KarlNet-TurboCell-TxRate','TxRate-493k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6403,NULL,'KarlNet-TurboCell-TxRate','TxRate-494k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6404,NULL,'KarlNet-TurboCell-TxRate','TxRate-495k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6405,NULL,'KarlNet-TurboCell-TxRate','TxRate-496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6406,NULL,'KarlNet-TurboCell-TxRate','TxRate-497k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6407,NULL,'KarlNet-TurboCell-TxRate','TxRate-498k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6408,NULL,'KarlNet-TurboCell-TxRate','TxRate-499k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6409,NULL,'KarlNet-TurboCell-TxRate','TxRate-500k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6410,NULL,'KarlNet-TurboCell-TxRate','TxRate-501k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6411,NULL,'KarlNet-TurboCell-TxRate','TxRate-502k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6412,NULL,'KarlNet-TurboCell-TxRate','TxRate-503k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6413,NULL,'KarlNet-TurboCell-TxRate','TxRate-504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6414,NULL,'KarlNet-TurboCell-TxRate','TxRate-505k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6415,NULL,'KarlNet-TurboCell-TxRate','TxRate-506k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6416,NULL,'KarlNet-TurboCell-TxRate','TxRate-507k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6417,NULL,'KarlNet-TurboCell-TxRate','TxRate-508k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6418,NULL,'KarlNet-TurboCell-TxRate','TxRate-509k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6419,NULL,'KarlNet-TurboCell-TxRate','TxRate-510k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6420,NULL,'KarlNet-TurboCell-TxRate','TxRate-511k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6421,NULL,'KarlNet-TurboCell-TxRate','TxRate-512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6422,NULL,'KarlNet-TurboCell-TxRate','TxRate-513k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6423,NULL,'KarlNet-TurboCell-TxRate','TxRate-514k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6424,NULL,'KarlNet-TurboCell-TxRate','TxRate-515k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6425,NULL,'KarlNet-TurboCell-TxRate','TxRate-516k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6426,NULL,'KarlNet-TurboCell-TxRate','TxRate-517k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6427,NULL,'KarlNet-TurboCell-TxRate','TxRate-518k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6428,NULL,'KarlNet-TurboCell-TxRate','TxRate-519k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6429,NULL,'KarlNet-TurboCell-TxRate','TxRate-520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6430,NULL,'KarlNet-TurboCell-TxRate','TxRate-521k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6431,NULL,'KarlNet-TurboCell-TxRate','TxRate-522k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6432,NULL,'KarlNet-TurboCell-TxRate','TxRate-523k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6433,NULL,'KarlNet-TurboCell-TxRate','TxRate-524k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6434,NULL,'KarlNet-TurboCell-TxRate','TxRate-525k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6435,NULL,'KarlNet-TurboCell-TxRate','TxRate-526k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6436,NULL,'KarlNet-TurboCell-TxRate','TxRate-527k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6437,NULL,'KarlNet-TurboCell-TxRate','TxRate-528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6438,NULL,'KarlNet-TurboCell-TxRate','TxRate-529k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6439,NULL,'KarlNet-TurboCell-TxRate','TxRate-530k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6440,NULL,'KarlNet-TurboCell-TxRate','TxRate-531k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6441,NULL,'KarlNet-TurboCell-TxRate','TxRate-532k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6442,NULL,'KarlNet-TurboCell-TxRate','TxRate-533k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6443,NULL,'KarlNet-TurboCell-TxRate','TxRate-534k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6444,NULL,'KarlNet-TurboCell-TxRate','TxRate-535k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6445,NULL,'KarlNet-TurboCell-TxRate','TxRate-536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6446,NULL,'KarlNet-TurboCell-TxRate','TxRate-537k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6447,NULL,'KarlNet-TurboCell-TxRate','TxRate-538k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6448,NULL,'KarlNet-TurboCell-TxRate','TxRate-539k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6449,NULL,'KarlNet-TurboCell-TxRate','TxRate-540k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6450,NULL,'KarlNet-TurboCell-TxRate','TxRate-541k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6451,NULL,'KarlNet-TurboCell-TxRate','TxRate-542k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6452,NULL,'KarlNet-TurboCell-TxRate','TxRate-543k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6453,NULL,'KarlNet-TurboCell-TxRate','TxRate-544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6454,NULL,'KarlNet-TurboCell-TxRate','TxRate-545k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6455,NULL,'KarlNet-TurboCell-TxRate','TxRate-546k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6456,NULL,'KarlNet-TurboCell-TxRate','TxRate-547k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6457,NULL,'KarlNet-TurboCell-TxRate','TxRate-548k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6458,NULL,'KarlNet-TurboCell-TxRate','TxRate-549k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6459,NULL,'KarlNet-TurboCell-TxRate','TxRate-550k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6460,NULL,'KarlNet-TurboCell-TxRate','TxRate-551k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6461,NULL,'KarlNet-TurboCell-TxRate','TxRate-552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6462,NULL,'KarlNet-TurboCell-TxRate','TxRate-553k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6463,NULL,'KarlNet-TurboCell-TxRate','TxRate-554k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6464,NULL,'KarlNet-TurboCell-TxRate','TxRate-555k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6465,NULL,'KarlNet-TurboCell-TxRate','TxRate-556k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6466,NULL,'KarlNet-TurboCell-TxRate','TxRate-557k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6467,NULL,'KarlNet-TurboCell-TxRate','TxRate-558k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6468,NULL,'KarlNet-TurboCell-TxRate','TxRate-559k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6469,NULL,'KarlNet-TurboCell-TxRate','TxRate-560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6470,NULL,'KarlNet-TurboCell-TxRate','TxRate-561k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6471,NULL,'KarlNet-TurboCell-TxRate','TxRate-562k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6472,NULL,'KarlNet-TurboCell-TxRate','TxRate-563k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6473,NULL,'KarlNet-TurboCell-TxRate','TxRate-564k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6474,NULL,'KarlNet-TurboCell-TxRate','TxRate-565k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6475,NULL,'KarlNet-TurboCell-TxRate','TxRate-566k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6476,NULL,'KarlNet-TurboCell-TxRate','TxRate-567k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6477,NULL,'KarlNet-TurboCell-TxRate','TxRate-568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6478,NULL,'KarlNet-TurboCell-TxRate','TxRate-569k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6479,NULL,'KarlNet-TurboCell-TxRate','TxRate-570k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6480,NULL,'KarlNet-TurboCell-TxRate','TxRate-571k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6481,NULL,'KarlNet-TurboCell-TxRate','TxRate-572k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6482,NULL,'KarlNet-TurboCell-TxRate','TxRate-573k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6483,NULL,'KarlNet-TurboCell-TxRate','TxRate-574k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6484,NULL,'KarlNet-TurboCell-TxRate','TxRate-575k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6485,NULL,'KarlNet-TurboCell-TxRate','TxRate-576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6486,NULL,'KarlNet-TurboCell-TxRate','TxRate-577k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6487,NULL,'KarlNet-TurboCell-TxRate','TxRate-578k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6488,NULL,'KarlNet-TurboCell-TxRate','TxRate-579k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6489,NULL,'KarlNet-TurboCell-TxRate','TxRate-580k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6490,NULL,'KarlNet-TurboCell-TxRate','TxRate-581k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6491,NULL,'KarlNet-TurboCell-TxRate','TxRate-582k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6492,NULL,'KarlNet-TurboCell-TxRate','TxRate-583k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6493,NULL,'KarlNet-TurboCell-TxRate','TxRate-584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6494,NULL,'KarlNet-TurboCell-TxRate','TxRate-585k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6495,NULL,'KarlNet-TurboCell-TxRate','TxRate-586k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6496,NULL,'KarlNet-TurboCell-TxRate','TxRate-587k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6497,NULL,'KarlNet-TurboCell-TxRate','TxRate-588k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6498,NULL,'KarlNet-TurboCell-TxRate','TxRate-589k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6499,NULL,'KarlNet-TurboCell-TxRate','TxRate-590k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6500,NULL,'KarlNet-TurboCell-TxRate','TxRate-591k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6501,NULL,'KarlNet-TurboCell-TxRate','TxRate-592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6502,NULL,'KarlNet-TurboCell-TxRate','TxRate-593k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6503,NULL,'KarlNet-TurboCell-TxRate','TxRate-594k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6504,NULL,'KarlNet-TurboCell-TxRate','TxRate-595k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6505,NULL,'KarlNet-TurboCell-TxRate','TxRate-596k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6506,NULL,'KarlNet-TurboCell-TxRate','TxRate-597k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6507,NULL,'KarlNet-TurboCell-TxRate','TxRate-598k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6508,NULL,'KarlNet-TurboCell-TxRate','TxRate-599k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6509,NULL,'KarlNet-TurboCell-TxRate','TxRate-600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6510,NULL,'KarlNet-TurboCell-TxRate','TxRate-601k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6511,NULL,'KarlNet-TurboCell-TxRate','TxRate-602k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6512,NULL,'KarlNet-TurboCell-TxRate','TxRate-603k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6513,NULL,'KarlNet-TurboCell-TxRate','TxRate-604k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6514,NULL,'KarlNet-TurboCell-TxRate','TxRate-605k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6515,NULL,'KarlNet-TurboCell-TxRate','TxRate-606k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6516,NULL,'KarlNet-TurboCell-TxRate','TxRate-607k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6517,NULL,'KarlNet-TurboCell-TxRate','TxRate-608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6518,NULL,'KarlNet-TurboCell-TxRate','TxRate-609k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6519,NULL,'KarlNet-TurboCell-TxRate','TxRate-610k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6520,NULL,'KarlNet-TurboCell-TxRate','TxRate-611k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6521,NULL,'KarlNet-TurboCell-TxRate','TxRate-612k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6522,NULL,'KarlNet-TurboCell-TxRate','TxRate-613k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6523,NULL,'KarlNet-TurboCell-TxRate','TxRate-614k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6524,NULL,'KarlNet-TurboCell-TxRate','TxRate-615k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6525,NULL,'KarlNet-TurboCell-TxRate','TxRate-616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6526,NULL,'KarlNet-TurboCell-TxRate','TxRate-617k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6527,NULL,'KarlNet-TurboCell-TxRate','TxRate-618k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6528,NULL,'KarlNet-TurboCell-TxRate','TxRate-619k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6529,NULL,'KarlNet-TurboCell-TxRate','TxRate-620k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6530,NULL,'KarlNet-TurboCell-TxRate','TxRate-621k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6531,NULL,'KarlNet-TurboCell-TxRate','TxRate-622k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6532,NULL,'KarlNet-TurboCell-TxRate','TxRate-623k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6533,NULL,'KarlNet-TurboCell-TxRate','TxRate-624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6534,NULL,'KarlNet-TurboCell-TxRate','TxRate-625k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6535,NULL,'KarlNet-TurboCell-TxRate','TxRate-626k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6536,NULL,'KarlNet-TurboCell-TxRate','TxRate-627k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6537,NULL,'KarlNet-TurboCell-TxRate','TxRate-628k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6538,NULL,'KarlNet-TurboCell-TxRate','TxRate-629k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6539,NULL,'KarlNet-TurboCell-TxRate','TxRate-630k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6540,NULL,'KarlNet-TurboCell-TxRate','TxRate-631k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6541,NULL,'KarlNet-TurboCell-TxRate','TxRate-632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6542,NULL,'KarlNet-TurboCell-TxRate','TxRate-633k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6543,NULL,'KarlNet-TurboCell-TxRate','TxRate-634k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6544,NULL,'KarlNet-TurboCell-TxRate','TxRate-635k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6545,NULL,'KarlNet-TurboCell-TxRate','TxRate-636k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6546,NULL,'KarlNet-TurboCell-TxRate','TxRate-637k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6547,NULL,'KarlNet-TurboCell-TxRate','TxRate-638k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6548,NULL,'KarlNet-TurboCell-TxRate','TxRate-639k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6549,NULL,'KarlNet-TurboCell-TxRate','TxRate-640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6550,NULL,'KarlNet-TurboCell-TxRate','TxRate-641k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6551,NULL,'KarlNet-TurboCell-TxRate','TxRate-642k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6552,NULL,'KarlNet-TurboCell-TxRate','TxRate-643k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6553,NULL,'KarlNet-TurboCell-TxRate','TxRate-644k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6554,NULL,'KarlNet-TurboCell-TxRate','TxRate-645k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6555,NULL,'KarlNet-TurboCell-TxRate','TxRate-646k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6556,NULL,'KarlNet-TurboCell-TxRate','TxRate-647k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6557,NULL,'KarlNet-TurboCell-TxRate','TxRate-648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6558,NULL,'KarlNet-TurboCell-TxRate','TxRate-649k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6559,NULL,'KarlNet-TurboCell-TxRate','TxRate-650k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6560,NULL,'KarlNet-TurboCell-TxRate','TxRate-651k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6561,NULL,'KarlNet-TurboCell-TxRate','TxRate-652k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6562,NULL,'KarlNet-TurboCell-TxRate','TxRate-653k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6563,NULL,'KarlNet-TurboCell-TxRate','TxRate-654k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6564,NULL,'KarlNet-TurboCell-TxRate','TxRate-655k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6565,NULL,'KarlNet-TurboCell-TxRate','TxRate-656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6566,NULL,'KarlNet-TurboCell-TxRate','TxRate-657k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6567,NULL,'KarlNet-TurboCell-TxRate','TxRate-658k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6568,NULL,'KarlNet-TurboCell-TxRate','TxRate-659k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6569,NULL,'KarlNet-TurboCell-TxRate','TxRate-660k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6570,NULL,'KarlNet-TurboCell-TxRate','TxRate-661k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6571,NULL,'KarlNet-TurboCell-TxRate','TxRate-662k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6572,NULL,'KarlNet-TurboCell-TxRate','TxRate-663k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6573,NULL,'KarlNet-TurboCell-TxRate','TxRate-664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6574,NULL,'KarlNet-TurboCell-TxRate','TxRate-665k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6575,NULL,'KarlNet-TurboCell-TxRate','TxRate-666k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6576,NULL,'KarlNet-TurboCell-TxRate','TxRate-667k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6577,NULL,'KarlNet-TurboCell-TxRate','TxRate-668k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6578,NULL,'KarlNet-TurboCell-TxRate','TxRate-669k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6579,NULL,'KarlNet-TurboCell-TxRate','TxRate-670k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6580,NULL,'KarlNet-TurboCell-TxRate','TxRate-671k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6581,NULL,'KarlNet-TurboCell-TxRate','TxRate-672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6582,NULL,'KarlNet-TurboCell-TxRate','TxRate-673k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6583,NULL,'KarlNet-TurboCell-TxRate','TxRate-674k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6584,NULL,'KarlNet-TurboCell-TxRate','TxRate-675k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6585,NULL,'KarlNet-TurboCell-TxRate','TxRate-676k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6586,NULL,'KarlNet-TurboCell-TxRate','TxRate-677k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6587,NULL,'KarlNet-TurboCell-TxRate','TxRate-678k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6588,NULL,'KarlNet-TurboCell-TxRate','TxRate-679k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6589,NULL,'KarlNet-TurboCell-TxRate','TxRate-680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6590,NULL,'KarlNet-TurboCell-TxRate','TxRate-681k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6591,NULL,'KarlNet-TurboCell-TxRate','TxRate-682k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6592,NULL,'KarlNet-TurboCell-TxRate','TxRate-683k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6593,NULL,'KarlNet-TurboCell-TxRate','TxRate-684k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6594,NULL,'KarlNet-TurboCell-TxRate','TxRate-685k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6595,NULL,'KarlNet-TurboCell-TxRate','TxRate-686k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6596,NULL,'KarlNet-TurboCell-TxRate','TxRate-687k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6597,NULL,'KarlNet-TurboCell-TxRate','TxRate-688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6598,NULL,'KarlNet-TurboCell-TxRate','TxRate-689k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6599,NULL,'KarlNet-TurboCell-TxRate','TxRate-690k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6600,NULL,'KarlNet-TurboCell-TxRate','TxRate-691k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6601,NULL,'KarlNet-TurboCell-TxRate','TxRate-692k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6602,NULL,'KarlNet-TurboCell-TxRate','TxRate-693k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6603,NULL,'KarlNet-TurboCell-TxRate','TxRate-694k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6604,NULL,'KarlNet-TurboCell-TxRate','TxRate-695k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6605,NULL,'KarlNet-TurboCell-TxRate','TxRate-696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6606,NULL,'KarlNet-TurboCell-TxRate','TxRate-697k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6607,NULL,'KarlNet-TurboCell-TxRate','TxRate-698k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6608,NULL,'KarlNet-TurboCell-TxRate','TxRate-699k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6609,NULL,'KarlNet-TurboCell-TxRate','TxRate-700k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6610,NULL,'KarlNet-TurboCell-TxRate','TxRate-701k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6611,NULL,'KarlNet-TurboCell-TxRate','TxRate-702k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6612,NULL,'KarlNet-TurboCell-TxRate','TxRate-703k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6613,NULL,'KarlNet-TurboCell-TxRate','TxRate-704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6614,NULL,'KarlNet-TurboCell-TxRate','TxRate-705k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6615,NULL,'KarlNet-TurboCell-TxRate','TxRate-706k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6616,NULL,'KarlNet-TurboCell-TxRate','TxRate-707k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6617,NULL,'KarlNet-TurboCell-TxRate','TxRate-708k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6618,NULL,'KarlNet-TurboCell-TxRate','TxRate-709k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6619,NULL,'KarlNet-TurboCell-TxRate','TxRate-710k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6620,NULL,'KarlNet-TurboCell-TxRate','TxRate-711k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6621,NULL,'KarlNet-TurboCell-TxRate','TxRate-712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6622,NULL,'KarlNet-TurboCell-TxRate','TxRate-713k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6623,NULL,'KarlNet-TurboCell-TxRate','TxRate-714k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6624,NULL,'KarlNet-TurboCell-TxRate','TxRate-715k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6625,NULL,'KarlNet-TurboCell-TxRate','TxRate-716k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6626,NULL,'KarlNet-TurboCell-TxRate','TxRate-717k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6627,NULL,'KarlNet-TurboCell-TxRate','TxRate-718k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6628,NULL,'KarlNet-TurboCell-TxRate','TxRate-719k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6629,NULL,'KarlNet-TurboCell-TxRate','TxRate-720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6630,NULL,'KarlNet-TurboCell-TxRate','TxRate-721k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6631,NULL,'KarlNet-TurboCell-TxRate','TxRate-722k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6632,NULL,'KarlNet-TurboCell-TxRate','TxRate-723k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6633,NULL,'KarlNet-TurboCell-TxRate','TxRate-724k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6634,NULL,'KarlNet-TurboCell-TxRate','TxRate-725k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6635,NULL,'KarlNet-TurboCell-TxRate','TxRate-726k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6636,NULL,'KarlNet-TurboCell-TxRate','TxRate-727k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6637,NULL,'KarlNet-TurboCell-TxRate','TxRate-728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6638,NULL,'KarlNet-TurboCell-TxRate','TxRate-729k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6639,NULL,'KarlNet-TurboCell-TxRate','TxRate-730k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6640,NULL,'KarlNet-TurboCell-TxRate','TxRate-731k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6641,NULL,'KarlNet-TurboCell-TxRate','TxRate-732k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6642,NULL,'KarlNet-TurboCell-TxRate','TxRate-733k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6643,NULL,'KarlNet-TurboCell-TxRate','TxRate-734k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6644,NULL,'KarlNet-TurboCell-TxRate','TxRate-735k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6645,NULL,'KarlNet-TurboCell-TxRate','TxRate-736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6646,NULL,'KarlNet-TurboCell-TxRate','TxRate-737k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6647,NULL,'KarlNet-TurboCell-TxRate','TxRate-738k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6648,NULL,'KarlNet-TurboCell-TxRate','TxRate-739k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6649,NULL,'KarlNet-TurboCell-TxRate','TxRate-740k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6650,NULL,'KarlNet-TurboCell-TxRate','TxRate-741k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6651,NULL,'KarlNet-TurboCell-TxRate','TxRate-742k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6652,NULL,'KarlNet-TurboCell-TxRate','TxRate-743k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6653,NULL,'KarlNet-TurboCell-TxRate','TxRate-744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6654,NULL,'KarlNet-TurboCell-TxRate','TxRate-745k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6655,NULL,'KarlNet-TurboCell-TxRate','TxRate-746k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6656,NULL,'KarlNet-TurboCell-TxRate','TxRate-747k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6657,NULL,'KarlNet-TurboCell-TxRate','TxRate-748k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6658,NULL,'KarlNet-TurboCell-TxRate','TxRate-749k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6659,NULL,'KarlNet-TurboCell-TxRate','TxRate-750k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6660,NULL,'KarlNet-TurboCell-TxRate','TxRate-751k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6661,NULL,'KarlNet-TurboCell-TxRate','TxRate-752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6662,NULL,'KarlNet-TurboCell-TxRate','TxRate-753k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6663,NULL,'KarlNet-TurboCell-TxRate','TxRate-754k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6664,NULL,'KarlNet-TurboCell-TxRate','TxRate-755k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6665,NULL,'KarlNet-TurboCell-TxRate','TxRate-756k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6666,NULL,'KarlNet-TurboCell-TxRate','TxRate-757k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6667,NULL,'KarlNet-TurboCell-TxRate','TxRate-758k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6668,NULL,'KarlNet-TurboCell-TxRate','TxRate-759k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6669,NULL,'KarlNet-TurboCell-TxRate','TxRate-760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6670,NULL,'KarlNet-TurboCell-TxRate','TxRate-761k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6671,NULL,'KarlNet-TurboCell-TxRate','TxRate-762k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6672,NULL,'KarlNet-TurboCell-TxRate','TxRate-763k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6673,NULL,'KarlNet-TurboCell-TxRate','TxRate-764k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6674,NULL,'KarlNet-TurboCell-TxRate','TxRate-765k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6675,NULL,'KarlNet-TurboCell-TxRate','TxRate-766k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6676,NULL,'KarlNet-TurboCell-TxRate','TxRate-767k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6677,NULL,'KarlNet-TurboCell-TxRate','TxRate-768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6678,NULL,'KarlNet-TurboCell-TxRate','TxRate-769k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6679,NULL,'KarlNet-TurboCell-TxRate','TxRate-770k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6680,NULL,'KarlNet-TurboCell-TxRate','TxRate-771k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6681,NULL,'KarlNet-TurboCell-TxRate','TxRate-772k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6682,NULL,'KarlNet-TurboCell-TxRate','TxRate-773k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6683,NULL,'KarlNet-TurboCell-TxRate','TxRate-774k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6684,NULL,'KarlNet-TurboCell-TxRate','TxRate-775k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6685,NULL,'KarlNet-TurboCell-TxRate','TxRate-776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6686,NULL,'KarlNet-TurboCell-TxRate','TxRate-777k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6687,NULL,'KarlNet-TurboCell-TxRate','TxRate-778k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6688,NULL,'KarlNet-TurboCell-TxRate','TxRate-779k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6689,NULL,'KarlNet-TurboCell-TxRate','TxRate-780k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6690,NULL,'KarlNet-TurboCell-TxRate','TxRate-781k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6691,NULL,'KarlNet-TurboCell-TxRate','TxRate-782k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6692,NULL,'KarlNet-TurboCell-TxRate','TxRate-783k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6693,NULL,'KarlNet-TurboCell-TxRate','TxRate-784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6694,NULL,'KarlNet-TurboCell-TxRate','TxRate-785k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6695,NULL,'KarlNet-TurboCell-TxRate','TxRate-786k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6696,NULL,'KarlNet-TurboCell-TxRate','TxRate-787k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6697,NULL,'KarlNet-TurboCell-TxRate','TxRate-788k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6698,NULL,'KarlNet-TurboCell-TxRate','TxRate-789k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6699,NULL,'KarlNet-TurboCell-TxRate','TxRate-790k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6700,NULL,'KarlNet-TurboCell-TxRate','TxRate-791k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6701,NULL,'KarlNet-TurboCell-TxRate','TxRate-792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6702,NULL,'KarlNet-TurboCell-TxRate','TxRate-793k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6703,NULL,'KarlNet-TurboCell-TxRate','TxRate-794k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6704,NULL,'KarlNet-TurboCell-TxRate','TxRate-795k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6705,NULL,'KarlNet-TurboCell-TxRate','TxRate-796k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6706,NULL,'KarlNet-TurboCell-TxRate','TxRate-797k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6707,NULL,'KarlNet-TurboCell-TxRate','TxRate-798k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6708,NULL,'KarlNet-TurboCell-TxRate','TxRate-799k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6709,NULL,'KarlNet-TurboCell-TxRate','TxRate-800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6710,NULL,'KarlNet-TurboCell-TxRate','TxRate-801k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6711,NULL,'KarlNet-TurboCell-TxRate','TxRate-802k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6712,NULL,'KarlNet-TurboCell-TxRate','TxRate-803k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6713,NULL,'KarlNet-TurboCell-TxRate','TxRate-804k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6714,NULL,'KarlNet-TurboCell-TxRate','TxRate-805k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6715,NULL,'KarlNet-TurboCell-TxRate','TxRate-806k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6716,NULL,'KarlNet-TurboCell-TxRate','TxRate-807k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6717,NULL,'KarlNet-TurboCell-TxRate','TxRate-808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6718,NULL,'KarlNet-TurboCell-TxRate','TxRate-809k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6719,NULL,'KarlNet-TurboCell-TxRate','TxRate-810k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6720,NULL,'KarlNet-TurboCell-TxRate','TxRate-811k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6721,NULL,'KarlNet-TurboCell-TxRate','TxRate-812k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6722,NULL,'KarlNet-TurboCell-TxRate','TxRate-813k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6723,NULL,'KarlNet-TurboCell-TxRate','TxRate-814k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6724,NULL,'KarlNet-TurboCell-TxRate','TxRate-815k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6725,NULL,'KarlNet-TurboCell-TxRate','TxRate-816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6726,NULL,'KarlNet-TurboCell-TxRate','TxRate-817k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6727,NULL,'KarlNet-TurboCell-TxRate','TxRate-818k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6728,NULL,'KarlNet-TurboCell-TxRate','TxRate-819k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6729,NULL,'KarlNet-TurboCell-TxRate','TxRate-820k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6730,NULL,'KarlNet-TurboCell-TxRate','TxRate-821k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6731,NULL,'KarlNet-TurboCell-TxRate','TxRate-822k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6732,NULL,'KarlNet-TurboCell-TxRate','TxRate-823k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6733,NULL,'KarlNet-TurboCell-TxRate','TxRate-824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6734,NULL,'KarlNet-TurboCell-TxRate','TxRate-825k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6735,NULL,'KarlNet-TurboCell-TxRate','TxRate-826k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6736,NULL,'KarlNet-TurboCell-TxRate','TxRate-827k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6737,NULL,'KarlNet-TurboCell-TxRate','TxRate-828k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6738,NULL,'KarlNet-TurboCell-TxRate','TxRate-829k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6739,NULL,'KarlNet-TurboCell-TxRate','TxRate-830k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6740,NULL,'KarlNet-TurboCell-TxRate','TxRate-831k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6741,NULL,'KarlNet-TurboCell-TxRate','TxRate-832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6742,NULL,'KarlNet-TurboCell-TxRate','TxRate-833k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6743,NULL,'KarlNet-TurboCell-TxRate','TxRate-834k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6744,NULL,'KarlNet-TurboCell-TxRate','TxRate-835k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6745,NULL,'KarlNet-TurboCell-TxRate','TxRate-836k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6746,NULL,'KarlNet-TurboCell-TxRate','TxRate-837k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6747,NULL,'KarlNet-TurboCell-TxRate','TxRate-838k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6748,NULL,'KarlNet-TurboCell-TxRate','TxRate-839k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6749,NULL,'KarlNet-TurboCell-TxRate','TxRate-840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6750,NULL,'KarlNet-TurboCell-TxRate','TxRate-841k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6751,NULL,'KarlNet-TurboCell-TxRate','TxRate-842k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6752,NULL,'KarlNet-TurboCell-TxRate','TxRate-843k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6753,NULL,'KarlNet-TurboCell-TxRate','TxRate-844k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6754,NULL,'KarlNet-TurboCell-TxRate','TxRate-845k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6755,NULL,'KarlNet-TurboCell-TxRate','TxRate-846k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6756,NULL,'KarlNet-TurboCell-TxRate','TxRate-847k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6757,NULL,'KarlNet-TurboCell-TxRate','TxRate-848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6758,NULL,'KarlNet-TurboCell-TxRate','TxRate-849k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6759,NULL,'KarlNet-TurboCell-TxRate','TxRate-850k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6760,NULL,'KarlNet-TurboCell-TxRate','TxRate-851k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6761,NULL,'KarlNet-TurboCell-TxRate','TxRate-852k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6762,NULL,'KarlNet-TurboCell-TxRate','TxRate-853k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6763,NULL,'KarlNet-TurboCell-TxRate','TxRate-854k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6764,NULL,'KarlNet-TurboCell-TxRate','TxRate-855k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6765,NULL,'KarlNet-TurboCell-TxRate','TxRate-856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6766,NULL,'KarlNet-TurboCell-TxRate','TxRate-857k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6767,NULL,'KarlNet-TurboCell-TxRate','TxRate-858k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6768,NULL,'KarlNet-TurboCell-TxRate','TxRate-859k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6769,NULL,'KarlNet-TurboCell-TxRate','TxRate-860k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6770,NULL,'KarlNet-TurboCell-TxRate','TxRate-861k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6771,NULL,'KarlNet-TurboCell-TxRate','TxRate-862k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6772,NULL,'KarlNet-TurboCell-TxRate','TxRate-863k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6773,NULL,'KarlNet-TurboCell-TxRate','TxRate-864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6774,NULL,'KarlNet-TurboCell-TxRate','TxRate-865k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6775,NULL,'KarlNet-TurboCell-TxRate','TxRate-866k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6776,NULL,'KarlNet-TurboCell-TxRate','TxRate-867k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6777,NULL,'KarlNet-TurboCell-TxRate','TxRate-868k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6778,NULL,'KarlNet-TurboCell-TxRate','TxRate-869k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6779,NULL,'KarlNet-TurboCell-TxRate','TxRate-870k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6780,NULL,'KarlNet-TurboCell-TxRate','TxRate-871k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6781,NULL,'KarlNet-TurboCell-TxRate','TxRate-872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6782,NULL,'KarlNet-TurboCell-TxRate','TxRate-873k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6783,NULL,'KarlNet-TurboCell-TxRate','TxRate-874k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6784,NULL,'KarlNet-TurboCell-TxRate','TxRate-875k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6785,NULL,'KarlNet-TurboCell-TxRate','TxRate-876k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6786,NULL,'KarlNet-TurboCell-TxRate','TxRate-877k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6787,NULL,'KarlNet-TurboCell-TxRate','TxRate-878k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6788,NULL,'KarlNet-TurboCell-TxRate','TxRate-879k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6789,NULL,'KarlNet-TurboCell-TxRate','TxRate-880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6790,NULL,'KarlNet-TurboCell-TxRate','TxRate-881k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6791,NULL,'KarlNet-TurboCell-TxRate','TxRate-882k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6792,NULL,'KarlNet-TurboCell-TxRate','TxRate-883k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6793,NULL,'KarlNet-TurboCell-TxRate','TxRate-884k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6794,NULL,'KarlNet-TurboCell-TxRate','TxRate-885k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6795,NULL,'KarlNet-TurboCell-TxRate','TxRate-886k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6796,NULL,'KarlNet-TurboCell-TxRate','TxRate-887k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6797,NULL,'KarlNet-TurboCell-TxRate','TxRate-888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6798,NULL,'KarlNet-TurboCell-TxRate','TxRate-889k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6799,NULL,'KarlNet-TurboCell-TxRate','TxRate-890k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6800,NULL,'KarlNet-TurboCell-TxRate','TxRate-891k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6801,NULL,'KarlNet-TurboCell-TxRate','TxRate-892k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6802,NULL,'KarlNet-TurboCell-TxRate','TxRate-893k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6803,NULL,'KarlNet-TurboCell-TxRate','TxRate-894k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6804,NULL,'KarlNet-TurboCell-TxRate','TxRate-895k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6805,NULL,'KarlNet-TurboCell-TxRate','TxRate-896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6806,NULL,'KarlNet-TurboCell-TxRate','TxRate-897k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6807,NULL,'KarlNet-TurboCell-TxRate','TxRate-898k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6808,NULL,'KarlNet-TurboCell-TxRate','TxRate-899k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6809,NULL,'KarlNet-TurboCell-TxRate','TxRate-900k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6810,NULL,'KarlNet-TurboCell-TxRate','TxRate-901k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6811,NULL,'KarlNet-TurboCell-TxRate','TxRate-902k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6812,NULL,'KarlNet-TurboCell-TxRate','TxRate-903k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6813,NULL,'KarlNet-TurboCell-TxRate','TxRate-904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6814,NULL,'KarlNet-TurboCell-TxRate','TxRate-905k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6815,NULL,'KarlNet-TurboCell-TxRate','TxRate-906k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6816,NULL,'KarlNet-TurboCell-TxRate','TxRate-907k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6817,NULL,'KarlNet-TurboCell-TxRate','TxRate-908k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6818,NULL,'KarlNet-TurboCell-TxRate','TxRate-909k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6819,NULL,'KarlNet-TurboCell-TxRate','TxRate-910k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6820,NULL,'KarlNet-TurboCell-TxRate','TxRate-911k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6821,NULL,'KarlNet-TurboCell-TxRate','TxRate-912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6822,NULL,'KarlNet-TurboCell-TxRate','TxRate-913k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6823,NULL,'KarlNet-TurboCell-TxRate','TxRate-914k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6824,NULL,'KarlNet-TurboCell-TxRate','TxRate-915k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6825,NULL,'KarlNet-TurboCell-TxRate','TxRate-916k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6826,NULL,'KarlNet-TurboCell-TxRate','TxRate-917k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6827,NULL,'KarlNet-TurboCell-TxRate','TxRate-918k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6828,NULL,'KarlNet-TurboCell-TxRate','TxRate-919k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6829,NULL,'KarlNet-TurboCell-TxRate','TxRate-920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6830,NULL,'KarlNet-TurboCell-TxRate','TxRate-921k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6831,NULL,'KarlNet-TurboCell-TxRate','TxRate-922k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6832,NULL,'KarlNet-TurboCell-TxRate','TxRate-923k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6833,NULL,'KarlNet-TurboCell-TxRate','TxRate-924k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6834,NULL,'KarlNet-TurboCell-TxRate','TxRate-925k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6835,NULL,'KarlNet-TurboCell-TxRate','TxRate-926k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6836,NULL,'KarlNet-TurboCell-TxRate','TxRate-927k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6837,NULL,'KarlNet-TurboCell-TxRate','TxRate-928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6838,NULL,'KarlNet-TurboCell-TxRate','TxRate-929k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6839,NULL,'KarlNet-TurboCell-TxRate','TxRate-930k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6840,NULL,'KarlNet-TurboCell-TxRate','TxRate-931k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6841,NULL,'KarlNet-TurboCell-TxRate','TxRate-932k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6842,NULL,'KarlNet-TurboCell-TxRate','TxRate-933k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6843,NULL,'KarlNet-TurboCell-TxRate','TxRate-934k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6844,NULL,'KarlNet-TurboCell-TxRate','TxRate-935k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6845,NULL,'KarlNet-TurboCell-TxRate','TxRate-936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6846,NULL,'KarlNet-TurboCell-TxRate','TxRate-937k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6847,NULL,'KarlNet-TurboCell-TxRate','TxRate-938k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6848,NULL,'KarlNet-TurboCell-TxRate','TxRate-939k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6849,NULL,'KarlNet-TurboCell-TxRate','TxRate-940k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6850,NULL,'KarlNet-TurboCell-TxRate','TxRate-941k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6851,NULL,'KarlNet-TurboCell-TxRate','TxRate-942k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6852,NULL,'KarlNet-TurboCell-TxRate','TxRate-943k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6853,NULL,'KarlNet-TurboCell-TxRate','TxRate-944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6854,NULL,'KarlNet-TurboCell-TxRate','TxRate-945k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6855,NULL,'KarlNet-TurboCell-TxRate','TxRate-946k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6856,NULL,'KarlNet-TurboCell-TxRate','TxRate-947k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6857,NULL,'KarlNet-TurboCell-TxRate','TxRate-948k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6858,NULL,'KarlNet-TurboCell-TxRate','TxRate-949k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6859,NULL,'KarlNet-TurboCell-TxRate','TxRate-950k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6860,NULL,'KarlNet-TurboCell-TxRate','TxRate-951k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6861,NULL,'KarlNet-TurboCell-TxRate','TxRate-952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6862,NULL,'KarlNet-TurboCell-TxRate','TxRate-953k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6863,NULL,'KarlNet-TurboCell-TxRate','TxRate-954k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6864,NULL,'KarlNet-TurboCell-TxRate','TxRate-955k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6865,NULL,'KarlNet-TurboCell-TxRate','TxRate-956k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6866,NULL,'KarlNet-TurboCell-TxRate','TxRate-957k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6867,NULL,'KarlNet-TurboCell-TxRate','TxRate-958k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6868,NULL,'KarlNet-TurboCell-TxRate','TxRate-959k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6869,NULL,'KarlNet-TurboCell-TxRate','TxRate-960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6870,NULL,'KarlNet-TurboCell-TxRate','TxRate-961k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6871,NULL,'KarlNet-TurboCell-TxRate','TxRate-962k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6872,NULL,'KarlNet-TurboCell-TxRate','TxRate-963k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6873,NULL,'KarlNet-TurboCell-TxRate','TxRate-964k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6874,NULL,'KarlNet-TurboCell-TxRate','TxRate-965k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6875,NULL,'KarlNet-TurboCell-TxRate','TxRate-966k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6876,NULL,'KarlNet-TurboCell-TxRate','TxRate-967k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6877,NULL,'KarlNet-TurboCell-TxRate','TxRate-968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6878,NULL,'KarlNet-TurboCell-TxRate','TxRate-969k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6879,NULL,'KarlNet-TurboCell-TxRate','TxRate-970k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6880,NULL,'KarlNet-TurboCell-TxRate','TxRate-971k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6881,NULL,'KarlNet-TurboCell-TxRate','TxRate-972k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6882,NULL,'KarlNet-TurboCell-TxRate','TxRate-973k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6883,NULL,'KarlNet-TurboCell-TxRate','TxRate-974k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6884,NULL,'KarlNet-TurboCell-TxRate','TxRate-975k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6885,NULL,'KarlNet-TurboCell-TxRate','TxRate-976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6886,NULL,'KarlNet-TurboCell-TxRate','TxRate-977k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6887,NULL,'KarlNet-TurboCell-TxRate','TxRate-978k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6888,NULL,'KarlNet-TurboCell-TxRate','TxRate-979k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6889,NULL,'KarlNet-TurboCell-TxRate','TxRate-980k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6890,NULL,'KarlNet-TurboCell-TxRate','TxRate-981k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6891,NULL,'KarlNet-TurboCell-TxRate','TxRate-982k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6892,NULL,'KarlNet-TurboCell-TxRate','TxRate-983k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6893,NULL,'KarlNet-TurboCell-TxRate','TxRate-984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6894,NULL,'KarlNet-TurboCell-TxRate','TxRate-985k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6895,NULL,'KarlNet-TurboCell-TxRate','TxRate-986k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6896,NULL,'KarlNet-TurboCell-TxRate','TxRate-987k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6897,NULL,'KarlNet-TurboCell-TxRate','TxRate-988k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6898,NULL,'KarlNet-TurboCell-TxRate','TxRate-989k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6899,NULL,'KarlNet-TurboCell-TxRate','TxRate-990k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6900,NULL,'KarlNet-TurboCell-TxRate','TxRate-991k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6901,NULL,'KarlNet-TurboCell-TxRate','TxRate-992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6902,NULL,'KarlNet-TurboCell-TxRate','TxRate-993k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6903,NULL,'KarlNet-TurboCell-TxRate','TxRate-994k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6904,NULL,'KarlNet-TurboCell-TxRate','TxRate-995k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6905,NULL,'KarlNet-TurboCell-TxRate','TxRate-996k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6906,NULL,'KarlNet-TurboCell-TxRate','TxRate-997k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6907,NULL,'KarlNet-TurboCell-TxRate','TxRate-998k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6908,NULL,'KarlNet-TurboCell-TxRate','TxRate-999k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6909,NULL,'KarlNet-TurboCell-TxRate','TxRate-1000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6910,NULL,'KarlNet-TurboCell-TxRate','TxRate-1001k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6911,NULL,'KarlNet-TurboCell-TxRate','TxRate-1002k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6912,NULL,'KarlNet-TurboCell-TxRate','TxRate-1003k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6913,NULL,'KarlNet-TurboCell-TxRate','TxRate-1004k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6914,NULL,'KarlNet-TurboCell-TxRate','TxRate-1005k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6915,NULL,'KarlNet-TurboCell-TxRate','TxRate-1006k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6916,NULL,'KarlNet-TurboCell-TxRate','TxRate-1007k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6917,NULL,'KarlNet-TurboCell-TxRate','TxRate-1008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6918,NULL,'KarlNet-TurboCell-TxRate','TxRate-1009k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6919,NULL,'KarlNet-TurboCell-TxRate','TxRate-1010k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6920,NULL,'KarlNet-TurboCell-TxRate','TxRate-1011k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6921,NULL,'KarlNet-TurboCell-TxRate','TxRate-1012k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6922,NULL,'KarlNet-TurboCell-TxRate','TxRate-1013k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6923,NULL,'KarlNet-TurboCell-TxRate','TxRate-1014k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6924,NULL,'KarlNet-TurboCell-TxRate','TxRate-1015k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6925,NULL,'KarlNet-TurboCell-TxRate','TxRate-1016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6926,NULL,'KarlNet-TurboCell-TxRate','TxRate-1017k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6927,NULL,'KarlNet-TurboCell-TxRate','TxRate-1018k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6928,NULL,'KarlNet-TurboCell-TxRate','TxRate-1019k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6929,NULL,'KarlNet-TurboCell-TxRate','TxRate-1020k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6930,NULL,'KarlNet-TurboCell-TxRate','TxRate-1021k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6931,NULL,'KarlNet-TurboCell-TxRate','TxRate-1022k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6932,NULL,'KarlNet-TurboCell-TxRate','TxRate-1023k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6933,NULL,'KarlNet-TurboCell-TxRate','TxRate-1024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6934,NULL,'KarlNet-TurboCell-TxRate','TxRate-1152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6935,NULL,'KarlNet-TurboCell-TxRate','TxRate-1280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6936,NULL,'KarlNet-TurboCell-TxRate','TxRate-1408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6937,NULL,'KarlNet-TurboCell-TxRate','TxRate-1536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6938,NULL,'KarlNet-TurboCell-TxRate','TxRate-1664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6939,NULL,'KarlNet-TurboCell-TxRate','TxRate-1792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6940,NULL,'KarlNet-TurboCell-TxRate','TxRate-1920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6941,NULL,'KarlNet-TurboCell-TxRate','TxRate-2048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6942,NULL,'KarlNet-TurboCell-TxRate','TxRate-2176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6943,NULL,'KarlNet-TurboCell-TxRate','TxRate-2304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6944,NULL,'KarlNet-TurboCell-TxRate','TxRate-2432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6945,NULL,'KarlNet-TurboCell-TxRate','TxRate-2560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6946,NULL,'KarlNet-TurboCell-TxRate','TxRate-2688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6947,NULL,'KarlNet-TurboCell-TxRate','TxRate-2816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6948,NULL,'KarlNet-TurboCell-TxRate','TxRate-2944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6949,NULL,'KarlNet-TurboCell-TxRate','TxRate-3072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6950,NULL,'KarlNet-TurboCell-TxRate','TxRate-3200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6951,NULL,'KarlNet-TurboCell-TxRate','TxRate-3328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6952,NULL,'KarlNet-TurboCell-TxRate','TxRate-3456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6953,NULL,'KarlNet-TurboCell-TxRate','TxRate-3584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6954,NULL,'KarlNet-TurboCell-TxRate','TxRate-3712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6955,NULL,'KarlNet-TurboCell-TxRate','TxRate-3840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6956,NULL,'KarlNet-TurboCell-TxRate','TxRate-3968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6957,NULL,'KarlNet-TurboCell-TxRate','TxRate-4096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6958,NULL,'KarlNet-TurboCell-TxRate','TxRate-4224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6959,NULL,'KarlNet-TurboCell-TxRate','TxRate-4352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6960,NULL,'KarlNet-TurboCell-TxRate','TxRate-4480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6961,NULL,'KarlNet-TurboCell-TxRate','TxRate-4608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6962,NULL,'KarlNet-TurboCell-TxRate','TxRate-4736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6963,NULL,'KarlNet-TurboCell-TxRate','TxRate-4864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6964,NULL,'KarlNet-TurboCell-TxRate','TxRate-4992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6965,NULL,'KarlNet-TurboCell-TxRate','TxRate-5120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6966,NULL,'KarlNet-TurboCell-TxRate','TxRate-5248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6967,NULL,'KarlNet-TurboCell-TxRate','TxRate-5376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6968,NULL,'KarlNet-TurboCell-TxRate','TxRate-5504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6969,NULL,'KarlNet-TurboCell-TxRate','TxRate-5632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6970,NULL,'KarlNet-TurboCell-TxRate','TxRate-5760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6971,NULL,'KarlNet-TurboCell-TxRate','TxRate-5888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6972,NULL,'KarlNet-TurboCell-TxRate','TxRate-6016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6973,NULL,'KarlNet-TurboCell-TxRate','TxRate-6144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6974,NULL,'KarlNet-TurboCell-TxRate','TxRate-6272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6975,NULL,'KarlNet-TurboCell-TxRate','TxRate-6400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6976,NULL,'KarlNet-TurboCell-TxRate','TxRate-6528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6977,NULL,'KarlNet-TurboCell-TxRate','TxRate-6656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6978,NULL,'KarlNet-TurboCell-TxRate','TxRate-6784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6979,NULL,'KarlNet-TurboCell-TxRate','TxRate-6912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6980,NULL,'KarlNet-TurboCell-TxRate','TxRate-7040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6981,NULL,'KarlNet-TurboCell-TxRate','TxRate-7168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6982,NULL,'KarlNet-TurboCell-TxRate','TxRate-7296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6983,NULL,'KarlNet-TurboCell-TxRate','TxRate-7424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6984,NULL,'KarlNet-TurboCell-TxRate','TxRate-7552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6985,NULL,'KarlNet-TurboCell-TxRate','TxRate-7680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6986,NULL,'KarlNet-TurboCell-TxRate','TxRate-7808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6987,NULL,'KarlNet-TurboCell-TxRate','TxRate-7936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6988,NULL,'KarlNet-TurboCell-TxRate','TxRate-8064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6989,NULL,'KarlNet-TurboCell-TxRate','TxRate-8192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6990,NULL,'KarlNet-TurboCell-TxRate','TxRate-8320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6991,NULL,'KarlNet-TurboCell-TxRate','TxRate-8448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6992,NULL,'KarlNet-TurboCell-TxRate','TxRate-8576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6993,NULL,'KarlNet-TurboCell-TxRate','TxRate-8704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6994,NULL,'KarlNet-TurboCell-TxRate','TxRate-8832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6995,NULL,'KarlNet-TurboCell-TxRate','TxRate-8960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6996,NULL,'KarlNet-TurboCell-TxRate','TxRate-9088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6997,NULL,'KarlNet-TurboCell-TxRate','TxRate-9216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6998,NULL,'KarlNet-TurboCell-TxRate','TxRate-9344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (6999,NULL,'KarlNet-TurboCell-TxRate','TxRate-9472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7000,NULL,'KarlNet-TurboCell-TxRate','TxRate-9600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7001,NULL,'KarlNet-TurboCell-TxRate','TxRate-9728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7002,NULL,'KarlNet-TurboCell-TxRate','TxRate-9856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7003,NULL,'KarlNet-TurboCell-TxRate','TxRate-9984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7004,NULL,'KarlNet-TurboCell-TxRate','TxRate-10112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7005,NULL,'KarlNet-TurboCell-TxRate','TxRate-10240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7006,NULL,'KarlNet-TurboCell-TxRate','TxRate-10368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7007,NULL,'KarlNet-TurboCell-TxRate','TxRate-10496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7008,NULL,'KarlNet-TurboCell-TxRate','TxRate-10624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7009,NULL,'KarlNet-TurboCell-TxRate','TxRate-10752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7010,NULL,'KarlNet-TurboCell-TxRate','TxRate-10880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7011,NULL,'KarlNet-TurboCell-TxRate','TxRate-11008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7012,NULL,'KarlNet-TurboCell-TxRate','TxRate-11136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7013,NULL,'KarlNet-TurboCell-TxRate','TxRate-11264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7014,NULL,'KarlNet-TurboCell-TxRate','TxRate-11392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7015,NULL,'KarlNet-TurboCell-TxRate','TxRate-11520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7016,NULL,'KarlNet-TurboCell-TxRate','TxRate-11648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7017,NULL,'KarlNet-TurboCell-TxRate','TxRate-11776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7018,NULL,'KarlNet-TurboCell-TxRate','TxRate-11904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7019,NULL,'KarlNet-TurboCell-TxRate','TxRate-12032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7020,NULL,'KarlNet-TurboCell-TxRate','TxRate-12160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7021,NULL,'KarlNet-TurboCell-TxRate','TxRate-12288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7022,NULL,'KarlNet-TurboCell-TxRate','TxRate-12416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7023,NULL,'KarlNet-TurboCell-TxRate','TxRate-12544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7024,NULL,'KarlNet-TurboCell-TxRate','TxRate-12672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7025,NULL,'KarlNet-TurboCell-TxRate','TxRate-12800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7026,NULL,'KarlNet-TurboCell-TxRate','TxRate-12928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7027,NULL,'KarlNet-TurboCell-TxRate','TxRate-13056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7028,NULL,'KarlNet-TurboCell-TxRate','TxRate-13184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7029,NULL,'KarlNet-TurboCell-TxRate','TxRate-13312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7030,NULL,'KarlNet-TurboCell-TxRate','TxRate-13440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7031,NULL,'KarlNet-TurboCell-TxRate','TxRate-13568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7032,NULL,'KarlNet-TurboCell-TxRate','TxRate-13696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7033,NULL,'KarlNet-TurboCell-TxRate','TxRate-13824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7034,NULL,'KarlNet-TurboCell-TxRate','TxRate-13952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7035,NULL,'KarlNet-TurboCell-TxRate','TxRate-14080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7036,NULL,'KarlNet-TurboCell-TxRate','TxRate-14208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7037,NULL,'KarlNet-TurboCell-TxRate','TxRate-14336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7038,NULL,'KarlNet-TurboCell-TxRate','TxRate-14464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7039,NULL,'KarlNet-TurboCell-TxRate','TxRate-14592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7040,NULL,'KarlNet-TurboCell-TxRate','TxRate-14720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7041,NULL,'KarlNet-TurboCell-TxRate','TxRate-14848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7042,NULL,'KarlNet-TurboCell-TxRate','TxRate-14976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7043,NULL,'KarlNet-TurboCell-TxRate','TxRate-15104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7044,NULL,'KarlNet-TurboCell-TxRate','TxRate-15232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7045,NULL,'KarlNet-TurboCell-TxRate','TxRate-15360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7046,NULL,'KarlNet-TurboCell-TxRate','TxRate-15488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7047,NULL,'KarlNet-TurboCell-TxRate','TxRate-15616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7048,NULL,'KarlNet-TurboCell-TxRate','TxRate-15744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7049,NULL,'KarlNet-TurboCell-TxRate','TxRate-15872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7050,NULL,'KarlNet-TurboCell-TxRate','TxRate-16000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7051,NULL,'KarlNet-TurboCell-TxRate','TxRate-16128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7052,NULL,'KarlNet-TurboCell-TxRate','TxRate-16256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7053,NULL,'KarlNet-TurboCell-TxRate','TxRate-16384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7054,NULL,'KarlNet-TurboCell-TxRate','TxRate-16512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7055,NULL,'KarlNet-TurboCell-TxRate','TxRate-16640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7056,NULL,'KarlNet-TurboCell-TxRate','TxRate-16768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7057,NULL,'KarlNet-TurboCell-TxRate','TxRate-16896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7058,NULL,'KarlNet-TurboCell-TxRate','TxRate-17024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7059,NULL,'KarlNet-TurboCell-TxRate','TxRate-17152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7060,NULL,'KarlNet-TurboCell-TxRate','TxRate-17280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7061,NULL,'KarlNet-TurboCell-TxRate','TxRate-17408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7062,NULL,'KarlNet-TurboCell-TxRate','TxRate-17536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7063,NULL,'KarlNet-TurboCell-TxRate','TxRate-17664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7064,NULL,'KarlNet-TurboCell-TxRate','TxRate-17792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7065,NULL,'KarlNet-TurboCell-TxRate','TxRate-17920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7066,NULL,'KarlNet-TurboCell-TxRate','TxRate-18048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7067,NULL,'KarlNet-TurboCell-TxRate','TxRate-18176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7068,NULL,'KarlNet-TurboCell-TxRate','TxRate-18304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7069,NULL,'KarlNet-TurboCell-TxRate','TxRate-18432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7070,NULL,'KarlNet-TurboCell-TxRate','TxRate-18560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7071,NULL,'KarlNet-TurboCell-TxRate','TxRate-18688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7072,NULL,'KarlNet-TurboCell-TxRate','TxRate-18816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7073,NULL,'KarlNet-TurboCell-TxRate','TxRate-18944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7074,NULL,'KarlNet-TurboCell-TxRate','TxRate-19072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7075,NULL,'KarlNet-TurboCell-TxRate','TxRate-19200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7076,NULL,'KarlNet-TurboCell-TxRate','TxRate-19328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7077,NULL,'KarlNet-TurboCell-TxRate','TxRate-19456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7078,NULL,'KarlNet-TurboCell-TxRate','TxRate-19584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7079,NULL,'KarlNet-TurboCell-TxRate','TxRate-19712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7080,NULL,'KarlNet-TurboCell-TxRate','TxRate-19840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7081,NULL,'KarlNet-TurboCell-TxRate','TxRate-19968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7082,NULL,'KarlNet-TurboCell-TxRate','TxRate-20096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7083,NULL,'KarlNet-TurboCell-TxRate','TxRate-20224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7084,NULL,'KarlNet-TurboCell-TxRate','TxRate-20352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7085,NULL,'KarlNet-TurboCell-TxRate','TxRate-20480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7086,NULL,'KarlNet-TurboCell-TxRate','TxRate-20608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7087,NULL,'KarlNet-TurboCell-TxRate','TxRate-20736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7088,NULL,'KarlNet-TurboCell-TxRate','TxRate-20864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7089,NULL,'KarlNet-TurboCell-TxRate','TxRate-20992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7090,NULL,'KarlNet-TurboCell-TxRate','TxRate-21120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7091,NULL,'KarlNet-TurboCell-TxRate','TxRate-21248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7092,NULL,'KarlNet-TurboCell-TxRate','TxRate-21376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7093,NULL,'KarlNet-TurboCell-TxRate','TxRate-21504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7094,NULL,'KarlNet-TurboCell-TxRate','TxRate-21632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7095,NULL,'KarlNet-TurboCell-TxRate','TxRate-21760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7096,NULL,'KarlNet-TurboCell-TxRate','TxRate-21888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7097,NULL,'KarlNet-TurboCell-TxRate','TxRate-22016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7098,NULL,'KarlNet-TurboCell-TxRate','TxRate-22144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7099,NULL,'KarlNet-TurboCell-TxRate','TxRate-22272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7100,NULL,'KarlNet-TurboCell-TxRate','TxRate-22400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7101,NULL,'KarlNet-TurboCell-TxRate','TxRate-22528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7102,NULL,'KarlNet-TurboCell-TxRate','TxRate-22656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7103,NULL,'KarlNet-TurboCell-TxRate','TxRate-22784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7104,NULL,'KarlNet-TurboCell-TxRate','TxRate-22912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7105,NULL,'KarlNet-TurboCell-TxRate','TxRate-23040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7106,NULL,'KarlNet-TurboCell-TxRate','TxRate-23168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7107,NULL,'KarlNet-TurboCell-TxRate','TxRate-23296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7108,NULL,'KarlNet-TurboCell-TxRate','TxRate-23424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7109,NULL,'KarlNet-TurboCell-TxRate','TxRate-23552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7110,NULL,'KarlNet-TurboCell-TxRate','TxRate-23680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7111,NULL,'KarlNet-TurboCell-TxRate','TxRate-23808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7112,NULL,'KarlNet-TurboCell-TxRate','TxRate-23936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7113,NULL,'KarlNet-TurboCell-TxRate','TxRate-24064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7114,NULL,'KarlNet-TurboCell-TxRate','TxRate-24192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7115,NULL,'KarlNet-TurboCell-TxRate','TxRate-24320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7116,NULL,'KarlNet-TurboCell-TxRate','TxRate-24448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7117,NULL,'KarlNet-TurboCell-TxRate','TxRate-24576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7118,NULL,'KarlNet-TurboCell-TxRate','TxRate-24704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7119,NULL,'KarlNet-TurboCell-TxRate','TxRate-24832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7120,NULL,'KarlNet-TurboCell-TxRate','TxRate-24960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7121,NULL,'KarlNet-TurboCell-TxRate','TxRate-25088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7122,NULL,'KarlNet-TurboCell-TxRate','TxRate-25216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7123,NULL,'KarlNet-TurboCell-TxRate','TxRate-25344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7124,NULL,'KarlNet-TurboCell-TxRate','TxRate-25472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7125,NULL,'KarlNet-TurboCell-TxRate','TxRate-25600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7126,NULL,'KarlNet-TurboCell-TxRate','TxRate-25728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7127,NULL,'KarlNet-TurboCell-TxRate','TxRate-25856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7128,NULL,'KarlNet-TurboCell-TxRate','TxRate-25984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7129,NULL,'KarlNet-TurboCell-TxRate','TxRate-26112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7130,NULL,'KarlNet-TurboCell-TxRate','TxRate-26240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7131,NULL,'KarlNet-TurboCell-TxRate','TxRate-26368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7132,NULL,'KarlNet-TurboCell-TxRate','TxRate-26496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7133,NULL,'KarlNet-TurboCell-TxRate','TxRate-26624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7134,NULL,'KarlNet-TurboCell-TxRate','TxRate-26752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7135,NULL,'KarlNet-TurboCell-TxRate','TxRate-26880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7136,NULL,'KarlNet-TurboCell-TxRate','TxRate-27008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7137,NULL,'KarlNet-TurboCell-TxRate','TxRate-27136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7138,NULL,'KarlNet-TurboCell-TxRate','TxRate-27264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7139,NULL,'KarlNet-TurboCell-TxRate','TxRate-27392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7140,NULL,'KarlNet-TurboCell-TxRate','TxRate-27520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7141,NULL,'KarlNet-TurboCell-TxRate','TxRate-27648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7142,NULL,'KarlNet-TurboCell-TxRate','TxRate-27776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7143,NULL,'KarlNet-TurboCell-TxRate','TxRate-27904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7144,NULL,'KarlNet-TurboCell-TxRate','TxRate-28032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7145,NULL,'KarlNet-TurboCell-TxRate','TxRate-28160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7146,NULL,'KarlNet-TurboCell-TxRate','TxRate-28288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7147,NULL,'KarlNet-TurboCell-TxRate','TxRate-28416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7148,NULL,'KarlNet-TurboCell-TxRate','TxRate-28544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7149,NULL,'KarlNet-TurboCell-TxRate','TxRate-28672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7150,NULL,'KarlNet-TurboCell-TxRate','TxRate-28800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7151,NULL,'KarlNet-TurboCell-TxRate','TxRate-28928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7152,NULL,'KarlNet-TurboCell-TxRate','TxRate-29056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7153,NULL,'KarlNet-TurboCell-TxRate','TxRate-29184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7154,NULL,'KarlNet-TurboCell-TxRate','TxRate-29312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7155,NULL,'KarlNet-TurboCell-TxRate','TxRate-29440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7156,NULL,'KarlNet-TurboCell-TxRate','TxRate-29568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7157,NULL,'KarlNet-TurboCell-TxRate','TxRate-29696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7158,NULL,'KarlNet-TurboCell-TxRate','TxRate-29824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7159,NULL,'KarlNet-TurboCell-TxRate','TxRate-29952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7160,NULL,'KarlNet-TurboCell-TxRate','TxRate-30080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7161,NULL,'KarlNet-TurboCell-TxRate','TxRate-30208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7162,NULL,'KarlNet-TurboCell-TxRate','TxRate-30336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7163,NULL,'KarlNet-TurboCell-TxRate','TxRate-30464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7164,NULL,'KarlNet-TurboCell-TxRate','TxRate-30592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7165,NULL,'KarlNet-TurboCell-TxRate','TxRate-30720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7166,NULL,'KarlNet-TurboCell-TxRate','TxRate-30848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7167,NULL,'KarlNet-TurboCell-TxRate','TxRate-30976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7168,NULL,'KarlNet-TurboCell-TxRate','TxRate-31104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7169,NULL,'KarlNet-TurboCell-TxRate','TxRate-31232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7170,NULL,'KarlNet-TurboCell-TxRate','TxRate-31360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7171,NULL,'KarlNet-TurboCell-TxRate','TxRate-31488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7172,NULL,'KarlNet-TurboCell-TxRate','TxRate-31616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7173,NULL,'KarlNet-TurboCell-TxRate','TxRate-31744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7174,NULL,'KarlNet-TurboCell-TxRate','TxRate-31872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7175,NULL,'KarlNet-TurboCell-TxRate','TxRate-32000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7176,NULL,'KarlNet-TurboCell-TxRate','TxRate-32128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7177,NULL,'KarlNet-TurboCell-TxRate','TxRate-32256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7178,NULL,'KarlNet-TurboCell-TxRate','TxRate-32384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7179,NULL,'KarlNet-TurboCell-TxRate','TxRate-32512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7180,NULL,'KarlNet-TurboCell-TxRate','TxRate-32640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7181,NULL,'KarlNet-TurboCell-TxRate','TxRate-32768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7182,NULL,'KarlNet-TurboCell-TxRate','TxRate-32896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7183,NULL,'KarlNet-TurboCell-TxRate','TxRate-33024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7184,NULL,'KarlNet-TurboCell-TxRate','TxRate-33152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7185,NULL,'KarlNet-TurboCell-TxRate','TxRate-33280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7186,NULL,'KarlNet-TurboCell-TxRate','TxRate-33408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7187,NULL,'KarlNet-TurboCell-TxRate','TxRate-33536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7188,NULL,'KarlNet-TurboCell-TxRate','TxRate-33664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7189,NULL,'KarlNet-TurboCell-TxRate','TxRate-33792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7190,NULL,'KarlNet-TurboCell-TxRate','TxRate-33920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7191,NULL,'KarlNet-TurboCell-TxRate','TxRate-34048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7192,NULL,'KarlNet-TurboCell-TxRate','TxRate-34176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7193,NULL,'KarlNet-TurboCell-TxRate','TxRate-34304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7194,NULL,'KarlNet-TurboCell-TxRate','TxRate-34432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7195,NULL,'KarlNet-TurboCell-TxRate','TxRate-34560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7196,NULL,'KarlNet-TurboCell-TxRate','TxRate-34688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7197,NULL,'KarlNet-TurboCell-TxRate','TxRate-34816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7198,NULL,'KarlNet-TurboCell-TxRate','TxRate-34944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7199,NULL,'KarlNet-TurboCell-TxRate','TxRate-35072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7200,NULL,'KarlNet-TurboCell-TxRate','TxRate-35200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7201,NULL,'KarlNet-TurboCell-TxRate','TxRate-35328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7202,NULL,'KarlNet-TurboCell-TxRate','TxRate-35456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7203,NULL,'KarlNet-TurboCell-TxRate','TxRate-35584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7204,NULL,'KarlNet-TurboCell-TxRate','TxRate-35712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7205,NULL,'KarlNet-TurboCell-TxRate','TxRate-35840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7206,NULL,'KarlNet-TurboCell-TxRate','TxRate-35968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7207,NULL,'KarlNet-TurboCell-TxRate','TxRate-36096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7208,NULL,'KarlNet-TurboCell-TxRate','TxRate-36224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7209,NULL,'KarlNet-TurboCell-TxRate','TxRate-36352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7210,NULL,'KarlNet-TurboCell-TxRate','TxRate-36480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7211,NULL,'KarlNet-TurboCell-TxRate','TxRate-36608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7212,NULL,'KarlNet-TurboCell-TxRate','TxRate-36736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7213,NULL,'KarlNet-TurboCell-TxRate','TxRate-36864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7214,NULL,'KarlNet-TurboCell-TxRate','TxRate-36992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7215,NULL,'KarlNet-TurboCell-TxRate','TxRate-37120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7216,NULL,'KarlNet-TurboCell-TxRate','TxRate-37248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7217,NULL,'KarlNet-TurboCell-TxRate','TxRate-37376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7218,NULL,'KarlNet-TurboCell-TxRate','TxRate-37504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7219,NULL,'KarlNet-TurboCell-TxRate','TxRate-37632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7220,NULL,'KarlNet-TurboCell-TxRate','TxRate-37760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7221,NULL,'KarlNet-TurboCell-TxRate','TxRate-37888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7222,NULL,'KarlNet-TurboCell-TxRate','TxRate-38016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7223,NULL,'KarlNet-TurboCell-TxRate','TxRate-38144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7224,NULL,'KarlNet-TurboCell-TxRate','TxRate-38272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7225,NULL,'KarlNet-TurboCell-TxRate','TxRate-38400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7226,NULL,'KarlNet-TurboCell-TxRate','TxRate-38528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7227,NULL,'KarlNet-TurboCell-TxRate','TxRate-38656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7228,NULL,'KarlNet-TurboCell-TxRate','TxRate-38784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7229,NULL,'KarlNet-TurboCell-TxRate','TxRate-38912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7230,NULL,'KarlNet-TurboCell-TxRate','TxRate-39040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7231,NULL,'KarlNet-TurboCell-TxRate','TxRate-39168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7232,NULL,'KarlNet-TurboCell-TxRate','TxRate-39296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7233,NULL,'KarlNet-TurboCell-TxRate','TxRate-39424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7234,NULL,'KarlNet-TurboCell-TxRate','TxRate-39552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7235,NULL,'KarlNet-TurboCell-TxRate','TxRate-39680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7236,NULL,'KarlNet-TurboCell-TxRate','TxRate-39808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7237,NULL,'KarlNet-TurboCell-TxRate','TxRate-39936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7238,NULL,'KarlNet-TurboCell-TxRate','TxRate-40064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7239,NULL,'KarlNet-TurboCell-TxRate','TxRate-40192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7240,NULL,'KarlNet-TurboCell-TxRate','TxRate-40320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7241,NULL,'KarlNet-TurboCell-TxRate','TxRate-40448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7242,NULL,'KarlNet-TurboCell-TxRate','TxRate-40576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7243,NULL,'KarlNet-TurboCell-TxRate','TxRate-40704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7244,NULL,'KarlNet-TurboCell-TxRate','TxRate-40832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7245,NULL,'KarlNet-TurboCell-TxRate','TxRate-40960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7246,NULL,'KarlNet-TurboCell-TxRate','TxRate-41088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7247,NULL,'KarlNet-TurboCell-TxRate','TxRate-41216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7248,NULL,'KarlNet-TurboCell-TxRate','TxRate-41344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7249,NULL,'KarlNet-TurboCell-TxRate','TxRate-41472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7250,NULL,'KarlNet-TurboCell-TxRate','TxRate-41600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7251,NULL,'KarlNet-TurboCell-TxRate','TxRate-41728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7252,NULL,'KarlNet-TurboCell-TxRate','TxRate-41856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7253,NULL,'KarlNet-TurboCell-TxRate','TxRate-41984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7254,NULL,'KarlNet-TurboCell-TxRate','TxRate-42112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7255,NULL,'KarlNet-TurboCell-TxRate','TxRate-42240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7256,NULL,'KarlNet-TurboCell-TxRate','TxRate-42368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7257,NULL,'KarlNet-TurboCell-TxRate','TxRate-42496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7258,NULL,'KarlNet-TurboCell-TxRate','TxRate-42624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7259,NULL,'KarlNet-TurboCell-TxRate','TxRate-42752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7260,NULL,'KarlNet-TurboCell-TxRate','TxRate-42880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7261,NULL,'KarlNet-TurboCell-TxRate','TxRate-43008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7262,NULL,'KarlNet-TurboCell-TxRate','TxRate-43136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7263,NULL,'KarlNet-TurboCell-TxRate','TxRate-43264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7264,NULL,'KarlNet-TurboCell-TxRate','TxRate-43392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7265,NULL,'KarlNet-TurboCell-TxRate','TxRate-43520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7266,NULL,'KarlNet-TurboCell-TxRate','TxRate-43648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7267,NULL,'KarlNet-TurboCell-TxRate','TxRate-43776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7268,NULL,'KarlNet-TurboCell-TxRate','TxRate-43904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7269,NULL,'KarlNet-TurboCell-TxRate','TxRate-44032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7270,NULL,'KarlNet-TurboCell-TxRate','TxRate-44160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7271,NULL,'KarlNet-TurboCell-TxRate','TxRate-44288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7272,NULL,'KarlNet-TurboCell-TxRate','TxRate-44416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7273,NULL,'KarlNet-TurboCell-TxRate','TxRate-44544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7274,NULL,'KarlNet-TurboCell-TxRate','TxRate-44672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7275,NULL,'KarlNet-TurboCell-TxRate','TxRate-44800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7276,NULL,'KarlNet-TurboCell-TxRate','TxRate-44928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7277,NULL,'KarlNet-TurboCell-TxRate','TxRate-45056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7278,NULL,'KarlNet-TurboCell-TxRate','TxRate-45184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7279,NULL,'KarlNet-TurboCell-TxRate','TxRate-45312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7280,NULL,'KarlNet-TurboCell-TxRate','TxRate-45440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7281,NULL,'KarlNet-TurboCell-TxRate','TxRate-45568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7282,NULL,'KarlNet-TurboCell-TxRate','TxRate-45696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7283,NULL,'KarlNet-TurboCell-TxRate','TxRate-45824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7284,NULL,'KarlNet-TurboCell-TxRate','TxRate-45952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7285,NULL,'KarlNet-TurboCell-TxRate','TxRate-46080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7286,NULL,'KarlNet-TurboCell-TxRate','TxRate-46208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7287,NULL,'KarlNet-TurboCell-TxRate','TxRate-46336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7288,NULL,'KarlNet-TurboCell-TxRate','TxRate-46464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7289,NULL,'KarlNet-TurboCell-TxRate','TxRate-46592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7290,NULL,'KarlNet-TurboCell-TxRate','TxRate-46720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7291,NULL,'KarlNet-TurboCell-TxRate','TxRate-46848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7292,NULL,'KarlNet-TurboCell-TxRate','TxRate-46976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7293,NULL,'KarlNet-TurboCell-TxRate','TxRate-47104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7294,NULL,'KarlNet-TurboCell-TxRate','TxRate-47232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7295,NULL,'KarlNet-TurboCell-TxRate','TxRate-47360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7296,NULL,'KarlNet-TurboCell-TxRate','TxRate-47488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7297,NULL,'KarlNet-TurboCell-TxRate','TxRate-47616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7298,NULL,'KarlNet-TurboCell-TxRate','TxRate-47744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7299,NULL,'KarlNet-TurboCell-TxRate','TxRate-47872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7300,NULL,'KarlNet-TurboCell-TxRate','TxRate-48000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7301,NULL,'KarlNet-TurboCell-TxRate','TxRate-48128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7302,NULL,'KarlNet-TurboCell-TxRate','TxRate-48256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7303,NULL,'KarlNet-TurboCell-TxRate','TxRate-48384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7304,NULL,'KarlNet-TurboCell-TxRate','TxRate-48512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7305,NULL,'KarlNet-TurboCell-TxRate','TxRate-48640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7306,NULL,'KarlNet-TurboCell-TxRate','TxRate-48768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7307,NULL,'KarlNet-TurboCell-TxRate','TxRate-48896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7308,NULL,'KarlNet-TurboCell-TxRate','TxRate-49024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7309,NULL,'KarlNet-TurboCell-TxRate','TxRate-49152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7310,NULL,'KarlNet-TurboCell-TxRate','TxRate-49280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7311,NULL,'KarlNet-TurboCell-TxRate','TxRate-49408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7312,NULL,'KarlNet-TurboCell-TxRate','TxRate-49536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7313,NULL,'KarlNet-TurboCell-TxRate','TxRate-49664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7314,NULL,'KarlNet-TurboCell-TxRate','TxRate-49792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7315,NULL,'KarlNet-TurboCell-TxRate','TxRate-49920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7316,NULL,'KarlNet-TurboCell-TxRate','TxRate-50048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7317,NULL,'KarlNet-TurboCell-TxRate','TxRate-50176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7318,NULL,'KarlNet-TurboCell-TxRate','TxRate-50304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7319,NULL,'KarlNet-TurboCell-TxRate','TxRate-50432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7320,NULL,'KarlNet-TurboCell-TxRate','TxRate-50560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7321,NULL,'KarlNet-TurboCell-TxRate','TxRate-50688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7322,NULL,'KarlNet-TurboCell-TxRate','TxRate-50816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7323,NULL,'KarlNet-TurboCell-TxRate','TxRate-50944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7324,NULL,'KarlNet-TurboCell-TxRate','TxRate-51072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7325,NULL,'KarlNet-TurboCell-TxRate','TxRate-51200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7326,NULL,'KarlNet-TurboCell-TxRate','TxRate-51328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7327,NULL,'KarlNet-TurboCell-TxRate','TxRate-51456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7328,NULL,'KarlNet-TurboCell-TxRate','TxRate-51584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7329,NULL,'KarlNet-TurboCell-TxRate','TxRate-51712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7330,NULL,'KarlNet-TurboCell-TxRate','TxRate-51840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7331,NULL,'KarlNet-TurboCell-TxRate','TxRate-51968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7332,NULL,'KarlNet-TurboCell-TxRate','TxRate-52096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7333,NULL,'KarlNet-TurboCell-TxRate','TxRate-52224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7334,NULL,'KarlNet-TurboCell-TxRate','TxRate-52352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7335,NULL,'KarlNet-TurboCell-TxRate','TxRate-52480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7336,NULL,'KarlNet-TurboCell-TxRate','TxRate-52608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7337,NULL,'KarlNet-TurboCell-TxRate','TxRate-52736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7338,NULL,'KarlNet-TurboCell-TxRate','TxRate-52864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7339,NULL,'KarlNet-TurboCell-TxRate','TxRate-52992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7340,NULL,'KarlNet-TurboCell-TxRate','TxRate-53120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7341,NULL,'KarlNet-TurboCell-TxRate','TxRate-53248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7342,NULL,'KarlNet-TurboCell-TxRate','TxRate-53376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7343,NULL,'KarlNet-TurboCell-TxRate','TxRate-53504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7344,NULL,'KarlNet-TurboCell-TxRate','TxRate-53632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7345,NULL,'KarlNet-TurboCell-TxRate','TxRate-53760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7346,NULL,'KarlNet-TurboCell-TxRate','TxRate-53888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7347,NULL,'KarlNet-TurboCell-TxRate','TxRate-54016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7348,NULL,'KarlNet-TurboCell-TxRate','TxRate-54144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7349,NULL,'KarlNet-TurboCell-TxRate','TxRate-54272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7350,NULL,'KarlNet-TurboCell-TxRate','TxRate-54400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7351,NULL,'KarlNet-TurboCell-TxRate','TxRate-54528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7352,NULL,'KarlNet-TurboCell-TxRate','TxRate-54656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7353,NULL,'KarlNet-TurboCell-TxRate','TxRate-54784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7354,NULL,'KarlNet-TurboCell-TxRate','TxRate-54912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7355,NULL,'KarlNet-TurboCell-TxRate','TxRate-55040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7356,NULL,'KarlNet-TurboCell-TxRate','TxRate-55168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7357,NULL,'KarlNet-TurboCell-TxRate','TxRate-55296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7358,NULL,'KarlNet-TurboCell-TxRate','TxRate-55424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7359,NULL,'KarlNet-TurboCell-TxRate','TxRate-55552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7360,NULL,'KarlNet-TurboCell-TxRate','TxRate-55680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7361,NULL,'KarlNet-TurboCell-TxRate','TxRate-55808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7362,NULL,'KarlNet-TurboCell-TxRate','TxRate-55936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7363,NULL,'KarlNet-TurboCell-TxRate','TxRate-56064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7364,NULL,'KarlNet-TurboCell-TxRate','TxRate-56192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7365,NULL,'KarlNet-TurboCell-TxRate','TxRate-56320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7366,NULL,'KarlNet-TurboCell-TxRate','TxRate-56448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7367,NULL,'KarlNet-TurboCell-TxRate','TxRate-56576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7368,NULL,'KarlNet-TurboCell-TxRate','TxRate-56704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7369,NULL,'KarlNet-TurboCell-TxRate','TxRate-56832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7370,NULL,'KarlNet-TurboCell-TxRate','TxRate-56960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7371,NULL,'KarlNet-TurboCell-TxRate','TxRate-57088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7372,NULL,'KarlNet-TurboCell-TxRate','TxRate-57216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7373,NULL,'KarlNet-TurboCell-TxRate','TxRate-57344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7374,NULL,'KarlNet-TurboCell-TxRate','TxRate-57472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7375,NULL,'KarlNet-TurboCell-TxRate','TxRate-57600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7376,NULL,'KarlNet-TurboCell-TxRate','TxRate-57728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7377,NULL,'KarlNet-TurboCell-TxRate','TxRate-57856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7378,NULL,'KarlNet-TurboCell-TxRate','TxRate-57984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7379,NULL,'KarlNet-TurboCell-TxRate','TxRate-58112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7380,NULL,'KarlNet-TurboCell-TxRate','TxRate-58240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7381,NULL,'KarlNet-TurboCell-TxRate','TxRate-58368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7382,NULL,'KarlNet-TurboCell-TxRate','TxRate-58496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7383,NULL,'KarlNet-TurboCell-TxRate','TxRate-58624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7384,NULL,'KarlNet-TurboCell-TxRate','TxRate-58752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7385,NULL,'KarlNet-TurboCell-TxRate','TxRate-58880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7386,NULL,'KarlNet-TurboCell-TxRate','TxRate-59008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7387,NULL,'KarlNet-TurboCell-TxRate','TxRate-59136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7388,NULL,'KarlNet-TurboCell-TxRate','TxRate-59264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7389,NULL,'KarlNet-TurboCell-TxRate','TxRate-59392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7390,NULL,'KarlNet-TurboCell-TxRate','TxRate-59520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7391,NULL,'KarlNet-TurboCell-TxRate','TxRate-59648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7392,NULL,'KarlNet-TurboCell-TxRate','TxRate-59776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7393,NULL,'KarlNet-TurboCell-TxRate','TxRate-59904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7394,NULL,'KarlNet-TurboCell-TxRate','TxRate-60032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7395,NULL,'KarlNet-TurboCell-TxRate','TxRate-60160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7396,NULL,'KarlNet-TurboCell-TxRate','TxRate-60288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7397,NULL,'KarlNet-TurboCell-TxRate','TxRate-60416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7398,NULL,'KarlNet-TurboCell-TxRate','TxRate-60544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7399,NULL,'KarlNet-TurboCell-TxRate','TxRate-60672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7400,NULL,'KarlNet-TurboCell-TxRate','TxRate-60800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7401,NULL,'KarlNet-TurboCell-TxRate','TxRate-60928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7402,NULL,'KarlNet-TurboCell-TxRate','TxRate-61056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7403,NULL,'KarlNet-TurboCell-TxRate','TxRate-61184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7404,NULL,'KarlNet-TurboCell-TxRate','TxRate-61312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7405,NULL,'KarlNet-TurboCell-TxRate','TxRate-61440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7406,NULL,'KarlNet-TurboCell-TxRate','TxRate-61568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7407,NULL,'KarlNet-TurboCell-TxRate','TxRate-61696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7408,NULL,'KarlNet-TurboCell-TxRate','TxRate-61824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7409,NULL,'KarlNet-TurboCell-TxRate','TxRate-61952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7410,NULL,'KarlNet-TurboCell-TxRate','TxRate-62080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7411,NULL,'KarlNet-TurboCell-TxRate','TxRate-62208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7412,NULL,'KarlNet-TurboCell-TxRate','TxRate-62336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7413,NULL,'KarlNet-TurboCell-TxRate','TxRate-62464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7414,NULL,'KarlNet-TurboCell-TxRate','TxRate-62592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7415,NULL,'KarlNet-TurboCell-TxRate','TxRate-62720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7416,NULL,'KarlNet-TurboCell-TxRate','TxRate-62848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7417,NULL,'KarlNet-TurboCell-TxRate','TxRate-62976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7418,NULL,'KarlNet-TurboCell-TxRate','TxRate-63104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7419,NULL,'KarlNet-TurboCell-TxRate','TxRate-63232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7420,NULL,'KarlNet-TurboCell-TxRate','TxRate-63360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7421,NULL,'KarlNet-TurboCell-TxRate','TxRate-63488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7422,NULL,'KarlNet-TurboCell-TxRate','TxRate-63616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7423,NULL,'KarlNet-TurboCell-TxRate','TxRate-63744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7424,NULL,'KarlNet-TurboCell-TxRate','TxRate-63872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7425,NULL,'KarlNet-TurboCell-TxRate','TxRate-64000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7426,NULL,'KarlNet-TurboCell-TxRate','TxRate-64128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7427,NULL,'KarlNet-TurboCell-TxRate','TxRate-64256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7428,NULL,'KarlNet-TurboCell-TxRate','TxRate-64384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7429,NULL,'KarlNet-TurboCell-TxRate','TxRate-64512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7430,NULL,'KarlNet-TurboCell-TxRate','TxRate-64640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7431,NULL,'KarlNet-TurboCell-TxRate','TxRate-64768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7432,NULL,'KarlNet-TurboCell-TxRate','TxRate-64896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7433,NULL,'KarlNet-TurboCell-TxRate','TxRate-65024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7434,NULL,'KarlNet-TurboCell-TxRate','TxRate-65152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7435,NULL,'KarlNet-TurboCell-TxRate','TxRate-65280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7436,NULL,'KarlNet-TurboCell-TxRate','TxRate-65408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7437,NULL,'KarlNet-TurboCell-TxRate','TxRate-65536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7438,NULL,'KarlNet-TurboCell-TxRate','TxRate-65664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7439,NULL,'KarlNet-TurboCell-TxRate','TxRate-65792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7440,NULL,'KarlNet-TurboCell-TxRate','TxRate-65920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7441,NULL,'KarlNet-TurboCell-TxRate','TxRate-66048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7442,NULL,'KarlNet-TurboCell-TxRate','TxRate-66176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7443,NULL,'KarlNet-TurboCell-TxRate','TxRate-66304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7444,NULL,'KarlNet-TurboCell-TxRate','TxRate-66432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7445,NULL,'KarlNet-TurboCell-TxRate','TxRate-66560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7446,NULL,'KarlNet-TurboCell-TxRate','TxRate-66688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7447,NULL,'KarlNet-TurboCell-TxRate','TxRate-66816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7448,NULL,'KarlNet-TurboCell-TxRate','TxRate-66944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7449,NULL,'KarlNet-TurboCell-TxRate','TxRate-67072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7450,NULL,'KarlNet-TurboCell-TxRate','TxRate-67200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7451,NULL,'KarlNet-TurboCell-TxRate','TxRate-67328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7452,NULL,'KarlNet-TurboCell-TxRate','TxRate-67456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7453,NULL,'KarlNet-TurboCell-TxRate','TxRate-67584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7454,NULL,'KarlNet-TurboCell-TxRate','TxRate-67712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7455,NULL,'KarlNet-TurboCell-TxRate','TxRate-67840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7456,NULL,'KarlNet-TurboCell-TxRate','TxRate-67968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7457,NULL,'KarlNet-TurboCell-TxRate','TxRate-68096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7458,NULL,'KarlNet-TurboCell-TxRate','TxRate-68224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7459,NULL,'KarlNet-TurboCell-TxRate','TxRate-68352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7460,NULL,'KarlNet-TurboCell-TxRate','TxRate-68480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7461,NULL,'KarlNet-TurboCell-TxRate','TxRate-68608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7462,NULL,'KarlNet-TurboCell-TxRate','TxRate-68736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7463,NULL,'KarlNet-TurboCell-TxRate','TxRate-68864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7464,NULL,'KarlNet-TurboCell-TxRate','TxRate-68992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7465,NULL,'KarlNet-TurboCell-TxRate','TxRate-69120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7466,NULL,'KarlNet-TurboCell-TxRate','TxRate-69248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7467,NULL,'KarlNet-TurboCell-TxRate','TxRate-69376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7468,NULL,'KarlNet-TurboCell-TxRate','TxRate-69504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7469,NULL,'KarlNet-TurboCell-TxRate','TxRate-69632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7470,NULL,'KarlNet-TurboCell-TxRate','TxRate-69760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7471,NULL,'KarlNet-TurboCell-TxRate','TxRate-69888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7472,NULL,'KarlNet-TurboCell-TxRate','TxRate-70016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7473,NULL,'KarlNet-TurboCell-TxRate','TxRate-70144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7474,NULL,'KarlNet-TurboCell-TxRate','TxRate-70272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7475,NULL,'KarlNet-TurboCell-TxRate','TxRate-70400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7476,NULL,'KarlNet-TurboCell-TxRate','TxRate-70528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7477,NULL,'KarlNet-TurboCell-TxRate','TxRate-70656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7478,NULL,'KarlNet-TurboCell-TxRate','TxRate-70784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7479,NULL,'KarlNet-TurboCell-TxRate','TxRate-70912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7480,NULL,'KarlNet-TurboCell-TxRate','TxRate-71040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7481,NULL,'KarlNet-TurboCell-TxRate','TxRate-71168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7482,NULL,'KarlNet-TurboCell-TxRate','TxRate-71296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7483,NULL,'KarlNet-TurboCell-TxRate','TxRate-71424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7484,NULL,'KarlNet-TurboCell-TxRate','TxRate-71552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7485,NULL,'KarlNet-TurboCell-TxRate','TxRate-71680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7486,NULL,'KarlNet-TurboCell-TxRate','TxRate-71808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7487,NULL,'KarlNet-TurboCell-TxRate','TxRate-71936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7488,NULL,'KarlNet-TurboCell-TxRate','TxRate-72064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7489,NULL,'KarlNet-TurboCell-TxRate','TxRate-72192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7490,NULL,'KarlNet-TurboCell-TxRate','TxRate-72320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7491,NULL,'KarlNet-TurboCell-TxRate','TxRate-72448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7492,NULL,'KarlNet-TurboCell-TxRate','TxRate-72576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7493,NULL,'KarlNet-TurboCell-TxRate','TxRate-72704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7494,NULL,'KarlNet-TurboCell-TxRate','TxRate-72832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7495,NULL,'KarlNet-TurboCell-TxRate','TxRate-72960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7496,NULL,'KarlNet-TurboCell-TxRate','TxRate-73088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7497,NULL,'KarlNet-TurboCell-TxRate','TxRate-73216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7498,NULL,'KarlNet-TurboCell-TxRate','TxRate-73344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7499,NULL,'KarlNet-TurboCell-TxRate','TxRate-73472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7500,NULL,'KarlNet-TurboCell-TxRate','TxRate-73600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7501,NULL,'KarlNet-TurboCell-TxRate','TxRate-73728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7502,NULL,'KarlNet-TurboCell-TxRate','TxRate-73856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7503,NULL,'KarlNet-TurboCell-TxRate','TxRate-73984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7504,NULL,'KarlNet-TurboCell-TxRate','TxRate-74112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7505,NULL,'KarlNet-TurboCell-TxRate','TxRate-74240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7506,NULL,'KarlNet-TurboCell-TxRate','TxRate-74368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7507,NULL,'KarlNet-TurboCell-TxRate','TxRate-74496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7508,NULL,'KarlNet-TurboCell-TxRate','TxRate-74624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7509,NULL,'KarlNet-TurboCell-TxRate','TxRate-74752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7510,NULL,'KarlNet-TurboCell-TxRate','TxRate-74880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7511,NULL,'KarlNet-TurboCell-TxRate','TxRate-75008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7512,NULL,'KarlNet-TurboCell-TxRate','TxRate-75136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7513,NULL,'KarlNet-TurboCell-TxRate','TxRate-75264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7514,NULL,'KarlNet-TurboCell-TxRate','TxRate-75392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7515,NULL,'KarlNet-TurboCell-TxRate','TxRate-75520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7516,NULL,'KarlNet-TurboCell-TxRate','TxRate-75648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7517,NULL,'KarlNet-TurboCell-TxRate','TxRate-75776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7518,NULL,'KarlNet-TurboCell-TxRate','TxRate-75904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7519,NULL,'KarlNet-TurboCell-TxRate','TxRate-76032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7520,NULL,'KarlNet-TurboCell-TxRate','TxRate-76160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7521,NULL,'KarlNet-TurboCell-TxRate','TxRate-76288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7522,NULL,'KarlNet-TurboCell-TxRate','TxRate-76416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7523,NULL,'KarlNet-TurboCell-TxRate','TxRate-76544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7524,NULL,'KarlNet-TurboCell-TxRate','TxRate-76672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7525,NULL,'KarlNet-TurboCell-TxRate','TxRate-76800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7526,NULL,'KarlNet-TurboCell-TxRate','TxRate-76928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7527,NULL,'KarlNet-TurboCell-TxRate','TxRate-77056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7528,NULL,'KarlNet-TurboCell-TxRate','TxRate-77184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7529,NULL,'KarlNet-TurboCell-TxRate','TxRate-77312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7530,NULL,'KarlNet-TurboCell-TxRate','TxRate-77440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7531,NULL,'KarlNet-TurboCell-TxRate','TxRate-77568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7532,NULL,'KarlNet-TurboCell-TxRate','TxRate-77696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7533,NULL,'KarlNet-TurboCell-TxRate','TxRate-77824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7534,NULL,'KarlNet-TurboCell-TxRate','TxRate-77952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7535,NULL,'KarlNet-TurboCell-TxRate','TxRate-78080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7536,NULL,'KarlNet-TurboCell-TxRate','TxRate-78208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7537,NULL,'KarlNet-TurboCell-TxRate','TxRate-78336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7538,NULL,'KarlNet-TurboCell-TxRate','TxRate-78464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7539,NULL,'KarlNet-TurboCell-TxRate','TxRate-78592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7540,NULL,'KarlNet-TurboCell-TxRate','TxRate-78720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7541,NULL,'KarlNet-TurboCell-TxRate','TxRate-78848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7542,NULL,'KarlNet-TurboCell-TxRate','TxRate-78976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7543,NULL,'KarlNet-TurboCell-TxRate','TxRate-79104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7544,NULL,'KarlNet-TurboCell-TxRate','TxRate-79232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7545,NULL,'KarlNet-TurboCell-TxRate','TxRate-79360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7546,NULL,'KarlNet-TurboCell-TxRate','TxRate-79488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7547,NULL,'KarlNet-TurboCell-TxRate','TxRate-79616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7548,NULL,'KarlNet-TurboCell-TxRate','TxRate-79744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7549,NULL,'KarlNet-TurboCell-TxRate','TxRate-79872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7550,NULL,'KarlNet-TurboCell-TxRate','TxRate-80000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7551,NULL,'KarlNet-TurboCell-TxRate','TxRate-80128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7552,NULL,'KarlNet-TurboCell-TxRate','TxRate-80256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7553,NULL,'KarlNet-TurboCell-TxRate','TxRate-80384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7554,NULL,'KarlNet-TurboCell-TxRate','TxRate-80512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7555,NULL,'KarlNet-TurboCell-TxRate','TxRate-80640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7556,NULL,'KarlNet-TurboCell-TxRate','TxRate-80768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7557,NULL,'KarlNet-TurboCell-TxRate','TxRate-80896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7558,NULL,'KarlNet-TurboCell-TxRate','TxRate-81024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7559,NULL,'KarlNet-TurboCell-TxRate','TxRate-81152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7560,NULL,'KarlNet-TurboCell-TxRate','TxRate-81280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7561,NULL,'KarlNet-TurboCell-TxRate','TxRate-81408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7562,NULL,'KarlNet-TurboCell-TxRate','TxRate-81536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7563,NULL,'KarlNet-TurboCell-TxRate','TxRate-81664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7564,NULL,'KarlNet-TurboCell-TxRate','TxRate-81792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7565,NULL,'KarlNet-TurboCell-TxRate','TxRate-81920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7566,NULL,'KarlNet-TurboCell-TxRate','TxRate-82048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7567,NULL,'KarlNet-TurboCell-TxRate','TxRate-82176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7568,NULL,'KarlNet-TurboCell-TxRate','TxRate-82304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7569,NULL,'KarlNet-TurboCell-TxRate','TxRate-82432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7570,NULL,'KarlNet-TurboCell-TxRate','TxRate-82560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7571,NULL,'KarlNet-TurboCell-TxRate','TxRate-82688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7572,NULL,'KarlNet-TurboCell-TxRate','TxRate-82816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7573,NULL,'KarlNet-TurboCell-TxRate','TxRate-82944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7574,NULL,'KarlNet-TurboCell-TxRate','TxRate-83072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7575,NULL,'KarlNet-TurboCell-TxRate','TxRate-83200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7576,NULL,'KarlNet-TurboCell-TxRate','TxRate-83328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7577,NULL,'KarlNet-TurboCell-TxRate','TxRate-83456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7578,NULL,'KarlNet-TurboCell-TxRate','TxRate-83584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7579,NULL,'KarlNet-TurboCell-TxRate','TxRate-83712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7580,NULL,'KarlNet-TurboCell-TxRate','TxRate-83840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7581,NULL,'KarlNet-TurboCell-TxRate','TxRate-83968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7582,NULL,'KarlNet-TurboCell-TxRate','TxRate-84096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7583,NULL,'KarlNet-TurboCell-TxRate','TxRate-84224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7584,NULL,'KarlNet-TurboCell-TxRate','TxRate-84352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7585,NULL,'KarlNet-TurboCell-TxRate','TxRate-84480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7586,NULL,'KarlNet-TurboCell-TxRate','TxRate-84608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7587,NULL,'KarlNet-TurboCell-TxRate','TxRate-84736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7588,NULL,'KarlNet-TurboCell-TxRate','TxRate-84864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7589,NULL,'KarlNet-TurboCell-TxRate','TxRate-84992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7590,NULL,'KarlNet-TurboCell-TxRate','TxRate-85120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7591,NULL,'KarlNet-TurboCell-TxRate','TxRate-85248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7592,NULL,'KarlNet-TurboCell-TxRate','TxRate-85376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7593,NULL,'KarlNet-TurboCell-TxRate','TxRate-85504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7594,NULL,'KarlNet-TurboCell-TxRate','TxRate-85632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7595,NULL,'KarlNet-TurboCell-TxRate','TxRate-85760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7596,NULL,'KarlNet-TurboCell-TxRate','TxRate-85888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7597,NULL,'KarlNet-TurboCell-TxRate','TxRate-86016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7598,NULL,'KarlNet-TurboCell-TxRate','TxRate-86144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7599,NULL,'KarlNet-TurboCell-TxRate','TxRate-86272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7600,NULL,'KarlNet-TurboCell-TxRate','TxRate-86400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7601,NULL,'KarlNet-TurboCell-TxRate','TxRate-86528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7602,NULL,'KarlNet-TurboCell-TxRate','TxRate-86656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7603,NULL,'KarlNet-TurboCell-TxRate','TxRate-86784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7604,NULL,'KarlNet-TurboCell-TxRate','TxRate-86912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7605,NULL,'KarlNet-TurboCell-TxRate','TxRate-87040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7606,NULL,'KarlNet-TurboCell-TxRate','TxRate-87168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7607,NULL,'KarlNet-TurboCell-TxRate','TxRate-87296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7608,NULL,'KarlNet-TurboCell-TxRate','TxRate-87424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7609,NULL,'KarlNet-TurboCell-TxRate','TxRate-87552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7610,NULL,'KarlNet-TurboCell-TxRate','TxRate-87680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7611,NULL,'KarlNet-TurboCell-TxRate','TxRate-87808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7612,NULL,'KarlNet-TurboCell-TxRate','TxRate-87936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7613,NULL,'KarlNet-TurboCell-TxRate','TxRate-88064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7614,NULL,'KarlNet-TurboCell-TxRate','TxRate-88192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7615,NULL,'KarlNet-TurboCell-TxRate','TxRate-88320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7616,NULL,'KarlNet-TurboCell-TxRate','TxRate-88448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7617,NULL,'KarlNet-TurboCell-TxRate','TxRate-88576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7618,NULL,'KarlNet-TurboCell-TxRate','TxRate-88704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7619,NULL,'KarlNet-TurboCell-TxRate','TxRate-88832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7620,NULL,'KarlNet-TurboCell-TxRate','TxRate-88960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7621,NULL,'KarlNet-TurboCell-TxRate','TxRate-89088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7622,NULL,'KarlNet-TurboCell-TxRate','TxRate-89216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7623,NULL,'KarlNet-TurboCell-TxRate','TxRate-89344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7624,NULL,'KarlNet-TurboCell-TxRate','TxRate-89472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7625,NULL,'KarlNet-TurboCell-TxRate','TxRate-89600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7626,NULL,'KarlNet-TurboCell-TxRate','TxRate-89728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7627,NULL,'KarlNet-TurboCell-TxRate','TxRate-89856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7628,NULL,'KarlNet-TurboCell-TxRate','TxRate-89984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7629,NULL,'KarlNet-TurboCell-TxRate','TxRate-90112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7630,NULL,'KarlNet-TurboCell-TxRate','TxRate-90240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7631,NULL,'KarlNet-TurboCell-TxRate','TxRate-90368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7632,NULL,'KarlNet-TurboCell-TxRate','TxRate-90496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7633,NULL,'KarlNet-TurboCell-TxRate','TxRate-90624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7634,NULL,'KarlNet-TurboCell-TxRate','TxRate-90752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7635,NULL,'KarlNet-TurboCell-TxRate','TxRate-90880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7636,NULL,'KarlNet-TurboCell-TxRate','TxRate-91008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7637,NULL,'KarlNet-TurboCell-TxRate','TxRate-91136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7638,NULL,'KarlNet-TurboCell-TxRate','TxRate-91264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7639,NULL,'KarlNet-TurboCell-TxRate','TxRate-91392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7640,NULL,'KarlNet-TurboCell-TxRate','TxRate-91520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7641,NULL,'KarlNet-TurboCell-TxRate','TxRate-91648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7642,NULL,'KarlNet-TurboCell-TxRate','TxRate-91776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7643,NULL,'KarlNet-TurboCell-TxRate','TxRate-91904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7644,NULL,'KarlNet-TurboCell-TxRate','TxRate-92032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7645,NULL,'KarlNet-TurboCell-TxRate','TxRate-92160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7646,NULL,'KarlNet-TurboCell-TxRate','TxRate-92288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7647,NULL,'KarlNet-TurboCell-TxRate','TxRate-92416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7648,NULL,'KarlNet-TurboCell-TxRate','TxRate-92544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7649,NULL,'KarlNet-TurboCell-TxRate','TxRate-92672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7650,NULL,'KarlNet-TurboCell-TxRate','TxRate-92800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7651,NULL,'KarlNet-TurboCell-TxRate','TxRate-92928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7652,NULL,'KarlNet-TurboCell-TxRate','TxRate-93056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7653,NULL,'KarlNet-TurboCell-TxRate','TxRate-93184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7654,NULL,'KarlNet-TurboCell-TxRate','TxRate-93312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7655,NULL,'KarlNet-TurboCell-TxRate','TxRate-93440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7656,NULL,'KarlNet-TurboCell-TxRate','TxRate-93568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7657,NULL,'KarlNet-TurboCell-TxRate','TxRate-93696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7658,NULL,'KarlNet-TurboCell-TxRate','TxRate-93824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7659,NULL,'KarlNet-TurboCell-TxRate','TxRate-93952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7660,NULL,'KarlNet-TurboCell-TxRate','TxRate-94080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7661,NULL,'KarlNet-TurboCell-TxRate','TxRate-94208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7662,NULL,'KarlNet-TurboCell-TxRate','TxRate-94336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7663,NULL,'KarlNet-TurboCell-TxRate','TxRate-94464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7664,NULL,'KarlNet-TurboCell-TxRate','TxRate-94592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7665,NULL,'KarlNet-TurboCell-TxRate','TxRate-94720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7666,NULL,'KarlNet-TurboCell-TxRate','TxRate-94848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7667,NULL,'KarlNet-TurboCell-TxRate','TxRate-94976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7668,NULL,'KarlNet-TurboCell-TxRate','TxRate-95104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7669,NULL,'KarlNet-TurboCell-TxRate','TxRate-95232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7670,NULL,'KarlNet-TurboCell-TxRate','TxRate-95360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7671,NULL,'KarlNet-TurboCell-TxRate','TxRate-95488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7672,NULL,'KarlNet-TurboCell-TxRate','TxRate-95616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7673,NULL,'KarlNet-TurboCell-TxRate','TxRate-95744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7674,NULL,'KarlNet-TurboCell-TxRate','TxRate-95872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7675,NULL,'KarlNet-TurboCell-TxRate','TxRate-96000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7676,NULL,'KarlNet-TurboCell-TxRate','TxRate-96128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7677,NULL,'KarlNet-TurboCell-TxRate','TxRate-96256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7678,NULL,'KarlNet-TurboCell-TxRate','TxRate-96384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7679,NULL,'KarlNet-TurboCell-TxRate','TxRate-96512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7680,NULL,'KarlNet-TurboCell-TxRate','TxRate-96640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7681,NULL,'KarlNet-TurboCell-TxRate','TxRate-96768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7682,NULL,'KarlNet-TurboCell-TxRate','TxRate-96896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7683,NULL,'KarlNet-TurboCell-TxRate','TxRate-97024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7684,NULL,'KarlNet-TurboCell-TxRate','TxRate-97152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7685,NULL,'KarlNet-TurboCell-TxRate','TxRate-97280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7686,NULL,'KarlNet-TurboCell-TxRate','TxRate-97408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7687,NULL,'KarlNet-TurboCell-TxRate','TxRate-97536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7688,NULL,'KarlNet-TurboCell-TxRate','TxRate-97664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7689,NULL,'KarlNet-TurboCell-TxRate','TxRate-97792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7690,NULL,'KarlNet-TurboCell-TxRate','TxRate-97920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7691,NULL,'KarlNet-TurboCell-TxRate','TxRate-98048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7692,NULL,'KarlNet-TurboCell-TxRate','TxRate-98176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7693,NULL,'KarlNet-TurboCell-TxRate','TxRate-98304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7694,NULL,'KarlNet-TurboCell-TxRate','TxRate-98432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7695,NULL,'KarlNet-TurboCell-TxRate','TxRate-98560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7696,NULL,'KarlNet-TurboCell-TxRate','TxRate-98688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7697,NULL,'KarlNet-TurboCell-TxRate','TxRate-98816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7698,NULL,'KarlNet-TurboCell-TxRate','TxRate-98944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7699,NULL,'KarlNet-TurboCell-TxRate','TxRate-99072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7700,NULL,'KarlNet-TurboCell-TxRate','TxRate-99200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7701,NULL,'KarlNet-TurboCell-TxRate','TxRate-99328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7702,NULL,'KarlNet-TurboCell-TxRate','TxRate-99456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7703,NULL,'KarlNet-TurboCell-TxRate','TxRate-99584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7704,NULL,'KarlNet-TurboCell-TxRate','TxRate-99712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7705,NULL,'KarlNet-TurboCell-TxRate','TxRate-99840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7706,NULL,'KarlNet-TurboCell-TxRate','TxRate-99968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7707,NULL,'KarlNet-TurboCell-TxRate','TxRate-100096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7708,NULL,'KarlNet-TurboCell-TxRate','TxRate-100224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7709,NULL,'KarlNet-TurboCell-TxRate','TxRate-100352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7710,NULL,'KarlNet-TurboCell-TxRate','TxRate-100480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7711,NULL,'KarlNet-TurboCell-TxRate','TxRate-100608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7712,NULL,'KarlNet-TurboCell-TxRate','TxRate-100736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7713,NULL,'KarlNet-TurboCell-TxRate','TxRate-100864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7714,NULL,'KarlNet-TurboCell-TxRate','TxRate-100992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7715,NULL,'KarlNet-TurboCell-TxRate','TxRate-101120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7716,NULL,'KarlNet-TurboCell-TxRate','TxRate-101248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7717,NULL,'KarlNet-TurboCell-TxRate','TxRate-101376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7718,NULL,'KarlNet-TurboCell-TxRate','TxRate-101504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7719,NULL,'KarlNet-TurboCell-TxRate','TxRate-101632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7720,NULL,'KarlNet-TurboCell-TxRate','TxRate-101760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7721,NULL,'KarlNet-TurboCell-TxRate','TxRate-101888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7722,NULL,'KarlNet-TurboCell-TxRate','TxRate-102016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7723,NULL,'KarlNet-TurboCell-TxRate','TxRate-102144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7724,NULL,'KarlNet-TurboCell-TxRate','TxRate-102272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7725,NULL,'KarlNet-TurboCell-TxRate','TxRate-102400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7726,NULL,'KarlNet-TurboCell-TxRate','TxRate-102528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7727,NULL,'KarlNet-TurboCell-TxRate','TxRate-102656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7728,NULL,'KarlNet-TurboCell-TxRate','TxRate-102784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7729,NULL,'KarlNet-TurboCell-TxRate','TxRate-102912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7730,NULL,'KarlNet-TurboCell-TxRate','TxRate-103040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7731,NULL,'KarlNet-TurboCell-TxRate','TxRate-103168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7732,NULL,'KarlNet-TurboCell-TxRate','TxRate-103296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7733,NULL,'KarlNet-TurboCell-TxRate','TxRate-103424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7734,NULL,'KarlNet-TurboCell-TxRate','TxRate-103552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7735,NULL,'KarlNet-TurboCell-TxRate','TxRate-103680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7736,NULL,'KarlNet-TurboCell-TxRate','TxRate-103808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7737,NULL,'KarlNet-TurboCell-TxRate','TxRate-103936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7738,NULL,'KarlNet-TurboCell-TxRate','TxRate-104064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7739,NULL,'KarlNet-TurboCell-TxRate','TxRate-104192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7740,NULL,'KarlNet-TurboCell-TxRate','TxRate-104320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7741,NULL,'KarlNet-TurboCell-TxRate','TxRate-104448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7742,NULL,'KarlNet-TurboCell-TxRate','TxRate-104576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7743,NULL,'KarlNet-TurboCell-TxRate','TxRate-104704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7744,NULL,'KarlNet-TurboCell-TxRate','TxRate-104832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7745,NULL,'KarlNet-TurboCell-TxRate','TxRate-104960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7746,NULL,'KarlNet-TurboCell-TxRate','TxRate-105088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7747,NULL,'KarlNet-TurboCell-TxRate','TxRate-105216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7748,NULL,'KarlNet-TurboCell-TxRate','TxRate-105344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7749,NULL,'KarlNet-TurboCell-TxRate','TxRate-105472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7750,NULL,'KarlNet-TurboCell-TxRate','TxRate-105600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7751,NULL,'KarlNet-TurboCell-TxRate','TxRate-105728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7752,NULL,'KarlNet-TurboCell-TxRate','TxRate-105856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7753,NULL,'KarlNet-TurboCell-TxRate','TxRate-105984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7754,NULL,'KarlNet-TurboCell-TxRate','TxRate-106112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7755,NULL,'KarlNet-TurboCell-TxRate','TxRate-106240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7756,NULL,'KarlNet-TurboCell-TxRate','TxRate-106368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7757,NULL,'KarlNet-TurboCell-TxRate','TxRate-106496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7758,NULL,'KarlNet-TurboCell-TxRate','TxRate-106624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7759,NULL,'KarlNet-TurboCell-TxRate','TxRate-106752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7760,NULL,'KarlNet-TurboCell-TxRate','TxRate-106880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7761,NULL,'KarlNet-TurboCell-TxRate','TxRate-107008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7762,NULL,'KarlNet-TurboCell-TxRate','TxRate-107136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7763,NULL,'KarlNet-TurboCell-TxRate','TxRate-107264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7764,NULL,'KarlNet-TurboCell-TxRate','TxRate-107392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7765,NULL,'KarlNet-TurboCell-TxRate','TxRate-107520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7766,NULL,'KarlNet-TurboCell-TxRate','TxRate-107648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7767,NULL,'KarlNet-TurboCell-TxRate','TxRate-107776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7768,NULL,'KarlNet-TurboCell-TxRate','TxRate-107904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7769,NULL,'KarlNet-TurboCell-TxRate','TxRate-108032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7770,NULL,'KarlNet-TurboCell-TxRate','TxRate-108160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7771,NULL,'KarlNet-TurboCell-TxRate','TxRate-108288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7772,NULL,'KarlNet-TurboCell-TxRate','TxRate-108416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7773,NULL,'KarlNet-TurboCell-TxRate','TxRate-108544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7774,NULL,'KarlNet-TurboCell-TxRate','TxRate-108672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7775,NULL,'KarlNet-TurboCell-TxRate','TxRate-108800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7776,NULL,'KarlNet-TurboCell-TxRate','TxRate-108928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7777,NULL,'KarlNet-TurboCell-TxRate','TxRate-109056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7778,NULL,'KarlNet-TurboCell-TxRate','TxRate-109184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7779,NULL,'KarlNet-TurboCell-TxRate','TxRate-109312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7780,NULL,'KarlNet-TurboCell-TxRate','TxRate-109440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7781,NULL,'KarlNet-TurboCell-TxRate','TxRate-109568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7782,NULL,'KarlNet-TurboCell-TxRate','TxRate-109696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7783,NULL,'KarlNet-TurboCell-TxRate','TxRate-109824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7784,NULL,'KarlNet-TurboCell-TxRate','TxRate-109952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7785,NULL,'KarlNet-TurboCell-TxRate','TxRate-110080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7786,NULL,'KarlNet-TurboCell-TxRate','TxRate-110208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7787,NULL,'KarlNet-TurboCell-TxRate','TxRate-110336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7788,NULL,'KarlNet-TurboCell-TxRate','TxRate-110464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7789,NULL,'KarlNet-TurboCell-TxRate','TxRate-110592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7790,NULL,'KarlNet-TurboCell-TxRate','TxRate-110720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7791,NULL,'KarlNet-TurboCell-TxRate','TxRate-110848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7792,NULL,'KarlNet-TurboCell-TxRate','TxRate-110976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7793,NULL,'KarlNet-TurboCell-TxRate','TxRate-111104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7794,NULL,'KarlNet-TurboCell-TxRate','TxRate-111232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7795,NULL,'KarlNet-TurboCell-TxRate','TxRate-111360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7796,NULL,'KarlNet-TurboCell-TxRate','TxRate-111488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7797,NULL,'KarlNet-TurboCell-TxRate','TxRate-111616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7798,NULL,'KarlNet-TurboCell-TxRate','TxRate-111744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7799,NULL,'KarlNet-TurboCell-TxRate','TxRate-111872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7800,NULL,'KarlNet-TurboCell-TxRate','TxRate-112000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7801,NULL,'KarlNet-TurboCell-TxRate','TxRate-112128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7802,NULL,'KarlNet-TurboCell-TxRate','TxRate-112256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7803,NULL,'KarlNet-TurboCell-TxRate','TxRate-112384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7804,NULL,'KarlNet-TurboCell-TxRate','TxRate-112512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7805,NULL,'KarlNet-TurboCell-TxRate','TxRate-112640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7806,NULL,'KarlNet-TurboCell-TxRate','TxRate-112768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7807,NULL,'KarlNet-TurboCell-TxRate','TxRate-112896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7808,NULL,'KarlNet-TurboCell-TxRate','TxRate-113024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7809,NULL,'KarlNet-TurboCell-TxRate','TxRate-113152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7810,NULL,'KarlNet-TurboCell-TxRate','TxRate-113280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7811,NULL,'KarlNet-TurboCell-TxRate','TxRate-113408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7812,NULL,'KarlNet-TurboCell-TxRate','TxRate-113536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7813,NULL,'KarlNet-TurboCell-TxRate','TxRate-113664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7814,NULL,'KarlNet-TurboCell-TxRate','TxRate-113792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7815,NULL,'KarlNet-TurboCell-TxRate','TxRate-113920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7816,NULL,'KarlNet-TurboCell-TxRate','TxRate-114048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7817,NULL,'KarlNet-TurboCell-TxRate','TxRate-114176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7818,NULL,'KarlNet-TurboCell-TxRate','TxRate-114304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7819,NULL,'KarlNet-TurboCell-TxRate','TxRate-114432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7820,NULL,'KarlNet-TurboCell-TxRate','TxRate-114560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7821,NULL,'KarlNet-TurboCell-TxRate','TxRate-114688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7822,NULL,'KarlNet-TurboCell-TxRate','TxRate-114816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7823,NULL,'KarlNet-TurboCell-TxRate','TxRate-114944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7824,NULL,'KarlNet-TurboCell-TxRate','TxRate-115072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7825,NULL,'KarlNet-TurboCell-TxRate','TxRate-115200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7826,NULL,'KarlNet-TurboCell-TxRate','TxRate-115328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7827,NULL,'KarlNet-TurboCell-TxRate','TxRate-115456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7828,NULL,'KarlNet-TurboCell-TxRate','TxRate-115584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7829,NULL,'KarlNet-TurboCell-TxRate','TxRate-115712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7830,NULL,'KarlNet-TurboCell-TxRate','TxRate-115840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7831,NULL,'KarlNet-TurboCell-TxRate','TxRate-115968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7832,NULL,'KarlNet-TurboCell-TxRate','TxRate-116096k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7833,NULL,'KarlNet-TurboCell-TxRate','TxRate-116224k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7834,NULL,'KarlNet-TurboCell-TxRate','TxRate-116352k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7835,NULL,'KarlNet-TurboCell-TxRate','TxRate-116480k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7836,NULL,'KarlNet-TurboCell-TxRate','TxRate-116608k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7837,NULL,'KarlNet-TurboCell-TxRate','TxRate-116736k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7838,NULL,'KarlNet-TurboCell-TxRate','TxRate-116864k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7839,NULL,'KarlNet-TurboCell-TxRate','TxRate-116992k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7840,NULL,'KarlNet-TurboCell-TxRate','TxRate-117120k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7841,NULL,'KarlNet-TurboCell-TxRate','TxRate-117248k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7842,NULL,'KarlNet-TurboCell-TxRate','TxRate-117376k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7843,NULL,'KarlNet-TurboCell-TxRate','TxRate-117504k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7844,NULL,'KarlNet-TurboCell-TxRate','TxRate-117632k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7845,NULL,'KarlNet-TurboCell-TxRate','TxRate-117760k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7846,NULL,'KarlNet-TurboCell-TxRate','TxRate-117888k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7847,NULL,'KarlNet-TurboCell-TxRate','TxRate-118016k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7848,NULL,'KarlNet-TurboCell-TxRate','TxRate-118144k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7849,NULL,'KarlNet-TurboCell-TxRate','TxRate-118272k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7850,NULL,'KarlNet-TurboCell-TxRate','TxRate-118400k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7851,NULL,'KarlNet-TurboCell-TxRate','TxRate-118528k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7852,NULL,'KarlNet-TurboCell-TxRate','TxRate-118656k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7853,NULL,'KarlNet-TurboCell-TxRate','TxRate-118784k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7854,NULL,'KarlNet-TurboCell-TxRate','TxRate-118912k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7855,NULL,'KarlNet-TurboCell-TxRate','TxRate-119040k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7856,NULL,'KarlNet-TurboCell-TxRate','TxRate-119168k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7857,NULL,'KarlNet-TurboCell-TxRate','TxRate-119296k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7858,NULL,'KarlNet-TurboCell-TxRate','TxRate-119424k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7859,NULL,'KarlNet-TurboCell-TxRate','TxRate-119552k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7860,NULL,'KarlNet-TurboCell-TxRate','TxRate-119680k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7861,NULL,'KarlNet-TurboCell-TxRate','TxRate-119808k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7862,NULL,'KarlNet-TurboCell-TxRate','TxRate-119936k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7863,NULL,'KarlNet-TurboCell-TxRate','TxRate-120064k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7864,NULL,'KarlNet-TurboCell-TxRate','TxRate-120192k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7865,NULL,'KarlNet-TurboCell-TxRate','TxRate-120320k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7866,NULL,'KarlNet-TurboCell-TxRate','TxRate-120448k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7867,NULL,'KarlNet-TurboCell-TxRate','TxRate-120576k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7868,NULL,'KarlNet-TurboCell-TxRate','TxRate-120704k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7869,NULL,'KarlNet-TurboCell-TxRate','TxRate-120832k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7870,NULL,'KarlNet-TurboCell-TxRate','TxRate-120960k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7871,NULL,'KarlNet-TurboCell-TxRate','TxRate-121088k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7872,NULL,'KarlNet-TurboCell-TxRate','TxRate-121216k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7873,NULL,'KarlNet-TurboCell-TxRate','TxRate-121344k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7874,NULL,'KarlNet-TurboCell-TxRate','TxRate-121472k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7875,NULL,'KarlNet-TurboCell-TxRate','TxRate-121600k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7876,NULL,'KarlNet-TurboCell-TxRate','TxRate-121728k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7877,NULL,'KarlNet-TurboCell-TxRate','TxRate-121856k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7878,NULL,'KarlNet-TurboCell-TxRate','TxRate-121984k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7879,NULL,'KarlNet-TurboCell-TxRate','TxRate-122112k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7880,NULL,'KarlNet-TurboCell-TxRate','TxRate-122240k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7881,NULL,'KarlNet-TurboCell-TxRate','TxRate-122368k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7882,NULL,'KarlNet-TurboCell-TxRate','TxRate-122496k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7883,NULL,'KarlNet-TurboCell-TxRate','TxRate-122624k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7884,NULL,'KarlNet-TurboCell-TxRate','TxRate-122752k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7885,NULL,'KarlNet-TurboCell-TxRate','TxRate-122880k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7886,NULL,'KarlNet-TurboCell-TxRate','TxRate-123008k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7887,NULL,'KarlNet-TurboCell-TxRate','TxRate-123136k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7888,NULL,'KarlNet-TurboCell-TxRate','TxRate-123264k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7889,NULL,'KarlNet-TurboCell-TxRate','TxRate-123392k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7890,NULL,'KarlNet-TurboCell-TxRate','TxRate-123520k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7891,NULL,'KarlNet-TurboCell-TxRate','TxRate-123648k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7892,NULL,'KarlNet-TurboCell-TxRate','TxRate-123776k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7893,NULL,'KarlNet-TurboCell-TxRate','TxRate-123904k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7894,NULL,'KarlNet-TurboCell-TxRate','TxRate-124032k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7895,NULL,'KarlNet-TurboCell-TxRate','TxRate-124160k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7896,NULL,'KarlNet-TurboCell-TxRate','TxRate-124288k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7897,NULL,'KarlNet-TurboCell-TxRate','TxRate-124416k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7898,NULL,'KarlNet-TurboCell-TxRate','TxRate-124544k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7899,NULL,'KarlNet-TurboCell-TxRate','TxRate-124672k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7900,NULL,'KarlNet-TurboCell-TxRate','TxRate-124800k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7901,NULL,'KarlNet-TurboCell-TxRate','TxRate-124928k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7902,NULL,'KarlNet-TurboCell-TxRate','TxRate-125056k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7903,NULL,'KarlNet-TurboCell-TxRate','TxRate-125184k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7904,NULL,'KarlNet-TurboCell-TxRate','TxRate-125312k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7905,NULL,'KarlNet-TurboCell-TxRate','TxRate-125440k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7906,NULL,'KarlNet-TurboCell-TxRate','TxRate-125568k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7907,NULL,'KarlNet-TurboCell-TxRate','TxRate-125696k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7908,NULL,'KarlNet-TurboCell-TxRate','TxRate-125824k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7909,NULL,'KarlNet-TurboCell-TxRate','TxRate-125952k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7910,NULL,'KarlNet-TurboCell-TxRate','TxRate-126080k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7911,NULL,'KarlNet-TurboCell-TxRate','TxRate-126208k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7912,NULL,'KarlNet-TurboCell-TxRate','TxRate-126336k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7913,NULL,'KarlNet-TurboCell-TxRate','TxRate-126464k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7914,NULL,'KarlNet-TurboCell-TxRate','TxRate-126592k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7915,NULL,'KarlNet-TurboCell-TxRate','TxRate-126720k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7916,NULL,'KarlNet-TurboCell-TxRate','TxRate-126848k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7917,NULL,'KarlNet-TurboCell-TxRate','TxRate-126976k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7918,NULL,'KarlNet-TurboCell-TxRate','TxRate-127104k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7919,NULL,'KarlNet-TurboCell-TxRate','TxRate-127232k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7920,NULL,'KarlNet-TurboCell-TxRate','TxRate-127360k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7921,NULL,'KarlNet-TurboCell-TxRate','TxRate-127488k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7922,NULL,'KarlNet-TurboCell-TxRate','TxRate-127616k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7923,NULL,'KarlNet-TurboCell-TxRate','TxRate-127744k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7924,NULL,'KarlNet-TurboCell-TxRate','TxRate-127872k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7925,NULL,'KarlNet-TurboCell-TxRate','TxRate-128000k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7926,NULL,'KarlNet-TurboCell-TxRate','TxRate-128128k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7927,NULL,'KarlNet-TurboCell-TxRate','TxRate-128256k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7928,NULL,'KarlNet-TurboCell-TxRate','TxRate-128384k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7929,NULL,'KarlNet-TurboCell-TxRate','TxRate-128512k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7930,NULL,'KarlNet-TurboCell-TxRate','TxRate-128640k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7931,NULL,'KarlNet-TurboCell-TxRate','TxRate-128768k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7932,NULL,'KarlNet-TurboCell-TxRate','TxRate-128896k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7933,NULL,'KarlNet-TurboCell-TxRate','TxRate-129024k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7934,NULL,'KarlNet-TurboCell-TxRate','TxRate-129152k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7935,NULL,'KarlNet-TurboCell-TxRate','TxRate-129280k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7936,NULL,'KarlNet-TurboCell-TxRate','TxRate-129408k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7937,NULL,'KarlNet-TurboCell-TxRate','TxRate-129536k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7938,NULL,'KarlNet-TurboCell-TxRate','TxRate-129664k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7939,NULL,'KarlNet-TurboCell-TxRate','TxRate-129792k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7940,NULL,'KarlNet-TurboCell-TxRate','TxRate-129920k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7941,NULL,'KarlNet-TurboCell-TxRate','TxRate-130048k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7942,NULL,'KarlNet-TurboCell-TxRate','TxRate-130176k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7943,NULL,'KarlNet-TurboCell-TxRate','TxRate-130304k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7944,NULL,'KarlNet-TurboCell-TxRate','TxRate-130432k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7945,NULL,'KarlNet-TurboCell-TxRate','TxRate-130560k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7946,NULL,'KarlNet-TurboCell-TxRate','TxRate-130688k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7947,NULL,'KarlNet-TurboCell-TxRate','TxRate-130816k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7948,NULL,'KarlNet-TurboCell-TxRate','TxRate-130944k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7949,NULL,'KarlNet-TurboCell-TxRate','TxRate-131072k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7950,NULL,'KarlNet-TurboCell-TxRate','TxRate-131200k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7951,NULL,'KarlNet-TurboCell-TxRate','TxRate-131328k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7952,NULL,'KarlNet-TurboCell-TxRate','TxRate-131456k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7953,NULL,'KarlNet-TurboCell-TxRate','TxRate-131584k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7954,NULL,'KarlNet-TurboCell-TxRate','TxRate-131712k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7955,NULL,'KarlNet-TurboCell-TxRate','TxRate-131840k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7956,NULL,'KarlNet-TurboCell-TxRate','TxRate-131968k',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7957,'integer','KarlNet-TurboCell-OpState',NULL,NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7958,NULL,'KarlNet-TurboCell-OpState','Up',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7959,NULL,'KarlNet-TurboCell-OpState','Down',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7960,'integer','KarlNet-TurboCell-OpMode',NULL,NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7961,NULL,'KarlNet-TurboCell-OpMode','Peer-to-Peer',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7962,NULL,'KarlNet-TurboCell-OpMode','Base',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7963,NULL,'KarlNet-TurboCell-OpMode','Base-Polling',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7964,NULL,'KarlNet-TurboCell-OpMode','Satellite-NT',NULL,'KarlNet',NULL,NULL,NULL,NULL),
                                (7965,'string','Packeteer-AVPair',NULL,NULL,'Packeteer',NULL,NULL,NULL,NULL),
                                (7966,'integer','Ascend-Max-Shared-Users',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7967,'string','Ascend-UU-Info',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7968,'integer','Ascend-CIR-Timer',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7969,'integer','Ascend-FR-08-Mode',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7970,'integer','Ascend-Destination-Nas-Port',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7971,'string','Ascend-FR-SVC-Addr',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7972,'integer','Ascend-NAS-Port-Format',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7973,'integer','Ascend-ATM-Fault-Management',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7974,'integer','Ascend-ATM-Loopback-Cell-Loss',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7975,'integer','Ascend-Ckt-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7976,'integer','Ascend-SVC-Enabled',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7977,'integer','Ascend-Session-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7978,'ipaddr','Ascend-H323-Gatekeeper',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7979,'string','Ascend-Global-Call-Id',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7980,'integer','Ascend-H323-Conference-Id',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7981,'ipaddr','Ascend-H323-Fegw-Address',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7982,'integer','Ascend-H323-Dialed-Time',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7983,'string','Ascend-Dialed-Number',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7984,'integer','Ascend-Inter-Arrival-Jitter',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7985,'integer','Ascend-Dropped-Octets',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7986,'integer','Ascend-Dropped-Packets',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7987,'integer','Ascend-Auth-Delay',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7988,'integer','Ascend-X25-Pad-X3-Profile',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7989,'string','Ascend-X25-Pad-X3-Parameters',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7990,'string','Ascend-Tunnel-VRouter-Name',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7991,'integer','Ascend-X25-Reverse-Charging',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7992,'string','Ascend-X25-Nui-Prompt',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7993,'string','Ascend-X25-Nui-Password-Prompt',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7994,'string','Ascend-X25-Cug',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7995,'string','Ascend-X25-Pad-Alias-1',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7996,'string','Ascend-X25-Pad-Alias-2',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7997,'string','Ascend-X25-Pad-Alias-3',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7998,'string','Ascend-X25-X121-Address',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (7999,'string','Ascend-X25-Nui',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8000,'string','Ascend-X25-Rpoa',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8001,'string','Ascend-X25-Pad-Prompt',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8002,'string','Ascend-X25-Pad-Banner',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8003,'string','Ascend-X25-Profile-Name',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8004,'string','Ascend-Recv-Name',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8005,'integer','Ascend-Bi-Directional-Auth',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8006,'integer','Ascend-MTU',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8007,'integer','Ascend-Call-Direction',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8008,'integer','Ascend-Service-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8009,'integer','Ascend-Filter-Required',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8010,'integer','Ascend-Traffic-Shaper',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8011,'string','Ascend-Access-Intercept-LEA',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8012,'string','Ascend-Access-Intercept-Log',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8013,'string','Ascend-Private-Route-Table-ID',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8014,'integer','Ascend-Private-Route-Required',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8015,'integer','Ascend-Cache-Refresh',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8016,'integer','Ascend-Cache-Time',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8017,'integer','Ascend-Egress-Enabled',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8018,'string','Ascend-QOS-Upstream',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8019,'string','Ascend-QOS-Downstream',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8020,'integer','Ascend-ATM-Connect-Vpi',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8021,'integer','Ascend-ATM-Connect-Vci',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8022,'integer','Ascend-ATM-Connect-Group',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8023,'integer','Ascend-ATM-Group',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8024,'integer','Ascend-IPX-Header-Compression',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8025,'integer','Ascend-Calling-Id-Type-Of-Num',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8026,'integer','Ascend-Calling-Id-Number-Plan',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8027,'integer','Ascend-Calling-Id-Presentatn',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8028,'integer','Ascend-Calling-Id-Screening',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8029,'integer','Ascend-BIR-Enable',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8030,'integer','Ascend-BIR-Proxy',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8031,'integer','Ascend-BIR-Bridge-Group',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8032,'string','Ascend-IPSEC-Profile',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8033,'integer','Ascend-PPPoE-Enable',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8034,'integer','Ascend-Bridge-Non-PPPoE',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8035,'integer','Ascend-ATM-Direct',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8036,'string','Ascend-ATM-Direct-Profile',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8037,'ipaddr','Ascend-Client-Primary-WINS',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8038,'ipaddr','Ascend-Client-Secondary-WINS',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8039,'integer','Ascend-Client-Assign-WINS',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8040,'integer','Ascend-Auth-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8041,'integer','Ascend-Port-Redir-Protocol',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8042,'integer','Ascend-Port-Redir-Portnum',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8043,'ipaddr','Ascend-Port-Redir-Server',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8044,'integer','Ascend-IP-Pool-Chaining',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8045,'ipaddr','Ascend-Owner-IP-Addr',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8046,'integer','Ascend-IP-TOS',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8047,'integer','Ascend-IP-TOS-Precedence',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8048,'integer','Ascend-IP-TOS-Apply-To',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8049,'string','Ascend-Filter',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8050,'string','Ascend-Telnet-Profile',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8051,'integer','Ascend-Dsl-Rate-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8052,'string','Ascend-Redirect-Number',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8053,'integer','Ascend-ATM-Vpi',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8054,'integer','Ascend-ATM-Vci',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8055,'integer','Ascend-Source-IP-Check',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8056,'integer','Ascend-Dsl-Rate-Mode',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8057,'integer','Ascend-Dsl-Upstream-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8058,'integer','Ascend-Dsl-Downstream-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8059,'integer','Ascend-Dsl-CIR-Recv-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8060,'integer','Ascend-Dsl-CIR-Xmit-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8061,'string','Ascend-VRouter-Name',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8062,'string','Ascend-Source-Auth',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8063,'string','Ascend-Private-Route',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8064,'integer','Ascend-Numbering-Plan-ID',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8065,'integer','Ascend-FR-Link-Status-DLCI',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8066,'string','Ascend-Calling-Subaddress',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8067,'integer','Ascend-Callback-Delay',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8068,'string','Ascend-Endpoint-Disc',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8069,'string','Ascend-Remote-FW',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8070,'integer','Ascend-Multicast-GLeave-Delay',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8071,'integer','Ascend-CBCP-Enable',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8072,'integer','Ascend-CBCP-Mode',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8073,'integer','Ascend-CBCP-Delay',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8074,'integer','Ascend-CBCP-Trunk-Group',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8075,'string','Ascend-Appletalk-Route',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8076,'integer','Ascend-Appletalk-Peer-Mode',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8077,'integer','Ascend-Route-Appletalk',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8078,'string','Ascend-FCP-Parameter',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8079,'integer','Ascend-Modem-PortNo',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8080,'integer','Ascend-Modem-SlotNo',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8081,'integer','Ascend-Modem-ShelfNo',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8082,'integer','Ascend-Call-Attempt-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8083,'integer','Ascend-Call-Block-Duration',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8084,'integer','Ascend-Maximum-Call-Duration',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8085,'integer','Ascend-Temporary-Rtes',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8086,'integer','Ascend-Tunneling-Protocol',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8087,'integer','Ascend-Shared-Profile-Enable',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8088,'string','Ascend-Primary-Home-Agent',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8089,'string','Ascend-Secondary-Home-Agent',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8090,'integer','Ascend-Dialout-Allowed',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8091,'ipaddr','Ascend-Client-Gateway',NULL,NULL,'Ascend','=','reply','','client gateway for DHCP-pool HotSpot login method (HotSpot only)'),
                                (8092,'integer','Ascend-BACP-Enable',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8093,'integer','Ascend-DHCP-Maximum-Leases',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8094,'ipaddr','Ascend-Client-Primary-DNS',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8095,'ipaddr','Ascend-Client-Secondary-DNS',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8096,'integer','Ascend-Client-Assign-DNS',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8097,'integer','Ascend-User-Acct-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8098,'ipaddr','Ascend-User-Acct-Host',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8099,'integer','Ascend-User-Acct-Port',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8100,'string','Ascend-User-Acct-Key',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8101,'integer','Ascend-User-Acct-Base',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8102,'integer','Ascend-User-Acct-Time',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8103,'ipaddr','Ascend-Assign-IP-Client',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8104,'ipaddr','Ascend-Assign-IP-Server',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8105,'string','Ascend-Assign-IP-Global-Pool',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8106,'integer','Ascend-DHCP-Reply',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8107,'integer','Ascend-DHCP-Pool-Number',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8108,'integer','Ascend-Expect-Callback',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8109,'integer','Ascend-Event-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8110,'string','Ascend-Session-Svr-Key',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8111,'integer','Ascend-Multicast-Rate-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8112,'ipaddr','Ascend-IF-Netmask',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8113,'ipaddr','Ascend-Remote-Addr',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8114,'integer','Ascend-Multicast-Client',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8115,'string','Ascend-FR-Circuit-Name',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8116,'integer','Ascend-FR-LinkUp',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8117,'integer','Ascend-FR-Nailed-Grp',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8118,'integer','Ascend-FR-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8119,'integer','Ascend-FR-Link-Mgt',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8120,'integer','Ascend-FR-N391',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8121,'integer','Ascend-FR-DCE-N392',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8122,'integer','Ascend-FR-DTE-N392',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8123,'integer','Ascend-FR-DCE-N393',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8124,'integer','Ascend-FR-DTE-N393',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8125,'integer','Ascend-FR-T391',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8126,'integer','Ascend-FR-T392',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8127,'string','Ascend-Bridge-Address',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8128,'integer','Ascend-TS-Idle-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8129,'integer','Ascend-TS-Idle-Mode',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8130,'integer','Ascend-DBA-Monitor',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8131,'integer','Ascend-Base-Channel-Count',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8132,'integer','Ascend-Minimum-Channels',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8133,'string','Ascend-IPX-Route',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8134,'integer','Ascend-FT1-Caller',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8135,'string','Ascend-Backup',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8136,'integer','Ascend-Call-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8137,'string','Ascend-Group',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8138,'integer','Ascend-FR-DLCI',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8139,'string','Ascend-FR-Profile-Name',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8140,'string','Ascend-Ara-PW',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8141,'string','Ascend-IPX-Node-Addr',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8142,'ipaddr','Ascend-Home-Agent-IP-Addr',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8143,'string','Ascend-Home-Agent-Password',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8144,'string','Ascend-Home-Network-Name',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8145,'integer','Ascend-Home-Agent-UDP-Port',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8146,'integer','Ascend-Multilink-ID',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8147,'integer','Ascend-Num-In-Multilink',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8148,'ipaddr','Ascend-First-Dest',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8149,'integer','Ascend-Pre-Input-Octets',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8150,'integer','Ascend-Pre-Output-Octets',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8151,'integer','Ascend-Pre-Input-Packets',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8152,'integer','Ascend-Pre-Output-Packets',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8153,'integer','Ascend-Maximum-Time',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8154,'integer','Ascend-Disconnect-Cause',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8155,'integer','Ascend-Connect-Progress',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8156,'integer','Ascend-Data-Rate',NULL,NULL,'Ascend',':=','reply','','tx/rx data rate limitation if multiple attributes are provided, first limits tx data rate, second - rx data rate. If used together with Ascend-Xmit-Rate, specifies rx rate. 0 if unlimited. Ignored if Rate-Limit attribute is present'),
                                (8157,'integer','Ascend-PreSession-Time',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8158,'integer','Ascend-Token-Idle',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8159,'integer','Ascend-Token-Immediate',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8160,'integer','Ascend-Require-Auth',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8161,'string','Ascend-Number-Sessions',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8162,'string','Ascend-Authen-Alias',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8163,'integer','Ascend-Token-Expiry',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8164,'string','Ascend-Menu-Selector',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8165,'string','Ascend-Menu-Item',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8166,'integer','Ascend-PW-Warntime',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8167,'integer','Ascend-PW-Lifetime',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8168,'ipaddr','Ascend-IP-Direct',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8169,'integer','Ascend-PPP-VJ-Slot-Comp',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8170,'integer','Ascend-PPP-VJ-1172',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8171,'integer','Ascend-PPP-Async-Map',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8172,'string','Ascend-Third-Prompt',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8173,'string','Ascend-Send-Secret',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8174,'string','Ascend-Receive-Secret',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8175,'integer','Ascend-IPX-Peer-Mode',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8176,'string','Ascend-IP-Pool-Definition',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8177,'integer','Ascend-Assign-IP-Pool',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8178,'integer','Ascend-FR-Direct',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8179,'string','Ascend-FR-Direct-Profile',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8180,'integer','Ascend-FR-Direct-DLCI',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8181,'integer','Ascend-Handle-IPX',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8182,'integer','Ascend-Netware-timeout',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8183,'integer','Ascend-IPX-Alias',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8184,'integer','Ascend-Metric',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8185,'integer','Ascend-PRI-Number-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8186,'string','Ascend-Dial-Number',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8187,'integer','Ascend-Route-IP',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8188,'integer','Ascend-Route-IPX',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8189,'integer','Ascend-Bridge',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8190,'integer','Ascend-Send-Auth',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8191,'string','Ascend-Send-Passwd',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8192,'integer','Ascend-Link-Compression',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8193,'integer','Ascend-Target-Util',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8194,'integer','Ascend-Maximum-Channels',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8195,'integer','Ascend-Inc-Channel-Count',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8196,'integer','Ascend-Dec-Channel-Count',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8197,'integer','Ascend-Seconds-Of-History',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8198,'integer','Ascend-History-Weigh-Type',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8199,'integer','Ascend-Add-Seconds',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8200,'integer','Ascend-Remove-Seconds',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8201,'abinary','Ascend-Data-Filter',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8202,'abinary','Ascend-Call-Filter',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8203,'integer','Ascend-Idle-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8204,'integer','Ascend-Preempt-Limit',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8205,'integer','Ascend-Callback',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8206,'integer','Ascend-Data-Svc',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8207,'integer','Ascend-Force-56',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8208,'string','Ascend-Billing-Number',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8209,'integer','Ascend-Call-By-Call',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8210,'string','Ascend-Transit-Number',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8211,'string','Ascend-Host-Info',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8212,'ipaddr','Ascend-PPP-Address',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8213,'integer','Ascend-MPP-Idle-Percent',NULL,NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8214,'integer','Ascend-Xmit-Rate',NULL,NULL,'Ascend',':=','reply','','tx data rate limitation. It may be used to specify tx limit only instead of sending two sequental Ascend-Data-Rate attributes (in that case Ascend-Data-Rate will specify the receive rate). 0 if unlimited. Ignored if Rate-Limit attribute is present'),
                                (8215,NULL,'Service-Type','Dialout-Framed-User',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8216,NULL,'Framed-Protocol','Ascend-ARA',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8217,NULL,'Framed-Protocol','Ascend-MPP',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8218,NULL,'Framed-Protocol','Ascend-EURAW',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8219,NULL,'Framed-Protocol','Ascend-EUUI',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8220,NULL,'Framed-Protocol','Ascend-X25',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8221,NULL,'Framed-Protocol','Ascend-COMB',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8222,NULL,'Framed-Protocol','Ascend-FR',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8223,NULL,'Framed-Protocol','Ascend-MP',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8224,NULL,'Framed-Protocol','Ascend-FR-CIR',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8225,NULL,'Ascend-Source-IP-Check','Source-IP-Check-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8226,NULL,'Ascend-Source-IP-Check','Source-IP-Check-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8227,NULL,'Ascend-CBCP-Enable','CBCP-Not-Enabled',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8228,NULL,'Ascend-CBCP-Enable','CBCP-Enabled',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8229,NULL,'Ascend-CBCP-Mode','CBCP-No-Callback',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8230,NULL,'Ascend-CBCP-Mode','CBCP-User-Callback',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8231,NULL,'Ascend-CBCP-Mode','CBCP-Profile-Callback',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8232,NULL,'Ascend-CBCP-Mode','CBCP-Any-Or-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8233,NULL,'Ascend-CBCP-Mode','CBCP-Off',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8234,NULL,'Ascend-FR-Direct','FR-Direct-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8235,NULL,'Ascend-FR-Direct','FR-Direct-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8236,NULL,'Ascend-Handle-IPX','Handle-IPX-None',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8237,NULL,'Ascend-Handle-IPX','Handle-IPX-Client',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8238,NULL,'Ascend-Handle-IPX','Handle-IPX-Server',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8239,NULL,'Ascend-IPX-Peer-Mode','IPX-Peer-Router',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8240,NULL,'Ascend-IPX-Peer-Mode','IPX-Peer-Dialin',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8241,NULL,'Ascend-Call-Type','Switched',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8242,NULL,'Ascend-Call-Type','Nailed',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8243,NULL,'Ascend-Call-Type','Nailed/Mpp',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8244,NULL,'Ascend-Call-Type','Perm/Switched',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8245,NULL,'Ascend-Call-Type','AO/DI',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8246,NULL,'Ascend-Call-Type','MegaMax',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8247,NULL,'Ascend-FT1-Caller','FT1-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8248,NULL,'Ascend-FT1-Caller','FT1-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8249,NULL,'Ascend-PRI-Number-Type','Unknown-Number',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8250,NULL,'Ascend-PRI-Number-Type','Intl-Number',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8251,NULL,'Ascend-PRI-Number-Type','National-Number',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8252,NULL,'Ascend-PRI-Number-Type','Net-Specific-Number',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8253,NULL,'Ascend-PRI-Number-Type','Local-Number',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8254,NULL,'Ascend-PRI-Number-Type','Abbrev-Number',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8255,NULL,'Ascend-Route-IP','Route-IP-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8256,NULL,'Ascend-Route-IP','Route-IP-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8257,NULL,'Ascend-Route-IPX','Route-IPX-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8258,NULL,'Ascend-Route-IPX','Route-IPX-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8259,NULL,'Ascend-Bridge','Bridge-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8260,NULL,'Ascend-Bridge','Bridge-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8261,NULL,'Ascend-TS-Idle-Mode','TS-Idle-None',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8262,NULL,'Ascend-TS-Idle-Mode','TS-Idle-Input',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8263,NULL,'Ascend-TS-Idle-Mode','TS-Idle-Input-Output',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8264,NULL,'Ascend-Send-Auth','Send-Auth-None',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8265,NULL,'Ascend-Send-Auth','Send-Auth-PAP',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8266,NULL,'Ascend-Send-Auth','Send-Auth-CHAP',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8267,NULL,'Ascend-Send-Auth','Send-Auth-MS-CHAP',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8268,NULL,'Ascend-Link-Compression','Link-Comp-None',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8269,NULL,'Ascend-Link-Compression','Link-Comp-Stac',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8270,NULL,'Ascend-Link-Compression','Link-Comp-Stac-Draft-9',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8271,NULL,'Ascend-Link-Compression','Link-Comp-MS-Stac',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8272,NULL,'Ascend-History-Weigh-Type','History-Constant',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8273,NULL,'Ascend-History-Weigh-Type','History-Linear',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8274,NULL,'Ascend-History-Weigh-Type','History-Quadratic',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8275,NULL,'Ascend-Callback','Callback-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8276,NULL,'Ascend-Callback','Callback-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8277,NULL,'Ascend-Expect-Callback','Expect-Callback-No',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8278,NULL,'Ascend-Expect-Callback','Expect-Callback-Yes',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8279,NULL,'Ascend-Data-Svc','Switched-Voice-Bearer',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8280,NULL,'Ascend-Data-Svc','Nailed-56KR',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8281,NULL,'Ascend-Data-Svc','Nailed-64K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8282,NULL,'Ascend-Data-Svc','Switched-64KR',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8283,NULL,'Ascend-Data-Svc','Switched-56K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8284,NULL,'Ascend-Data-Svc','Switched-384KR',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8285,NULL,'Ascend-Data-Svc','Switched-384K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8286,NULL,'Ascend-Data-Svc','Switched-1536K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8287,NULL,'Ascend-Data-Svc','Switched-1536KR',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8288,NULL,'Ascend-Data-Svc','Switched-128K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8289,NULL,'Ascend-Data-Svc','Switched-192K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8290,NULL,'Ascend-Data-Svc','Switched-256K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8291,NULL,'Ascend-Data-Svc','Switched-320K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8292,NULL,'Ascend-Data-Svc','Switched-384K-MR',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8293,NULL,'Ascend-Data-Svc','Switched-448K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8294,NULL,'Ascend-Data-Svc','Switched-512K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8295,NULL,'Ascend-Data-Svc','Switched-576K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8296,NULL,'Ascend-Data-Svc','Switched-640K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8297,NULL,'Ascend-Data-Svc','Switched-704K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8298,NULL,'Ascend-Data-Svc','Switched-768K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8299,NULL,'Ascend-Data-Svc','Switched-832K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8300,NULL,'Ascend-Data-Svc','Switched-896K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8301,NULL,'Ascend-Data-Svc','Switched-960K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8302,NULL,'Ascend-Data-Svc','Switched-1024K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8303,NULL,'Ascend-Data-Svc','Switched-1088K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8304,NULL,'Ascend-Data-Svc','Switched-1152K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8305,NULL,'Ascend-Data-Svc','Switched-1216K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8306,NULL,'Ascend-Data-Svc','Switched-1280K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8307,NULL,'Ascend-Data-Svc','Switched-1344K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8308,NULL,'Ascend-Data-Svc','Switched-1408K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8309,NULL,'Ascend-Data-Svc','Switched-1472K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8310,NULL,'Ascend-Data-Svc','Switched-1600K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8311,NULL,'Ascend-Data-Svc','Switched-1664K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8312,NULL,'Ascend-Data-Svc','Switched-1728K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8313,NULL,'Ascend-Data-Svc','Switched-1792K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8314,NULL,'Ascend-Data-Svc','Switched-1856K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8315,NULL,'Ascend-Data-Svc','Switched-1920K',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8316,NULL,'Ascend-Data-Svc','Switched-inherited',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8317,NULL,'Ascend-Data-Svc','Switched-restricted-bearer-x30',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8318,NULL,'Ascend-Data-Svc','Switched-clear-bearer-v110',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8319,NULL,'Ascend-Data-Svc','Switched-restricted-64-x30',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8320,NULL,'Ascend-Data-Svc','Switched-clear-56-v110',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8321,NULL,'Ascend-Data-Svc','Switched-modem',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8322,NULL,'Ascend-Data-Svc','Switched-atmodem',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8323,NULL,'Ascend-Data-Svc','Switched-V110-24-56',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8324,NULL,'Ascend-Data-Svc','Switched-V110-48-56',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8325,NULL,'Ascend-Data-Svc','Switched-V110-96-56',NULL,'Ascend',NULL,NULL,NULL,NULL),
                                (8326,NULL,'Ascend-Data-Svc','Switched-V110-192-56',NULL,'Ascend',NULL,NULL,NULL,N